{$DEFINE __USE_CANVAS}
{$DEFINE _LOADING_IMAGES}
{$DEFINE _LOAD_FROM_RESOURCE}

unit MainUtDX;

interface

{$IFDEF _LOAD_FROM_RESOURCE}
   {$R Bitmap.Res}
{$ENDIF}

uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
   DDraw, DDUtils, ExtCtrls, Main1, SMHan10;

const
   MAX_IMAGE_SURFACE = 1;
   IMAGE_SURFACE     = MAX_IMAGE_SURFACE;
   IMAGE_FILE_NAME   = 'Neto';

   WIN_MOUSE_X_GAP   = 5;
   WIN_MOUSE_Y_GAP   = 24;

   BPP               : WORD    = 1;
   LEVEL_DATA        : integer = 1;
   STAGE_DATA        : integer = 1;

type

   TOption = record
      IsExclusive           : boolean; // Direct X     
      IsHighRevolution      : boolean; // ػ  
      CanModifyWalkFrame    : boolean; // ǽð  Ű 
      UseMIDI               : boolean;
      CanDisplayPerformance : boolean; //  ս   
      UseSystemMemory       : boolean; // ý ޸𸮸 ۷ 
      IsRegistered          : boolean; //   Ǿ° ?
      MainMode              : (mmGame, mmEdit);
   end;

   TPixelFormat = (pfUnknown, pfRGB8, pfRGB16, pfRGB15, pfBGR16, pfRGB24, pfBGR24, pfRGB32);

   TBasic = class(TForm)

      procedure   DDFormCreate  (Sender: TObject);
      procedure   DDFormDestroy (Sender: TObject);
      procedure   DDFormShow    (Sender: TObject; IsExcusive : boolean);

      procedure   FormCreate    (Sender: TObject);
      procedure   FormShow      (Sender: TObject);
      procedure   FormClose     (Sender: TObject; var Action: TCloseAction);
      procedure   FormDestroy   (Sender: TObject);
      procedure   FormMinimize  (Sender: TObject);
      procedure   FormOnRestore (Sender: TObject);
      procedure   FormPaint     (Sender: TObject);
      procedure   FormKeyDown   (Sender: TObject; var Key: Word; Shift: TShiftState);

   private

      FPreviousFlipping : boolean;
      FFlippingEnabled  : boolean;
      FActive           : boolean;

      FIsFirstShow      : boolean;

      procedure   ExceptionHandler(Sender  : TObject; Error : Exception);
      procedure   HandleMessage   (var Msg : TMsg; var Handled : boolean);
      procedure   IdleHandler     (Sender  : TObject; var Done : boolean);
      function    GetBitmapName   (BitmapName : string; i : integer) : string;
      function    RestoreSurfaces : HResult;
      procedure   DrawSurfaces;
      procedure   SetFlippingEnabled(Value : boolean);

   public

      FStartTickCount   : integer;     { īƮ ۽ Tick            }
      FFlippingCount    : integer;     {  ø ȸ          }

      FIsLocked         : boolean;
      PixelFormat       : TPixelFormat;
      Tranceparency     : DWORD;
      DirectDraw        : IDirectDraw;         // DirectDraw object  
      PrimarySurface    : IDirectDrawSurface;  //  ȭ 
      BackBuffer        : IDirectDrawSurface;  // ĸ 
    {$IFDEF _USE_CANVAS}
      PrimaryCanvas     : TDDCanvas;
      BackCanvas        : TDDCanvas;
    {$ENDIF}
      Clipper           : IDirectDrawClipper;  // Ŭ ü
      DDPalette         : IDirectDrawPalette;  // ĸ  Ʈʿ ε
    {$IFDEF _LOADING_IMAGES}
      Image             : array[1..MAX_IMAGE_SURFACE] of IDirectDrawSurface;
                                               // ̹ 
    {$ENDIF}
      LockDesc          : TDDSurfaceDesc;      // Lock Suface Ÿ 

      procedure   DrawScreen;
      procedure   UpdateDisplay(IsCommandable : boolean);
      function    MakeItSo     (DDResult : HResult) : boolean;
      property    FlippingEnabled : boolean read  FFlippingEnabled
                                            write SetFlippingEnabled;
      procedure   LockBackGround;
      procedure   UnlockBackGround;

      procedure   InitializeGame;
      procedure   FinalizeGame;

      procedure   WMActiveApp(var Msg : TWMActivateApp); message WM_ACTIVATEAPP;

   end;

var
   Basic  : TBasic;
   Option : TOption;


implementation

{$R *.DFM}

const
   DD_ERROR_CONST = $88760000;


procedure  PutPixel256(x, y : integer; Color : TColorRef);
begin
   PByte(DWORD(Basic.LockDesc.lpSurface) + Basic.LockDesc.lPitch * y + x)^ := Byte(Color);
end;

procedure  PutPixelTrueColor(x, y : integer; Color : TColorRef);
var
   Temp : Longint;
begin
   case Basic.PixelFormat of
      pfRGB16 :
      begin
         asm
            mov  eax, Color
            and  eax, 00FFFFFFh
            mov  ecx, eax
            mov  edx, eax
            shr  eax, 16+3      // Blue
            shr  ecx, 5
            and  ecx, 000007E0h // Green
            shl  edx, 8
            and  edx, 0000F800h // Red
            or   eax, ecx
            or   eax, edx
            mov  Color, eax
         end;
         PWord(DWORD(Basic.LockDesc.lpSurface) + Basic.LockDesc.lPitch * y + x*2)^
              := Word(Color);
      end;
      pfRGB15 :
      begin
         asm
            mov  eax, Color
            and  eax, 00FFFFFFh
            mov  ecx, eax
            mov  edx, eax
            shr  eax, 16+3      // Blue
            shr  ecx, 6
            and  ecx, 000003E0h // Green
            shl  edx, 7
            and  edx, 00007C00h // Red
            or   eax, ecx
            or   eax, edx
            mov  Color, eax
         end;
         PWord(DWORD(Basic.LockDesc.lpSurface) + Basic.LockDesc.lPitch * y + x*2)^
              := Word(Color);
      end;
      pfBGR16 :
      begin
         asm
            mov  eax, Color
            and  eax, 00FFFFFFh
            mov  ecx, eax
            mov  edx, eax
            shr  eax, 3         // Red
            shr  ecx, 5
            and  ecx, 000007E0h // Green
            shr  edx, 8
            and  edx, 0000F800h // Blue
            or   eax, ecx
            or   eax, edx
            mov  Color, eax
         end;
         PWord(DWORD(Basic.LockDesc.lpSurface) + Basic.LockDesc.lPitch * y + x*2)^
              := Word(Color);
      end;
      pfRGB24 :
      begin
         asm
            mov  eax, Color
            and  eax, 00FFFFFFh
            mov  ecx, eax
            mov  edx, eax
            and  eax, 000000FFh
            shl  eax, 16        // Red
            and  ecx, 0000FF00h // Green
            and  edx, 00FF0000h
            shr  edx, 16        // Blue
            or   eax, ecx
            or   eax, edx
            mov  Color, eax
         end;
         Temp  := PDWORD(DWORD(Basic.LockDesc.lpSurface) + Basic.LockDesc.lPitch * y + x*3)^;
         Color := (Temp and $FF000000) or Color;
         PDWORD(DWORD(Basic.LockDesc.lpSurface) + Basic.LockDesc.lPitch * y + x*3)^
               := Color;
      end;
      pfBGR24 :
      begin
         Temp  := PDWORD(DWORD(Basic.LockDesc.lpSurface) + Basic.LockDesc.lPitch * y + x*3)^;
         Color := (Temp and $FF000000) or Color;
         PDWORD(DWORD(Basic.LockDesc.lpSurface) + Basic.LockDesc.lPitch * y + x*3)^
               := Color;
      end;
      pfRGB32 :
      begin
         asm
            mov  eax, Color
            and  eax, 00FFFFFFh
            mov  ecx, eax
            mov  edx, eax
            and  eax, 000000FFh
            shl  eax, 16        // Red
            and  ecx, 0000FF00h // Green
            and  edx, 00FF0000h
            shr  edx, 16        // Blue
            or   eax, ecx
            or   eax, edx
            mov  Color, eax
         end;
         PDWORD(DWORD(Basic.LockDesc.lpSurface) + Basic.LockDesc.lPitch * y + x*4)^
               := Color;
      end;
   end;
end;

function   TBasic.GetBitmapName(BitmapName : string; i : integer) : string;
begin
 {$IFDEF _LOAD_FROM_RESOURCE}
   Result := BitmapName + IntToStr(i);
 {$ELSE}
   Result := ExtractFilePath(Application.ExeName) + BitmapName + IntToStr(i) + '.BMP';
 {$ENDIF}
end;

procedure   TBasic.DDFormCreate(Sender: TObject);
begin
   FIsFirstShow      := TRUE;

   FIsLocked         := FALSE;
   FPreviousFlipping := FALSE;
   FFlippingEnabled  := FALSE;

  {  ڵ鷯  }
   Application.OnException := ExceptionHandler;
   Application.OnMinimize  := FormMinimize;
   Application.OnRestore   := FormOnRestore;

  {  ڸ ְ  , Ŀ  }
   Color       := clBlack;

   if Option.IsExclusive then begin
      SetBounds(0,0,MAX_X_LINE,MAX_Y_LINE);
      BorderStyle := bsNone;
   end else begin
      SetBounds(0,0,MAX_X_LINE+WIN_MOUSE_X_GAP*2,MAX_Y_LINE+WIN_MOUSE_Y_GAP+5);
      BorderStyle := bsSingle;
   end;
end;

procedure   TBasic.DDFormShow(Sender: TObject; IsExcusive : boolean);
var
   i             : integer;
   Test          : HRESULT;
//   pVideo        : PDWORD;
   DDSurfaceDesc : TDDSurfaceDesc;
   DDSCaps       : TDDSCaps;
   DDPixelFormat : TDDPixelFormat;
   ColorKey      : TDDColorKey;
   DC            : HDC;
begin
   if not FIsFirstShow then exit;

   FIsFirstShow := FALSE;

  { DD COM ü  }
   if DirectDrawCreate(nil,DirectDraw,nil) <> DD_OK then
      Raise Exception.Create('DirectDraw ü  ');

   if not Assigned(DirectDraw) then exit;

   if IsExcusive then begin

     { Ÿ Ǯũ Ȯ }
      Test := DirectDraw.SetCooperativeLevel(Handle,DDSCL_EXCLUSIVE or DDSCL_FULLSCREEN or DDSCL_ALLOWREBOOT);
      if Test <> DD_OK then
         Raise Exception.Create('Ÿ Ǯũ   : '+IntToStr(Test-DD_ERROR_CONST));

     { ȭ  ٲ }
      Test := DirectDraw.SetDisplayMode(MAX_X_LINE,MAX_Y_LINE,8*BPP);
      if Test <> DD_OK then
         Raise Exception.Create('640 x 480   : '+IntToStr(Test-DD_ERROR_CONST));

     { DirectDrawSurface ũ  }
      FillChar(DDSurfaceDesc,SizeOf(DDSurfaceDesc),0);
      with DDSurfaceDesc do begin
         dwSize            := SizeOf(DDSurfaceDesc);
         dwFlags           := DDSD_CAPS or DDSD_BACKBUFFERCOUNT;
         ddSCaps.dwCaps    := DDSCAPS_COMPLEX or DDSCAPS_FLIP or DDSCAPS_PRIMARYSURFACE;
         if Option.UseSystemMemory then
            ddSCaps.dwCaps := ddSCaps.dwCaps or DDSCAPS_SYSTEMMEMORY;
         dwBackBufferCount := 1;
      end;

     {  ȭ   }
      Test := DirectDraw.CreateSurface(DDSurfaceDesc,PrimarySurface,nil);
      if Test <> DD_OK then
         Raise Exception.Create(' ȭ    : '+IntToStr(Test-DD_ERROR_CONST));

     { ĸ  ü  }
      DDSCaps.dwCaps := DDSCAPS_BACKBUFFER;
      Test := PrimarySurface.GetAttachedSurface(DDSCaps,BackBuffer);
      if Test <> DD_OK then
         Raise Exception.Create('ĸ    : '+IntToStr(Test-DD_ERROR_CONST));

   end else begin

     { Ϲ   }
      if DirectDraw.SetCooperativeLevel(Handle,DDSCL_NORMAL) <> DD_OK then
         Raise Exception.Create('Ϲ    ');

     { DirectDrawSurface ũ  }
      FillChar(DDSurfaceDesc,SizeOf(DDSurfaceDesc),0);
      with DDSurfaceDesc do begin
         dwSize            := SizeOf(DDSurfaceDesc);
         dwFlags           := DDSD_CAPS;
         ddSCaps.dwCaps    := DDSCAPS_PRIMARYSURFACE;
      end;

     {  ȭ   }
      if DirectDraw.CreateSurface(DDSurfaceDesc,PrimarySurface,nil) <> DD_OK then
         Raise Exception.Create(' ȭ   ');

     { ĸ  ü  }
      FillChar(DDSurfaceDesc,SizeOf(DDSurfaceDesc),0);
      with DDSurfaceDesc do begin
         dwSize            := SizeOf(DDSurfaceDesc);
         dwFlags           := DDSD_CAPS or DDSD_HEIGHT or DDSD_WIDTH;
         ddSCaps.dwCaps    := DDSCAPS_OFFSCREENPLAIN;
         if Option.UseSystemMemory then
            ddSCaps.dwCaps := ddSCaps.dwCaps or DDSCAPS_SYSTEMMEMORY;
         dwWidth           := MAX_X_LINE;
         dwHeight          := MAX_Y_LINE;
      end;

      if DirectDraw.CreateSurface(DDSurfaceDesc,BackBuffer,nil) <> DD_OK then
         Raise Exception.Create('   ');

      if DirectDraw.CreateClipper(0,Clipper,nil) <> DD_OK then
         Raise EXception.Create('Ŭ ü  ');

      if Clipper.SetHWnd(0,handle) <> DD_OK then
         Raise EXception.Create('Ŭ ü  ');

      if PrimarySurface.SetClipper(Clipper) <> DD_OK then
         Raise EXception.Create('Ŭ ǥ ߰ ');

      try
         BackBuffer.GetDC(DC);
         BPP := GetDeviceCaps(DC,BITSPIXEL) div 8;
      finally
         BackBuffer.ReleaseDC(DC);
      end;
   end;

{$IFDEF _USE_CANVAS}
  {  ȭ  TDDCanvases ü  }
   PrimaryCanvas  := TDDCanvas.Create(PrimarySurface);
   BackCanvas     := TDDCanvas.Create(BackBuffer);
{$ENDIF}

{$IFDEF _LOADING_IMAGES}

  { ȷƮ ε }
   if (BPP = 1) and IsExcusive then begin
      DDPalette := DDLoadPalette(DirectDraw,GetBitmapName(IMAGE_FILE_NAME,1));
      if PrimarySurface.SetPalette(DDPalette) <> DD_OK then
         Raise Exception.Create('ȷƮ ε ');
   end;

  { Ʈ  & ε }
   for i := 1 to IMAGE_SURFACE do begin
      Image[i] := DDLoadBitmap(DirectDraw,GetBitmapName(IMAGE_FILE_NAME,i),0,0);
   end;

  {   }
   for i := 1 to IMAGE_SURFACE do begin
      ColorKey.dwColorSpaceLowValue  := 0;
      ColorKey.dwColorSpaceHighValue := 0;
      if Image[i].SetColorKey(DDCKEY_SRCBLT,ColorKey) <> DD_OK then
         Raise Exception.Create('  ');
   end;
{$ENDIF}

  { 16Ʈ ÷ ȼ  ǵ }

   FillChar(DDPixelFormat,sizeof(DDPixelFormat),0);
   DDPixelFormat.dwSize := sizeof(DDPixelFormat);
   if PrimarySurface.GetPixelFormat(DDPixelFormat) <> DD_OK then
      Raise Exception.Create('ȼ  б ');

   case BPP of

      1 :
      begin
         PixelFormat := pfRGB8;
      end;

      2 :
      begin
         if DDPixelFormat.dwRBitMask = $0000F800 then begin
            PixelFormat   := pfRGB16;
            Tranceparency := $FFFF;
         end else if DDPixelFormat.dwRBitMask = $00007C00 then begin
            PixelFormat   := pfRGB15;
            Tranceparency := $7FFF;
         end else if DDPixelFormat.dwRBitMask = $0000001F then begin
            PixelFormat   := pfBGR16;
            Tranceparency := $FFFF;
         end else begin
            PixelFormat   := pfUnknown;
            Tranceparency := $0000;
         end;
      end;

      3 :
      begin
         if DDPixelFormat.dwRBitMask = $00FF0000 then begin
            PixelFormat   := pfRGB24;
            Tranceparency := $FFFFFF;
         end else if DDPixelFormat.dwRBitMask = $000000FF then begin
            PixelFormat   := pfBGR24;
            Tranceparency := $FFFFFF;
         end else begin
            PixelFormat   := pfUnknown;
            Tranceparency := $000000;
         end;
      end;

      4 :
      begin
         PixelFormat   := pfRGB32;
         Tranceparency := $FFFFFF;
      end;

      else
      begin
         PixelFormat   := pfUnknown;
      end;

   end;

   Cursor := crNone;
   if Option.IsExclusive then begin
      ShowCursor(FALSE);
   end;

   InitializeGame;

end;

procedure   TBasic.DDFormDestroy(Sender: TObject);
var
   i : integer;
begin
   UnlockBackGround;
  {  ø  }
   FlippingEnabled := FALSE;

   FinalizeGame;

{$IFDEF _USE_CANVAS}
  { ĵ ü  }
   PrimaryCanvas.Free;
   BackCanvas.Free;
{$ENDIF}

  { ȭ   }
   if Assigned(PrimarySurface) then PrimarySurface.Release;

 {$IFDEF _LOADING_IMAGES}
   for i := 1 to IMAGE_SURFACE do begin
      if Assigned(Image[i]) then Image[i].Release;
   end;
 {$ENDIF}

  { DirectDraw COM ü  }
   if Assigned(DirectDraw) then DirectDraw.Release;
   DirectDraw := nil;

  {  ڵ鷯  }
   Application.OnException := nil;
   Application.OnMinimize  := nil;
   Application.OnRestore   := nil;

   ShowCursor(TRUE);
end;

procedure   TBasic.LockBackGround;
begin
   if not FIsLocked then begin
      LockDesc.dwSize := SizeOf(TDDSurfaceDesc);
      repeat
      until MakeItSo(BackBuffer.Lock(Rect(0,0,MAX_X_LINE,MAX_Y_LINE),LockDesc,DDLOCK_SURFACEMEMORYPTR +
                     DDLOCK_WAIT, 0));
      FIsLocked := TRUE;
   end;
end;

procedure   TBasic.UnlockBackGround;
begin
   if FIsLocked then begin
      BackBuffer.UnLock(LockDesc.lpSurface);
      FIsLocked := FALSE;
   end;
end;

procedure   TBasic.SetFlippingEnabled(Value : boolean);
begin
   if Value <> FFlippingEnabled then begin
      FFlippingEnabled := Value;
      if FFlippingEnabled then begin
        {  ̺Ʈ ڵ鷯 ġ }
         Application.OnMessage := HandleMessage;
         Application.OnIdle    := IdleHandler;
      end else begin
        {  ̺Ʈ ڵ鷯  }
         Application.OnMessage := nil;
         Application.OnIdle    := nil;
      end;
   end;
end;

function    TBasic.MakeItSo(DDResult : HResult) : boolean;
begin
  { ȭ   Լ }
   case DDResult of
      DD_OK             : Result := TRUE;
      DDERR_SURFACELOST : Result := RestoreSurfaces <> DD_OK;
      else                Result := DDResult <> DDERR_WASSTILLDRAWING;
   end;
end;

function   TBasic.RestoreSurfaces : HResult;
var
   i : integer;
begin
  { ȭ Ҿ MakeItSo ȣ }
   Result := PrimarySurface.Restore;
   if Result = DD_OK then begin
    {$IFDEF _LOADING_IMAGES}
      for i := 1 to IMAGE_SURFACE do begin
         Result := Image[i].Restore;
         if Result <> DD_OK then begin
            exit;
         end;
      end;
    {$ENDIF}
      if Result = DD_OK then DrawSurfaces;
   end;
end;

procedure   TBasic.DrawSurfaces;
var
   i : integer;
begin
 {$IFDEF _LOADING_IMAGES}
   for i := 1 to IMAGE_SURFACE do begin
      DDReloadBitmap(Image[i],GetBitmapName(IMAGE_FILE_NAME,i));
   end;
 {$ENDIF}
end;

procedure   TBasic.UpdateDisplay(IsCommandable : boolean);
begin
   if FActive or not Option.IsExclusive then DrawScreen;
end;

procedure   TBasic.HandleMessage(var Msg : TMsg; var Handled : boolean);
begin
   UpdateDisplay(TRUE);
end;

procedure   TBasic.IdleHandler(Sender : TObject; var Done : boolean);
begin
   UpdateDisplay(TRUE);
   Done := FALSE;
end;

(* WINDOW EVENT SECTION *)

procedure   TBasic.FormCreate(Sender: TObject);
begin

   if Option.IsHighRevolution then begin
      MAX_X_LINE         := 800;
      MAX_Y_LINE         := 600;
   end else begin
      MAX_X_LINE         := 640;
      MAX_Y_LINE         := 480;
   end;

   FActive := TRUE;

   DDFormCreate(Sender);
end;

procedure   TBasic.FormShow(Sender: TObject);
begin
   DDFormShow(Sender,Option.IsExclusive);
end;

procedure   TBasic.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
end;

procedure   TBasic.FormDestroy(Sender: TObject);
begin
   DDFormDestroy(Sender);
end;

procedure   TBasic.FormPaint(Sender: TObject);
begin
   if Assigned(DirectDraw) then
      DrawSurfaces;
end;

procedure   TBasic.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
   if key = VK_F12 then Close;
end;

procedure   TBasic.FormMinimize(Sender: TObject);
begin
   FPreviousFlipping := FlippingEnabled;
   FlippingEnabled   := FALSE;
end;

procedure   TBasic.FormOnRestore(Sender: TObject);
begin
   FlippingEnabled   := FPreviousFlipping;
   Basic.WindowState := wsNormal;
end;

procedure   TBasic.ExceptionHandler(Sender : TObject; Error : Exception);
var
   WasEnabled : boolean;
   WasLocked  : boolean;
begin
  {  ޼ ̱  GDI ȯ }

   MessageBeep(0);

   WasEnabled      := FlippingEnabled;
   FlippingEnabled := FALSE;

   WasLocked       := FIsLocked;
   if WasLocked then begin
      UnlockBackGround;
   end;

   if Assigned(DirectDraw) then DirectDraw.FlipToGDISurface;

   MessageDlg(Error.Message,mtError,[mbOK],0);

   if WasLocked then begin
      LockBackGround;
   end;

   FlippingEnabled := WasEnabled;

   Close;
end;

(* USER DEFINIION SECTION *)

procedure   TBasic.InitializeGame;
var
   Temp : Longint;
begin
   SystemParametersInfo(SPI_SCREENSAVERRUNNING,Word(TRUE),@Temp,0); // Disabled Ctrl-Alt-Del
   if PixelFormat = pfRGB8 then begin
      SMHan10.InitializeSM(PutPixel256);
      SMHan10.SetHangulUnit(huPixel);
   end else begin
      SMHan10.InitializeSM(PutPixelTrueColor);
      SMHan10.SetHangulUnit(huGradation);
   end;
   Main1.InitializeGame;
end;

procedure   TBasic.FinalizeGame;
var
   Temp : Longint;
begin
   SMHan10.FinalizeSM;
   Main1.FinalizeGame;
   ClipCursor(nil);
   SystemParametersInfo(SPI_SCREENSAVERRUNNING,Word(FALSE),@Temp,0); // Enabled Ctrl-Alt-Del
end;

procedure   TBasic.DrawScreen;
begin
   Main1.DoAction;
end;

procedure   TBasic.WMActiveApp(var Msg : TWMActivateApp);
begin
   FActive := Msg.Active;
   if FActive then begin
      FFlippingCount  := -50;
      FStartTickCount := GetTickCount;
      FlippingEnabled := TRUE;
   end else begin
      if Option.IsExclusive then begin
         FlippingEnabled := FALSE;
      end;
   end;

end;

begin
   with Option do begin
      IsExclusive           := TRUE;
      IsHighRevolution      := TRUE;
      CanModifyWalkFrame    := TRUE;
      UseMIDI               := TRUE;

      CanDisplayPerformance := not TRUE;
      UseSystemMemory       := TRUE;
      IsRegistered          := not TRUE;
      MainMode              := mmGame;
   end;
end.

