unit Menu;

interface

uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
   Menus, ComCtrls, ToolWin, StdCtrls, ExtCtrls, Grids,
   MainUtDX, CMap, Title, {JukeBox,} MPlayer;

const
   NORMAL_WIDTH  = 290;
   NORMAL_HEIGHT = 312;

type
   TMenuForm = class(TForm)

      MainMenu         : TMainMenu;
      SystemMenu       : TMenuItem;
      SystemMenuStart  : TMenuItem;
      NOP1             : TMenuItem;
      SystemMenuExit   : TMenuItem;
      HelpMenu         : TMenuItem;
      HelpMenuHelp     : TMenuItem;
      HelpMenuAbout    : TMenuItem;
      NOP2             : TMenuItem;
      HelpMenuRegister : TMenuItem;

      ToolBar          : TToolBar;
      ToolBarStart     : TToolButton;
      ToolBarEdit      : TToolButton;
      ToolBarHelp      : TToolButton;
      ToolBarExit      : TToolButton;
      ToolBarSepa1     : TToolButton;
      ToolBarSera2     : TToolButton;

      LoadDialog       : TOpenDialog;
      SaveDialog       : TSaveDialog;
      ImageList1       : TImageList;
      ImageList2       : TImageList;
      StatusBar        : TStatusBar;

      NormalPanel      : TPanel;
      LevelLabel       : TLabel;
      StageLabel       : TLabel;
      LevelSelector    : TComboBox;
      StageSelector    : TComboBox;
      OptionGroup      : TGroupBox;
      ExclusiveCheck   : TCheckBox;
      ResolutionCheck  : TCheckBox;
      FrameCheck       : TCheckBox;
      MidiCheck        : TCheckBox;
      PerformanceCheck : TCheckBox;
      PlaneGroup       : TRadioGroup;

      EditPanel        : TPanel;
      FileNameLabel    : TLabel;
      FileNameEdit     : TEdit;
      StageMakerGrid   : TStringGrid;
      EditMenuButton   : TButton;

      EditMenu         : TPopupMenu;
      EditMenuInit     : TMenuItem;
      EditMenuLoad     : TMenuItem;
      EditMenuSave     : TMenuItem;
      MediaPlayer      : TMediaPlayer;

      procedure   FormCreate           (Sender : TObject);
      procedure   FormShow             (Sender : TObject);
      procedure   FormDestroy          (Sender : TObject);
      procedure   DisplayHint          (Sender : TObject);

      procedure   SystemMenuStartClick (Sender : TObject);
//      procedure   SystemMenuMusicClick (Sender: TObject);
      procedure   SystemMenuExitClick  (Sender : TObject);
      procedure   HelpMenuHelpClick    (Sender : TObject);
      procedure   HelpMenuAboutClick   (Sender : TObject);
      procedure   HelpMenuRegisterClick(Sender: TObject);

      procedure   ToolBarStartClick    (Sender : TObject);
      procedure   ToolBarEditClick     (Sender : TObject);
      procedure   ToolBarHelpClick     (Sender : TObject);
      procedure   ToolBarExitClick     (Sender : TObject);

      procedure   LevelSelectorChange  (Sender : TObject);
      procedure   StageSelectorChange  (Sender : TObject);

      procedure   ExclusiveCheckClick  (Sender : TObject);

      procedure   StageMakerGridSetEditText(Sender: TObject;
                                      ACol, ARow: Integer; const Value: String);

      procedure   EditMenuButtonClick  (Sender : TObject);
      procedure   EditMenuInitClick    (Sender : TObject);
      procedure   EditMenuLoadClick    (Sender : TObject);
      procedure   EditMenuSaveClick    (Sender : TObject);

   private
      IsFirstAllocation : boolean;

   public
      procedure   VerifyResiteration;

   end;

var
   MenuForm : TMenuForm;

implementation

{$R *.DFM}

procedure   TMenuForm.FormCreate(Sender: TObject);
begin
   Application.OnHint := DisplayHint;
   IsFirstAllocation  := TRUE;
end;

procedure   TMenuForm.FormShow(Sender: TObject);
var
   i : integer;
begin

   if IsFirstAllocation then begin
      Width               := NORMAL_WIDTH;
      Height              := NORMAL_HEIGHT;

      NormalPanel.Visible := TRUE;
      EditPanel.Visible   := FALSE;
      EditPanel.Left      := NormalPanel.Left;
      EditPanel.Top       := NormalPanel.Top;

      VerifyResiteration;

      LevelSelector.ItemIndex := 0;
      LevelSelectorChange(Self);
      StageSelector.ItemIndex := 0;
      StageSelectorChange(Self);

      ExclusiveCheckClick(Self);

      StageMakerGrid.Cells[1,0] := '  ';
      for i := 1 to Pred(StageMakerGrid.RowCount) do begin
         StageMakerGrid.Cells[0,i] := IntToStr(i);
      end;

      Map := TMap.Create;

      IsFirstAllocation := FALSE;
   end;
end;

procedure   TMenuForm.FormDestroy(Sender: TObject);
begin
   Map.Free;
end;

procedure   TMenuForm.DisplayHint(Sender : TObject);
begin
   StatusBar.Panels[0].Text := ' ' + Application.Hint;
end;

procedure   TMenuForm.SystemMenuStartClick(Sender: TObject);
var
   OK : boolean;
begin
   OK := TRUE;

   with MainUtDX.Option do begin
      IsExclusive           := ExclusiveCheck.Checked;
      IsHighRevolution      := ResolutionCheck.Checked;
      CanModifyWalkFrame    := FrameCheck.Checked;
      UseMIDI               := MidiCheck.Checked;
//      CanDisplayPerformance := PerformanceCheck.Checked;
   end;
   LevelSelectorChange(Sender);
   StageSelectorChange(Sender);
   BPP := PlaneGroup.ItemIndex + 1;

   if MainUtDX.LEVEL_DATA = 0 then begin
      EditMenuLoadClick(Sender);
      if LoadDialog.Tag = 0 then OK := FALSE;
   end;

   if OK then begin
      MenuForm.Visible := FALSE;

      Application.CreateForm(TBasic,Basic);
      Basic.ShowModal;

      MenuForm.Visible := TRUE;

      GetAsyncKeyState(VK_LBUTTON);
      GetAsyncKeyState(VK_RBUTTON);
   end;

end;
{
procedure TMenuForm.SystemMenuMusicClick(Sender: TObject);
begin
   Application.CreateForm(TByulbram,Byulbram);
   Byulbram.ShowModal;
end;
}
procedure   TMenuForm.SystemMenuExitClick(Sender: TObject);
begin
   Close;
end;

procedure   TMenuForm.HelpMenuHelpClick(Sender: TObject);
begin
   MessageDlg('𸣸 !',mtInformation,[mbOK],0);
end;

procedure   TMenuForm.HelpMenuAboutClick(Sender: TObject);
begin
   Application.CreateForm(TTitleForm,TitleForm);
   TitleForm.ShowModal;
end;

procedure   TMenuForm.HelpMenuRegisterClick(Sender: TObject);
begin
   Option.IsRegistered := not Option.IsRegistered;
   VerifyResiteration;
end;

procedure   TMenuForm.ToolBarStartClick(Sender: TObject);
begin
   SystemMenuStartClick(Sender);
end;

procedure   TMenuForm.ToolBarEditClick(Sender: TObject);
begin
   if ToolBarEdit.Down then begin
      NormalPanel.Visible := FALSE;
      EditPanel.Visible   := TRUE;
      Option.MainMode     := mmEdit;
   end else begin
      NormalPanel.Visible := TRUE;
      EditPanel.Visible   := FALSE;
      Option.MainMode     := mmGame;
   end;
end;

procedure   TMenuForm.ToolBarHelpClick(Sender: TObject);
begin
   HelpMenuHelpClick(Sender);
end;

procedure   TMenuForm.ToolBarExitClick(Sender: TObject);
begin
   SystemMenuExitClick(Sender);
end;

procedure   TMenuForm.LevelSelectorChange(Sender: TObject);
begin
   if LevelSelector.ItemIndex in [0..4] then begin
      MainUtDX.LEVEL_DATA := LevelSelector.ItemIndex + 1;
   end else begin
      MainUtDX.LEVEL_DATA := 0;
   end;
end;

procedure   TMenuForm.StageSelectorChange(Sender: TObject);
begin
   if StageSelector.ItemIndex in [0..Pred(MAX_STAGE)] then begin
      MainUtDX.STAGE_DATA := StageSelector.ItemIndex + 1;
   end;
end;

procedure   TMenuForm.ExclusiveCheckClick(Sender: TObject);
begin
   PlaneGroup.Enabled := ExclusiveCheck.Checked;
end;

procedure   TMenuForm.StageMakerGridSetEditText(Sender : TObject;
                    ACol, ARow : Integer; const Value : String);
begin
   Map.mNewMapData[ARow].mInformation := Value;
end;

procedure   TMenuForm.EditMenuButtonClick(Sender: TObject);
begin
   EditMenu.Popup(Left+100,Top+250);
end;

procedure   TMenuForm.EditMenuInitClick(Sender: TObject);
var
   i : integer;
begin
   LoadDialog.FileName := '';
   FileNameEdit.Text   := '';
   Map.InitializeMap;
   for i := 1 to Pred(StageMakerGrid.RowCount) do begin
      StageMakerGrid.Cells[1,i] := '';
   end;
end;

procedure   TMenuForm.EditMenuLoadClick(Sender: TObject);
var
   i : integer;
begin
   LoadDialog.Tag := 0;
   if LoadDialog.Execute then begin
      FileNameEdit.Text := ExtractFilename(LoadDialog.FileName);
      Map.LoadMap(LoadDialog.FileName);
      for i := 1 to Pred(StageMakerGrid.RowCount) do begin
         StageMakerGrid.Cells[1,i] := Map.mNewMapData[i].mInformation;
      end;
      LoadDialog.Tag := 1;
   end;
end;

procedure   TMenuForm.EditMenuSaveClick(Sender: TObject);
begin
   SaveDialog.Tag := 0;
   SaveDialog.FileName := LoadDialog.FileName;
   if SaveDialog.Execute then begin
      FileNameEdit.Text := ExtractFilename(SaveDialog.FileName);
      Map.SaveMap(SaveDialog.FileName);
      SaveDialog.Tag := 1;
   end;
end;

procedure   TMenuForm.VerifyResiteration;
begin
   ToolBarEdit.Enabled := Option.IsRegistered;
end;

end.
