Unit SrchPath;

INTERFACE

uses
   Windows;

const
   NONE   = 0;
   UP     = 1;
   LEFT   = 2;
   RIGHT  = 3;
   DOWN   = 4;
   START  = 5;

type

   TMapType = (mtTile,mtSpecial);

   PPath = ^TPath;
   TPath = record
      data : integer;
      next : PPath;
   end;

   PNode = ^TNode;
   TNode = record
      prev : PNode;
      data : integer;
      next : PNode;
   end;

   TSearchPath = Class

      constructor Create(max_x, max_y : word; var pMap);

   private
      MAX_MAP_X  : word;
      MAX_MAP_Y  : word;
      head, tail : PNode;
      Map        : array[mtTile..mtSpecial,0..99,0..99] of byte;

   public
      procedure   InitializeQueue;
      procedure   FinalizeQueue;
      function    IsQueueEmpty : boolean;
      procedure   Put(data : integer);
      function    Get : integer;
      function    CanGo(x, y : integer) : boolean;
      function    SearchPath(Sour, Dest : TPoint) : PPath;
      function    SearchNearest(Sour, Dest : TPoint) : string;

   end;

IMPLEMENTATION

constructor TSearchPath.Create(max_x, max_y : word; var pMap);
var
   x, y : integer;
   pb   : PByte;
begin
   inherited Create;

   MAX_MAP_X := max_x;
   MAX_MAP_Y := max_y;

   pb        := PByte(@pMap);
   for y := 0 to Pred(MAX_MAP_Y) do
   for x := 0 to Pred(MAX_MAP_X) do begin
      Map[mtTile,x,y] := pb^;
      inc(pb);
   end;
end;

procedure TSearchPath.InitializeQueue;
begin
   GetMem(head,sizeof(TNode));
   GetMem(tail,sizeof(TNode));
   head^.prev := head;
   head^.next := tail;
   tail^.prev := head;
   tail^.next := tail;
end;

procedure TSearchPath.FinalizeQueue;
var
   temp, aux : PNode;
begin
   temp := head;
   while (temp^.next <> tail) do begin
      aux  := temp;
      temp := temp^.next;
      FreeMem(aux,sizeof(TNode));
   end;
   FreeMem(temp,sizeof(TNode));
   FreeMem(tail,sizeof(TNode));
end;

function  TSearchPath.IsQueueEmpty : boolean;
begin
   if (head^.next = tail) then IsQueueEmpty := TRUE
                          else IsQueueEmpty := FALSE
end;

procedure TSearchPath.Put(data : integer);
var
   temp : PNode;
begin
   GetMem(temp,sizeof(TNode));
   if temp <> nil then begin
      tail^.prev^.next := temp;
      temp^.prev := tail^.prev;
      tail^.prev := temp;
      temp^.next := tail;
      temp^.data := data;
   end;
end;

function  TSearchPath.Get : integer;
var
   temp : PNode;
   i    : integer;
begin
   temp := head^.next;
   i    := temp^.data;

   head^.next := temp^.next;
   temp^.next^.prev := head;
   FreeMem(temp,sizeof(TNode));
   Get  := i;
end;

function  TSearchPath.CanGo(x, y : integer) : boolean;
begin
   CanGo := FALSE;
   if (x in [0..Pred(MAX_MAP_X)]) and (y in [0..Pred(MAX_MAP_Y)]) and
      (Map[mtTile,x,y] <> 1) and (Map[mtSpecial,x,y] = NONE) then begin
      CanGo := TRUE;
   end;
end;

function  TSearchPath.SearchPath(Sour, Dest : TPoint) : PPath;
var
   x, y              : integer;
   course, temp, mem : PPath;
begin
   InitializeQueue;

   for y := 0 to Pred(MAX_MAP_Y) do
   for x := 0 to Pred(MAX_MAP_X) do begin
      Map[mtSpecial,x,y] := NONE;
   end;

   Put(Dest.X); Put(Dest.Y);

   Map[mtSpecial,Dest.X,Dest.Y] := START;

   mem    := nil;
   temp   := nil;
   course := nil;

   while not IsQueueEmpty do begin
      x := Get;
      y := Get;

      if (x = Sour.X) and (y = Sour.Y) then begin
         while Map[mtSpecial,x,y] <> START do begin
            GetMem(mem,sizeof(TNode));
            mem^.data := Map[mtSpecial,x,y];

            if course = nil then begin
               temp   := mem;
               course := temp;
            end else begin
               temp^.next := mem;
               temp       := mem;
            end;

            if      Map[mtSpecial,x,y] = UP    then dec(y)
            else if Map[mtSpecial,x,y] = DOWN  then inc(y)
            else if Map[mtSpecial,x,y] = LEFT  then dec(x)
            else if Map[mtSpecial,x,y] = RIGHT then inc(x)
         end;
         if Assigned(mem) then mem^.next := nil;
         SearchPath := course;
         FinalizeQueue;
         exit;
      end;

      if CanGo(x,y-1) then begin
         Map[mtSpecial,x,y-1] := DOWN;
         Put(x); Put(y-1);
      end;

      if CanGo(x-1,y) then begin
         Map[mtSpecial,x-1,y] := RIGHT;
         Put(x-1); Put(y);
      end;

      if CanGo(x+1,y) then begin
         Map[mtSpecial,x+1,y] := LEFT;
         Put(x+1); Put(y);
      end;

      if CanGo(x,y+1) then begin
         Map[mtSpecial,x,y+1] := UP;
         Put(x); Put(y+1);
      end;

   end;

   FinalizeQueue;
   SearchPath := nil;
end;

function  TSearchPath.SearchNearest(Sour, Dest : TPoint) : string;
var
   temp, aux  : PPath;
   Return     : string;
begin
   temp := SearchPath(Sour,Dest);

   Return := '';
   while (temp <> nil) do begin
      if temp^.data = UP    then Return := Return + '4';
      if temp^.data = DOWN  then Return := Return + '6';
      if temp^.data = LEFT  then Return := Return + '2';
      if temp^.data = RIGHT then Return := Return + '8';
      aux  := temp^.next;
      FreeMem(temp,sizeof(TNode));
      temp := aux;
   end;

   SearchNearest := Return
end;

end.
