unit Title;

interface

uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
   StdCtrls, ImageSub, SMHan10;

type
   TTitleForm = class(TForm)
      Button1 : TButton;
      procedure FormCreate(Sender: TObject);
      procedure FormPaint(Sender: TObject);
      procedure FormClose(Sender: TObject; var Action: TCloseAction);
      procedure Button1Click(Sender: TObject);

   private
      FIsFirst : boolean;
   end;

var
   TitleForm : TTitleForm;

implementation

{$R *.DFM}
uses
   Menu;

procedure  PutPixel(x, y : integer; Color : TColorRef);
begin
   TitleForm.Canvas.Pixels[x,y] := Color;
end;

procedure   TTitleForm.FormCreate(Sender: TObject);
begin
   Width  := 640+6;
   Height := 480+25;

   Button1.Left := Width  - Button1.Width  - 15;
   Button1.Top  := Height - Button1.Height - 35;

   FIsFirst := TRUE;
end;

procedure   TTitleForm.FormPaint(Sender: TObject);
const
   MESSAGE_X   = 90;
   MESSAGE_Y   = 170;
   Message_GAP = 20;
   MAX_STR     = 3;
   TitleStr : array[1..MAX_STR] of string = (
      '  ȹ : ȿ(SMgal)',
      '׷ : ڼ(NeoTouch)',
      '   : 豤(ٶ)'
   );
var
   i        : integer;
   ImageSub : TImageSub;
begin
   ImageSub := TImageSub.Create(Canvas.Handle);
   ImageSub.loadPCX256('Title',0,0,FALSE);
   ImageSub.loadDIBitmap256;
   ImageSub.Free;

   SMHan10.InitializeSM(PutPixel);
   SMHan10.SetHangulUnit(huGradation);
   for i := 1 to MAX_STR do begin
      SMHan10.PrintHangul(MESSAGE_X,MESSAGE_Y + Pred(i)*MESSAGE_GAP,PChar(TitleStr[i]),RGB(255,255,255),FALSE);
   end;
   SMHan10.FinalizeSM;
end;

procedure   TTitleForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
end;

procedure   TTitleForm.Button1Click(Sender: TObject);
begin
   Close;
end;

end.
