// DirectDraw.cpp

#include "StdAfx.h"
#include "DirectDraw.h"
#include <ddraw.h>

CDirectDraw :: CDirectDraw() 
{
	m_pDD = NULL;
	m_pDDSPrimary = NULL;
	m_pDDSBack = NULL;
	m_pPalette = NULL;

	m_bFullMode = false;
	m_bActive = false;
	m_lpSurface = NULL;
}

CDirectDraw :: ~CDirectDraw()
{
	Release();
}

bool CDirectDraw :: Create()
{
	HRESULT  hRet;

	hRet = DirectDrawCreate(NULL, &m_pDD, NULL);

	if FAILED (hRet) 
		return false;
	
	return true;
}

void CDirectDraw :: Release() 
{
	if (m_pDD) {

		//	ǥ鿡 õ ͵ Ų.
		ReleaseSurface();

		m_pDD->Release();
		m_pDD = NULL;
	}
	m_bActive = false;
}

void CDirectDraw :: ReleaseSurface()
{
	m_pDD->RestoreDisplayMode();

	if (m_pPalette) {
		m_pPalette->Release();
		m_pPalette = NULL;
	}

	if (m_pDDSBack) {
		m_pDDSBack->Release();
		m_pDDSBack = NULL;
	}

	if (m_pDDSPrimary) {
		m_pDDSPrimary->Release();
		m_pDDSPrimary = NULL;
	}
}

bool CDirectDraw :: SetDisplayMode(HWND hWnd, int w, int h, int bpp, bool bFull)
{
	HRESULT				hRet;
	DDSURFACEDESC		ddsd;
	DDSCAPS				ddscaps;
	LPDIRECTDRAWCLIPPER pClipper;

	m_iWidth = w;
	m_iHeight = h;
	m_iBpp = bpp;
	m_bFullMode = bFull;

	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);

	if (m_bFullMode) {
		hRet = m_pDD->SetCooperativeLevel (hWnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN | DDSCL_ALLOWREBOOT);
		if FAILED (hRet)
			return false;

		hRet = m_pDD->SetDisplayMode(m_iWidth, m_iHeight, m_iBpp);
		if FAILED (hRet)
			return false;

		ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | 
							  DDSCAPS_FLIP | 
							  DDSCAPS_COMPLEX |
							  DDSCAPS_VIDEOMEMORY;							  
		ddsd.dwBackBufferCount = 1;

		hRet = m_pDD->CreateSurface(&ddsd, &m_pDDSPrimary, NULL);
		if FAILED (hRet) {
			ddsd.ddsCaps.dwCaps &= ~DDSCAPS_VIDEOMEMORY;
			hRet = m_pDD->CreateSurface(&ddsd, &m_pDDSPrimary, NULL);
			if FAILED (hRet) 
				return false;
		}

		ddscaps.dwCaps = DDSCAPS_BACKBUFFER | DDSCAPS_VIDEOMEMORY;
		hRet = m_pDDSPrimary->GetAttachedSurface(&ddscaps, &m_pDDSBack);
		if FAILED (hRet) {
			ddscaps.dwCaps &= ~DDSCAPS_VIDEOMEMORY;
			hRet = m_pDDSPrimary->GetAttachedSurface(&ddscaps, &m_pDDSBack);
			if FAILED (hRet)
				return false;
		}
	} else {
		hRet = m_pDD->SetCooperativeLevel(hWnd, DDSCL_NORMAL);
		if FAILED (hRet) 
			return false;

		ddsd.dwFlags = DDSD_CAPS;
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
		hRet = m_pDD->CreateSurface(&ddsd, &m_pDDSPrimary, NULL);
		if FAILED (hRet) 
			return false;

		hRet = m_pDD->CreateClipper(0, &pClipper, NULL);
		if FAILED (hRet) 
			return false;

		pClipper->SetHWnd(0, hWnd);
		m_pDDSPrimary->SetClipper(pClipper);
		pClipper->Release();
		pClipper = NULL;

		ddsd.dwFlags = DDSD_WIDTH |	DDSD_HEIGHT | DDSD_CAPS;
		ddsd.dwWidth = m_iWidth;
		ddsd.dwHeight = m_iHeight;
		ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
		hRet = m_pDD->CreateSurface(&ddsd, &m_pDDSBack, NULL);
		if FAILED (hRet)
			return false;

	}
	
	return true;
}

bool CDirectDraw :: Flip(DWORD dwFlags)
{
	HRESULT hRet;
	hRet = m_pDDSPrimary->Flip(NULL, dwFlags);

	if (hRet == DDERR_SURFACELOST) {
		if (m_pDDSPrimary->IsLost() != DD_OK)
			m_pDDSPrimary->Restore();
	}

	return true;
}

void *CDirectDraw :: Lock() 
{
	DDSURFACEDESC	ddsd;

	if (m_lpSurface)
		Unlock();

	ZeroMemory(&ddsd, sizeof(ddsd));
	ddsd.dwSize = sizeof(ddsd);

	m_pDDSBack->Lock(NULL, &ddsd, DDLOCK_WAIT | DDLOCK_SURFACEMEMORYPTR, NULL);


	m_lpSurface =  ddsd.lpSurface;

	return (void *) m_lpSurface;
}

void CDirectDraw :: Unlock()
{
	if (m_lpSurface)
		m_pDDSBack->Unlock(m_lpSurface);
	m_lpSurface = NULL;
}