//	DirectDraw.h

#ifndef __CDIRECTDRAW
#define __CDIRECTDRAW

#pragma once

class CDirectDraw {
protected:
	LPDIRECTDRAW			m_pDD;
	LPDIRECTDRAWSURFACE		m_pDDSPrimary;
	LPDIRECTDRAWSURFACE		m_pDDSBack;
	LPDIRECTDRAWPALETTE		m_pPalette;

	LPVOID					m_lpSurface;
	bool					m_bFullMode;
	int						m_iWidth;
	int						m_iHeight;
	int						m_iBpp;
	bool					m_bActive;

		
public:
	CDirectDraw();
	virtual ~CDirectDraw();
	bool Create();
	void Release();
	void ReleaseSurface();

	bool SetDisplayMode(HWND hWnd, int w, int h, int bpp, bool bFull);
	void *Lock();
	void Unlock();

	bool Flip(DWORD dwFlags = DDFLIP_WAIT);
	bool IsFullScreen() { return m_bFullMode; }
	bool Update();
	LPDIRECTDRAWSURFACE GetFrontBuffer() { return m_pDDSPrimary; }
	LPDIRECTDRAWSURFACE GetBackBuffer() { return m_pDDSBack; }
};

#endif

	
	
