// directWnd.cpp: DirectX  CWnd  ü̴.
//
// Implementation for:
// CDirectWnd
//

#include "stdafx.h"
#include "DirectDraw.h"
#include "DirectWnd.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//  ̷Ʈ ο ü

/////////////////////////////////////////////////////////////////////////////
// CDirectWnd

CDirectWnd::CDirectWnd()
{
	//  ä ִ´
	m_pCDD = NULL;
	m_bAutoDelete = false;
	m_bAppActive  = false;
	m_bFullScreen = false;

	m_rcClient	= CRect(0, 0, 640, 480);
	m_iWidth	= m_rcClient.Width();
	m_iHeight	= m_rcClient.Height();
}

CDirectWnd::~CDirectWnd()
{
	m_pCDD->Release();
}

BEGIN_MESSAGE_MAP(CDirectWnd, CWnd)
	//{{AFX_MSG_MAP(CDirectWnd)
	ON_WM_DESTROY()
	ON_WM_ACTIVATEAPP()
	ON_WM_ERASEBKGND()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// ̷Ʈ 츦 Ѵ
// Ű:
// pszCaption : ø̼ ĸ
// size : Ŭ̾Ʈ  ũ
// bpp : ̷Ʈ ο ǽ Ʈ 
// bFull : ȭ  ÷.  츦 Ѵ
// pParent :   .  ǹ 
bool CDirectWnd::Create(LPCTSTR pszCaption, SIZE size, int bpp, bool bFull, CWnd *pParent)
{
	const char* pszClass = AfxRegisterWndClass(CS_VREDRAW | CS_HREDRAW,
				::LoadCursor(NULL, IDC_ARROW),
				(HBRUSH)::GetStockObject(GRAY_BRUSH));

	// Ȯ  Ÿ
	DWORD dwStyle = bFull? WS_VISIBLE | WS_POPUP : WS_OVERLAPPED | WS_SYSMENU;

	// Ŭ̾Ʈ  츦   Ѵ
	CSize area = size;
	
	//  ũ Ŭ̾Ʈ    ũ̴
	area.cx += GetSystemMetrics(SM_CXSIZEFRAME);
    area.cy += GetSystemMetrics(SM_CYSIZEFRAME) + GetSystemMetrics(SM_CYMENU) * 2;
	//  *2 ൵ ٵ... 켱  ߾
	
	//  Ÿ Ѵ.
	if (CWnd::CreateEx(0, pszClass, pszCaption, dwStyle, 0, 0, 
		area.cx, area.cy, (pParent ? pParent->GetSafeHwnd() : NULL), NULL) == FALSE)
	{
		return false;
	}


	m_pCDD = new CDirectDraw();
	if (!m_pCDD) 
		return false;
	
	// ̷Ʈ ο Ŭ Ѵ
	if (!m_pCDD->Create()) 
		return false;
	// ÷ 带 Ѵ
	if (!m_pCDD->SetDisplayMode(GetSafeHwnd(), size.cx, size.cy, bpp, bFull))
		return false;

	//  Ŭ̾Ʈ  ũ⸦ Ѵ
	m_rcClient = CRect(0, 0, size.cx, size.cy);
	m_iWidth = size.cx;
	m_iHeight = size.cy;

	// ʱ⿡ ø̼ ϴ · ´
	m_bAppActive = true;

	//     ڴµ...
	// 鼭ǽ   ߰
	
	//  Ͽ
	return true;
}

///////////////////////////////////////////////////////////////////////////////
// Message Handler

void CDirectWnd::OnDestroy() 
{
	CWnd::OnDestroy();
}

void CDirectWnd::PostNcDestroy()
{
	CWnd::PostNcDestroy();
	if (m_bAutoDelete)
	{
		delete this;
	}
}

// :  Լ  ̷Ʈ 찡 ø̼ 
//  쿡 ȣǾ Ѵ. ٸ 쿡 ø̼
// WM_ACTIVATE޽  ڵ鸵ؾ Ѵ
void CDirectWnd::OnActivateApp(bool bActive, HTASK hTask) 
{
	m_bAppActive = bActive;

	// ̷Ʈ ο ü ˰ ־ Ѵ
//	if (m_pDD)
//	{
		// m_pDD->OnActivate(bActive);
//	}
}

bool CDirectWnd::OnEraseBkgnd(CDC* pDC)
{
	return true; // 츮 ̹ ڵ鸵 ߴٰ ش
}

///////////////////////////////////////////////////////////////////////////////
// Implementation

// ũ Ѵ
//  ø̼ ̵ ¶  ְ
//  ̷ ٸ  ش
bool CDirectWnd::Update()
{
	// ø̼ ΰ?
	if (!m_bAppActive)
		return false;

	//  Ǯȭ  ܼ øϸ 
	// ׷ ʴٸ 1 ǥ  ؾ߸ Ѵ
	if (IsFullScreen()) {
		m_pCDD->Flip();
	} else {
		// Ŭ̾Ʈ  ȭ ǥ Ѵ
		CPoint pt(0, 0);
		ClientToScreen(&pt);

		CRect rect = m_rcClient;
		rect.OffsetRect(pt);

		// ۿ Ʈ ۷  Ѵ
		HRESULT hr;
		LPDIRECTDRAWSURFACE pDDS = m_pCDD->GetFrontBuffer();
		hr = pDDS->Blt(rect, m_pCDD->GetBackBuffer(), NULL, DDBLT_WAIT, NULL);
		if (hr == DDERR_SURFACELOST)
			pDDS->Restore();
	}

	//   ̷
	return true;
}

void CDirectWnd :: Release()
{
	if (m_pCDD)
		m_pCDD->Release();

}
