// EditWnd.cpp : implementation file
//

#include "stdafx.h"
#include "GEditor.h"
#include "EditWnd.h"
#include "Animate.h"
#include "GTools.h"

#include <list>

using namespace std;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



/////////////////////////////////////////////////////////////////////////////
// CEditWnd

const int _WIDTH = 800;
const int _HEIGHT = 600;
const int _BPP = 24;
const int _IPITCH = _WIDTH * _BPP >> 3;
const int _SCREENSIZE = _IPITCH * _HEIGHT;

CAnimate Animate;

CEditWnd::CEditWnd()
{

}

CEditWnd::~CEditWnd()
{
}


BEGIN_MESSAGE_MAP(CEditWnd, CWnd)
	//{{AFX_MSG_MAP(CEditWnd)
	ON_WM_CLOSE()
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CEditWnd message handlers
void CEditWnd :: Create(bool bFullMode) 
{

	if( !CDirectWnd :: Create("Editor V 1.00", CSize(_WIDTH, _HEIGHT), _BPP, bFullMode, NULL) )
		MessageBox("DD Setup fail", "Msg", 0);

	Animate.Create(IDD_ANIMATE, this);
	Animate.ShowWindow(SW_SHOW);
}

void CEditWnd :: Release()
{

}

BYTE	mix [_SCREENSIZE] ; 
bool CEditWnd :: Update()
{

	PBYTE	buf;
	FillMemory(mix, _SCREENSIZE, 0x00);

	if (Animate.m_pImage) {
		IMAGE img;
		img.bpp = _BPP;
		img.height = _HEIGHT;
		img.width = _WIDTH;
		img.pBuf = mix;
		img.pPal = NULL;
		DrawImage24(&img, 0, 0, Animate.m_pImage);
	}

	buf = (PBYTE)Lock();
	if (buf)
		CopyMemory(buf, mix, _SCREENSIZE);
	else {
		MessageBox("failed", "Msg",0);
		SendMessage(WM_CLOSE);
		return false;
	}

	Unlock();	

	CDirectWnd :: Update();
	return true;
}

void CEditWnd::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	Release();
	CWnd::OnClose();
}

void CEditWnd::OnFileOpen() 
{
	// TODO: Add your command handler code here
	// TODO: Add your command handler code here
	int pos = 0;
	char *filter = 
		"PCX Files (*.pcx) |*.pcx| All Files (*.*) |*.*||";

	CFileDialog	FileDialog( TRUE, NULL, "*.pcx", 
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
		filter, NULL );

	FileDialog.m_ofn.Flags |= OFN_ALLOWMULTISELECT;
	if (FileDialog.DoModal() != IDOK) 
		return;

	CString str;
	POSITION position = FileDialog.GetStartPosition();

	while(position) {
		str = FileDialog.GetNextPathName(position);

		IMAGE *img = new IMAGE;

		//	PCX file дµ  list ͸ ߰ϰ 
		//	׷ 쿡 ҴǾ ޸𸮸 Ѵ.
		//	ȷƮ κ ߰  ʿ  Ƽ ȷƮ List  ִ´.
		if (!ReadPcx(str, img))
			delete img;
		if (ReadPcx(str, img)) {
//			if (img->pPal) Animate.m_PalList.push_back(img->pPal);
			Animate.m_ImageList.push_back(img);
			Animate.m_lstImage.InsertItem(Animate.m_lstImage.GetItemCount(), str);
		} else {
			delete img;
		}

	}
}
