//	GTools.cpp

#include "StdAfx.h"
#include "GTools.h"

bool	ReadPcx(LPCSTR filename, IMAGE *desImage)
{
	CFile	f;
	SIZE	size;
	DWORD	dwBodySize;
	PCXHEADER	header;
	
	ZeroMemory(desImage, sizeof(desImage));

	if (!f.Open(filename, CFile::modeRead))
		return false;

	f.Read(&header, sizeof(header));
	size.cx = header.ex - header.sx + 1;
	size.cy = header.ey - header.sy + 1;
	
	if ((header.manufacturer != 10) || (header.version != 5))
		return false;

	if (header.color_planes == 3) {
		desImage->bpp = 24;
		dwBodySize = f.GetLength() - sizeof(header) + 1;
		desImage->pBuf = new BYTE [ size.cx * size.cy * 3 ];		
		desImage->pPal = NULL;
	} else if (header.color_planes == 1) {
		desImage->bpp = 8;
		desImage->pPal = new PCXPAL;
		dwBodySize = f.GetLength() - sizeof(header) - 768;
		if (!desImage->pPal) return false;
		desImage->pBuf = new BYTE [ size.cx * size.cy ];		
	} else
		return false;

	if (!desImage->pBuf) {
		if (desImage->pPal) 
			delete desImage->pPal;
		return false;
	}

	PBYTE	pOrigin = NULL;
	pOrigin = new BYTE [dwBodySize];
	if (!pOrigin) return false;

	f.Read(pOrigin, dwBodySize);
	if (desImage->pPal)
		f.Read(desImage->pPal, 768);

	desImage->width = size.cx;
	desImage->height = size.cy;

	int i = 0, num;
	int	cnt = size.cx * size.cy * desImage->bpp >> 3;

	PBYTE pSrc = pOrigin;
	PBYTE pDes = desImage->pBuf;
		
	while (i < cnt) {
		if (*pSrc >= 0xc0) {
			num = (*pSrc) & 0x3f;
			pSrc++;
			while(num--)
				pDes[i++] = *pSrc;
			pSrc++;
		} else {
			pDes[i++] = *pSrc;
			pSrc++;
		}
	}	

	delete pOrigin;
	f.Close();

	if (desImage->bpp == 24) {
		int i, j;
		int iPitch = (desImage->bpp >> 3) * desImage->width;
		
		pSrc = new BYTE[iPitch];
		if (!pSrc) return false;
		
		pDes = desImage->pBuf;
		for (i = 0; i < desImage->height; i ++) {
			CopyMemory(pSrc, pDes, iPitch);
			ZeroMemory(pDes, iPitch);
			for (j = 0; j < desImage->width; j ++) {
				pDes[0] = pSrc[desImage->width * 2 + j];
				pDes[1] = pSrc[desImage->width + j];
				pDes[2] = pSrc[j];
				pDes += 3;		
			}
		}
		delete pSrc;
	}

	return true;
}

bool	WritePcx(LPCSTR filename, IMAGE *desImage)
{
	

	return true;
}

void	DrawImage24(IMAGE *pDes, int x, int y, IMAGE *pSrc)
{
	//	  24 bit color  ƴϰ,   8 bit color ε ȷƮ  
	if (pDes->bpp != 24) return;
	if (pSrc->bpp == 8 && pSrc->pPal == NULL) return;

	//	   쿡 
	if (pDes->width < x || pDes->height < y || 
		(- x) > pSrc->width || (- y) > pSrc->height) return;

	int width = pSrc->width;
	int height = pSrc->height;
	int i, j, desPitch, srcPitch, srcCpp, desCpp;

	srcCpp = pSrc->bpp >> 3;
	desCpp = pDes->bpp >> 3;
	srcPitch = pSrc->width * srcCpp;
	desPitch = pDes->width * desCpp;	

	PBYTE des = pDes->pBuf + (x * desCpp) + y * desPitch;
	PBYTE src = pSrc->pBuf;

	if (x < 0 ) { 
		src += (- x) * srcCpp;
		width += x;
	} else if (x > 0) {
		des += x * desCpp;
	}

	if (y < 0) {
		src += (- y) * srcPitch;
		height += y;
	} else if (y > 0) {
		des += y * desPitch;
	}


	if (x + pSrc->width > pDes->width) width += pDes->width - (x + pSrc->width);
	if (y + pSrc->height > pDes->height) height += pDes->height - (y + pSrc->height);

	for (i = 0; i < height; i ++) {
		if (pSrc->bpp == 8) {
			for (j = 0; j < width; j ++) {
				des[j * desCpp + 2] = pSrc->pPal->buf[src[j]].r;
				des[j * desCpp + 1] = pSrc->pPal->buf[src[j]].g;
				des[j * desCpp + 0] = pSrc->pPal->buf[src[j]].b;
			}
		} else {
			CopyMemory(des, src, width * pSrc->bpp >> 3);			
		}
		src += srcPitch;
		des += desPitch;
	}

}



