//	GTools.h

#ifndef	__GTOOLS
#define __GTOOLS

struct PCXHEADER {	
	char	manufacturer;
	char	version;
	char	encoding;
	char	bits_per_pixel;
	short	sx, sy, ex, ey;
	short	hres, vres;
	char	palette[48];
	char	reserved;
	char	color_planes;
	short	bytes_per_line;
	short	palette_type;
	char	filler[58];
};

struct PCXPALETTEENTRY {
	unsigned char r;
	unsigned char g;
	unsigned char b;
};

struct PCXPAL {
	PCXPALETTEENTRY buf[256];
};

struct IMAGE {
	int		width;
	int		height;
	int		bpp;
	PBYTE	pBuf;
	PCXPAL	*pPal;
};

bool	ReadPcx(LPCSTR filename, IMAGE *desImage);
bool	WritePcx(LPCSTR filename, IMAGE *desImage);
void	DrawImage24(IMAGE *pDes, int x, int y, IMAGE *pSrc);

#endif