////////////////////////////////////////////////////////////////////
//  File:   cmap.cpp											  //
//  Description: map class										  //
//  Rev:   A													  //
//  Created : September 1998									  //
//																  //
//  Author: Guillaume Jay										  //
//  mail:   jay@mail.dotcom.fr									  //
//																  //
////////////////////////////////////////////////////////////////////    

#include "isoxmain.h"



CMap::CMap()
{
	MapData=NULL;
	Clear();
}

CMap::~CMap()
{
	if (MapData)
		delete [] MapData;
}

void CMap::Clear()
{
	if (MapData)
		delete [] MapData;
	MapData=NULL;
	Height=0;Width=0;NbCases=0;
	MapName[0]='\0';
}

CCase::CCase()
{
	Ground=0;
	//Objects=NULL;
}

BOOL CCase::Read(FILE *MapHandle)
{
	return fread(&Ground,sizeof(Ground),1,MapHandle);
}

BYTE CMap::Load(char *NewMapName)
{ // 0 if succesful, or error code
	Clear();
	strcpy(MapName,NewMapName);
	FILE *MapHandle;
	if (!(MapHandle=fopen(MapName,"rb")))
		return OPEN_ERROR;
	if (!fread(&Width,sizeof(MAPDIM),1,MapHandle))
	{
		fclose(MapHandle);
		return MAGIC_ERROR;
	}
	if (!fread(&Height,sizeof(MAPDIM),1,MapHandle))
	{
		fclose(MapHandle);
		return MAGIC_ERROR;
	}
	NbCases=Width*Height;
	if (!(MapData=new CCase[NbCases]))
	{
		fclose(MapHandle);
		return MEMORY_ERROR;
	}
	for (DWORD i=0;i<NbCases;i++)
	{
		if (!MapData[i].Read(MapHandle))
		{
			fclose(MapHandle);
			return READ_ERROR;
		}
	}
	fclose(MapHandle);
	return 0;
}

void CMap::ErrorText(BYTE ErrorCode, char Error[250])
{
	switch(ErrorCode)
	{
		case OPEN_ERROR:
			sprintf(Error,"Error while opening %s !",MapName);
			break;
		case MEMORY_ERROR:
			sprintf(Error,"Error while allocating %d bytes for %s !",NbCases*sizeof(CCase), MapName);
			break;
		case READ_ERROR:
			sprintf(Error,"Error while reading %s !",MapName);
			break;
		case MAGIC_ERROR:
			sprintf(Error,"Magic cookie not found in %s !", MapName);
			break;
		default:
			strcpy(Error,"Unknown error in CMap !"); // should never appear.
			break;
	}
}
