////////////////////////////////////////////////////////////////////
//  File:   csprite.cpp											  //
//  Description: Sprite class									  //
//  Rev:   A													  //
//  Created : September 1998									  //
//																  //
//  Author: Yannis Deliyannis									  //
//  mail:   yannis@club-internet.fr								  //
//																  //
//  no copyright												  //
////////////////////////////////////////////////////////////////////    

#include "isoxmain.h"


void CSprite::Init()
{
	m_ddSurface = NULL;
	m_spriteX = 0;
	m_spriteY = 0;
	m_frame = 0;
	m_bVisible = TRUE;
}


CSprite::CSprite(LPSTR filename, unsigned short width, unsigned short height)
{
	LPDIRECTDRAW lpdd = DDGetLPDirectDraw();

	// Initialize
	Init();

	// Create offscreen surface holding sprite bitmap
	m_ddSurface = DDLoadBitmap (lpdd, filename, 0, 0);

	if (m_ddSurface == NULL)
	{
		OutputDebugString( "CSprite (DDLoadBitmap) : Couldn't create CSprite object surface...\n" );
		return;
	}

	// Set color key for this surface
	DDSetColorKey (m_ddSurface, RGB(255,255,255));

	// initialize variables
	m_w = width;
	m_h = height;
}


CSprite::~CSprite()
{
	if( m_ddSurface != NULL )
		m_ddSurface->Release();
}


void CSprite::Render (LPDIRECTDRAWSURFACE lpDestSurf, signed short x, signed short y, unsigned short frame, BOOL bMirroring)
{
	DDBLTFX     ddbltfx;

	RECT srcRect;
	RECT destRect = {x-m_w, y-m_h, x, y};
	
	signed short xOffset,yOffset;
	signed short xLen, yLen;
	signed short xOff, yOff;

	if (frame < 10) 
	{
		xOffset=frame * (m_w+1);
		yOffset=0;
	}
	else if (frame < 20) 
	{
		xOffset = (frame-10) * (m_w+1);
		yOffset = m_h;
	}
	else if (frame < 30)
	{
		xOffset = (frame-20) * (m_w+1);
		yOffset = m_h*2;
	}
	else if (frame < 40)
	{
		xOffset = (frame - 30) * (m_w+1);
		yOffset = m_h*3;
	}
	else if (frame < 50)
	{
		xOffset = (frame - 40) * (m_w+1);
		yOffset = m_h*4;
	}
	else if (frame < 60)
	{
		xOffset = (frame - 50) * (m_w+1);
		yOffset = m_h*5;
	}

	x-=m_w;
	y-=m_h;

	xLen = m_w;
	yLen = m_h;

	xOff = 0;
	yOff = 0;
	
	if (x < 0) 
	{
		xLen+=x;
		xOff=-x;
		x=0;
	}

	if (x+m_w > 639) 
	{
		xLen=640-x;
	}

	if (y < 0)
	{
		yLen=m_h+y;
		yOff+=(y*-1);
		y=0;	
	}

	if (y+m_h > 479)
	{
		yLen=480-y;
		if (y>480) 
			return ;
	}

	if (xLen < 0 || yLen < 0) 
		return ;


	srcRect.left=xOffset+xOff;
	srcRect.top=yOffset+yOff;
	srcRect.right=xOffset+xOff+xLen;
	srcRect.bottom=yOffset+yOff+yLen;

	if (destRect.left < 0)
		destRect.left = 0;
	if (destRect.top < 0)
		destRect.top = 0;
	if (destRect.right > Screen.Width())
		destRect.right = Screen.Width();
	if (destRect.bottom > Screen.Height())
		destRect.bottom = Screen.Height();

	ZeroMemory(&ddbltfx, sizeof(ddbltfx));
	ddbltfx.dwSize = sizeof(ddbltfx);

	if (bMirroring)
		ddbltfx.dwDDFX = DDBLTFX_MIRRORLEFTRIGHT;
	else
		ddbltfx.dwDDFX = NULL;

	lpDestSurf->Blt(&destRect, m_ddSurface, &srcRect, DDBLT_DDFX | DDBLT_WAIT | DDBLT_KEYSRC, &ddbltfx); 		
}
