
#ifndef _ISOXDDRAW_H
#define _ISOXDDRAW_H

// Structure definition ///////////////

typedef struct _DDraw
{
	HWND					hwndApp;

	LPDIRECTDRAW			lpDD;			// Pointer to DirectDraw object
	//LPDIRECTDRAW4			lpDD4;
	
	LPDIRECTDRAWSURFACE		lpDDSPrimary;	// Pointer to primary surface
	LPDIRECTDRAWSURFACE		lpDDSBack;		// Pointer to back buffer
	LPDIRECTDRAWSURFACE		lpDDSTiles;		// Pointer to offscreen tile surface
	LPDIRECTDRAWSURFACE		lpDDSBoard;		// Pointer to offscreen board surface

	LPDIRECTDRAWPALETTE		lpDDPal;
	LPDIRECTDRAWCLIPPER		lpClipper;		// Pointer to clipper
	DDBLTFX					ddbltfx;
	BOOL					fEnabled;		// DirectDraw enabled
	BOOL					fFullScreen;	// True when in FullScreen mode

	int						nCooperation;	// Cooperation level
	int						cx;				// Width of window
	int						cy;				// Height of window
	int						bbp;			// Bits per plane
	int						nBuffers;		// Numbers of buffers to create
} DDraw, *LPDDraw;

extern LPDDraw lpdraw;

typedef struct tagDisplayMode
{
	int width;
	int height;
	int bpp;
} DisplayMode, FAR *LPDisplayMode;



// Functions declarations ///////////////////

BOOL DDEnable();
static BOOL DDCreateSurfaces();
LPDIRECTDRAWSURFACE DDCreateSurface(DWORD width, DWORD height, BOOL sysmem);
void DDSetWidth( int w );
void DDSetHeight( int h );
void DDSetBpp( int bpp );
void DDDestroy();
void DDDisable();
BOOL DDSetCooperativeLevel(int level);
int DDGetCooperativeLevel();
LPDIRECTDRAW DDCreate(HWND hwndApp);
BOOL DDFlip();
HRESULT DDTextOut( LPDIRECTDRAWSURFACE lpDDSSurface, char* lpString, COLORREF BackColor, COLORREF TextColor, int posx, int posy);
void BlitBoard (LPDIRECTDRAWSURFACE lpDDSScreen);
LPDIRECTDRAW DDGetLPDirectDraw();

#endif