
#ifndef _ISOXMAIN_H
#define _ISOXMAIN_H


#define STRICT
#define WIN32_LEAN_AND_MEAN


#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <ddraw.h>
#include <mmsystem.h>
	
#include "ddutil.h"

#include "cmap.h"
#include "cmusic.h"
#include "csprite.h"
#include "cscreen.h"

#include "isoxmap.h"
#include "isoxddraw.h"
#include "isoxutil.h"	// not for release



// Structure definitions //////////////////////////////
// Global Variables ///////////////////////////////////

typedef struct _GApp
{
	// Global datas //
	HWND		hwnd;
	RECT		wndRect;
	UINT		timerid;
	BOOL		bFlippingPaused;
	BOOL		bCanRunWindowed;
} GApp;

extern GApp gapp;


// classes definitions /////////////////////////////////

extern CScreen  Screen;
extern CSprite* Player;
extern CSprite* Tree;

// Functions declarations //////////////////////////////

static	BOOL DoInit (HINSTANCE hInstance, int nCmdShow);
static	BOOL DDrawInit();
long	FAR PASCAL WindowProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
static	BOOL InitFail (HWND hwnd);
static void MainLoop();
static	BOOL DrawInit();
static void PlayerNextFrame();
static	BOOL FillBufferRect(LPDIRECTDRAWSURFACE lpSurface, LPRECT lprect, COLORREF color);
void	CheckKeyboard();
BOOL	CreateObjects();
void	DestroyObjects();

#endif