////////////////////////////////////////////////////////////////////
//  File:   isoxmap.cpp											  //
//  Description: Take care of map graphics and drawing			  //
//  Rev:   A													  //
//  Created : September 1998									  //
//																  //
//  Author: Yannis Deliyannis									  //
//			(some functions are from Terence Tan, 1997)			  //
//  mail:   yannis@club-internet.fr								  //
//																  //
//  no copyright												  //
////////////////////////////////////////////////////////////////////    

#include "isoxmain.h"


MAP_INFO map[MAP_HEIGHT][MAP_WIDTH];

MAP_INFO objects[MAP_HEIGHT][MAP_WIDTH];


// SetupMap -- Load data into map structure ///////////////////

void SetupMap()
{
	MAPDIM i,j;
	BYTE retour;
	
	CMap Map;
	if ((retour=Map.Load("Map.Bin")))
	{
		char Error[250];
		Map.ErrorText(retour,Error);
		MessageBox (gapp.hwnd, Error, "IsometriX Engine", MB_OK);
		DestroyWindow(gapp.hwnd);
		return;
	}
  // transform the map into map structure
  for(i=0;i<MAP_HEIGHT;i++)
  {
    for(j=0;j<MAP_WIDTH;j++)
	{
		switch (Map.GetGround(j,i)) {
		case 0: // Grass
			map[i][j].num       = 1; 
            map[i][j].tile[0]   = 0;
            map[i][j].height[0] = 0;
            map[i][j].layer[0]  = 0;
			map[i][j].walkable = TRUE;
            break;
		case 1: // Road
			map[i][j].num       = 1; 
            map[i][j].tile[0]   = 1;
            map[i][j].height[0] = 0;
            map[i][j].layer[0]  = 0;
			map[i][j].walkable = TRUE;
            break;
		case 2: // Water
			map[i][j].num       = 1; 
            map[i][j].tile[0]   = 2;
            map[i][j].height[0] = 0;
            map[i][j].layer[0]  = 0;
			map[i][j].walkable = FALSE;
            break;
		case 3: // Building corner
			map[i][j].num       = 3; 
            map[i][j].tile[0]   = 3;
            map[i][j].height[0] = 0;
            map[i][j].layer[0]  = 1;
            map[i][j].tile[1]   = 4;
            map[i][j].height[1] = 0;
            map[i][j].layer[1]  = 1;
            map[i][j].tile[2]   = 5;
            map[i][j].height[2] = 15;
            map[i][j].layer[2]  = 1; 
			map[i][j].walkable = FALSE;
            break;
		case 4: // Building wall and roof
			map[i][j].num       = 2; 
            map[i][j].tile[0]   = 3;
            map[i][j].height[0] = 0;
            map[i][j].layer[0]  = 1;
            map[i][j].tile[1]   = 5;
            map[i][j].height[1] = 15;
            map[i][j].layer[1]  = 1; 
			map[i][j].walkable = FALSE;
            break;
		case 5: // Building wall and roof 2
			map[i][j].num       = 2; 
            map[i][j].tile[0]   = 4;
            map[i][j].height[0] = 0;
            map[i][j].layer[0]  = 1;
            map[i][j].tile[1]   = 5;
            map[i][j].height[1] = 15;
            map[i][j].layer[1]  = 1; 
			map[i][j].walkable = FALSE;
            break;
		case 6: // Building roof
			map[i][j].num       = 1; 
            map[i][j].tile[0]   = 5;
            map[i][j].height[0] = 15;
            map[i][j].layer[0]  = 1; 
			map[i][j].walkable = FALSE;
            break;
		case 7: // Building door and roof
			map[i][j].num       = 3; 
            map[i][j].tile[0]   = 3;
            map[i][j].height[0] = 0;
            map[i][j].layer[0]  = 1;
            map[i][j].tile[1]   = 10;
            map[i][j].height[1] = 0;
            map[i][j].layer[1]  = 1;
            map[i][j].tile[2]   = 5;
            map[i][j].height[2] = 15;
            map[i][j].layer[2]  = 1; 
			map[i][j].walkable = FALSE;
            break;
		case 8: // Building door and roof
			map[i][j].num       = 3; 
            map[i][j].tile[0]   = 4;
            map[i][j].height[0] = 0;
            map[i][j].layer[0]  = 1;
            map[i][j].tile[1]   = 11;
            map[i][j].height[1] = 0;
            map[i][j].layer[1]  = 1;
            map[i][j].tile[2]   = 5;
            map[i][j].height[2] = 15;
            map[i][j].layer[2]  = 1; 
			map[i][j].walkable = FALSE;
            break;
		default:
			MessageBox (gapp.hwnd, "Error reading map file !", "IsometriX Engine", MB_OK);
			DestroyWindow(gapp.hwnd);
		break;
      }
    }
  }	
	return;
}

// SetupObjects ////////////////////////////////////////////////
void SetupObjects()
{	
	MAPDIM i,j;
	BYTE retour;
	
	CMap Objects;

	if ((retour=Objects.Load("objects.bin")))
	{
		char Error[250];
		Objects.ErrorText(retour,Error);
		MessageBox (gapp.hwnd, Error, "IsometriX Engine", MB_OK);
		DestroyWindow(gapp.hwnd);
		return;
	}
  // transform the object map into structure
  for(i=0;i<MAP_HEIGHT;i++)
  {
    for(j=0;j<MAP_WIDTH;j++)
	{
		switch (Objects.GetGround(j,i)) {
		case 0: // nothing
			objects[i][j].tile[0]	= 0;
			objects[i][j].walkable  = TRUE;
            break;

		case 1: // Tree 1
            objects[i][j].tile[0]   = 1;
			objects[i][j].walkable	= FALSE;
            break;

		case 2: // Tree 2
            objects[i][j].tile[0]   = 2;
      		objects[i][j].walkable	= FALSE;
            break;

		default:
			MessageBox (gapp.hwnd, "Error reading object file !", "IsometriX Engine", MB_OK);
			DestroyWindow(gapp.hwnd);
			break;
      }
    }
  }	
	return;
}

// DrawMap -- takes direct draw surface, and fine coordinates as input

void DrawMap(LPDIRECTDRAWSURFACE lpDDSScreen, signed short int x,signed short int y, signed short int realX, signed short int realY)
{
  unsigned short int i, j, k, length;
  signed short int startingX, startingY;
  signed short int xOut, yOut, xOffset, yOffset;
  signed short int mx, my, tx, ty;
  signed short int screenX, screenY, tempRealX, tempRealY;
  signed short int currentLayer, highestLayer;
  char tileToDraw,heightToDraw;

  BOOL bDrawTile;

  // initialize variables
  currentLayer = 0;
  highestLayer = 1;

  bDrawTile = FALSE;

  // Convert to fine coordinates
	startingX = x / (TILE_WIDTH/2);		
	xOut	  = x & ((TILE_WIDTH/2)-1);	
	startingY = y / TILE_HEIGHT;		
    yOut	  = y & (TILE_HEIGHT-1);	
    xOffset   = xOut - yOut;
    yOffset   = (xOut>>1) + (yOut>>1);

  while(1)
  {
    mx = startingX;
    my = startingY;

	tempRealY = realY - yOffset;

	screenY =  (TILE_HEIGHT/2) - yOffset;    

    // This loop takes care of the vertical screen draw ///////////
    for (i=0;i<38;i++)	// 70 lines / tiles to be drawn vertically
	{
      tx = mx;
      ty = my;

      screenX = (TILE_WIDTH/2) - xOffset ; 

	  tempRealX = realX - xOffset;

	  length = 12;		// number of tiles to be drawn horizontally (even lines)
      
	  if(i&1)			// if line is odd :
	  {
        length++;		// one more tile to be drawn horizontally (so 25)
        screenX-=(TILE_WIDTH/2); 	// pre-step 32 pixels back left
		tempRealX-=(TILE_WIDTH/2);
      }
	  
	  // This loop takes care of the horizontal screen draw which is done first
      for (j=0;j<length;j++) // it is repeated (length) time, one for each tile in the line
	  {
		 if (bDrawTile = CheckTileCoordinates(tempRealX,tempRealY))
		 { 
		    // This loop takes care of all the tiles (num) in this tile coordinates
			for (k=0;k<map[ty][tx].num;k++)
			{
				if (map[ty][tx].layer[k] == currentLayer)
				{
					tileToDraw = map[ty][tx].tile[k];
					heightToDraw = map[ty][tx].height[k];
					BlockDraw(lpDDSScreen, screenX, screenY-heightToDraw, 64, 100,tileToDraw); // draw this tile
				}
			}
		 }

		 
	if (bDrawTile && currentLayer == Player->m_layer)
	{
		if (Player->m_bVisible && i == 15 && j == 5)
			DrawPlayerSprite(ty,tx);

		DrawSprites(ty,tx,screenX+32,screenY);
	}
	 
        screenX+=TILE_WIDTH; // move 64 pixels right for next tile

		tempRealX+=TILE_WIDTH;

        // map update and wrap around
        if ((tx+=1) > MAP_WIDTH-1)
				tx = 0;
			
        if ((ty-=1) < 0)
			ty = MAP_HEIGHT-1;
      }

    screenY+=(TILE_HEIGHT/2); // move 16 pixels down for next line

	tempRealY+=(TILE_HEIGHT/2);
	
	if(i & 1) // if line is odd
	  {
		if ((mx+=1) > (MAP_WIDTH-1))
			mx = 0;
      } 
	  else		// if line is even
	  {
        if ((my+=1) > (MAP_HEIGHT-1))
			my = 0;
	  }  
    }

	currentLayer++;

	if (currentLayer > highestLayer)
		break;
	}
}

// BlockDraw - Draw tile block ///////////////

int BlockDraw(LPDIRECTDRAWSURFACE lpDDSScreen, signed short x, signed short y, unsigned short w, unsigned short h, unsigned short tile)
{

	unsigned short xOff, yOff;
	unsigned short xLen, yLen;
	unsigned short height;
	
	HRESULT ddrval;
	
	switch (tile) 
	{
	case 0: // grass
	case 1: // road
	case 2:	// water
	case 3: // east wall
	case 4: // west wall
		height=100;
		break;
	case 5: // roof
		height=31;
		break;
	case 10:
	case 11:
	default:
		height=100;
		break;
	}

	x-=64;
	y-=100;

	xLen = w;
	yLen = height;
	xOff = 0;
	yOff = 100-height;

	if (x < 0) 
	{
		xLen+=x;
		xOff=-x;
		x=0;
	}

	if (x+w > (Screen.Width()-1)) 
	{
		xLen = Screen.Width()-x;
	}

	if (y < 0)
	{
		yLen=height+y;
		yOff+=(y*-1);
		y=0;	
	}

	if (y+height > (Screen.Height()-1))
	{
		yLen = Screen.Height()-y;
		if (y > Screen.Height()) 
			return 1;
	}

	if (xLen< 0 || yLen < 0) 
		return 1;

	// Blit tile from tile surface
	while(1)
	{
		ddrval=BlitTile(lpDDSScreen,tile,x,y,xLen,yLen,xOff,yOff);

		if (ddrval == DD_OK)
			break;

	    if( ddrval != DDERR_WASSTILLDRAWING )
            break;
    }
	return 0;
}

// BlitTile - Blit tile block or sprite ///////////////////

HRESULT BlitTile(LPDIRECTDRAWSURFACE lpDDSScreen, unsigned short tile, unsigned short x, unsigned short y, unsigned short w, unsigned short h, unsigned short xOff, unsigned short yOff) 
{
	unsigned short xOffset,yOffset;
	RECT rcRect;
	

		if (tile < 10) 
		{
			xOffset=tile * TILE_WIDTH;
			yOffset=0;
		}
	else
		if (tile < 20) 
		{
			xOffset=(tile-10) * TILE_WIDTH;
			yOffset=100;
		}
	else
		if (tile < 30) 
		{
			xOffset=(tile-20) * TILE_WIDTH;
			yOffset=200;
		}
	else
		if (tile < 40)
		{
			xOffset=(tile-30) * TILE_WIDTH;
			yOffset=300;
		}

	rcRect.left=xOffset+xOff;
	rcRect.top=yOffset+yOff;
	rcRect.right=xOffset+xOff+w;
	rcRect.bottom=yOffset+yOff+h;

	return lpDDSScreen->BltFast(x,y,lpdraw->lpDDSTiles,&rcRect,DDBLTFAST_SRCCOLORKEY);	
}

// Wrap Map around //////////////////////

void CheckMapCoordinates()
{
	if (Screen.m_mapX < 0)
		Screen.m_mapX = Screen.m_mapX + (MAP_WIDTH*(TILE_WIDTH/2));	

	if (Screen.m_mapX >= (MAP_WIDTH*(TILE_WIDTH/2)))
		Screen.m_mapX = Screen.m_mapX - (MAP_WIDTH*(TILE_WIDTH/2));	
				
	if (Screen.m_mapY < 0)
		Screen.m_mapY = Screen.m_mapY + (MAP_HEIGHT*TILE_HEIGHT);
	
	if (Screen.m_mapY >= (MAP_HEIGHT*TILE_HEIGHT))
		Screen.m_mapY = Screen.m_mapY - (MAP_HEIGHT*TILE_HEIGHT);
}

// Check if tile at (x,y) is inside or outside map ////////////////////////

BOOL CheckTileCoordinates(signed short int x, signed short int y)
{
	if (y <= ((MAP_HEIGHT*TILE_HEIGHT)/2))
	{
		if ((abs(x)) <= (y*2))
			return TRUE;
		else
			return FALSE;
	}
	else if (y > ((MAP_HEIGHT*TILE_HEIGHT)/2))
	{
		if (y <= ((MAP_HEIGHT*TILE_HEIGHT)-((abs(x)/2))))
			return TRUE;
		else
			return FALSE;
	}
	return FALSE;
}

// void DrawPlayerSprite() ////////////////////////////
void DrawPlayerSprite(signed short ty, signed short tx)
{
	// check if tile the player is walking on is walkable or not
	BOOL WalkableTile = map[ty][tx].walkable;
	BOOL WalkableObject = objects[ty][tx].walkable;

	// if it is not, collision and can't move
	if (!WalkableTile || !WalkableObject)
	{		
		switch (Player->m_direction)
		{
			case 2 : // going south
					Screen.m_mapY-=Screen.m_scrollSpeed;
					Screen.m_mapX-=Screen.m_scrollSpeed;
					Screen.m_y-=Screen.m_scrollSpeed;
					break;

			case 8 : // going north
					Screen.m_mapY+=Screen.m_scrollSpeed;
					Screen.m_mapX+=Screen.m_scrollSpeed;
					Screen.m_y+=Screen.m_scrollSpeed;
					break;
					
				case 6 : // going west
					Screen.m_mapX-=Screen.m_scrollSpeed;
					Screen.m_mapY+=Screen.m_scrollSpeed;
					Screen.m_x-=(Screen.m_scrollSpeed*2);
					break;
					
				case 4 : // going east
					Screen.m_mapX+=Screen.m_scrollSpeed;
					Screen.m_mapY-=Screen.m_scrollSpeed;
					Screen.m_x+=(Screen.m_scrollSpeed*2);
					break;

				case 7 : // going northwest
					Screen.m_mapX+=(Screen.m_scrollSpeed*2);
					Screen.m_x+=(Screen.m_scrollSpeed*2);
					Screen.m_y+=Screen.m_scrollSpeed;
					break;

				case 9 : // going northeast
					Screen.m_mapY+=(Screen.m_scrollSpeed*2);
					Screen.m_x-=(Screen.m_scrollSpeed*2);
					Screen.m_y+=Screen.m_scrollSpeed;
					break;

				case 3 : // going southeast
					Screen.m_mapX-=(Screen.m_scrollSpeed*2);
					Screen.m_x-=(Screen.m_scrollSpeed*2);
					Screen.m_y-=Screen.m_scrollSpeed;
					break;

				case 1 : // going southwest
					Screen.m_mapY-=(Screen.m_scrollSpeed*2);
					Screen.m_x+=(Screen.m_scrollSpeed*2);
					Screen.m_y-=Screen.m_scrollSpeed;
					break;
				}	
		}
	Player->Render(lpdraw->lpDDSBack, Player->GetPosX(), Player->GetPosY(), Player->m_frame, Player->m_bMirroring);
	
}

// DrawSprites () -- Take care of the drawing of all sprites
void DrawSprites(signed short ty, signed short tx, unsigned short screenX, unsigned short screenY)
{
	switch (objects[ty][tx].tile[0])
	{
		case 0:
			break;
		case 1: // Tree 1
			Tree->Render(lpdraw->lpDDSBack, screenX, screenY, 0, 0);
			break;
		case 2: // Tree 2
			Tree->Render(lpdraw->lpDDSBack, screenX, screenY, 1, 0);
			break;
		default:
			break;
	}
	return;
}

