
#ifndef _ISOXMAP_H
#define _ISOXMAP_H


#define MAP_WIDTH	32
#define MAP_HEIGHT	32
#define TILE_WIDTH  64
#define TILE_HEIGHT	32

// Definition of our map structure

typedef struct {
	char num;		 // num = number of tiles at one coordinate (allows stacking of tiles)
	char tile[10];   // tile = type of tile (0=grass, 1=path, etc.)
	char height[10]; // height = how tall the tile reaches
	char layer[10];	 // layer = used to make sure the sprites doesn't block.
	BOOL walkable;
} MAP_INFO;

extern MAP_INFO map[MAP_HEIGHT][MAP_WIDTH];


// Functions declarations
void	SetupMap();
void	SetupObjects();
void	DrawMap(LPDIRECTDRAWSURFACE lpDDSScreen, signed short x, signed short y, signed short realx, signed short realy);
int		BlockDraw(LPDIRECTDRAWSURFACE lpDDSScreen, signed short int x, signed short y, unsigned short w, unsigned short h, unsigned short tile);
HRESULT BlitTile(LPDIRECTDRAWSURFACE lpDDSScreen, unsigned short tile, unsigned short x, unsigned short y, unsigned short w, unsigned short h, unsigned short xoff, unsigned short yoff);
void	CheckMapCoordinates();
static	BOOL CheckTileCoordinates(signed short x, signed short y);
void	DrawSprites(signed short ty, signed short tx, unsigned short screenx, unsigned short screeny);
void	DrawPlayerSprite(signed short ty, signed short tx);

#endif