////////////////////////////////////////////////////////////////////
//  File:   isoxutil.cpp										  //
//  Description: Utilities for debugging (not for release)		  //
//  Rev:   A													  //
//  Created : September 1998									  //
//																  //
//  Author: Yannis Deliyannis									  //
//  mail:   yannis@club-internet.fr								  //
//																  //
//  no copyright												  //
////////////////////////////////////////////////////////////////////    

#include "isoxmain.h"


static DWORD	dwFrameTime;
static DWORD	dwFrames;
static DWORD	dwFrameCount;
static char	S[100];


// DebugPrintf - Output a string to the debugger /////////////
void DebugPrintf( LPSTR fmt, ... )
{
    char    buff[256];

    sprintf( buff, fmt, (LPSTR)(&fmt+1) );

	OutputDebugString( buff );
}


// GetFrameRate -- Calculates the frame rate /////////////////
void GetFrameRate(DWORD dwTime)
{
	char str[255];
	char strtext[255];
	DWORD dwTime2;

	dwFrameCount++;
    dwTime2 = dwTime - dwFrameTime;
    if( dwTime2 > 1000)
    {
        dwFrames = ( dwFrameCount * 1000 ) / dwTime2;
        dwFrameTime = timeGetTime();
        dwFrameCount = 0;
    }
    sprintf(str, "%d", dwFrames);
	sprintf(strtext, "%s", "FPS : ");
    DDTextOut( lpdraw->lpDDSBack,strtext, RGB(0,0,0), RGB(255,255,255), 6, 70 );
    DDTextOut( lpdraw->lpDDSBack,str, RGB(0,0,0), RGB(255,255,255), 44, 70 );

}

// KeyMouse_OnMouseMove -- Get MouseX, and MouseY coords //////////
void KeyMouse_OnMouseMove(HWND hwnd, int x, int y, UINT keyFlags)
{
	sprintf (S, "WM_MOUSEMOVE => x = %d y = %d keyFlags = %d   ",x,y,keyFlags);

	Screen.m_mouseX = x;
	Screen.m_mouseY = y;

	return;
}

// DebugVars -- used for debugging variables /////////////////
void DebugVars()
{
	char strrealx[255];
	char strrealy[255];
	char strcomma[255];
	char strviewx[255];
	char strviewy[255];
	char strrealtxt[255];
	char strviewtxt[255];
	char strdebugvar1[255];

	sprintf(strdebugvar1, "%d", Player->m_frame);
    sprintf(strrealx, "%d", Screen.m_x);
    sprintf(strrealy, "%d", Screen.m_y);
	sprintf(strcomma, "%s", ",");
	sprintf(strviewx, "%d", Screen.m_mapX);
	sprintf(strviewy, "%d", Screen.m_mapY);
	sprintf(strrealtxt, "%s", "realx, realy");
	sprintf(strviewtxt, "%s", "viewx, viewy");

	DDTextOut( lpdraw->lpDDSBack,S, RGB(0,0,0), RGB(255,255,255), 10, 150);

	DDTextOut( lpdraw->lpDDSBack,strdebugvar1, RGB(0,0,0), RGB(255,255,255), 50, 100 );
	DDTextOut( lpdraw->lpDDSBack,strviewtxt, RGB(0,0,0), RGB(255,255,255), 1, 3 );
	DDTextOut( lpdraw->lpDDSBack,strviewx, RGB(0,0,0), RGB(255,255,255), 20, 20 );
	DDTextOut( lpdraw->lpDDSBack,strcomma, RGB(0,0,0), RGB(255,255,255), 53, 20 );
	DDTextOut( lpdraw->lpDDSBack,strviewy, RGB(0,0,0), RGB(255,255,255), 57, 20 );
	DDTextOut( lpdraw->lpDDSBack,strrealx, RGB(0,0,0), RGB(255,255,255), 20, 60 );
	DDTextOut( lpdraw->lpDDSBack,strcomma, RGB(0,0,0), RGB(255,255,255), 53, 60 );
	DDTextOut( lpdraw->lpDDSBack,strrealy, RGB(0,0,0), RGB(255,255,255), 57, 60 );
	DDTextOut( lpdraw->lpDDSBack,strrealtxt, RGB(0,0,0), RGB(255,255,255), 10, 40 );
}

