/* 
 *    Example program for the Allegro library, by Shawn Hargreaves.
 *
 *    This is a very simple program showing how to get into graphics
 *    mode and draw text onto the screen.
 */


#include <stdlib.h>
#include <stdio.h>

#ifdef __RSXNT__
#include "wrapper.h"
#endif

#include "allegro.h"


void restore_screen()
{
   set_pallete(desktop_pallete);
   acquire_screen();
   clear (screen);
   textout_centre(screen, font, "Hello, world!", SCREEN_W/2, SCREEN_H/2, 255);
   release_screen();
}

int main(int argc, char *argv[])
{
   /* you should always do this at the start of Allegro programs */
   allegro_init();

   /* set up the keyboard handler */
   install_keyboard(); 

   /* set VGA graphics mode 13h (sized 320x200) */
#ifndef __WIN32__
   set_gfx_mode(GFX_AUTODETECT, 320, 200, 0, 0);
#else
   set_gfx_mode(GFX_DIRECTX, 640, 480, 0, 0);
#endif

   /* install lost bitmap callback */
   install_lost_bitmap_callback(restore_screen);

   /* set the color pallete */
   set_pallete(desktop_pallete);

   /* write some text to the screen */
   acquire_screen();
   textout_centre(screen, font, "Hello, world!", SCREEN_W/2, SCREEN_H/2, 255);
   release_screen();

   /* wait for a keypress */
   while (!keypressed())
   {
       acquire_screen();
	   release_screen();
   }
   readkey();

   return 0;
}


