/* 
 *    Example program for the Allegro library, by Shawn Hargreaves.
 *
 *    This program demonstrates how to access the contents of an
 *    Allegro datafile (created by the grabber utility).
 */


#include <stdlib.h>
#include <stdio.h>

#ifdef __RSXNT__
#include "wrapper.h"
#endif

#include "allegro.h"


/* the grabber produces this header, which contains defines for the names
 * of all the objects in the datafile (BIG_FONT, SILLY_BITMAP, etc).
 */
#include "example.h"



int main(int argc, char *argv[])
{
   DATAFILE *datafile;
   char buf[80];

   allegro_init();
   install_keyboard(); 
   #ifdef __ALLEG_DOS__
   set_gfx_mode(GFX_AUTODETECT, 320, 200, 0, 0);
   #else
   set_gfx_mode (GFX_AUTODETECT, 640, 480, 0, 0);
   #endif

   /* load the datafile into memory */
   strcpy(buf, argv[0]);
   strcpy(get_filename(buf), "example.dat");
   datafile = load_datafile(buf);
   if (!datafile) {
      acquire_screen();
      textout (screen, font, "Error loading exampl.dat!", 0, 0, 15);
	  release_screen();
	  readkey();
      allegro_exit();
      return 1;
   }

   /* select the pallete which was loaded from the datafile */
   set_pallete(datafile[THE_PALLETE].dat);

   acquire_screen();

   /* display the bitmap from the datafile */
   textout(screen, font, "This is the bitmap:", 32, 16, 255);
   blit(datafile[SILLY_BITMAP].dat, screen, 0, 0, 64, 32, 64, 64);

   /* and use the font from the datafile */
   textout(screen, datafile[BIG_FONT].dat, "And this is a big font!", 32, 128, 96);

   release_screen();

   readkey();

   /* unload the datafile when we are finished with it */
   unload_datafile(datafile);

   return 0;
}
