/*----------------------------------------------------------------------------*/
/*                         Allegro Library example file.                      */
/*                                                                            */
/* This example demonstrates how to use pcx files, palletes and stretch blits.*/
/* It loads a pcx file, sets its pallete and does some random stretch_blits.  */
/*----------------------------------------------------------------------------*/
/* by Grzegorz "LUD0" Ludorowski (pajonk@ajax.umcs.lublin.pl)                 */
/*                               (http://ajax.umcs.lublin.pl/~pajonk)         */
/*----------------------------------------------------------------------------*/
#include <stdlib.h>
#include <stdio.h>

#ifdef __ALLEG_DJGPP_DOS__
#include <dir.h>
#include <pc.h>
#endif

#ifdef __RSXNT__
#include "wrapper.h"
#endif

#include "allegro.h"

#ifdef __WIN32__
#include "gfxprint.h"
#endif


/* Declaration of a user pallete where pallete of loaded pcx will be stored.  */
PALLETE my_pallete;
/* Pointer to a buffer, where pcx file will be stored.                        */
BITMAP *scr_buffer;
/* Name of pcx file.                                                          */
/* w-screen width, h-screen height, card-card type (defined in allegro.h)     */
int card, w, h;
/* Place to store set_gfx_mode () output. -1 means error */
int err_vmode;

/* Begin of main routine                                 */
int main (int argc, char *argv[])
{
   char pcx_name[80];
   strcpy(pcx_name, argv[0]);
   strcpy(get_filename(pcx_name), "mysha.pcx");
   
   allegro_init();              /* Initialise all Allegro stuff       */
   install_keyboard();          /* Install keyboard interrupt handler */
   #ifdef __WIN32__
   if (set_gfx_mode (GFX_AUTODETECT, 640, 480, 0, 0) < 0) return -1;
   init_gfx_printf();
   #endif

   printf ("This example demonstrates how to use pcx files, palletes and stretch blits.\n");
   printf ("It loads a pcx file, sets its pallete and does some random stretch blits.\n");
   printf ("Don't worry - it's VERY slowed down using vsync()\n");
   printf ("Hit any key to begin.\n");
   readkey();

   /* Check if pcx file exists in current directory.                        */
   if ( (file_exists (pcx_name, 32, NULL) ) == 0)
   {
      printf ("File %s not found. Exiting",pcx_name);
      #ifdef __WIN32__
      readkey();
      #endif
      return 1;
   }

   #ifndef __WIN32__
   /* Removes everything from keyboard's buffer                       */
   clear_keybuf ();
   card = GFX_AUTODETECT;
   w = 320;
   h = 200;

   /* Sets 320x200x256 mode */
   err_vmode = set_gfx_mode(card, w, h, 0, 0);
   /* Checks if any error occured during screen mode initialization   */
   if ( err_vmode != 0 )
   {
    printf("Error setting graphics mode\n%s\n\n", allegro_error);
   /* Shut down Allegro          */
    allegro_exit ();
    return 1;
   }
   #endif /* !__WIN32__ */
   
   /* Loads pcx file into buffer */
   scr_buffer = load_pcx (pcx_name,my_pallete);
   /* Sets pcx's pallete         */
   set_pallete (my_pallete);
   acquire_screen();
   blit (scr_buffer, screen, 0,0,0,0,320,200);
   release_screen();

   while (!keypressed () )
   {
      /* Blit until key pressed */
      acquire_screen();
      stretch_blit (scr_buffer, screen, 0, 0, 320, 200, random () % SCREEN_W, random () % SCREEN_H, random () % SCREEN_W, random () % SCREEN_H);
      release_screen();
      /* Waits for vertical retrace */
      vsync ();
   }
   /* Destroys bitmap buffer */
   destroy_bitmap(scr_buffer);
   /* Shuts down Allegro     */
   allegro_exit();
   /* Exit program           */
   return 0;
}
