/*
 *    Example program for the Allegro library, by Patrick Hogan
 *
 *    This program demonstrates how to draw gouraud shaded (lit) sprites.
 */


#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#ifdef __RSXNT__
#include "wrapper.h"
#endif

#include "allegro.h"


COLOR_MAP light_table;



int distance(int x1, int y1, int x2, int y2)
{
   int dx = x2 - x1;
   int dy = y2 - y1;
   int temp = sqrt((dx * dx) + (dy * dy));

   temp *= 2;
   if (temp > 255)
      temp = 255;

   return (255 - temp);
}



int main(int argc, char *argv[])
{
   PALLETE pal;
   BITMAP *buffer;
   BITMAP *planet;
   char buf[80];

   allegro_init();
   install_keyboard();
   install_mouse();
   #ifdef __WIN32__
   if (set_gfx_mode (GFX_AUTODETECT, 640, 480, 0, 0) < 0) return -1;
   #else
   if (set_gfx_mode(GFX_AUTODETECT, 320, 240, 0, 0) < 0) {
      allegro_exit();
      printf ("Error setting graphics mode 320x240x8bpp: %s\n", allegro_error);
      return -1;
   }
   #endif
   
   strcpy(buf, argv[0]);
   strcpy(get_filename(buf), "planet.pcx");

   planet = load_bitmap(buf, pal);
   if (!planet) {
      allegro_exit();
      printf("Error reading planet.pcx\n");
      return 1;
   }

   buffer = create_bitmap(SCREEN_W, SCREEN_H);
   clear(buffer);

   set_pallete(pal);

   create_light_table(&light_table, pal, 0, 0, 0, NULL);
   color_map = &light_table;

   do {
      draw_gouraud_sprite(buffer, planet, 160, 100,
			  distance(160, 100, mouse_x, mouse_y),
			  distance(160 + planet->w, 100, mouse_x, mouse_y),
			  distance(160 + planet->w, 100 + planet->h, mouse_x, mouse_y),
			  distance(160, 100 + planet->h, mouse_x, mouse_y));

      textout(buffer, font, "Gouraud Shaded Sprite Demo", 0, 0, 10);

      show_mouse(buffer);
	  acquire_screen();
      blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	  release_screen();
      show_mouse(NULL);

   } while (!keypressed());

   destroy_bitmap(planet);
   destroy_bitmap(buffer);

   return 0;
}

