/* 
 *    Example program for the Allegro library, by Shawn Hargreaves.
 *
 *    This program demonstrates the use of double buffering.
 *    It moves a circle across the screen, first just erasing and
 *    redrawing directly to the screen, then with a double buffer.
 */


#include <stdlib.h>
#include <stdio.h>

#ifdef __RSXNT__
#include "wrapper.h"
#endif

#include "allegro.h"


int main (int argc, char *argv[])
{
   BITMAP *buffer;
   int c;

   allegro_init();
   install_timer();

   set_gfx_mode(GFX_AUTODETECT, 320, 200, 0, 0);
   set_pallete(desktop_pallete);

   /* allocate the memory buffer */
   buffer = create_bitmap(SCREEN_W, SCREEN_H);

   /* First without any buffering...
    * Note use of the global retrace_counter to control the speed.
    */
   c = retrace_count+32;
   while (retrace_count-c <= SCREEN_W+32) {
      acquire_screen();
      clear(screen);
      circlefill(screen, retrace_count-c, SCREEN_H/2, 32, 255);
      textout(screen, font, "No buffering (320x200x8bpp)", 0, 0, 255);
	  release_screen();
   }

   /* and now with a double buffer... */
   c = retrace_count+32;
   while (retrace_count-c <= SCREEN_W+32) {
      clear(buffer);
      circlefill(buffer, retrace_count-c, SCREEN_H/2, 32, 255);
      textout(buffer, font, "Double buffered (320x200x8bpp)", 0, 0, 255);
	  acquire_screen();
      blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	  release_screen();
   }

   destroy_bitmap(buffer);

   return 0;
}
