           Readme for RSXNTDJ port of WinAllegro
                       by George Foot

                  revision 2  (24/09/1998)

                 patch level 3  (24/09/1998)


Introduction
~~~~~~~~~~~~
	This file contains notes about the port of WinAllegro to 
	RSXNTDJ.  You should also read `readme.win', which 
	describes the WinAllegro port of Allegro in general.
	
	I think this port is now suitable for general use.  There 
	are of course a few creases to iron out, and not all of the 
	Allegro utilities have been converted yet, but the library 
	itself seems to work almost as well as can be expected.
	
	I assume that you already have RSXNTDJ set up and working 
	properly (try its sample programs).  If not, you can find 
	instructions on my WinAllegro + RSXNTDJ pages:
	
		http://www.canvaslink.com/gfoot/winallegro/


Downloading and installing
~~~~~~~~~~~~~~~~~~~~~~~~~~
	You need to put `allegro.h' and 'winalleg.h' into your 
	RSXNTDJ `include' directory and put 'libwinal.a' into 
	your RSXNTDJ `lib' directory.  You should also put
	`all30w6.dll' into your Windows `system' directory 
	if it's not already there (from WinAllegro's 
	`lib/win32/release' directory).
		
Building the sample programs
~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	I have ported to RSXNTDJ all of the example programs that 
	can work with the current version of WinAllegro, and the 
	Allegro demo game.  You'll find a makefile in the 
	`examples' directory which will build all of the supported 
	example programs, and another makefile in the `demo' 
	directory to build the demo game.


Compiling WinAllegro programs with RSXNTDJ
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	As always for RSXNTDJ compilations you should pass 
	`-Zwin32' to gcc at all stages.  Because WinAllegro 
	requires multithreading support you need to pass `-Zmt' as 
	well.  You also want to link to the import library, using 
	`-lwinal', rather than the normal Allegro library (which 
	would be `-lalleg').
	
	WinAllegro programs must be GUI applications, not console 
	applications.  They'll crash otherwise.  In RSXNTDJ this 
	means that you must not have a `main' function -- otherwise 
	the NtBind utility will assume you're making a console 
	application.  To check that it isn't doing this, look at 
	the line it prints after linking, which should say:
	
		Ntbind: Building GUI Application "foo.exe"
	
	and not:
	
		Ntbind: Building Console Application "foo.exe"


Porting DOS Allegro programs to WinAllegro + RSXNTDJ
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	Because you're using the same compiler and because 
	WinAllegro is well designed the porting is really very 
	simple.  The basic requirements for porting WinAllegro 
	programs are described in `docs/winalleg.htm', which you 
	should now read.
	
	In this section I'll mention some points which I think are 
	specific to the RSXNTDJ port of WinAllegro.  In brief, 
	these points are:
	
		1) You can't use a `main' function
		2) The DLL can't access your memory
	
	1) You can't use a `main' function
	
		WinAllegro normally allows you to ignore `WinMain' 
		completely and just write a `main' function, but as 
		mentioned above that doesn't work on RSXNTDJ.  You 
		really do need to do what it says in `winalleg.htm' -- 
		either write your own WinMain wrapper around your main 
		function and rename it to something other than `main', 
		or just write a WinMain function to do everything.
		
		If you look in the `examples' directory you'll find 
		`wrapper.h', which is a wrapper I used in all of the 
		examples to allow them to go on using a function called 
		`main'.  In fact it gets renamed by a #define in 
		`wrapper.h', to prevent it from confusing NtBind.
	
	2) The DLL can't access your memory
	
		The WinAllegro DLL can't access some of your 
		application's memory space.  I don't really understand 
		this; I noticed it when dealing with listbox callbacks, 
		which return pointers to string constants.  The listbox 
		dialog routines try to modify the data pointed to, and 
		hang the machine.  Look at `demo.c' and `ex13.c' to see 
		how to get around this problem; in the end I hope it 
		will be solved inside the DLL itself so you don't have 
		to worry about it.


Distributing RSXNTDJ programs
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	I'm not completely sure about this, but I think by default 
	your programs use the C library from a DLL called 
	`rsxnt.dll'.  If this is the case then you need to 
	distribute that with your programs.  You can stop this from 
	happening by using compiler switches -- see the RSXNTDJ 
	documentation for details.
	
	You will need to distribute `all30w4.dll' and `msvcrt.dll', 
	though.


Contacting me
~~~~~~~~~~~~~
	I'm George Foot, and my email address is:
	
		george.foot@merton.oxford.ac.uk
	
	Let me know how you get on with WinAllegro and RSXNTDJ.  
	Please do tell me about any problems you have with it or 
	with this documentation.  As always, comments, criticism, 
	corrections and suggestions are most welcome.
	
	Enjoy and share!


History of changes to this file
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Revision 2  (24/09/1998)
	Minor revision clarifying which WinAllegro package you 
	need to download.
	
	Added these histories of changes.

Revision 1  (22/09/1998)
	First version of this file.


History of changes to WinAllegro for RSXNTDJ
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Patch level 3  (24/09/1998)
	Includes the header files I accidentally left out of PL2.
	
	Slightly modified ex13.c (#include <string.h>)

Patch level 2  (22/09/1998)
	More changes to the header files.  Accidentally put the 
	wrong ones in the diff though! :(
	
	Almost all example programs ported.
	
	Demo game ported.

Patch level 1  (21/09/1998 IIRC)
	Changes to the header files
	
	A few example programs ported (ex1, ex2, ex4, ex5; ex3 not working)

