/*         ______   ___    ___ 
 *        /\  _  \ /\_ \  /\_ \ 
 *        \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___ 
 *         \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
 *          \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
 *           \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
 *            \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
 *                                           /\____/
 *                                           \_/__/
 *      By Shawn Hargreaves,
 *      1 Salisbury Road,
 *      Market Drayton,
 *      Shropshire,
 *      England, TF9 1AJ.
 *
 *      Win32 Allegro midi driver, by Stefan Schimanski (1Stein@gmx.de)
 *
 *      See readme.txt for copyright information.
 */


#include <stdlib.h>
#include <string.h>

#define WIN32_LEAN_AND_MEAN
#define BITMAP WINDOWS_BITMAP
#include <windows.h>
#include <mmsystem.h>
#include <mmreg.h>
#include "win/windx.h"
#include "win/winintrn.h"
#undef BITMAP
#undef RGB

/*#include "allegro.h"*/
#include "internal.h"
#include "windx.h"


/* external interface to the Win32 midi driver */
static int win32midi_detect(int input);
static int win32midi_init(int input, int voices);
static void win32midi_exit(int input);
static void win32midi_output(unsigned char data);

static char win32midi_desc[80] = "not initialised";


MIDI_DRIVER midi_win32 =
{
   "Win32 Midi", 
   win32midi_desc,
   0, 0, 0xFFFF, 0, -1, -1,
   win32midi_detect,
   win32midi_init,
   win32midi_exit,
   NULL,
   win32midi_output,
   _dummy_load_patches,
   _dummy_adjust_patches,
   _dummy_key_on,
   _dummy_noop1,
   _dummy_noop2,
   _dummy_noop3,
   _dummy_noop2,
   _dummy_noop2
};


/* win32midi_output:
 *  Writes a byte to the Win32 midi interface.
 */

HMIDIOUT MidiDevice = NULL;

int MidiMsgLengths[8] = { 3, 3, 3, 3, 2, 2, 3, 0 };

unsigned long MidiMsg;
int MidiMsgLength;
int MidiMsgPos;

static void win32midi_output(unsigned char data)
{
	if (data>=0x80)
	{
		MidiMsgLength = MidiMsgLengths[(data >> 4) & 0x07];
		MidiMsg = 0;
		MidiMsgPos = 0;
	}

	if (MidiMsgLength>0)
	{
		MidiMsg |= ((unsigned long)data) << (MidiMsgPos*8);
		MidiMsgPos++;
	
		if (MidiMsgPos==MidiMsgLength)
		{
            if (MidiDevice!=NULL)
	        {
		        midiOutShortMsg(MidiDevice, MidiMsg);
	        }			
		}
	}
}


/* win32midi_detect:
 *  Detects the presence of an Win32 compatible midi interface.
 */
static int win32midi_detect(int input)
{
   /* only bother with the detection if we aren't already active */
   sprintf(win32midi_desc, "Win32 midi interface");
   
   /* can we handle input? */
   if (input) {
     return FALSE;
   }

   return midiOutGetNumDevs()>0;
}



/* win32midi_init:
 *  Initialises the Win32 midi interface.
 */
static int win32midi_init(int input, int voices)
{	
   	MMRESULT r;	

	// Open the MIDI Mapper
	r = midiOutOpen(&MidiDevice, (UINT)-1, 0, 0, CALLBACK_NULL);
	if (r!=MMSYSERR_NOERROR )
		goto Error;	

	// Resets MIDI Mapper
	midiOutReset(MidiDevice);
	
	// Return to caller
	return 0;

Error:
	win32midi_exit(input);
	return 1;
}



/* win32midi_exit:
 *  Resets the Win32 midi interface when we are finished.
 */
static void win32midi_exit(int input)
{
    // Closes the midi stream
	if (MidiDevice!=NULL)
	{
		midiOutReset(MidiDevice);
		midiOutClose(MidiDevice);
		MidiDevice = NULL;
	}    
}

