/*         ______   ___    ___ 
 *        /\  _  \ /\_ \  /\_ \ 
 *        \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___ 
 *         \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
 *          \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
 *           \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
 *            \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
 *                                           /\____/
 *                                           \_/__/
 *      By Shawn Hargreaves,
 *      1 Salisbury Road,
 *      Market Drayton,
 *      Shropshire,
 *      England, TF9 1AJ.
 *
 *      Internal Allegro function for Win32, by Stefan Schimanski (1Stein@gmx.de)
 *
 *      See readme.txt for copyright information.
 */


#ifndef INTERNWN_H
#define INTERNWN_H


#ifdef __cplusplus
extern "C" {
#endif

#ifndef WIN32
#error This file should only be used by the Win32 version of Allegro
#endif

#include <io.h>
#include <direct.h>


/* Visual C has real strange find function. This is the wrapper */
struct finddata
{
struct _finddata_t data;
long date;
long time;
long size;
char *name;
long attrib;
long hFile;
};

/* file access macros */
#define FILE_OPEN(filename, handle)             handle = open(filename, O_RDONLY | O_BINARY)
#define FILE_CREATE(filename, handle)           handle = open(filename, O_WRONLY | O_BINARY | O_CREAT | O_TRUNC)
#define FILE_CLOSE(handle)                      close(handle)
#define FILE_READ(handle, buf, size, sz)        sz = read(handle, buf, size)
#define FILE_WRITE(handle, buf, size, sz)       sz = write(handle, buf, size) 
#define FILE_SEARCH_STRUCT                      struct finddata
#define FILE_FINDFIRST(filename, attrib, dta)   myfindfirst(filename, dta, attrib)
#define FILE_FINDNEXT(dta)                      myfindnext(dta)
#define FILE_FINDCLOSE(dta)						myfindend(dta)
#define FILE_ATTRIB                             attrib
#define FILE_SIZE                               size
#define FILE_NAME                               name
#define FILE_DATE								date
#define FILE_TIME								time

int findfirst(char *filename, struct finddata *dta, long attrib);
int findnext(struct finddata *dta);

#define getdisk() (_getdrive()-1)
#define setdisk(d) _chdrive((d)+1)

#define outportb(p, v)
#define inportb(p) (0)

int WinAllegro_HandleMessages();
int WinAllegro_GetWindowsVersion();
int WinAllegro_DriveExist(int Drive);

void EnterSemaphore();
void LeaveSemaphore();
#define DISABLE() EnterSemaphore();
#define ENABLE() LeaveSemaphore();
#define enter_critical() EnterSemaphore();
#define exit_critical() LeaveSemaphore();
#define _dma_lock_mem()

#define __dpmi_regs int
union REGS {int Dummy;};
#define _go32_dpmi_lock_data(addr, size) 

#define FA_RDONLY _A_RDONLY
#define FA_ARCH _A_ARCH
#define FA_HIDDEN _A_HIDDEN
#define FA_SYSTEM _A_SYSTEM
#define FA_SUBDIR _A_SUBDIR
#define FA_DIREC _A_SUBDIR

extern int WN_Argc;
extern char *WN_Argv[256];
#define _crt0_argv WN_Argv
#define __crt0_argv WN_Argv
#define ___crt0_argv WN_Argv
#define _crt0_argc WN_Argc
#define __crt0_argc WN_Argc
#define ___crt0_argc WN_Argc

#ifdef __cplusplus
}
#endif

#endif