/*         ______   ___    ___ 
 *        /\  _  \ /\_ \  /\_ \ 
 *        \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___ 
 *         \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
 *          \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
 *           \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
 *            \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
 *                                           /\____/
 *                                           \_/__/
 *      By Shawn Hargreaves,
 *      1 Salisbury Road,
 *      Market Drayton,
 *      Shropshire,
 *      England, TF9 1AJ.
 *
 *      Win32 joystick routines.
 *
 *      See readme.txt for copyright information.
 */


#ifndef WIN32
#error This file should only be used by the Win32 version of Allegro
#endif

#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <errno.h>

/*#include "allegro.h"*/
#include "internal.h"
#include "windx.h"


/* driver functions */
static int joy_init(); 
static void joy_exit(); 
static int joy_poll();
static int joy_save_data();
static int joy_load_data();
static char *joy_calibrate_name(int n);
static int joy_calibrate(int n);


/* the driver structure (shared by all analogue style stick variants) */
JOYSTICK_DRIVER joystick_win32 =
{
   "",
   "",
   joy_init,
   joy_exit,
   joy_poll,
   NULL,
   NULL,
   NULL, /*joy_calibrate_name,*/
   NULL, /*joy_calibrate*/
};


struct JOYSTICK (*DI_Joysticks)[MAXJOYSTICKS];

/* driver state information */
static int joystick_flags = 0;

static int joycentre_x, joycentre_y;
static int joyx_min, joyx_low_margin, joyx_high_margin, joyx_max;
static int joyy_min, joyy_low_margin, joyy_high_margin, joyy_max;

static int joycentre2_x, joycentre2_y;
static int joyx2_min, joyx2_low_margin, joyx2_high_margin, joyx2_max;
static int joyy2_min, joyy2_low_margin, joyy2_high_margin, joyy2_max;

static int joy_thr_min, joy_thr_max;

static int joy_hat_pos[5], joy_hat_threshold[4];

static int joy_old_x, joy_old_y;
static int joy2_old_x, joy2_old_y;


/* joy_init:
 *  Initialises the driver.
 */
static int joy_init()
{
   static char name_x[] = "X";
   static char name_y[] = "Y";
   static char name_stick[] = "Stick";
   static char name_hat[] = "Hat";
   static char name_throttle[] = "Throttle";
   static char *name_b[] = { "B1", "B2", "B3", "B4", "B5", "B6", "B7", "B8" };
   int i;
   int s,n,a;

   DI_Joysticks = DI_GetJoysticks();
   if (DI_InitJoystick()!=0) return -1;

   /* store info about the stick type */
   joystick_win32.name = "DirectInput Joystick";
   joystick_win32.desc = "";
   joystick_flags = JOYFLAG_ANALOGUE;

   joy_old_x = joy_old_y = 0;
   joy2_old_x = joy2_old_y = 0;

   /* fill in the joystick structure */
   num_joysticks = JoystickAttached;

   joy[0].flags = JOYFLAG_DIGITAL | JOYFLAG_ANALOGUE;

   /* how many buttons? */
   for (n=0; n<num_joysticks; n++)
   {
		joy[n].num_buttons = DI_Joysticks[n]->ButtonsNum;
		joy[n].flags = JOYFLAG_ANALOGUE | JOYFLAG_DIGITAL;

		/* main analogue stick */
		if (DI_Joysticks[n]->AxesNum>0)
		{			
			s=0;
			a=0;
			
			if (DI_Joysticks[n]->AxesNum>1)
			{
				joy[n].stick[s].flags = JOYFLAG_DIGITAL | JOYFLAG_ANALOGUE | JOYFLAG_SIGNED;
				joy[n].stick[s].num_axis = 2;
				joy[n].stick[s].axis[0].name = name_x;
				joy[n].stick[s].axis[1].name = name_y;
				joy[n].stick[s].name = name_stick;
				s++;
				a+=2;
			} 

			for (;a<DI_Joysticks[n]->AxesNum;)
			{
				joy[n].stick[s].flags = JOYFLAG_DIGITAL | JOYFLAG_ANALOGUE | JOYFLAG_UNSIGNED;
				joy[n].stick[s].num_axis = 1;
				joy[n].stick[s].axis[0].name = "";
				joy[n].stick[s].name = name_throttle;
				s++;
				a++;
			}

			if (DI_Joysticks[n]->HasHat)
			{
				joy[n].stick[s].flags = JOYFLAG_DIGITAL | JOYFLAG_SIGNED;
				joy[n].stick[s].num_axis = 2;
				joy[n].stick[s].axis[0].name = "up/down";
				joy[n].stick[s].axis[1].name = "up/down";
				joy[n].stick[s].name = "hat";
				s++;				
			}
						
			joy[0].num_sticks = s;		
		} else
		{
			joy[n].num_sticks=0;
		}
   
		/* fill in the button names */
		for (i=0; i<joy[0].num_buttons; i++)
			joy[0].button[i].name = name_b[i];

		for (i=0; i<joy[1].num_buttons; i++)
			joy[1].button[i].name = name_b[i];   
   }

   return 0;
}



/* joy_exit:
 *  Shuts down the driver.
 */
static void joy_exit()
{
   joystick_flags = 0;
}



/* joy_poll:
 *  Updates the joystick status variables.
 */
static int joy_poll()
{
	int n, s, wa, a, b, p, Dimension, h, v;
	
	DI_PollJoystick();

	joy_old_x = joy[0].stick[0].axis[0].pos;
	joy_old_y = joy[0].stick[0].axis[1].pos;

	joy2_old_x = joy[1].stick[0].axis[0].pos;
	joy2_old_y = joy[1].stick[0].axis[1].pos;

	for (n=0; n<num_joysticks; n++)
	{
		/* buttons */
		for (b=0; b<DI_Joysticks[n]->ButtonsNum; b++)
			joy[n].button[b].b = DI_Joysticks[n]->Buttons[b];
		
		/* sticks */
		for (wa=0; wa<DI_Joysticks[n]->AxesNum;)
		{
			for (s=0; s<joy[n].num_sticks; s++)
			{
				if (DI_Joysticks[n]->HasHat && s==1) continue;

				for (a=0; a<joy[n].stick[s].num_axis; a++)
				{
					p = DI_Joysticks[n]->Axes[wa] - DI_Joysticks[n]->Min[wa];
					Dimension = DI_Joysticks[n]->Max[wa]-DI_Joysticks[n]->Min[wa];
					if (Dimension>0)
						p = p*256 / Dimension;
					else
						p = 0;

					if (joy[n].stick[s].flags | JOYFLAG_ANALOGUE)
					{
						if (joy[n].stick[s].flags | JOYFLAG_SIGNED)
							joy[n].stick[s].axis[a].pos = p-128;
						else
							joy[n].stick[s].axis[a].pos = p;						
					}

					if (joy[n].stick[s].flags | JOYFLAG_DIGITAL)
					{
						if (p<64) 
							joy[n].stick[s].axis[a].d1 = 1;
						else
							joy[n].stick[s].axis[a].d1 = 0;

						if (p>192) 
							joy[n].stick[s].axis[a].d2 = 1;
						else
							joy[n].stick[s].axis[a].d2 = 0;
					}

					wa++;
				}
			}
		} 
	
		/* hat */
		if (DI_Joysticks[n]->HasHat)
		{			
			joy[n].stick[1].axis[0].d1 = DI_Joysticks[n]->Hat==1; 
			joy[n].stick[1].axis[0].d2 = DI_Joysticks[n]->Hat==3;			
			joy[n].stick[1].axis[1].d1 = DI_Joysticks[n]->Hat==4;
			joy[n].stick[1].axis[1].d2 = DI_Joysticks[n]->Hat==2;

			/* emulate analog joystick */
			h=0;
			v=0;
			switch (DI_Joysticks[n]->Hat)
			{
			case 1: h=-128; break;
			case 3: h=+128; break;
			case 4: v=+128; break;
			case 2: h=-128; break;
			}

			joy[n].stick[1].axis[0].pos = h;
			joy[n].stick[1].axis[0].pos = v;
			
			s++;
		}
	}

	return 0;
}



/* calibrate_corner:
 *  For analogue access to the joystick, this is used to measure the top
 *  left and bottom right corner positions.
 */
static int calibrate_corner(int stick, int corner)
{
   return 0;
}



/* calibrate_joystick_tl:
 *  For backward compatibility with the old API.
 */
int calibrate_joystick_tl()
{
   return 0;
}



/* calibrate_joystick_br:
 *  For backward compatibility with the old API.
 */
int calibrate_joystick_br()
{
   return 0;
}



/* calibrate_joystick_throttle_min:
 *  For analogue access to the FSPro's throttle, call this after 
 *  initialise_joystick(), with the throttle at the "minimum" extreme
 *  (the user decides whether this is all the way forwards or all the
 *  way back), and also call calibrate_joystick_throttle_max().
 */
int calibrate_joystick_throttle_min()
{
   return 0;
}



/* calibrate_joystick_throttle_max:
 *  For analogue access to the FSPro's throttle, call this after 
 *  initialise_joystick(), with the throttle at the "maximum" extreme
 *  (the user decides whether this is all the way forwards or all the
 *  way back), and also call calibrate_joystick_throttle_min().
 */
int calibrate_joystick_throttle_max()
{
   return 0;
}



/* calibrate_joystick_hat:
 *  For access to the Wingman Extreme's hat (I think this will work on all 
 *  Thrustmaster compatible joysticks), call this after initialise_joystick(), 
 *  passing the JOY_HAT constant you wish to calibrate.
 */
int calibrate_joystick_hat(int direction)
{
   return 0;
}
