#define WIN32_LEAN_AND_MEAN
#define BITMAP WINDOWS_BITMAP
#include <windows.h>
#undef BITMAP
#undef RGB
#include "allegro.h"
#include "winalleg.h"

extern int main(int argc, char **argv);

/*
 * WinMain
 *
 * Initialize the WinAllegro DLL
 */
int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, 
		LPSTR lpCmdLine, int nCmdShow)
{
	int result = WinAllegro_Init(hInstance);

	if (result==0)
	{
		result = main(WinAllegro_GetArgc(), WinAllegro_GetArgv());
		allegro_exit();
		WinAllegro_Exit();

		if (result!=0)
		{
			MessageBox(NULL, "WinAllegro application was shutdown after an error occured. "
				"For more information look in allegro.log!", "WinAllegro Error", 
				MB_ICONERROR | MB_OK | MB_SETFOREGROUND);
		}
	} else
	{
		WinAllegro_Exit();

		MessageBox(NULL, "WinAllegro couldn't be setup."
				"For more information look in allegro.log!", "WinAllegro Error", 
				MB_ICONERROR | MB_OK | MB_SETFOREGROUND);
	}
		
	return result;	
}
 
 