/*         ______   ___    ___ 
 *        /\  _  \ /\_ \  /\_ \ 
 *        \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___ 
 *         \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
 *          \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
 *           \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
 *            \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
 *                                           /\____/
 *                                           \_/__/
 *      By Shawn Hargreaves,
 *      1 Salisbury Road,
 *      Market Drayton,
 *      Shropshire,
 *      England, TF9 1AJ.
 *
 *		Debug functions, by Stefan Schimanski (1Stein@gmx.de)
 *
 *      See readme.txt for copyright information.
 */


#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <fstream.h>
#include <stdio.h>
#include <stdarg.h>
#include "winintrn.h"


/*****************************************************************************/


CRITICAL_SECTION DebugLogCriticalSection; // critical section to write into 
                                          // the debug log file
int UseLogFile = 0;
int DbgLogLevel = 0;
int DbgLevel = 0;

int NextPriority = 0;
int NextLine = 0;
char *NextFile = NULL;
char s[256];
char s2[256];

/*****************************************************************************/



void DbgInit(int Priority, int aLine, char *aFile)
{
#ifdef _DEBUG
    EnterCriticalSection(&DebugLogCriticalSection);

    // Save information for next DbgMsg call
    NextPriority = Priority;
    NextLine = aLine;

    // extract only last part after SRC of path
    char *p = strrchr(aFile, '\\');    
    if (p!=NULL) aFile = p+1;
    NextFile = aFile;
#endif
}


void DbgMsg(char *Msg, ...)
{
#ifdef _DEBUG    
    // Generate message
    va_list arg;
    va_start(arg, Msg);     
    vsprintf(s2, Msg, arg);
    va_end(arg);
    s2[79] = 0;    

    // Handle different output modes
    char *Mode;

    switch (NextPriority)
    {            
    case 0: Mode = "DERR"; break;
    case 1: Mode = "D1"; break;
    case 2: Mode = "D2"; break;
    case 3: Mode = "D3"; break;
    case 4: Mode = "D4"; break;
    case 5: Mode = "D5"; break;
    case 6: Mode = "DBEG"; break;
    case 7: Mode = "DEND"; break;
    default: Mode = "D";
    }

    // Add line and file
    sprintf(s, "%-2s %-13s.%-4u: %s\n", Mode, NextFile, NextLine, s2);
    s[79] = 0;
   
    // Output to log file
    if (NextPriority<=DbgLogLevel)
    {                
        ofstream cdebuglog("allegro.log", ios::app | ios::ate | ios::out);        
        cdebuglog << s;
    }

    // Output to debugger
    if (NextPriority<=DbgLevel)
    {        
        OutputDebugString(s);        
    }

    LeaveCriticalSection(&DebugLogCriticalSection);
#endif
}


int InitDebug()
{
#ifdef _DEBUG
   	InitializeCriticalSection(&DebugLogCriticalSection);

    // Get debug levels from registry
    HKEY hDbgKey;

    DbgLevel = 0;
    DbgLogLevel = 9;

    // Open debug key
    LONG r = RegOpenKey(HKEY_CURRENT_USER, 
        "Software\\WinAllegro\\Debug", &hDbgKey);
    if (r==ERROR_SUCCESS)
    {
        DWORD Buf;
        DWORD Size;
        DWORD Type;

        // Get debug level
        Size = sizeof(Buf);
        r = RegQueryValueEx(hDbgKey, "DebugLevel", NULL, &Type, 
            (LPBYTE)&Buf, &Size);
        if (r==ERROR_SUCCESS && Type==REG_DWORD)
        {
            DbgLevel = Buf;
        }

        // Get log level
        Size = sizeof(Buf);
        r = RegQueryValueEx(hDbgKey, "LogLevel", NULL, &Type, 
            (LPBYTE)&Buf, &Size);
        if (r==ERROR_SUCCESS && Type==REG_DWORD)
        {
            DbgLogLevel = Buf;
        }

        RegCloseKey(hDbgKey);
    }

    // Create log file
    if (DbgLogLevel>0)
    {
	    ofstream cdebuglog("allegro.log", ios::out | ios::trunc);
	    cdebuglog << "WinAllegro " << __DATE__ << " " << __TIME__ << endl;
	    cdebuglog.close();
    }
#endif

    return 0;
}


void DoneDebug()
{
#ifdef _DEBUG
    DeleteCriticalSection(&DebugLogCriticalSection);
#endif
}