/*         ______   ___    ___ 
 *        /\  _  \ /\_ \  /\_ \ 
 *        \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___ 
 *         \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
 *          \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
 *           \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
 *            \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
 *                                           /\____/
 *                                           \_/__/
 *      By Shawn Hargreaves,
 *      1 Salisbury Road,
 *      Market Drayton,
 *      Shropshire,
 *      England, TF9 1AJ.
 *
 *		DirectX wrapper, by Stefan Schimanski (1Stein@gmx.de)
 *
 *      See readme.txt for copyright information.
 */


#ifndef WINDX_H_INCLUDED
#define WINDX_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif


#define INTERNAL_FILE


/*
DirectDraw functions
*/
struct CDDColor
{
	char r;
	char g;
	char b;
	char Dummy;
};


struct CDDSurface
{
	struct IDirectDrawSurface *Surface;
	int Locked;
	int Lost;
	int Pitch;
	char *BasePtr;
};

extern int DD_Width;
extern int DD_Height;
extern int DD_Depth;

struct CDDSurface *DD_Open(int w, int h, int cdepth, int fullscreeen);
void DD_Close();

void DD_SetPalette(struct CDDColor *Pal, int from, int to, int vsync);
void DD_SetCurrentPalette();
void DD_ExpandGDIPal();
void DD_ReduceGDIPal();
void DD_VSync();

struct CDDSurface *DD_CreateSurface(int Width, int Height);
void DD_DestroySurface(struct CDDSurface *Surface);
int DD_ShowSurface(struct CDDSurface *Surface, int Wait);
int DD_ShowFinished();
void DD_Lock(struct CDDSurface *Surface);
void DD_Unlock(struct CDDSurface *Surface);
int DD_Lost(struct CDDSurface *Surface);

int DD_Blit(struct CDDSurface *Source, struct CDDSurface *Dest, 
			int Source_x, int Source_y, int Dest_x, int Dest_y, int Width, int Height);
int DD_BlitTrans(struct CDDSurface *Source, struct CDDSurface *Dest, 
			int Source_x, int Source_y, int Dest_x, int Dest_y, int Width, int Height);


/*
DirectInput functions
*/

/* Mouse functions */
int DI_InitMouse(void (*MouseInt)(int dx, int dy, int px, int py, int but), int Exclusive);
int DI_AcquireMouse();
void DI_UnAcquireMouse();
void DI_DoneMouse();
void DI_PollMouse();
void DI_ShowMouse();
void DI_HideMouse();
void DI_MoveMouse(int x, int y);

/* Keyboard functions */
int DI_InitKeyboard(int (*keyint)(int scancode, int foreground));
int DI_AcquireKeyboard();
void DI_UnAcquireKeyboard();
void DI_DoneKeyboard();
void DI_PollKeyboard();

/* Joystick functions */
#define MAXJOYSTICKS 2
#define MAXBUTTONS 8
#define MAXAXES 3

extern int JoysticksNum;
extern int JoystickAttached;

struct JOYSTICK
{
	int Min[MAXAXES];
	int Max[MAXAXES];
	int Axes[MAXAXES];
	int Buttons[MAXBUTTONS];
	int Hat;
	int HasHat;
	int ButtonsNum;
	int AxesNum;
};

int DI_InitJoystick();
void DI_DoneJoystick();
int DI_AcquireJoystick();
void DI_UnAcquireJoystick();
void DI_PollJoystick();
struct JOYSTICK *DI_GetJoysticks();

/*
DirectSound functions
*/

struct DS_VOICE
{
	int Looping;
	int Playing;
    int Size;
	void *BufA, *BufB;
	int SizeA, SizeB;
    int Freq, Is16Bit, IsStereo;
	struct IDirectSoundBuffer *SoundBuffer;
};

int DS_Init(int aTryPrimary);
void DS_Done();

int DS_Detect();

int DS_IsPrimaryPossible();
void DS_GetCaps(int *aFreq, int *aIs16Bit, int *aIsStereo);
int DS_Lock(struct DS_VOICE *aVoice, int aPos, int aLength, void **aBufA, unsigned long *aSizeA, void **aBufB, unsigned long *aSizeB);
void DS_Unlock(struct DS_VOICE *aVoice);
void DS_Volume(int aVolume);

struct DS_VOICE* DS_CreateVoice(int aIs16Bit, int aIsStereo, int aFreq, int Size);
struct DS_VOICE* DS_CreatePrimaryVoice(int aIs16Bit, int aIsStereo, int aFreq);
void DS_DestroyVoice(struct DS_VOICE *aVoice);

void DS_StartVoice(struct DS_VOICE *aVoice);
void DS_StopVoice(struct DS_VOICE *aVoice);
void DS_AdjustVoice(struct DS_VOICE *aVoice, int aLooping);

int DS_GetVoicePos(struct DS_VOICE *aVoice);
void DS_SetVoicePos(struct DS_VOICE *aVoice, int aPos);

int DS_GetVoiceVol(struct DS_VOICE *aVoice);
void DS_SetVoiceVol(struct DS_VOICE *aVoice, int aVol);

int DS_GetVoiceFreq(struct DS_VOICE *aVoice);
void DS_SetVoiceFreq(struct DS_VOICE *aVoice, int aFreq);

int DS_GetVoicePan(struct DS_VOICE *aVoice);
void DS_SetVoicePan(struct DS_VOICE *aVoice, int aPan);



#ifdef _DEBUG

#ifndef D1
void DbgInit(int Priority, int aLine, char *aFile);
void DbgMsg(char *Msg, ...);

#ifdef LOG
    #undef LOG
#endif

#define DERR DbgInit(0, __LINE__, __FILE__); DbgMsg
#define D1 DbgInit(1, __LINE__, __FILE__); DbgMsg
#define D2 DbgInit(2, __LINE__, __FILE__); DbgMsg
#define D3 DbgInit(3, __LINE__, __FILE__); DbgMsg
#define D4 DbgInit(4, __LINE__, __FILE__); DbgMsg
#define D5 DbgInit(5, __LINE__, __FILE__); DbgMsg
#define DBEG DbgInit(6, __LINE__, __FILE__); DbgMsg
#define DEND DbgInit(7, __LINE__, __FILE__); DbgMsg
#define LOG DbgInit(3, __LINE__, __FILE__); DbgMsg
#endif

#else

#define D1 //
#define D2 //
#define D3 //
#define D4 //
#define D5 //
#define DERR //
#define DBEG //
#define DEND //
#define LOG //

#endif

#ifdef __cplusplus
}
#endif

#endif