/*         ______   ___    ___ 
 *        /\  _  \ /\_ \  /\_ \ 
 *        \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___ 
 *         \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
 *          \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
 *           \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
 *            \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
 *                                           /\____/
 *                                           \_/__/
 *      By Shawn Hargreaves,
 *      1 Salisbury Road,
 *      Market Drayton,
 *      Shropshire,
 *      England, TF9 1AJ.
 *
 *		Win32 midi driver (windows file), by Stefan Schimanski (1Stein@gmx.de)
 *
 *      See readme.txt for copyright information.
 */


#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <process.h>
#include <mmsystem.h>
#include <dsound.h>
#include "winintrn.h"


/***********************************************************************/

HMIDIOUT MidiDevice = NULL;


/*
 * DM_Detect
 *
 * Returns whether there is at least one midi device in the systme
 */
int DM_Detect()
{	
	return midiOutGetNumDevs()>0;
}


/*
 * DM_Init
 *
 * Initialise the Win32 midi driver
 */
int DM_Init()
{
	MMRESULT r;	

	// Open the MIDI Mapper
	r = midiOutOpen(&MidiDevice, (UINT)-1, 0, 0, CALLBACK_NULL);
	if (r!=MMSYSERR_NOERROR )
		goto Error;	

	// Resets MIDI Mapper
	midiOutReset(MidiDevice);
	
	// Return to caller
	return 0;

Error:
	
	return 1;
}


/*
 * DM_Done
 *
 * Shuts down the Win32 midi driver
 */
void DM_Done()
{
	// Closes the midi stream
	if (MidiDevice!=NULL)
	{
		midiOutReset(MidiDevice);
		midiOutClose(MidiDevice);
		MidiDevice = NULL;
	}
}


/*
 * DM_Output
 *
 * Sends one midi message to the default midi device
 */
void DM_Output(unsigned long Data)
{
	if (MidiDevice!=NULL)
	{
		midiOutShortMsg(MidiDevice, Data);
	}
}
