/*         ______   ___    ___ 
 *        /\  _  \ /\_ \  /\_ \ 
 *        \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___ 
 *         \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
 *          \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
 *           \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
 *            \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
 *                                           /\____/
 *                                           \_/__/
 *      By Shawn Hargreaves,
 *      1 Salisbury Road,
 *      Market Drayton,
 *      Shropshire,
 *      England, TF9 1AJ.
 *
 *		Thread synchronisation (windows file), by Stefan Schimanski (1Stein@gmx.de)
 *
 *      See readme.txt for copyright information.
 */

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <winbase.h>
#include "winintrn.h"


/******************************************************************************/

CRITICAL_SECTION WinAllegroSection;


/*
 * InitSync
 *
 * Initialise the synchronisation system
 */
int InitSync()
{
	InitializeCriticalSection(&WinAllegroSection);

	return 0;
}


/*
 * DoneSync
 *
 * Shuts down synchronisation system
 */
void DoneSync()
{
	DeleteCriticalSection(&WinAllegroSection);
}


/*
 * EnterSemaphore
 *
 * Enters the WinAllegro critical section
 */
void EnterSemaphore()
{
	EnterCriticalSection(&WinAllegroSection);	
}


/*
 * LeaveSemaphore
 *
 * Leaves the WinAllegro critical section
 */
void LeaveSemaphore()
{
	LeaveCriticalSection(&WinAllegroSection);
}
