/*         ______   ___    ___ 
 *        /\  _  \ /\_ \  /\_ \ 
 *        \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___ 
 *         \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
 *          \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
 *           \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
 *            \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
 *                                           /\____/
 *                                           \_/__/
 *      By Shawn Hargreaves,
 *      1 Salisbury Road,
 *      Market Drayton,
 *      Shropshire,
 *      England, TF9 1AJ.
 *
 *		Timer, by Stefan Schimanski (1Stein@gmx.de)
 *
 *      See readme.txt for copyright information.
 */


#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <winbase.h>
#include <mmsystem.h>
#include <fstream.h>
#include <process.h>
#include "winintrn.h"


/*****************************************************************************/


#define THREAD_TIMER


extern "C" int timerint(int last_delay);	// Allegro timer handler
#define TIMERS_PER_SECOND     1193181L
#define MSEC_TO_TIMER(x)      ((long)(x) * (TIMERS_PER_SECOND / 1000))
#define TIMER_TO_MSEC(x)      ((long)(x) * 1000 / TIMERS_PER_SECOND)

#ifndef THREAD_TIMER
    int TimerId = NULL;					// id of the Win32 timer
#else
    volatile bool EndTimerThread = false;
    HANDLE hTimerThread = NULL;
    #define TimerPriority THREAD_PRIORITY_ABOVE_NORMAL
    //TIME_CRITICAL 
#endif

#ifndef MIN
#define MIN(x,y)     (((x) < (y)) ? (x) : (y))
#define MAX(x,y)     (((x) > (y)) ? (x) : (y))
#define MID(x,y,z)   MAX((x), MIN((y), (z)))
#endif

UINT TimerRes;						// Timer resolution

bool UsePerformanceCounter = false;
LARGE_INTEGER liPentiumFrequency;
LARGE_INTEGER liPentiumCounter;

float TimerSpeed = TIMERS_PER_SECOND;
float PentiumFreq;

#ifdef THREAD_TIMER
const DEFAULT_DELAY = MSEC_TO_TIMER(100);
#else
const DEFAULT_DELAY = MSEC_TO_TIMER(100);
#endif


/*****************************************************************************/


inline long GetMiddleDWord(LARGE_INTEGER *i) // Gets bits 16-47
{
	return (i->LowPart >> 16) + (i->HighPart << 16);
}


LONGLONG StartCounter;

void StartTiming()
{
        StartCounter = liPentiumCounter.QuadPart;		
}


int ReadTiming()
{
    // Get new value
	QueryPerformanceCounter(&liPentiumCounter);
		   
    return int(Int32x32To64((liPentiumCounter.QuadPart - StartCounter), TIMERS_PER_SECOND) / liPentiumFrequency.QuadPart);
}


/*
 * Timer
 *
 * Win32 Multimedia timer callback
 */
int TimerProc(int CurrentDelay)
{    
    if (UsePerformanceCounter)
	{	
		// Save old value
		LONGLONG OldCounter = liPentiumCounter.QuadPart;

		// Get new value
		QueryPerformanceCounter(&liPentiumCounter);
		   
        /*int t = liPentiumCounter.QuadPart - OldCounter;        
        CurrentDelay = int(Int32x32To64(t, TIMERS_PER_SECOND) / liPentiumFrequency.QuadPart);*/
        
        float Delay = (float)(liPentiumCounter.QuadPart - OldCounter);        

        CurrentDelay = (int)(Delay * TimerSpeed / PentiumFreq);

        if (CurrentDelay>MSEC_TO_TIMER(200) || CurrentDelay<=0)
        {
            D2("TimerThread - error: CurrentDelay = %d", CurrentDelay);
        }        
	}

	int NextDelay = DEFAULT_DELAY;

	// Call Allegro timer and update delay for next shot
	if (!AppBackground)
	{                
        if (CurrentDelay<=0) CurrentDelay = 1;
        
        EnterSemaphore();
		NextDelay = timerint(CurrentDelay) / 2;        
        LeaveSemaphore();        
	}    
    
	// Check next delay
    if (NextDelay<=0) NextDelay = 1;
    if (NextDelay>DEFAULT_DELAY)
    {
        D2("TimerThread - error: NextDelay = %d", NextDelay);    
        NextDelay = DEFAULT_DELAY;
    }

    return NextDelay;
}


#ifdef THREAD_TIMER

void TimerThread(void *pParam)
{	
	LOG("TimerThread - start");

    HANDLE TimerEvent = CreateEvent(NULL, false, false, NULL);
    int CurrentDelay = DEFAULT_DELAY;

    while (!EndTimerThread)
    {
        CurrentDelay = TimerProc(CurrentDelay);    
        /*D5("StartTimin");
        StartTiming();*/
        int w = TIMER_TO_MSEC(CurrentDelay);
        if (w>0) Sleep(w);
        //WaitForSingleObject(TimerEvent, w);    
        /*int t =  ReadTiming();
        D5("Timed: %7u <-> %7u(%u ms)  -> %u%%", t, CurrentDelay, w, t*100/CurrentDelay);*/
    }

    CloseHandle(TimerEvent);

	LOG("TimerThread - end");
	_endthreadex(0);
}

#else

void __stdcall Timer(unsigned int,unsigned int,unsigned long,unsigned long,unsigned long)
{	
    static int CurrentDelay = DEFAULT_DELAY;    
    
    // Call timer proc
    int NextDelay = TimerProc(CurrentDelay);
    
    // Check new delay	
    int w = TIMER_TO_MSEC(NextDelay);
    if (w<TimerRes) w = TimerRes;    

    CurrentDelay = MSEC_TO_TIMER(w);

    // Setup next shot
    //D5("Timer - timerSetEvent(%d ms, ...)", w);
	TimerId = timeSetEvent(w, 0, Timer, NULL, TIME_ONESHOT);
    if (TimerId==NULL)
    {
        D5("Timer - timerSetEvent failed");

        CurrentDelay = DEFAULT_DELAY;
        TimerId = timeSetEvent(TIMER_TO_MSEC(CurrentDelay), 0, Timer, NULL, TIME_ONESHOT);
    }
}

#endif



/*
 * InitTimer
 */
int InitTimer()
{
    LOG("InitTimer - Entry");

   	// Create high peformance counter
	if (QueryPerformanceFrequency(&liPentiumFrequency)!=0)
	{			
		// Query current value
		QueryPerformanceCounter(&liPentiumCounter);

        PentiumFreq = (float)liPentiumFrequency.QuadPart;

		UsePerformanceCounter = true;
	} else
		UsePerformanceCounter = false;

#ifndef THREAD_TIMER
	TIMECAPS tc;	

	// Get timer caps
	LOG("InitTimer - timeGetDevCaps");
	if (timeGetDevCaps(&tc, sizeof(TIMECAPS)) != TIMERR_NOERROR)
	{
		LOG("Can't get timer caps");
		return -1;
	}

	// Set timer resolution
	LOG("InitTimer - timeBeginPeriod");
	TimerRes = min(max(tc.wPeriodMin, 1), tc.wPeriodMax);
	timeBeginPeriod(TimerRes); 

	// Create timer
	LOG("InitTimer - timeSetEvent");
	TimerId = timeSetEvent(TIMER_TO_MSEC(DEFAULT_DELAY), 0, Timer, NULL, TIME_ONESHOT);//TIME_PERIODIC);
	if (TimerId==NULL) 
	{
		LOG("Can't create multimedia timer.");		
		return -1;
	}
#else
    D3("InitTimer - Starting timer thread");
	EndTimerThread = false;
	hTimerThread  = (HANDLE)_beginthread(TimerThread, 0, NULL);
	SetThreadPriority((HANDLE)hTimerThread, TimerPriority);
#endif

	LOG("InitTimer - Exit");
	return 0;
}


/*
 *
 */
void DoneTimer()
{
#ifdef THREAD_TIMER
    EndTimerThread = true;
#else
	if (TimerId!=NULL)
    {
		timeKillEvent(TimerId);
        TimerId == NULL;
    }
#endif
}

