/*         ______   ___    ___ 
 *        /\  _  \ /\_ \  /\_ \ 
 *        \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___ 
 *         \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
 *          \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
 *           \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
 *            \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
 *                                           /\____/
 *                                           \_/__/
 *      By Shawn Hargreaves,
 *      1 Salisbury Road,
 *      Market Drayton,
 *      Shropshire,
 *      England, TF9 1AJ.
 *
 *		Internal WinAllegro header, by Stefan Schimanski (1Stein@gmx.de)
 *
 *      See readme.txt for copyright information.
 */


#ifndef WININTERN_H_INCLUDED
#define WININTERN_H_INCLUDED

#define INTERNAL_FILE

#ifdef __cplusplus
extern "C" {
#endif

#include "winalleg.h"
#include "internwn.h"
#include "windx.h"
	
extern HINSTANCE hInst;
extern HWND hMainWnd;
extern int ClientPosX;
extern int ClientPosY;
extern int AppBackground;

int WinAllegro_HandleMessages();

int InitTimer();
void DoneTimer();

int InitDebug();
void DoneDebug();

#ifdef _DEBUG

#ifndef D1
void DbgInit(int Priority, int aLine, char *aFile);
void DbgMsg(char *Msg, ...);

#define DERR DbgInit(0, __LINE__, __FILE__); DbgMsg
#define D1 DbgInit(1, __LINE__, __FILE__); DbgMsg
#define D2 DbgInit(2, __LINE__, __FILE__); DbgMsg
#define D3 DbgInit(3, __LINE__, __FILE__); DbgMsg
#define D4 DbgInit(4, __LINE__, __FILE__); DbgMsg
#define D5 DbgInit(5, __LINE__, __FILE__); DbgMsg
#define DBEG DbgInit(6, __LINE__, __FILE__); DbgMsg
#define DEND DbgInit(7, __LINE__, __FILE__); DbgMsg
#define LOG DbgInit(3, __LINE__, __FILE__); DbgMsg
#endif

#else

#define D1 //
#define D2 //
#define D3 //
#define D4 //
#define D5 //
#define DERR //
#define DBEG //
#define DEND //
#define LOG //

#endif

/*
 Windows messages
*/
#define WM_STOPAPPPAUSE (WM_USER+0)
#define WM_ACQUIREMOUSE (WM_USER+1)
#define WM_SHUTDOWN	(WM_USER+2)


/*
Synchronisation
*/
int InitSync();
void DoneSync();

void EnterSemaphore();
void LeaveSemaphore();

void EnterWindowSemaphore();
void LeaveWindowSemaphore();

/*
DirectX sub system
*/

/* DirectDraw */
int DD_Init();
void DD_Done();

void DD_OpenCore();
void DD_CloseCore();

/* DirectInput */
extern long DI_KeyboardEvent;
extern long DI_MouseEvent;

void DI_Done();
int DI_Init();

void DI_UpdateMouseCursor();

#ifdef __cplusplus
}
#endif

#endif