/*         ______   ___    ___ 
 *        /\  _  \ /\_ \  /\_ \ 
 *        \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___ 
 *         \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
 *          \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
 *           \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
 *            \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
 *                                           /\____/
 *                                           \_/__/
 *      By Shawn Hargreaves,
 *      1 Salisbury Road,
 *      Market Drayton,
 *      Shropshire,
 *      England, TF9 1AJ.
 *
 *		WinAlleg functions header, by Stefan Schimanski (1Stein@gmx.de)
 *
 *      See readme.txt for copyright information.
 */


#ifndef WINALLEG_H_INCLUDED
#define WINALLEG_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif


#ifndef EXTERN
	#ifdef __RSXNT__
		#define EXTERN extern
	#else
		#ifdef INTERNAL_FILE
			#define EXTERN __declspec(dllexport)
		#else
			#define EXTERN __declspec(dllimport)
		#endif
	#endif
#endif


#define DEBUGLOG


#ifndef _WINDOWS_
#ifdef _INC_WINDOWS
#define _WINDOWS_
#endif
#endif

/*
General functions
*/
#ifdef _WINDOWS_
EXTERN int WinAllegro_Init(HINSTANCE hInstance);
EXTERN void WinAllegro_Exit();
#endif

EXTERN int WinAllegro_IsForeground();
EXTERN int WinAllegro_GetArgc();
EXTERN char **WinAllegro_GetArgv();
EXTERN int WinAllegro_DriveExist(int Drive);


EXTERN int WinAllegro_GetKeyboardDelay();
EXTERN int WinAllegro_GetKeyboardRepeat();
EXTERN void WinAllegro_SetKeyboardDelay(int ms);
EXTERN void WinAllegro_SetKeyboardRepeat(int ms);

/*
Window functions
*/

EXTERN void WinAllegro_SetWindowTitle(char *Title);

#ifdef _WINDOWS_
EXTERN HWND WinAllegro_GetWindowHandle();
EXTERN void WinAllegro_SetWindowIcon(HICON hIcon);
EXTERN WNDPROC WinAllegro_SetWndProc(WNDPROC WndProc);
#endif

/*
DirectDraw callbacks
*/
#ifdef DIRECTDRAW_VERSION
EXTERN LPDIRECTDRAW WinAllegro_GetDirectDraw();
EXTERN LPDIRECTDRAW2 WinAllegro_GetDirectDraw2();
#ifdef ALLEGRO_H

inline LPDIRECTDRAWSURFACE WinAllegro_GetSurface(struct BITMAP *bmp)
{
    return *((LPDIRECTDRAWSURFACE*)bmp->extra);
}

#endif
#endif


#ifdef DEBUGLOG
EXTERN void DebugLog(char *Msg, int aLine, char *aFile);
#define LOG(Msg) DebugLog(Msg, __LINE__, __FILE__)
#else
#define LOG(s)
#endif

#ifdef __cplusplus
}
#endif

#endif
