// glyphView.cpp : implementation of the CGlyphView class
//

#include "stdafx.h"
#include "glyph.h"

#include "glyphDoc.h"
#include "glyphView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGlyphView

IMPLEMENT_DYNCREATE(CGlyphView, CView)

BEGIN_MESSAGE_MAP(CGlyphView, CView)
	//{{AFX_MSG_MAP(CGlyphView)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGlyphView construction/destruction

CGlyphView::CGlyphView()
{
	// TODO: add construction code here

}

CGlyphView::~CGlyphView()
{
}

BOOL CGlyphView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CGlyphView drawing

void CGlyphView::OnDraw(CDC* pDC)
{
	CGlyphDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);
	// TODO: add draw code for native data here
}
/////////////////////////////////////////////////////////////////////////////
// CGlyphView diagnostics

#ifdef _DEBUG
void CGlyphView::AssertValid() const
{
	CView::AssertValid();
}

void CGlyphView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CGlyphDoc* CGlyphView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CGlyphDoc)));
	return (CGlyphDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CGlyphView message handlers
FIXED FixedFromDouble(double d)
{
    long l;

    l = (long) (d * 65536L);
    return *(FIXED *)&l;
}
void put_number(CDC* dc, int x, int y, int number)
{
	char buffer[100];
	sprintf(buffer,"%d",number);
	dc->TextOut(x,y,buffer);
}

BOOL GV_bStart=TRUE;
void DrawCurve(CDC & dc, LPSTR lpBits)
{
	//setting
	int ox=100;
	int oy=250;
	//analyze
	TTPOLYGONHEADER* head= (TTPOLYGONHEADER*) lpBits;
	DWORD head_size=head->cb;
	DWORD end=(DWORD)head+ (DWORD)head_size;
	TTPOLYCURVE* curve;
	TTPOLYCURVE* NxtCurve=NULL;  //previous
	TTPOLYCURVE* PreCurve=NULL; //next
	curve=(TTPOLYCURVE*)(head+1);
	int i,x,y,curve_size;
	POINTFX p;
	int bFirst;
	int SX,SY; //starting point
	

	//draw head
	x=head->pfxStart.x.value;
	y=head->pfxStart.y.value;
	if (GV_bStart) {dc.MoveTo(x+ox, -y+oy); GV_bStart=FALSE; SX=x, SY=y;
	}
	else dc.LineTo(x+ox,-y+oy);




	//draw curve
	
	bFirst=TRUE;
	while( (DWORD)curve < end)
	{

		//how big is the curve?
		curve_size= curve->cpfx;

		//curve decide
		NxtCurve=(TTPOLYCURVE*)(&(curve->apfx[curve_size])); 

		
		if (curve->wType==TT_PRIM_LINE ) { //straight line

			if( bFirst==FALSE)  { //not a first point 
				POINTFX* preP= (POINTFX*)((LPSTR)curve - sizeof(POINTFX));

				dc.LineTo(preP->x.value+ox, -preP->y.value+oy);

				for (i=0; i< curve->cpfx; i++) 
				{
					p=curve->apfx[i];
					x=p.x.value;
					y=p.y.value;
					dc.LineTo(x+ox,-y+oy);
				}



			}
			else { //the first
				for (i=0; i< curve->cpfx; i++) 
				{
					p=curve->apfx[i];
					x=p.x.value;
					y=p.y.value;
					dc.LineTo(x+ox,-y+oy);
				}
				bFirst=FALSE;
			}
			//dc.LineTo(NxtCurve->apfx[0].x.value ,
			//NxtCurve->apfx[0].y.value );

		}
		else if (curve->wType==TT_PRIM_QSPLINE ) {  //spline
				POINTFX* preP= (POINTFX*)((LPSTR)curve - sizeof(POINTFX));
				float p[3][2];

			
				p[0][0]=(preP->x.value);
				p[0][1]=(preP->y.value);

				p[1][0]=curve->apfx[0].x.value;
				p[1][1]=curve->apfx[0].y.value;

				p[2][0]=(curve->apfx[1].x.value);
				p[2][1]=(curve->apfx[1].y.value);



				float t;
				float x,y;
				float b[3];

				
				for (t=0.0f;t<=1.1f;t+=0.2f) {
					b[0]=(1-t)*(1-t);
					b[1]=2*t*(1-t);
					b[2]=t*t;

					x=p[0][0]*b[0]+ p[1][0]*b[1]+ p[2][0]*b[2] ;
					y=p[0][1]*b[0]+ p[1][1]*b[1]+ p[2][1]*b[2] ;

					dc.LineTo((int)x+ox,-(int)y+oy);
			
				} 


			/*	for (i=0;i<3;i++) {
					dc.Rectangle(CRect(p[i][0],p[i][1],p[i][0]+3*(i+1),p[i][1]+3*(i+1)));
				}*/
			
		
		}

		curve=NxtCurve; 
		PreCurve=curve;

	}


	dc.LineTo(SX+ox,-SY+oy);

}
void CGlyphView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	// ̸ 
	//letter = (256 + (int)*param) * 256 + (256 + (int)*(param + 1));    
	//dc.TextOut(10,10,"A");
	/*DWORD GetGlyphOutline( UINT nChar, UINT nFormat, LPGLYPHMETRICS lpgm, 
		DWORD cbBuffer, LPVOID lpBuffer, const MAT2 FAR* lpmat2 ) const;*/

	//set font
	LOGFONT fn; //attribute of a font
	fn.lfHeight= -250;
	fn.lfWidth= 0;
	fn.lfWeight=FW_NORMAL; //FW_NORMAL or FW_BOLD  : thin or normal?
	
	fn.lfOrientation=0;
	fn.lfEscapement=0;
	fn.lfItalic=FALSE;
	fn.lfUnderline=FALSE;
	fn.lfStrikeOut=FALSE;
	fn.lfCharSet=JOHAB_CHARSET; //we use hangul..
	fn.lfOutPrecision=OUT_TT_PRECIS;//choose true type font
	fn.lfQuality=PROOF_QUALITY;
	fn.lfPitchAndFamily=VARIABLE_PITCH;//picth of font
	//strcpy(fn.lfFaceName,"HYM");
	strcpy(fn.lfFaceName,"ü");


	CFont font;
	font.CreateFontIndirect(&fn);
	dc.SelectObject(&font);


	//dc.TextOut(0,0,"");


	//set glyph
	GLYPHMETRICS gm;
	DWORD size;
	LPSTR lpBits;
	MAT2 mat;

	mat.eM11=FixedFromDouble(1.0);
	mat.eM12=FixedFromDouble(0.0);
	mat.eM21=FixedFromDouble(0.0);
	mat.eM22=FixedFromDouble(1.0);


	int letter='M';
	char* param="";
	letter = (256 + (int)*param) * 256 + (256 + (int)*(param + 1));    
	
	size=dc.GetGlyphOutline(letter, GGO_NATIVE, &gm, 0, NULL, &mat);
	lpBits=new char[size];

	size=dc.GetGlyphOutline(letter, GGO_NATIVE, &gm, size, lpBits, &mat);
	if (size<0) 
		TRACE("fial to get glyph\n");

	//analyze
	TTPOLYGONHEADER* head= (TTPOLYGONHEADER*) lpBits;
	char* buffer=(char*)head;
	DWORD head_size;
	DWORD finish=(DWORD)head+ (DWORD)size;

	int count=0;
	
	while((DWORD)head< finish) {
		//process
		GV_bStart=TRUE;	
		DrawCurve(dc, buffer);
		count++;
		//move to the next curve
		head_size= head->cb;
		buffer=buffer+head_size;
		head=(TTPOLYGONHEADER*)buffer;
	}
	// Do not call CView::OnPaint() for painting messages
}

void CGlyphView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();
	
	// TODO: Add your specialized code here and/or call the base class
}
