#define __HRGE_LIB_MAIN

#include<stdio.h>
#include<dos.h>
#include<mem.h>

#include "HRGE.h"

char r[16],g[16],b[16];
unsigned char engfont[97][16];
unsigned char first[8][20][32];
unsigned char second[4][22][32];
unsigned char third[4][28][32];
unsigned char han_mem[32];
unsigned char temp[32];

const char hantable[3][32]={
{0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,1,2,3,4,5,0,0,6,7,8,9,10,11,0,0,12,13,14,15,16,17,0,0,18,19,20,21,0,0},
{0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,0,17,18,19,20,21,22,23,24,25,26,27,0,0}};
static char cho_tb_yes[]={5,5,5,5,5,5,5,5,5,6,7,7,7,6,6,7,7,7,6,6,7,5};
static char cho_tb_no[]={0,0,0,0,0,0,0,0,0,1,3,3,3,1,2,4,4,4,2,1,3,0};
static char jong_tb[]={0,0,2,0,2,1,2,1,2,3,0,2,1,3,3,1,2,1,3,3,1,1};

const char paltable[16]={0,1,2,3,4,5,6,7,16,17,18,19,20,21,22,23};


void set_mode(unsigned char mode)
/* aϢ ai aa
   0x0e: 640*200*16 (a ai awiae  aA b)
   0x10: 640*350*16
   0x12: 640*480*16
   0x3 : Baa   */
{
   asm{
   xor ah,ah
   mov al,mode
   int 10h
   }
}

void doubley()
/* iaāa Yai ea
   640*200A awae 640*400a Ea */
{
   asm{
   mov dx,3d4h
   mov al,9
   out dx,al
   inc dx
   in  al,dx
   and al,07fh
   out dx,al
   }
}

void mode_1by1()
/* e Ii 1:1 aa
   640*200A awae 640*240awaa A
   640*400A awae 640*480awaa Ea */
{
   asm{
   mov  dx,3c2h
   mov  al,0E3h
   out  dx,al
   mov  dx,3c4h
   mov  ax,0300h
   out  dx,ax
   }
}

void res240()
{
/* 640*200aA 640*240a aa.
   ea res240() qA i  */
   asm{
   mov  dx,3d4h
   mov  ax,0e11h
   out  dx,ax
   mov  ax,0D06h
   out  dx,ax
   mov  ax,3E07h
   out  dx,ax
   mov  ax,0EA10h
   out  dx,ax
   mov  ax,0DF12h
   out  dx,ax
   mov  ax,0E715h
   out  dx,ax
   mov  ax,0616h
   out  dx,ax
   }
}

void memfill(ofs,length,color)
unsigned int ofs,length;
unsigned char color;
/* Ai a a e i a
   wordeᝡ aa lengthe 2 ᴡ ea */
{
   asm{
   push ds
   push es

   mov ax,0a000h
   mov es,ax
   mov ax,ofs
   mov di,ax      /* b廡e diA  */
   mov ax,length
   shr ax,1       /* lengthi 2 aA (ᐡae a孷a) */
   mov cx,ax      /* 孷aᝡ ea */

   mov dx,3ceh    /* packed pixel write */
   mov al,05h
   out dx,al
   inc dx
   mov al,02h
   out dx,al
   dec dx

   mov ah,color
   mov al,ah      /* word 孷i Ё ah,al a color t iea */
   cld

   rep stosw      /* 孷 */

   mov al,05h     /* mode reg  */
   out dx,al
   inc dx
   mov al,00h
   out dx,al
   dec dx

   pop es
   pop ds
   }
}

void memcopy(sorofs,tarofs,length)
unsigned int sorofs,tarofs,length;
/*  Ae ai ea
   A awA aa */
{
   asm{
   push ds
   push es

   mov dx,3ceh    /* latch mode */
   mov al,05h
   out dx,al
   inc dx
   mov al,01h
   out dx,al

   mov ax,0a000h
   mov ds,ax
   mov si,sorofs
   mov es,ax      /* Aea Aaae a a000h */
   mov di,tarofs  /* a Ui ea */
   cld
   mov cx,length  /*   */
   rep movsb      /* 孷 */

   mov al,0       /* mode  */
   out dx,al

   pop es
   pop ds
   }
}

void setstadd(addr)
unsigned int addr;
/* b廡i a page ewa aaaai ea
   pgklibA . */
{
   asm{
   mov bx,addr

   mov dx,0x3d4
   mov al,0xd
   mov ah,bl
   out dx,ax      /* badr  aaa */

   mov dx,0x3d4
   mov al,0xc
   mov ah,bh
   out dx,ax      /* badr  waa */

   mov dx,0x3da   /* status address port */
   }

loop1:
   asm{
   in  al,dx
   and al,9
   cmp al,9
   je  loop1
   }

loop2:
   asm{
   in  al,dx
   and al,9
   cmp al,9
   jne loop2
   }
}

void waitvert(void)
{
    asm mov dx,3dah
    lloop:
    asm{
    in al,dx
    test al,8
    jz lloop
    }
}

void putpix(unsigned int x,unsigned int y,unsigned char color)
/* eӡ  aai ea */
{
   asm{
   push ds
   push es

   mov bx,x /* Xa */
   mov ax,y /* ya */
   /*** get address ***/
   mov cx,80
   mul cx     /* YaA 80i Ё 廡i ea */
   mov cl,bl  /* bl ϡ */
   shr bx,1   /* x i 8 a 廡i ea */
   shr bx,1
   shr bx,1
   add bx,ax  /*  廡i sea */

   mov ax,0a000h
   mov es,ax

   and cl,07h  /* Xa mod 8 aa aaa i ea */
   mov al,80h  /* aaa á */
   ror al,cl   /* E Aeq a */
   mov cl,al   /* clA ea */

   mov dx,3ceh /* pcaked pixel writea ea */
   mov al,05h
   out dx,al
   inc dx
   mov al,02h
   out dx,al
   dec dx

   mov al,08h  /* A ee i bit mask regA ea */
   out dx,al
   mov al,cl
   inc dx
   out dx,al
   dec dx

   mov al,color    /* ia  */
   mov ah,es:[bx]  /* A e  */
   mov es:[bx],al  /* iai aa */


   mov al,05h   /* modei wȁ */
   out dx,al
   inc dx
   mov al,00h
   out dx,al
   dec dx

   mov al,08h   /* bit maski wȁ */
   out dx,al
   mov al,0ffh
   inc dx
   out dx,al
   dec dx

   pop es
   pop ds
   }
}

void vline(x,y,yl,color)
unsigned int x,y,yl;
unsigned char color;
/* i uea. yl 0 bwA Ё ea! */
{
   asm{
   push ds
   push es

   mov bx,x
   mov ax,y

   mov cx,80
   mul cx
   mov cl,bl
   shr bx,1
   shr bx,1
   shr bx,1
   add bx,ax

   mov ax,0a000h
   mov es,ax

   and cl,07h
   mov al,80h
   ror al,cl
   mov cl,al   /* aae putpixq */

   mov dx,3ceh /* packed pixel write a aa */
   mov al,05h
   out dx,al
   inc dx
   mov al,02h
   out dx,al
   dec dx

   mov al,08h  /* mask i ew */
   out dx,al
   mov al,cl
   inc dx
   out dx,al
   dec dx

   mov cx,yl   /* y i aᝡ ea */
   mov al,color
   }
lloop:
   asm{

   mov ah,es:[bx]
   mov es:[bx],al
   add bx,80
   loop lloop   /* 񿢓e ˥a {aa aᝡ ai eA aaa */

   /* e Aa  */
   mov al,05h
   out dx,al
   inc dx
   mov al,00h
   out dx,al
   dec dx

   mov al,08h
   out dx,al
   mov al,0ffh
   inc dx
   out dx,al
   dec dx

   pop es
   pop ds
   }
}

void hline(x,y,xl,color)
unsigned int x,y,xl;
unsigned char color;
/* ai uea . x xle 1eᷡa
   b xl 0 e ea */
{
   asm{
   push ds
   push es

   mov ax,0a000h
   mov es,ax

   mov cx,x
   mov di,cx  /* x1e di iea */
   mov bx,xl
   add bx,cx
   dec bx     /* x2=x1+xl-1  x2i ea*/
   mov si,bx  /* x2e si iea */

   and bx,07h
   and cx,07h /* x1,x2 aaa ái ea */
   mov bh,cl  /* A x1 maske bh, x2 maske bl iea */
   shr di,3
   shr si,3   /* di si 廡w ái ea */

   mov ax,y
   mov cx,80
   mul cx     /* y*80a y廡 ai Ё */
   add si,ax
   add di,ax  /* di,siA ea */

   mov dx,3ceh  /* packed pixel write mode */
   mov al,5
   out dx,al
   inc dx
   mov al,2
   out dx,al
   dec dx

   cmp si,di    /* di si 廡a {ea? */
   jz onepoint  /* {ae aae  ˥a */

   mov al,8     /* set mask reg */
   out dx,al
   inc dx
   mov al,0ffh
   mov cl,bh
   shr al,cl    /* x1 maski A */
   out dx,al
   dec dx
   mov al,color
   mov ah,es:[di]
   mov es:[di],al  /* ii ea */

   inc dx
   mov al,07fh
   mov cl,bl
   shr al,cl       /* x2 maski A */
   not al          /* x2 mask :  */
   out dx,al       /*  0:10000000 1:11000000 2:1110000~ a */
   dec dx          /*  01111111i shr a ai nota ea */
   mov al,color
   mov ah,es:[si]
   mov es:[si],al  /* ii ea */

   inc dx          /* mask regi  */
   mov al,0ffh
   out dx,al
   dec dx

   mov ax,di
   mov cx,si
   sub cx,ax
   dec cx          /* di-si-1  aA  i e */
   jz endl         /* aA iA ae { */

   mov al,color
   }
lloop:
   asm{
   inc di          /* b 廡e di+1 */
   mov es:[di],al
   loop lloop
   jmp endl
   }
onepoint:           /* aae  ˥ */
   asm{
   mov al,8         /* bit mask reg. */
   out dx,al
   inc dx
   mov ax,07fffh
   mov cl,bh
   shr al,cl        /* x1 aaa aa */
   mov cl,bl
   shr ah,cl
   not ah           /* x2 aaa aa */
   and al,ah        /* a i andǥa */
   out dx,al
   dec dx

   mov al,color     /*  */
   mov ah,es:[di]
   mov es:[di],al
   }
endl:
   asm{
   mov al,05h   /* mode reg  */
   out dx,al
   inc dx
   mov al,00h
   out dx,al
   dec dx

   mov al,08h   /* bit mask reg  */
   out dx,al
   mov al,0ffh
   inc dx
   out dx,al
   dec dx

   pop es
   pop ds
   }
}

void boxfill8(x8,y,xl8,yl,color)
unsigned int x8;
unsigned int y;
unsigned char xl8;
unsigned int yl;
unsigned char color;
/* éЁ wai aa
   x xle 8bit eᷡa.
   b xla yl 0 bwe ea */
{
   asm{

   push ds
   push es

   mov ax,y
   mov bx,x8

   mov cx,80
   mul cx       /* yA 80i Ё */
   add bx,ax    /* x8 A Ё 廡i ea */

   mov ax,yl
   mov si,ax    /* ye siA ea */

   mov ax,0a000h
   mov es,ax

   mov dx,3ceh /* packed pixel write a ea */
   mov al,05h
   out dx,al
   inc dx
   mov al,02h
   out dx,al
   dec dx

   mov al,color
   mov di,bx    /* 廡e diA Aaǥa */
   }
yloop:
   asm{
   mov cl,xl8   /* xa aa */
   mov bx,di    /* 廡 aea */
   }
lloop:
   asm{
   mov es:[bx],al
   inc bx
   dec cl
   jnz lloop    /* xa e  */

   add di,80    /* 廡 80(Aaa) wa */
   dec si
   jnz yloop:   /* y e e */

   mov al,05h   /* mode reg  */
   out dx,al
   inc dx
   mov al,00h
   out dx,al
   dec dx

   pop es
   pop ds
   }
}

void gettile8m(x8,yofs,xs8,ys,adrseg,adrofs)
unsigned int x8,yofs;
unsigned char xs8;
unsigned char ys;
unsigned int adrseg,adrofs;
/* Xa a 8bit  ai ia
   A ae xs8*ys*4 bytea
   e 32*32 ai eae (32/4)*32*4=1024 bytes
    i e iw e ϩa */
{
   asm{
   push ds
   push es

   mov ax,0a000h
   mov ds,ax

   mov es,adrseg
   mov di,adrofs  /*  廡i ds:si Ai es:di ea */
                  /* (ᐡae A A 孷aa) */
   mov si,yofs

   mov cx,x8
   add si,cx     /* b廡 eЁ siA  */

   mov cl,4      /* read plane select */
   mov dx,3ceh
   mov al,4
   out dx,al
   inc dx

   cld
   mov bh,xs8
   }
ploop:           /* plane loop (0~3) */
   asm{
   mov al,4
   sub al,cl
   out dx,al     /* i iAi  */
   push si       /* b廡 ϡ */
   mov bl,ys
   }
yloop:
   asm{
   mov ch,bh     /* xs8i chA  */
   shr ch,1      /* 2 a(a孷i iAa)*/
   jnb xloop     /* aỡa ae */
   movsb         /* aa孷 ea */
   }
xloop:
   asm{
   movsw         /* a孷 */
   dec ch
   jnz xloop     /*  rep movswi ea ᐡa
                    e chi eA(iAa)a
                     A aeA cxa e a 
			  aa A */
   mov al,bh
   xor ah,ah
   sub si,ax
   add si,80     /* xloopa {ae aq b廡i ǥa */
   dec bl
   jnz yloop

   pop si        /* yloopa {ae aq iAi Ё b廡  */
   dec cl
   jnz ploop

   mov al,0h     /* read plane  */
   out dx,al

   pop es
   pop ds
   }
}

void gettile16m(x8,yofs,xs16,ys,adrseg,adrofs)
unsigned int x8,yofs;
unsigned char xs16;
unsigned char ys;
unsigned int adrseg,adrofs;
/* xa 16bit ai ia
   i Ё a eiq
    A aa 孷i eae  e ᷁ q {aa
   Aⷥ we q */
{
   asm{
   push ds
   push es

   mov ax,0a000h
   mov ds,ax

   mov es,adrseg
   mov di,adrofs

   mov si,yofs

   mov cx,x8
   add si,cx

   mov cl,4
   mov dx,3ceh
   mov al,4
   out dx,al
   inc dx
   cld
   mov bh,xs16
   }
ploop:
   asm{
   mov al,4
   sub al,cl
   out dx,al
   push si
   mov bl,ys
   }
yloop:
   asm{
   mov ch,bh
   }
xloop:
   asm{
   movsw
   dec ch
   jnz xloop

   mov al,bh
   shl al,1
   xor ah,ah
   sub si,ax
   add si,80
   dec bl
   jnz yloop

   pop si
   dec cl
   jnz ploop

   mov al,0fh
   out dx,al

   pop es
   pop ds
   }
}

void puttile8m(x8,yofs,xs8,ys,adrseg,adrofs)
unsigned int x8,yofs;
unsigned char xs8;
unsigned char ys;
unsigned int adrseg,adrofs;
{
   asm{
   push ds
   push es

   mov ax,0a000h
   mov es,ax

   mov ds,adrseg
   mov si,adrofs

   mov di,yofs

   mov cx,x8
   add di,cx

   mov cl,4
   mov dx,3c4h
   mov al,2
   out dx,al
   inc dx
   cld
   mov bh,xs8
   }
ploop:
   asm{
   mov al,10h
   shr al,cl
   out dx,al
   push di
   mov bl,ys
   }
yloop:
   asm{
   mov ch,bh
   shr ch,1
   jnb xloop
   movsb
   }
xloop:
   asm{
   movsw
   dec ch
   jnz xloop

   mov al,bh
   xor ah,ah
   sub di,ax
   add di,80
   dec bl
   jnz yloop

   pop di
   dec cl
   jnz ploop

   mov al,0fh
   out dx,al

   pop es
   pop ds
   }
}

void puttile16m(x8,yofs,xs16,ys,adrseg,adrofs)
unsigned int x8,yofs;
unsigned char xs16;
unsigned char ys;
unsigned int adrseg,adrofs;
{
   asm{
   push ds
   push es

   mov ax,0a000h
   mov es,ax

   mov ds,adrseg
   mov si,adrofs

   mov di,yofs

   mov cx,x8
   add di,cx

   mov cl,4
   mov dx,3c4h
   mov al,2
   out dx,al
   inc dx
   cld
   mov bh,xs16
   }
ploop:
   asm{
   mov al,10h
   shr al,cl
   out dx,al
   push di
   mov bl,ys
   }
yloop:
   asm{
   mov ch,bh
   }
xloop:
   asm{
   movsw
   dec ch
   jnz xloop

   mov al,bh
   shl al,1
   xor ah,ah
   sub di,ax
   add di,80
   dec bl
   jnz yloop

   pop di
   dec cl
   jnz ploop

   mov al,0fh
   out dx,al

   pop es
   pop ds
   }
}

void putneospr8m(x8,yofs,xs8,ys,adrseg,adrofs)
unsigned int x8,yofs;
unsigned char xs8;
unsigned char ys;
unsigned int adrseg,adrofs;
{
   asm{
   push ds
   push es

   mov ax,0a000h
   mov es,ax

   mov di,yofs
   add di,x8

   mov ds,adrseg
   mov si,adrofs

   mov dx,3c4h
   mov al,2
   out dx,al
   inc dx
   mov al,0fh
   out dx,al

   add dx,9
   mov al,3
   out dx,al
   inc dx
   mov al,08h
   out dx,al

   mov bh,ys
   mov ch,xs8
   push di
   }
yloop:
   asm{
   mov cl,ch
   }
xloop:
   asm{
   mov ah,es:[di]
   mov al,ds:[si]
   mov es:[di],al
   inc si
   inc di
   dec cl
   jnz xloop

   mov al,ch
   xor ah,ah
   sub di,ax
   add di,80
   dec bh
   jnz yloop

   mov al,10h
   out dx,al
   dec dx

   mov dx,3c4h
   mov al,2
   out dx,al
   inc dx

   pop di
   mov bl,4
   }
ploop:
   asm{
   mov cl,bl
   mov al,10h
   shr al,cl
   out dx,al

   mov bh,ys
   push di
   }
yloop2:
   asm{
   mov cl,ch
   }
xloop2:
   asm{
   mov ah,es:[di]
   movsb
   dec cl
   jnz xloop2

   mov al,ch
   xor ah,ah
   sub di,ax
   add di,80
   dec bh
   jnz yloop2

   pop di
   dec bl
   jnz ploop

   mov al,0fh
   out dx,al
   mov dx,3ceh
   mov al,3
   out dx,al
   inc dx
   mov al,0
   out dx,al

   pop es
   pop ds
   }
}

void getbitmapm(x8,yofs,xs8,ys,adrseg,adrofs)
unsigned int x8,yofs;
unsigned char xs8;
unsigned char ys;
unsigned int adrseg,adrofs;
{
   asm{
   push ds
   push es

   mov ax,0a000h
   mov es,ax

   mov ds,adrseg
   mov si,adrofs

   mov ax,yofs
   mov bx,x8
   add ax,bx
   mov di,ax

   mov dx,3ceh
   mov al,4
   out dx,al
   inc dx
   mov al,0
   out dx,al

   mov ch,ys
   }
   yloop:
   asm{
   push di
   mov cl,xs8
   }
   xloop:
   asm{
   mov al,es:[di]
   mov ds:[si],al
   inc si
   inc di
   dec cl
   jnz xloop

   pop di
   add di,80
   dec ch
   jnz yloop:

   pop es
   pop ds
   }
}

void putbitmapm(x8,yofs,xs8,ys,color,adrseg,adrofs)
unsigned int x8,yofs;
unsigned char xs8;
unsigned char ys;
unsigned char color;
unsigned int adrseg,adrofs;
{
   asm{
   push ds
   push es

   mov ax,0a000h
   mov es,ax

   mov ds,adrseg
   mov si,adrofs

   mov ax,yofs
   mov bx,x8
   add ax,bx
   mov di,ax

   mov dx,3ceh
   mov al,1
   out dx,al
   inc dx
   mov al,color
   not al
   out dx,al

   mov ch,ys
   }
   yloop:
   asm{
   push di
   mov cl,xs8
   }
   xloop:
   asm{
   mov al,ds:[si]
   mov es:[di],al
   inc si
   inc di
   dec cl
   jnz xloop

   pop di
   add di,80
   dec ch
   jnz yloop:

   mov al,0
   out dx,al
   pop es
   pop ds
   }
}

void putneobitm(x8,yofs,xs8,ys,color,adrseg,adrofs)
unsigned int x8,yofs;
unsigned char xs8;
unsigned char ys;
unsigned char color;
unsigned int adrseg,adrofs;
{
   asm{
   push ds
   push es

   mov ax,0a000h
   mov es,ax

   mov di,yofs
   add di,x8

   mov ds,adrseg
   mov si,adrofs

   mov dx,3c4h
   mov al,2
   out dx,al
   inc dx
   mov al,0fh
   out dx,al

   add dx,9
   mov al,3
   out dx,al
   inc dx
   mov al,08h
   out dx,al

   mov bh,ys
   mov ch,xs8
   push di
   push si
   }
yloop:
   asm{
   mov cl,ch
   }
xloop:
   asm{
   mov ah,es:[di]
   mov al,ds:[si]
   not al
   mov es:[di],al
   inc si
   inc di
   dec cl
   jnz xloop

   mov al,ch
   xor ah,ah
   sub di,ax
   add di,80
   dec bh
   jnz yloop

   mov al,10h
   out dx,al

   pop si
   pop di

   mov dx,3c4h
   mov al,2
   out dx,al
   inc dx
   mov al,color
   or al,al
   jz fin
   out dx,al

   mov bh,ys
   }
yloop2:
   asm{
   mov cl,ch
   }
xloop2:
   asm{
   mov ah,es:[di]
   movsb
   dec cl
   jnz xloop2

   mov al,ch
   xor ah,ah
   sub di,ax
   add di,80
   dec bh
   jnz yloop2
   }
fin:
   asm{
   mov al,0fh
   out dx,al
   mov dx,3ceh
   mov al,3
   out dx,al
   inc dx
   mov al,0
   out dx,al

   pop es
   pop ds
   }
}

void box(x,y,x2,y2,c)
unsigned int x,y,x2,y2;
unsigned char c;
{
   hline(x,y,x2-x+1,c);
   hline(x,y2,x2-x+1,c);
   vline(x,y,y2-y+1,c);
   vline(x2,y,y2-y+1,c);
}

void loadfont()
{
   FILE *fp;
   int i,j,k;

   fp=fopen("engfont.fnt","rb");
   for(i=0;i<32*16;i++) fgetc(fp);
   for(i=0;i<97;i++)
	for(j=0;j<16;j++)
	   engfont[i][j]=fgetc(fp);
   fclose(fp);
   fp=fopen("hanfont.fnt","rb");
   for(i=0;i<8;i++)
	for(j=0;j<20;j++)
	   for(k=0;k<32;k++)
		first[i][j][k]=fgetc(fp);
   for(i=0;i<4;i++)
	for(j=0;j<22;j++)
	   for(k=0;k<32;k++)
		second[i][j][k]=fgetc(fp);
   for(i=0;i<4;i++)
	for(j=0;j<28;j++)
	   for(k=0;k<32;k++)
		third[i][j][k]=fgetc(fp);
   fclose(fp);
}

void or_image(unsigned char *src,unsigned char *dest,int lens)
{
   char i;
   for(i=0;i<lens;i++) dest[i]|=src[i];
}

void shdcopy(unsigned char *src,unsigned char lens)
{
   char i;
   temp[0]=0; temp[1]=0;
   if (lens==16)
	for(i=0;i<15;i++) temp[i+1]=src[i]>>1;
   else{
	for(i=0;i<32;i+=2) temp[i+2]=src[i]>>1;
	for(i=1;i<32;i+=2) temp[i+2]=(src[i]>>1)|(src[i-1]<<7);
   }
}

void puthanfont(x8,y,cho,jung,jong,color,ox)
int x8,y;
unsigned char cho,jung,jong;
unsigned char color,ox;
{
   unsigned char t1,t2,t3;
   unsigned char h1,h2,h3;
   h1=hantable[0][cho];
   h2=hantable[1][jung];
   h3=hantable[2][jong];
   t1=h3?cho_tb_yes[h2]:cho_tb_no[h2];
   t2=((h1==0||h1==1||h1==16)?0:1)+(h3?2:0);
   t3=jong_tb[h2];

   if (h1) memcpy(han_mem,first[t1][h1],32);
   else memset(han_mem,0,32);
   if (h2) or_image(second[t2][h2],han_mem,32);
   if (h3) or_image(third[t3][h3],han_mem,32);

   switch(ox){
   case 0:putbitmap(x8,y,2,16,color,han_mem); break;
   case 1:putneobit(x8,y,2,16,color,han_mem); break;
   case 2:shdcopy(han_mem,32);
	    putneobit(x8,y,2,16,color,temp);
	    putneobit(x8,y,2,16,color,han_mem); break;
   }
}

void putengfont(x8,y,data,color,ox)
int x8,y;
unsigned char data,color,ox;
{
   switch(ox){
   case 0:putbitmap(x8,y,1,16,color,engfont[data-' ']); break;
   case 1:putneobit(x8,y,1,16,color,engfont[data-' ']); break;
   case 2:shdcopy(engfont[data-' '],16);
	    putneobit(x8,y,1,16,color,temp);
	    putneobit(x8,y,1,16,color,engfont[data-' ']);break;
   }
}

void printfont(x8,y,st,color,ox)
int x8,y;
unsigned char *st;
unsigned char color;
unsigned char ox;
{
   unsigned char ch1,ch2;
   unsigned char cho,jung,jong;
   while(*st!=0){
	ch1=*st;
	if (ch1>127){
	   st++;
	   ch2=*st;
	   cho=(ch1&124)>>2;
	   jung=(ch1&3)*8+(ch2>>5);
	   jong=(ch2&31);
	   puthanfont(x8,y,cho,jung,jong,color,ox);
	   x8+=2;
	   st++;
	}
	else{
	   putengfont(x8,y,ch1,color,ox);
	   x8++;
	   st++;
	}
   }
}

void shdfont(x8,y,st,color1,color2)
int x8,y;
unsigned char *st;
unsigned char color1,color2;
{
   printfont(x8,y,st,color2,2);
   printfont(x8,y,st,color1,1);
}

void setpalette(color,r,g,b)
char color,r,g,b;
{
   outportb(0x3c8,paltable[color]);
   outportb(0x3c9,r);
   outportb(0x3c9,g);
   outportb(0x3c9,b);
}

void setallpalette()
{
   char i;
   for(i=0;i<16;i++) {
	outportb(0x3c8,paltable[i]);
	outportb(0x3c9,r[i]);
	outportb(0x3c9,g[i]);
	outportb(0x3c9,b[i]);
   }
}

void getallpalette()
{
    char i;
    for(i=0;i<16;i++){
	 outportb(0x3c7,paltable[i]);
	    r[i]=inportb(0x3c9);
	    g[i]=inportb(0x3c9);
	    b[i]=inportb(0x3c9);
    }
}

void fade_out(dac1,dac2,inc)
unsigned int dac1,dac2;
unsigned char inc;
{
    unsigned int i,j;
    unsigned char rt,gt,bt;

    for(i=dac1;i>=dac2;i-=inc){
	 for(j=0;j<16;j++){
	    rt=(r[j]*i)/dac1;
	    gt=(g[j]*i)/dac1;
	    bt=(b[j]*i)/dac1;
	    setpalette(j,rt,gt,bt);
	 }
	 waitvert();
    }
}

void fade_in(dac1,dac2,inc)
unsigned int dac1,dac2;
unsigned char inc;
{
    unsigned int i,j;
    unsigned char rt,gt,bt;

    for(i=dac2;i<=dac1;i+=inc){
	 for(j=0;j<16;j++){
	    rt=(r[j]*i)/dac1;
	    gt=(g[j]*i)/dac1;
	    bt=(b[j]*i)/dac1;
	    setpalette(j,rt,gt,bt);
	 }
	 waitvert();
    }
}

void fade(r1,g1,b1,maxcount,count)
unsigned char r1,g1,b1,maxcount,count;
{
   char cnt;
   for(cnt=0;cnt<16;cnt++){
      outportb(0x3c8,paltable[cnt]);
      outportb(0x3c9,*(r+cnt)+abs(r1-*(r+cnt))*count/maxcount);
      outportb(0x3c9,*(g+cnt)+abs(g1-*(g+cnt))*count/maxcount);
      outportb(0x3c9,*(b+cnt)+abs(b1-*(b+cnt))*count/maxcount);
   }
}


char pcxread(char *fname,unsigned int sadr)
/* pcx i ew. we ... */
{
   FILE *fp;
   unsigned int maxx,maxy;
   unsigned char ch,count;
   int i;
   unsigned char *adr;
   int x,y;
   char p;

   adr=(unsigned char *)0xa0000000;
   adr+=sadr;
   fp=fopen(fname,"rb");
   if (fp==NULL) return(-1);
   for(i=0;i<12;i++) fgetc(fp);
   maxx=getw(fp); maxy=getw(fp);
   maxx=maxx/8;
   maxx=80;
   maxy=400;
   for(i=0;i<16;i++) {
	r[i]=fgetc(fp)>>2;
	g[i]=fgetc(fp)>>2;
	b[i]=fgetc(fp)>>2;
   }
   setallpalette();

   for(i=0;i<64;i++) ch=fgetc(fp);

   outportb(0x3c4,2);
   for(y=0;y<maxy;y++)
	for(p=0;p<4;p++){
	   outportb(0x3c5,1<<p);
	   x=0;
	   while(x<maxx){
		ch=fgetc(fp);
		if ((ch & 0xc0)==0xc0){
		   count=(ch & 0x3f);
		   ch=fgetc(fp);
		   while(count>0){
			count--;
			*(adr+y*(maxx)+x)=ch;
			x++;
			if ((x>=maxx)&&(p<3)){
			   p++;
			   outportb(0x3c5,1<<p);
			   x=0;
			}
		   }
		}else{
		   *(adr+y*(maxx)+x)=ch;
		   x++;
		}
	   }
	}
   outportb(0x3c5,0xf);
   fclose(fp);
   return(0);
}

void pcxsave(char *fname,unsigned int sadr,unsigned int maxx,unsigned int maxy)
{
   unsigned char header[12]=
   {0xa,5,1,1,0,0,0,0,0x7f,2,0x8f,1};
   unsigned char head2[3]=
   {0,4,0x50};
   FILE *fp;
   unsigned char ch,ch2,counter;
   int i;
   unsigned char *adr;
   int x,y;
   char p;

   adr=(unsigned char *)0xa0000000;
   adr+=sadr;
   fp=fopen(fname,"wb");
   for(i=0;i<12;i++) fputc(header[i],fp);
   putw(maxx,fp); putw(maxy,fp);
   for(i=0;i<16;i++){
	fputc(r[i]<<2,fp);
	fputc(g[i]<<2,fp);
	fputc(b[i]<<2,fp);
   }
   for(i=0;i<3;i++) fputc(head2[i],fp);
   for(i=0;i<61;i++) fputc(0,fp);

   outportb(0x3ce,4);
   for(y=0;y<maxy;y++){
	outportb(0x3cf,0);
	counter=1;
	x=0;
	ch=*(adr+(y*80)+x);
	x++;
	for(p=0;p<4;p++){
	   outportb(0x3cf,p);
	   if (p!=0) x=0;
	   while(x<maxx){
		ch2=ch;
		ch=*(adr+(y*80)+x);
		x++;
		if ((x>=maxx)&&(p<3)){
		   p++;
		   outportb(0x3cf,p);
		   x=0;
		}
		if ((ch2!=ch)||(counter==0x3f))
		   if ((counter==1)&&(ch2<0xc0)) fputc(ch2,fp);
		   else{
		   fputc(counter|0xc0,fp);
		   fputc(ch2,fp);
		   counter=1;
		}
		else counter++;
	   }
	}
	if ((counter==1)&&(ch<0xc0))
	   fputc(ch,fp);
	else{
	   fputc(counter|0xc0,fp);
	   fputc(ch,fp);
	   counter=1;
	}
   }
   fclose(fp);
}
