unit MainUtDX;

interface

uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
   DDraw, DDUtils, ExtCtrls;

const
   MAX_X_LINE : Word = 640;
   MAX_Y_LINE : Word = 480;

   MAX_IMAGE_SURFACE = 2;
   IMAGE_SURFACE     = MAX_IMAGE_SURFACE;
   IMAGE_FILE_NAME   = 'Test';

   WIN_MOUSE_X_GAP   = 5;
   WIN_MOUSE_Y_GAP   = 24;

   BPP               : WORD    = 1;
   LEVEL_DATA        : integer = 1;
   STAGE_DATA        : integer = 1;

type

   TOption = record
      IsExclusive           : boolean; // Direct X     
      IsHighRevolution      : boolean; // ػ  
      CanModifyWalkFrame    : boolean; // ǽð  Ű 
      CanDisplayPerformance : boolean; //  ս   
      UseSystemMemory       : boolean; // ý ޸𸮸 ۷ 
      IsRegistered          : boolean; //   Ǿ° ?
   end;

   TPixelFormat = (pfUnknown, pfRGB8, pfRGB16, pfRGB15, pfBGR16, pfRGB24, pfBGR24, pfRGB32);

   TBasic = class(TForm)

      procedure   DDFormCreate  (Sender: TObject);
      procedure   DDFormDestroy (Sender: TObject);
      procedure   DDFormShow    (Sender: TObject; IsExcusive : boolean);

      procedure   FormCreate    (Sender: TObject);
      procedure   FormShow      (Sender: TObject);
      procedure   FormClose     (Sender: TObject; var Action: TCloseAction);
      procedure   FormDestroy   (Sender: TObject);
      procedure   FormMinimize  (Sender: TObject);
      procedure   FormOnRestore (Sender: TObject);
      procedure   FormPaint     (Sender: TObject);
      procedure   FormKeyDown   (Sender: TObject; var Key: Word; Shift: TShiftState);

   private

      FPreviousFlipping : boolean;
      FFlippingEnabled  : boolean;
      FActive           : boolean;
      FIsFirstShow      : boolean;
      FCounter          : integer;

      procedure   ExceptionHandler(Sender  : TObject; Error : Exception);
      procedure   HandleMessage   (var Msg : TMsg; var Handled : boolean);
      procedure   IdleHandler     (Sender  : TObject; var Done : boolean);
      function    GetBitmapName   (BitmapName : string; i : integer) : string;
      function    RestoreSurfaces : HResult;
      procedure   DrawSurfaces;
      procedure   SetFlippingEnabled(Value : boolean);

   public

      FStartTickCount   : integer;     { īƮ ۽ Tick            }
      FFlippingCount    : integer;     {  ø ȸ          }

      FIsLocked         : boolean;
      PixelFormat       : TPixelFormat;
      Tranceparency     : DWORD;
      DirectDraw        : IDirectDraw;         // DirectDraw object  
      PrimarySurface    : IDirectDrawSurface;  //  ȭ 
      BackBuffer        : IDirectDrawSurface;  // ĸ 
      Clipper           : IDirectDrawClipper;  // Ŭ ü
      DDPalette         : IDirectDrawPalette;  // ĸ  Ʈʿ ε
      Image             : array[1..MAX_IMAGE_SURFACE] of IDirectDrawSurface;
                                               // ̹ 
      LockDesc          : TDDSurfaceDesc;      // Lock Suface Ÿ 

      procedure   DrawScreen;
      procedure   UpdateDisplay(IsCommandable : boolean);
      function    MakeItSo     (DDResult : HResult) : boolean;
      property    FlippingEnabled : boolean read  FFlippingEnabled
                                            write SetFlippingEnabled;
      procedure   LockBackGround;
      procedure   UnlockBackGround;

      procedure   InitializeGame;
      procedure   FinalizeGame;

      procedure   WMActiveApp(var Msg : TWMActivateApp); message WM_ACTIVATEAPP;

   end;

var
   Basic  : TBasic;
   Option : TOption;


implementation

{$R *.DFM}

const
   DD_ERROR_CONST = $88760000;


function   TBasic.GetBitmapName(BitmapName : string; i : integer) : string;
begin
   Result := ExtractFilePath(Application.ExeName) + BitmapName + IntToStr(i) + '.BMP';
end;

procedure   TBasic.DDFormCreate(Sender: TObject);
begin
   FIsFirstShow      := TRUE;

   FIsLocked         := FALSE;
   FPreviousFlipping := FALSE;
   FFlippingEnabled  := FALSE;

  {  ڵ鷯  }
   Application.OnException := ExceptionHandler;
   Application.OnMinimize  := FormMinimize;
   Application.OnRestore   := FormOnRestore;

  {  ڸ ְ  , Ŀ  }
   Color       := clBlack;

   if Option.IsExclusive then begin
      SetBounds(0,0,MAX_X_LINE,MAX_Y_LINE);
      BorderStyle := bsNone;
   end else begin
      SetBounds(0,0,MAX_X_LINE+WIN_MOUSE_X_GAP*2,MAX_Y_LINE+WIN_MOUSE_Y_GAP+5);
      BorderStyle := bsSingle;
   end;
end;

procedure   TBasic.DDFormShow(Sender: TObject; IsExcusive : boolean);
var
   i             : integer;
   Test          : HRESULT;
//   pVideo        : PDWORD;
   DDSurfaceDesc : TDDSurfaceDesc;
   DDSCaps       : TDDSCaps;
   DDPixelFormat : TDDPixelFormat;
   ColorKey      : TDDColorKey;
   DC            : HDC;
begin
   if not FIsFirstShow then exit;

   FIsFirstShow := FALSE;

  { DD COM ü  }
   if DirectDrawCreate(nil,DirectDraw,nil) <> DD_OK then
      Raise Exception.Create('DirectDraw ü  ');

   if not Assigned(DirectDraw) then exit;

   if IsExcusive then begin

     { Ÿ Ǯũ Ȯ }
      Test := DirectDraw.SetCooperativeLevel(Handle,DDSCL_EXCLUSIVE or DDSCL_FULLSCREEN or DDSCL_ALLOWREBOOT);
      if Test <> DD_OK then
         Raise Exception.Create('Ÿ Ǯũ   : '+IntToStr(Test-DD_ERROR_CONST));

     { ȭ  ٲ }
      Test := DirectDraw.SetDisplayMode(MAX_X_LINE,MAX_Y_LINE,8*BPP);
      if Test <> DD_OK then
         Raise Exception.Create('640 x 480   : '+IntToStr(Test-DD_ERROR_CONST));

     { DirectDrawSurface ũ  }
      FillChar(DDSurfaceDesc,SizeOf(DDSurfaceDesc),0);
      with DDSurfaceDesc do begin
         dwSize            := SizeOf(DDSurfaceDesc);
         dwFlags           := DDSD_CAPS or DDSD_BACKBUFFERCOUNT;
         ddSCaps.dwCaps    := DDSCAPS_COMPLEX or DDSCAPS_FLIP or DDSCAPS_PRIMARYSURFACE;
         if Option.UseSystemMemory then
            ddSCaps.dwCaps := ddSCaps.dwCaps or DDSCAPS_SYSTEMMEMORY;
         dwBackBufferCount := 1;
      end;

     {  ȭ   }
      Test := DirectDraw.CreateSurface(DDSurfaceDesc,PrimarySurface,nil);
      if Test <> DD_OK then
         Raise Exception.Create(' ȭ    : '+IntToStr(Test-DD_ERROR_CONST));

     { ĸ  ü  }
      DDSCaps.dwCaps := DDSCAPS_BACKBUFFER;
      Test := PrimarySurface.GetAttachedSurface(DDSCaps,BackBuffer);
      if Test <> DD_OK then
         Raise Exception.Create('ĸ    : '+IntToStr(Test-DD_ERROR_CONST));

   end else begin

     { Ϲ   }
      if DirectDraw.SetCooperativeLevel(Handle,DDSCL_NORMAL) <> DD_OK then
         Raise Exception.Create('Ϲ    ');

     { DirectDrawSurface ũ  }
      FillChar(DDSurfaceDesc,SizeOf(DDSurfaceDesc),0);
      with DDSurfaceDesc do begin
         dwSize            := SizeOf(DDSurfaceDesc);
         dwFlags           := DDSD_CAPS;
         ddSCaps.dwCaps    := DDSCAPS_PRIMARYSURFACE;
      end;

     {  ȭ   }
      if DirectDraw.CreateSurface(DDSurfaceDesc,PrimarySurface,nil) <> DD_OK then
         Raise Exception.Create(' ȭ   ');

     { ĸ  ü  }
      FillChar(DDSurfaceDesc,SizeOf(DDSurfaceDesc),0);
      with DDSurfaceDesc do begin
         dwSize            := SizeOf(DDSurfaceDesc);
         dwFlags           := DDSD_CAPS or DDSD_HEIGHT or DDSD_WIDTH;
         ddSCaps.dwCaps    := DDSCAPS_OFFSCREENPLAIN;
         if Option.UseSystemMemory then
            ddSCaps.dwCaps := ddSCaps.dwCaps or DDSCAPS_SYSTEMMEMORY;
         dwWidth           := MAX_X_LINE;
         dwHeight          := MAX_Y_LINE;
      end;

      if DirectDraw.CreateSurface(DDSurfaceDesc,BackBuffer,nil) <> DD_OK then
         Raise Exception.Create('   ');

      if DirectDraw.CreateClipper(0,Clipper,nil) <> DD_OK then
         Raise EXception.Create('Ŭ ü  ');

      if Clipper.SetHWnd(0,handle) <> DD_OK then
         Raise EXception.Create('Ŭ ü  ');

      if PrimarySurface.SetClipper(Clipper) <> DD_OK then
         Raise EXception.Create('Ŭ ǥ ߰ ');

      try
         BackBuffer.GetDC(DC);
         BPP := GetDeviceCaps(DC,BITSPIXEL) div 8;
      finally
         BackBuffer.ReleaseDC(DC);
      end;
   end;

  { ȷƮ ε }
   if (BPP = 1) and IsExcusive then begin
      DDPalette := DDLoadPalette(DirectDraw,GetBitmapName(IMAGE_FILE_NAME,1));
      if PrimarySurface.SetPalette(DDPalette) <> DD_OK then
         Raise Exception.Create('ȷƮ ε ');
   end;

  { Ʈ  & ε }
   for i := 1 to IMAGE_SURFACE do begin
      Image[i] := DDLoadBitmap(DirectDraw,GetBitmapName(IMAGE_FILE_NAME,i),0,0,Option.UseSystemMemory);
   end;

  {   }
   for i := 1 to IMAGE_SURFACE do begin
      ColorKey.dwColorSpaceLowValue  := 0;
      ColorKey.dwColorSpaceHighValue := 0;
      if Image[i].SetColorKey(DDCKEY_SRCBLT,ColorKey) <> DD_OK then
         Raise Exception.Create('  ');
   end;

  { ȼ  ǵ }

   FillChar(DDPixelFormat,sizeof(DDPixelFormat),0);
   DDPixelFormat.dwSize := sizeof(DDPixelFormat);
   if PrimarySurface.GetPixelFormat(DDPixelFormat) <> DD_OK then
      Raise Exception.Create('ȼ  б ');

   case BPP of

      1 :
      begin
         PixelFormat := pfRGB8;
      end;

      2 :
      begin
         if DDPixelFormat.dwRBitMask = $0000F800 then begin
            PixelFormat   := pfRGB16;
            Tranceparency := $FFFF;
         end else if DDPixelFormat.dwRBitMask = $00007C00 then begin
            PixelFormat   := pfRGB15;
            Tranceparency := $7FFF;
         end else if DDPixelFormat.dwRBitMask = $0000001F then begin
            PixelFormat   := pfBGR16;
            Tranceparency := $FFFF;
         end else begin
            PixelFormat   := pfUnknown;
            Tranceparency := $0000;
         end;
      end;

      3 :
      begin
         if DDPixelFormat.dwRBitMask = $00FF0000 then begin
            PixelFormat   := pfRGB24;
            Tranceparency := $FFFFFF;
         end else if DDPixelFormat.dwRBitMask = $000000FF then begin
            PixelFormat   := pfBGR24;
            Tranceparency := $FFFFFF;
         end else begin
            PixelFormat   := pfUnknown;
            Tranceparency := $000000;
         end;
      end;

      4 :
      begin
         PixelFormat   := pfRGB32;
         Tranceparency := $FFFFFF;
      end;

      else
      begin
         PixelFormat   := pfUnknown;
      end;

   end;

   Cursor := crNone;
   if Option.IsExclusive then begin
      ShowCursor(FALSE);
   end;

   InitializeGame;

end;

procedure   TBasic.DDFormDestroy(Sender: TObject);
var
   i : integer;
begin
   UnlockBackGround;
  {  ø  }
   FlippingEnabled := FALSE;

   FinalizeGame;

  { ȭ   }
   if Assigned(PrimarySurface) then PrimarySurface.Release;

   for i := 1 to IMAGE_SURFACE do begin
      if Assigned(Image[i]) then Image[i].Release;
   end;

  { DirectDraw COM ü  }
   if Assigned(DirectDraw) then DirectDraw.Release;
   DirectDraw := nil;

  {  ڵ鷯  }
   Application.OnException := nil;
   Application.OnMinimize  := nil;
   Application.OnRestore   := nil;

   ShowCursor(TRUE);
end;

procedure   TBasic.LockBackGround;
begin
   if not FIsLocked then begin
      LockDesc.dwSize := SizeOf(TDDSurfaceDesc);
      repeat
      until MakeItSo(BackBuffer.Lock(Rect(0,0,MAX_X_LINE,MAX_Y_LINE),LockDesc,DDLOCK_SURFACEMEMORYPTR +
                     DDLOCK_WAIT, 0));
      FIsLocked := TRUE;
   end;
end;

procedure   TBasic.UnlockBackGround;
begin
   if FIsLocked then begin
      BackBuffer.UnLock(LockDesc.lpSurface);
      FIsLocked := FALSE;
   end;
end;

procedure   TBasic.SetFlippingEnabled(Value : boolean);
begin
   if Value <> FFlippingEnabled then begin
      FFlippingEnabled := Value;
      if FFlippingEnabled then begin
        {  ̺Ʈ ڵ鷯 ġ }
         Application.OnMessage := HandleMessage;
         Application.OnIdle    := IdleHandler;
      end else begin
        {  ̺Ʈ ڵ鷯  }
         Application.OnMessage := nil;
         Application.OnIdle    := nil;
      end;
   end;
end;

function    TBasic.MakeItSo(DDResult : HResult) : boolean;
begin
  { ȭ   Լ }
   case DDResult of
      DD_OK             : Result := TRUE;
      DDERR_SURFACELOST : Result := RestoreSurfaces <> DD_OK;
      else                Result := DDResult <> DDERR_WASSTILLDRAWING;
   end;
end;

function   TBasic.RestoreSurfaces : HResult;
var
   i : integer;
begin
  { ȭ Ҿ MakeItSo ȣ }
   Result := PrimarySurface.Restore;
   if Result = DD_OK then begin
      for i := 1 to IMAGE_SURFACE do begin
         Result := Image[i].Restore;
         if Result <> DD_OK then begin
            exit;
         end;
      end;
      if Result = DD_OK then DrawSurfaces;
   end;
end;

procedure   TBasic.DrawSurfaces;
var
   i : integer;
begin
   for i := 1 to IMAGE_SURFACE do begin
      DDReloadBitmap(Image[i],GetBitmapName(IMAGE_FILE_NAME,i));
   end;
end;

procedure   TBasic.UpdateDisplay(IsCommandable : boolean);
begin
   if FActive or not Option.IsExclusive then DrawScreen;
end;

procedure   TBasic.HandleMessage(var Msg : TMsg; var Handled : boolean);
begin
   UpdateDisplay(TRUE);
end;

procedure   TBasic.IdleHandler(Sender : TObject; var Done : boolean);
begin
   UpdateDisplay(TRUE);
   Done := FALSE;
end;

(* WINDOW EVENT SECTION *)

procedure   TBasic.FormCreate(Sender: TObject);
begin

   if Option.IsHighRevolution then begin
      MAX_X_LINE         := 800;
      MAX_Y_LINE         := 600;
   end else begin
      MAX_X_LINE         := 640;
      MAX_Y_LINE         := 480;
   end;

   FActive  := TRUE;
   FCounter := 0;

   DDFormCreate(Sender);
end;

procedure   TBasic.FormShow(Sender: TObject);
begin
   DDFormShow(Sender,Option.IsExclusive);
end;

procedure   TBasic.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
end;

procedure   TBasic.FormDestroy(Sender: TObject);
begin
   DDFormDestroy(Sender);
end;

procedure   TBasic.FormPaint(Sender: TObject);
begin
   if Assigned(DirectDraw) then
      DrawSurfaces;
end;

procedure   TBasic.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
   if key = VK_F12 then Close;
end;

procedure   TBasic.FormMinimize(Sender: TObject);
begin
   FPreviousFlipping := FlippingEnabled;
   FlippingEnabled   := FALSE;
end;

procedure   TBasic.FormOnRestore(Sender: TObject);
begin
   FlippingEnabled   := FPreviousFlipping;
   Basic.WindowState := wsNormal;
end;

procedure   TBasic.ExceptionHandler(Sender : TObject; Error : Exception);
var
   WasEnabled : boolean;
   WasLocked  : boolean;
begin
  {  ޼ ̱  GDI ȯ }

   MessageBeep(0);

   WasEnabled      := FlippingEnabled;
   FlippingEnabled := FALSE;

   WasLocked       := FIsLocked;
   if WasLocked then begin
      UnlockBackGround;
   end;

   if Assigned(DirectDraw) then DirectDraw.FlipToGDISurface;

   MessageDlg(Error.Message,mtError,[mbOK],0);

   if WasLocked then begin
      LockBackGround;
   end;

   FlippingEnabled := WasEnabled;

   Close;
end;

(* USER DEFINIION SECTION *)

procedure   TBasic.InitializeGame;
var
   Temp : Longint;
begin
   SystemParametersInfo(SPI_SCREENSAVERRUNNING,Word(TRUE),@Temp,0); // Disabled Ctrl-Alt-Del

end;

procedure   TBasic.FinalizeGame;
var
   Temp : Longint;
begin
   ClipCursor(nil);
   SystemParametersInfo(SPI_SCREENSAVERRUNNING,Word(FALSE),@Temp,0); // Enabled Ctrl-Alt-Del
end;

procedure   SpriteCopy(DestX, DestY : integer;
                       SourX, SourY : integer;
                       Size         : TPoint;
                       Sour, Dest   : IDirectDrawSurface);
const
   TRANSPARENCY_VALUE  = 80; //  80 ε̴.
var
   SourDesc, DestDesc  : TDDSurfaceDesc;
   pSour, pDest, pMask : PByte;
   Transparency        : array[1..8] of byte;
begin

   FillChar(Transparency,8,TRANSPARENCY_VALUE);

   SourDesc.dwSize := SizeOf(TDDSurfaceDesc);
   with Basic do repeat
   until MakeItSo(Sour.Lock(PRect(nil)^,SourDesc,DDLOCK_SURFACEMEMORYPTR + DDLOCK_WAIT,0));

   DestDesc.dwSize := SizeOf(TDDSurfaceDesc);
   with Basic do repeat
   until MakeItSo(Dest.Lock(PRect(nil)^,DestDesc,DDLOCK_SURFACEMEMORYPTR + DDLOCK_WAIT,0));

   pSour := PByte(DWORD(SourDesc.lpSurface) + SourY * SourDesc.lPitch + SourX);
   pDest := PByte(DWORD(DestDesc.lpSurface) + DestY * DestDesc.lPitch + DestX);
   pMask := Pointer(@Transparency);

   asm
         push  esi
         push  edi

         mov   esi, pMask
         db $0F,$6F,$26       /// movq  mm4, [esi]
                             //  mm4   ȣ ִ´
         mov   esi, pSour
         mov   edi, pDest

         mov   ecx, Size.Y

   @@LOOP_Y:

         push  ecx

         mov   ecx, Size.X
         shr   ecx, 3         // ÿ 8  ϹǷ


   @@LOOP_X:

         db $0F,$6F,$07       /// movq  mm0, [edi]
                              //  mm0  Destination
         db $0F,$6F,$0E       /// movq  mm1, [esi]
                              //  mm1  Source
         db $0F,$6F,$D1       /// movq  mm2, mm1
                              //  mm2  Source ͸ 
         db $0F,$74,$D4       /// pcmpeqb mm2, mm4
                              //  mm2    ũ 
         db $0F,$6F,$DA       /// movq  mm3, mm2
                              //  mm3  ũ ϳ  
         db $0F,$DF,$D1       /// pandn mm2, mm1
                              //  Source Ʈ κи 
         db $0F,$DB,$D8       /// pand  mm3, mm0
                              //  Destination  ŵ κи 
         db $0F,$EB,$D3       /// por   mm2, mm3
                              //  Source  Destination  
         db $0F,$7F,$17       /// movq  [edi], mm2
                              //  Destination   

         add   esi, 8
                              //  ѹ 8 bytes  ÿ óǷ
         add   edi, 8

         loop  @@LOOP_X

         add   esi, SourDesc.lPitch
         sub   esi, Size.X
         add   edi, DestDesc.lPitch
         sub   edi, Size.X

         pop   ecx
         loop  @@LOOP_Y

         db $0F,$77              /// emms

         pop   edi
         pop   esi

   end;

   Sour.UnLock(SourDesc.lpSurface);
   Dest.UnLock(DestDesc.lpSurface);

end;

procedure   TBasic.DrawScreen;
begin
   repeat
   until MakeItSo(BackBuffer.BltFast(0,0,Image[2],PRect(nil)^,DDBLTFAST_NOCOLORKEY));

   SpriteCopy(MAX_X_LINE - FCounter mod MAX_X_LINE,100 + Abs(FCounter mod 20 - 10),0,0,Point(256,275),Image[1],BackBuffer);

   if Option.IsExclusive then begin
      repeat
      until MakeItSo(PrimarySurface.Flip(nil,DDFLIP_WAIT));
   end else begin
      Basic.DirectDraw.WaitForVerticalBlank(DDWAITVB_BLOCKBEGIN,0);
      repeat
      until MakeItSo(PrimarySurface.Blt(Bounds(Left+WIN_MOUSE_X_GAP,Top+WIN_MOUSE_Y_GAP,
                     MAX_X_LINE,MAX_Y_LINE),BackBuffer,Rect(0,0,MAX_X_LINE,MAX_Y_LINE){PRect(nil)^},DDFLIP_WAIT,PDDBltFX(nil)^));
   end;
   Inc(FCounter);
end;

procedure   TBasic.WMActiveApp(var Msg : TWMActivateApp);
begin
   FActive := Msg.Active;
   if FActive then begin
      FFlippingCount  := -50;
      FStartTickCount := GetTickCount;
      FlippingEnabled := TRUE;
   end else begin
      if Option.IsExclusive then begin
         FlippingEnabled := FALSE;
      end;
   end;

end;

begin
   with Option do begin
      IsExclusive           := TRUE;
      IsHighRevolution      := not TRUE;
      CanModifyWalkFrame    := TRUE;
      CanDisplayPerformance := not TRUE;
      UseSystemMemory       := TRUE;
      IsRegistered          := not TRUE;
   end;
end.

