//////////////////////////////////////////////////////////////
//
// CD Audio Class (CAudio.cpp)
//
// 1999.4.8                                        Bull
//
//////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "CAudio.h"




/////////////////////////////////////////////////////////////////////////////
//  ߻ߴٸ MCI  ϴ ڿ ޽ ڿѴ.
DWORD CAudio::ErrorMsg(DWORD dwError)
{
	if(dwError)
	{
		if(this->AUDIO_ERROR_MSG[0] == NULL) ::strcpy((LPSTR)this->AUDIO_ERROR_MSG, "CD Audio Error!");

//	    ::MessageBox( NULL, (LPSTR)this->AUDIO_ERROR_MSG, "Class CD Audio Message", MB_ICONINFORMATION|MB_OK );
	}

	return dwError;
}




CAudio::CAudio()
{
	this->m_isopen					= FALSE;
	this->m_currenttrack.tracknum	= ID_START_TRACK;
	this->m_looptotaltracks			= TRUE;		

	Open();
	
	GetNumberOfTracks(this->m_totaltrack.totaltracknum);			// ü Ʈ  
	GetLength(this->m_totaltrack.min, this->m_totaltrack.sec);		// ü ð(, )
}



CAudio::~CAudio()
{
	Close();
}






/////////////////////////////////////////////////////////////////////////////
// CD  ġ .
DWORD CAudio::Open()
{
	DWORD					dwResult;
	MCI_OPEN_PARMS			mciOpenParms;

	if(this->m_isopen)	Close();

	SetCurrentTrack(this->m_currenttrack.tracknum);

	::ZeroMemory(&mciOpenParms, sizeof(MCI_OPEN_PARMS));
	mciOpenParms.lpstrDeviceType = (LPCSTR)MCI_DEVTYPE_CD_AUDIO;

	dwResult = ::mciSendCommand(NULL, MCI_OPEN, MCI_OPEN_TYPE | MCI_OPEN_TYPE_ID |
		MCI_OPEN_SHAREABLE, (DWORD)(LPVOID)&mciOpenParms);

	if (!dwResult)
	{
		this->m_isopen		= TRUE;
		this->m_deviceid	= mciOpenParms.wDeviceID;
		MCI_SET_PARMS mciSetInfo;
		mciSetInfo.dwTimeFormat = MCI_FORMAT_TMSF;
				
		dwResult = ::mciSendCommand(this->m_deviceid, MCI_SET, MCI_SET_TIME_FORMAT | MCI_WAIT,
			(DWORD)(LPVOID)&mciSetInfo);
	}

	::strcpy((LPSTR)this->AUDIO_ERROR_MSG, "CD Audio Open Error!");
	return ErrorMsg(dwResult);
}



/////////////////////////////////////////////////////////////////////////////
// CD  ġ ݴ´.
DWORD CAudio::Close()
{
	DWORD	dwResult = 0;

	if(this->m_isopen)
	{
		dwResult = Stop();
		ErrorMsg(dwResult);

		dwResult = ::mciSendCommand(this->m_deviceid, MCI_CLOSE, MCI_WAIT, NULL);
		ErrorMsg(dwResult);

		if (!dwResult) this->m_isopen = FALSE;
	}

	::strcpy((LPSTR)this->AUDIO_ERROR_MSG, "CD Audio Close Error!");
	return ErrorMsg(dwResult);
}



/////////////////////////////////////////////////////////////////////////////
// ġ  .
DWORD CAudio::Stop()
{
	DWORD	dwResult;

	dwResult = ::mciSendCommand(this->m_deviceid, MCI_STOP, MCI_WAIT, NULL);

	::strcpy((LPSTR)this->AUDIO_ERROR_MSG, "CD Audio Stop Error!");
	return ErrorMsg(dwResult);
}




/////////////////////////////////////////////////////////////////////////////
// ġ CD  Ѵ.
DWORD CAudio::Play()
{
	DWORD	dwResult;

	if (this->m_isopen)
	{
		GetTrackLength(this->m_currenttrack.tracknum, this->m_currenttrack.min, this->m_currenttrack.sec);
		this->m_mciplayparms.dwFrom		= MCI_MAKE_TMSF(this->m_currenttrack.tracknum, 0, 0, 0);
		this->m_mciplayparms.dwTo		= MCI_MAKE_TMSF(this->m_currenttrack.tracknum, this->m_currenttrack.min, this->m_currenttrack.sec, 0);
		this->m_mciplayparms.dwCallback	= NULL; //(DWORD)hwnd;
		dwResult = ::mciSendCommand(this->m_deviceid, MCI_PLAY, MCI_FROM | MCI_TO | MCI_NOTIFY,
				(DWORD)(LPVOID)&this->m_mciplayparms);
	}

	::strcpy((LPSTR)this->AUDIO_ERROR_MSG, "CD Audio Play Error!");
	return ErrorMsg(dwResult);
}





/////////////////////////////////////////////////////////////////////////////
//  Ʈ ÷
DWORD CAudio::PrePlay()
{
	DWORD	dwResult;

	OneStepTrackMove(ID_SUB_TRACK);

	dwResult = Play();

	::strcpy((LPSTR)this->AUDIO_ERROR_MSG, "CD Audio PrePlay Error!");
	return ErrorMsg(dwResult);
}





/////////////////////////////////////////////////////////////////////////////
//  Ʈ ÷
DWORD CAudio::NextPlay()
{
	DWORD	dwResult;

	OneStepTrackMove(ID_ADD_TRACK);

	dwResult = Play();

	::strcpy((LPSTR)this->AUDIO_ERROR_MSG, "CD Audio NextPlay Error!");
	return ErrorMsg(dwResult);
}




/////////////////////////////////////////////////////////////////////////////
//  Ʈ ÷ 
DWORD CAudio::RandomPlay(BYTE num)
{
	DWORD	dwResult;

	SetCurrentTrack(num);

	dwResult = Play();

	::strcpy((LPSTR)this->AUDIO_ERROR_MSG, "CD Audio RandomPlay Error!");
	return ErrorMsg(dwResult);
}




/////////////////////////////////////////////////////////////////////////////
// ġ  Ͻ ߴѴ.
DWORD CAudio::Pause()
{
	DWORD	dwResult;

	dwResult = ::mciSendCommand(this->m_deviceid, MCI_PAUSE, MCI_WAIT, NULL);

	::strcpy((LPSTR)this->AUDIO_ERROR_MSG, "CD Audio Pause Error!");
	return ErrorMsg(dwResult);
}




/////////////////////////////////////////////////////////////////////////////
//  ġ CD  簳Ѵ.
// ̳ ߴ ġ  ʰ CD  Ѵ.
DWORD CAudio::ResumePlay()
{
	DWORD					dwResult;

	dwResult = ::mciSendCommand(this->m_deviceid, MCI_PLAY, MCI_NOTIFY, (DWORD)(LPVOID)&this->m_mciplayparms); 

	::strcpy((LPSTR)this->AUDIO_ERROR_MSG, "CD Audio ResumePlay Error!");
	return ErrorMsg(dwResult);
}



/////////////////////////////////////////////////////////////////////////////
// ġ ü .
DWORD CAudio::Eject()
{
	DWORD					dwResult;

	dwResult = ::mciSendCommand(this->m_deviceid, MCI_SET, MCI_SET_DOOR_OPEN, NULL);

	::strcpy((LPSTR)this->AUDIO_ERROR_MSG, "CD Audio Eject Error!");
	return ErrorMsg(dwResult);
}




/////////////////////////////////////////////////////////////////////////////
// CD Ʈ ȮѴ.
DWORD CAudio::GetNumberOfTracks(DWORD& dwNumTracks)
{
	DWORD					dwResult;
	MCI_STATUS_PARMS		mciStatusInfo;

	mciStatusInfo.dwItem = MCI_STATUS_NUMBER_OF_TRACKS;
				
	dwResult = ::mciSendCommand(this->m_deviceid, MCI_STATUS, MCI_STATUS_ITEM,// | MCI_WAIT, 
			(DWORD)(LPVOID)&mciStatusInfo);
	dwNumTracks = mciStatusInfo.dwReturn;

	::strcpy((LPSTR)this->AUDIO_ERROR_MSG, "CD Audio GetNumberOfTracks Error!");
	return ErrorMsg(dwResult);
}



/////////////////////////////////////////////////////////////////////////////
//  CD ̺꿡 ü ִ ȮѴ.
DWORD CAudio::IsMediaPresent(BOOL& bPresent)
{
	DWORD					dwResult;
	MCI_STATUS_PARMS		mciStatusParms;

	mciStatusParms.dwItem = MCI_STATUS_MEDIA_PRESENT;

	dwResult = ::mciSendCommand(this->m_deviceid, MCI_STATUS, MCI_STATUS_ITEM,// | MCI_WAIT,
		(DWORD)(LPVOID)&mciStatusParms);

	bPresent = (mciStatusParms.dwReturn) ? TRUE : FALSE;

	::strcpy((LPSTR)this->AUDIO_ERROR_MSG, "CD Audio IsMediaPresent Error!");
	return ErrorMsg(dwResult);
}




/////////////////////////////////////////////////////////////////////////////
//  CD  ȮѴ.
DWORD CAudio::IsPlaying(BOOL& bPlaying)
{
	DWORD					dwResult;
	MCI_STATUS_PARMS		mciStatusParms;
	mciStatusParms.dwItem = MCI_STATUS_MODE;

	dwResult = ::mciSendCommand(this->m_deviceid, MCI_STATUS, MCI_STATUS_ITEM,// | MCI_WAIT,
		(DWORD)(LPVOID)&mciStatusParms);

	bPlaying = (mciStatusParms.dwReturn == MCI_MODE_PLAY) ? TRUE : FALSE;

	::strcpy((LPSTR)this->AUDIO_ERROR_MSG, "CD Audio IsPlaying Error!");
	return ErrorMsg(dwResult);
}






/////////////////////////////////////////////////////////////////////////////
// CD ̳  ð Ѵ.
// CD ü ð а ʴ Ѵ.
DWORD CAudio::GetLength(BYTE& nMinutes, BYTE& nSeconds)
{
	DWORD					dwResult;
	MCI_STATUS_PARMS		mciStatusParms;
	mciStatusParms.dwItem = MCI_STATUS_LENGTH;

	dwResult = ::mciSendCommand(this->m_deviceid, MCI_STATUS, MCI_STATUS_ITEM,// | MCI_WAIT,
		(DWORD)(LPVOID)&mciStatusParms);

	nMinutes = MCI_MSF_MINUTE(mciStatusParms.dwReturn);
	nSeconds = MCI_MSF_SECOND(mciStatusParms.dwReturn);

	::strcpy((LPSTR)this->AUDIO_ERROR_MSG, "CD Audio GetLength Error!");
	return ErrorMsg(dwResult);
}





/////////////////////////////////////////////////////////////////////////////
// Ư Ʈ ̸ Ѵ.
DWORD CAudio::GetTrackLength(BYTE nTrack, BYTE& nMinutes, BYTE& nSeconds)
{
	DWORD					dwResult;
	MCI_STATUS_PARMS		mciStatusParms;

	mciStatusParms.dwItem = MCI_STATUS_LENGTH;
	mciStatusParms.dwTrack = nTrack;

	dwResult = ::mciSendCommand(this->m_deviceid, MCI_STATUS, MCI_STATUS_ITEM | MCI_TRACK,// | MCI_WAIT,
		(DWORD)(LPVOID)&mciStatusParms);

	nMinutes = MCI_MSF_MINUTE(mciStatusParms.dwReturn);
	nSeconds = MCI_MSF_SECOND(mciStatusParms.dwReturn);

	::strcpy((LPSTR)this->AUDIO_ERROR_MSG, "CD Audio GetTrackLength Error!");
	return ErrorMsg(dwResult);
}






/////////////////////////////////////////////////////////////////////////////
// CD  ġ ȮѴ.
DWORD CAudio::GetPosition(BYTE& nTrack, BYTE& nMinutes, BYTE& nSeconds)
{
	DWORD					dwResult;
	MCI_STATUS_PARMS		mciStatusParms;

	mciStatusParms.dwItem = MCI_STATUS_POSITION;

	dwResult = ::mciSendCommand(this->m_deviceid, MCI_STATUS, MCI_STATUS_ITEM,// | MCI_WAIT,
		(DWORD)(LPVOID)&mciStatusParms);

	nTrack = MCI_TMSF_TRACK(mciStatusParms.dwReturn);
	nMinutes = MCI_TMSF_MINUTE(mciStatusParms.dwReturn);
	nSeconds = MCI_TMSF_SECOND(mciStatusParms.dwReturn);

	::strcpy((LPSTR)this->AUDIO_ERROR_MSG, "CD Audio GetPosition Error!");
	return ErrorMsg(dwResult);
}





/////////////////////////////////////////////////////////////////////////////
//  Ʈȣ ´.
BYTE CAudio::GetCurrentTrack()
{
	return this->m_currenttrack.tracknum;
}



/////////////////////////////////////////////////////////////////////////////
//
void CAudio::SetCurrentTrack(BYTE TrackNumber)
{
	this->m_currenttrack.tracknum = TrackNumber;
}



/////////////////////////////////////////////////////////////////////////////
// Ʈ ϰų .(Ǫϰ ƴҰ찡 ִ)
void CAudio::OneStepTrackMove(DWORD dwId)
{
	switch(dwId)
	{
	case ID_ADD_TRACK:
		switch(this->m_looptotaltracks)
		{
		case FALSE:
			this->m_currenttrack.tracknum++;
			if(this->m_currenttrack.tracknum > this->m_totaltrack.totaltracknum)
			{
				this->m_currenttrack.tracknum = (BYTE)this->m_totaltrack.totaltracknum;
			}
			break;
		case TRUE:
			this->m_currenttrack.tracknum++;
			if(this->m_currenttrack.tracknum > this->m_totaltrack.totaltracknum)
			{
				this->m_currenttrack.tracknum = ID_START_TRACK;
			}
			break;
		}
		break;

	case ID_SUB_TRACK:
		switch(this->m_looptotaltracks)
		{
		case FALSE:
			this->m_currenttrack.tracknum--;
			if(this->m_currenttrack.tracknum < ID_START_TRACK)
			{
				this->m_currenttrack.tracknum = ID_START_TRACK;
			}
			break;
		case TRUE:
			this->m_currenttrack.tracknum--;
			if(this->m_currenttrack.tracknum < ID_START_TRACK)
			{
				this->m_currenttrack.tracknum = (BYTE)this->m_totaltrack.totaltracknum;
			}
			break;
		}
		break;
	}
}








