///////////////////////////////////////////////////////////////
//
// Direct Draw 16bit Color Control (CBull.cpp)
//
// 1998.12.18                                        Bull
//
///////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "CBullXX.h"

/////////////////////////////////////////
// ޼  
BOOL CBullXX::ErrorMsg()
{
	if (this->BX_ERROR_MSG[0] == NULL) ::strcpy((LPSTR)this->BX_ERROR_MSG, "Direct Draw Error!");

    UnInit();
    ::MessageBox( NULL, (LPSTR)this->BX_ERROR_MSG, "Class BullXX Message", MB_ICONINFORMATION|MB_OK );

	return FALSE;
}


/////////////////////////////////////////
//  
CBullXX::CBullXX()
{
}

/////////////////////////////////////////
// Ҹ 
CBullXX::~CBullXX()
{
}



/////////////////////////////////////////
// ʱȭ(Direct Draw Surface Create) 
// hwnd :  ڵ
//  w   :  ػ
//  h   :  ػ 
BOOL CBullXX::Init(HWND hwnd, int w, int h, int displaymode)
{
	this->m_dd				= NULL;
	this->m_primarysurface	= NULL;
	this->m_backsurface		= NULL;
	this->m_clipper			= NULL;

	this->m_hwnd			= hwnd;

	this->m_width			= w;
	this->m_height			= h;
	this->m_rgb_bitcount	= BX_RGB_BITCOUNT;

	this->m_displaymode		= displaymode;	

	this->m_primary			= NULL;
	this->m_back			= NULL;
	

	this->BX_ERROR_MSG[0]	= NULL;

	
	switch(this->m_displaymode)
	{
	case BX_FULLSCREEN_MODE:
		if(!CreateFullScreenMode())					// ü ȭ  (Full Screen Mode)
		{
			return FALSE;
		}
		break;
	case BX_WINDOWSCREEN_MODE:
		if(!CreateWindowMode())						// â ȭ  (Window Screen Mode)
		{
			return FALSE;
		}
		break;
	}


	return TRUE;
}




//////////////////////////////////////////
// ʱȭ  
void CBullXX::UnInit()
{
    if( this->m_dd != NULL )
    {
		switch(this->m_displaymode)
		{
		case BX_FULLSCREEN_MODE:
			if(this->m_backsurface != NULL)
			{
				this->m_backsurface->Release();
				this->m_backsurface = NULL;
			}
			break;
		}

		if(this->m_primarysurface != NULL)
		{
			this->m_primarysurface->Release();
			this->m_primarysurface = NULL;
		}

        this->m_dd->RestoreDisplayMode();

		this->m_dd->Release();
		this->m_dd = NULL;
    }
}





//////////////////////////////////////////
// Surface 
BOOL CBullXX::Restore()
{
	if(this->m_primarysurface != NULL && this->m_primarysurface->IsLost() != DD_OK)
	{
		if( FAILED(this->m_primarysurface->Restore()) )
		{
			::strcpy((LPSTR)this->BX_ERROR_MSG, "Direct Draw Restore Error! 2001");
			return ErrorMsg();
		}
	}

	if(this->m_backsurface != NULL && this->m_backsurface->IsLost() != DD_OK)
	{
		if( FAILED(this->m_backsurface->Restore()) )
		{
			::strcpy((LPSTR)this->BX_ERROR_MSG, "Direct Draw Restore Error! 2002");
			return ErrorMsg();
		}
	}

	return TRUE;
}









//////////////////////////////////////////
// ü ȭ  
BOOL CBullXX::CreateFullScreenMode()
{
	DDSCAPS2		ddscaps;
	LPDIRECTDRAW	lpdd;

	// DX Object Create
	if( FAILED(::DirectDrawCreate( NULL, &lpdd, NULL )) )
	{
		::strcpy((LPSTR)this->BX_ERROR_MSG, "Direct Draw Create Error!");
		return ErrorMsg();
	}

	// DX Object Interface Query
	if( FAILED(lpdd->QueryInterface(IID_IDirectDraw4, (LPVOID *)&this->m_dd)) )
	{
		::strcpy((LPSTR)this->BX_ERROR_MSG, "QueryInterface FAILED!");
		return ErrorMsg();
	}

	//   
	if( FAILED(this->m_dd->SetCooperativeLevel( this->m_hwnd, DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN )) )
	{
		::strcpy((LPSTR)this->BX_ERROR_MSG, "CoorperativeLevel mode Error!");
		return ErrorMsg();
	}

    // 16bit  
	if( FAILED(this->m_dd->SetDisplayMode( this->m_width, this->m_height, this->m_rgb_bitcount, 0, 0)) )
	{
		::strcpy((LPSTR)this->BX_ERROR_MSG, "Display Mode Error!");
		return ErrorMsg();
	}

    // , ĸ   
    ::ZeroMemory(&this->m_ddsd, sizeof(this->m_ddsd));
	this->m_ddsd.dwSize				= sizeof( this->m_ddsd );
    this->m_ddsd.dwFlags			= DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
    this->m_ddsd.ddsCaps.dwCaps		= DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX;
    this->m_ddsd.dwBackBufferCount	= 1;
    
	if( FAILED(this->m_dd->CreateSurface(&this->m_ddsd, &this->m_primarysurface, NULL)) )
	{
		::strcpy((LPSTR)this->BX_ERROR_MSG, "Create PrimarySurface Error!");
		return ErrorMsg();
	}

    ddscaps.dwCaps = DDSCAPS_BACKBUFFER;			 // ĸ
	if( FAILED(this->m_primarysurface->GetAttachedSurface(&ddscaps, &this->m_backsurface)) )
	{
		::strcpy((LPSTR)this->BX_ERROR_MSG, "BackSurface Create Error!");
		return ErrorMsg();
	}

	lpdd->Release();

	return TRUE;
}





//////////////////////////////////////////
// â ȭ  
BOOL CBullXX::CreateWindowMode()
{
	LPDIRECTDRAW	lpdd;

	// DX Object Create
	if( FAILED(::DirectDrawCreate( NULL, &lpdd, NULL )) )
	{
		::strcpy((LPSTR)this->BX_ERROR_MSG, "Direct Draw Create Error!");
		return ErrorMsg();
	}

	// DX Object Interface Query
	if( FAILED(lpdd->QueryInterface(IID_IDirectDraw4, (LPVOID *)&this->m_dd)) )
	{
		::strcpy((LPSTR)this->BX_ERROR_MSG, "QueryInterface FAILED!");
		return ErrorMsg();
	}

	if( FAILED(this->m_dd->SetCooperativeLevel(this->m_hwnd, DDSCL_NORMAL)) )
	{
		::strcpy((LPSTR)this->BX_ERROR_MSG, "CooperativeLevel mode Error!");
		return ErrorMsg();
	}

	//  
    ::ZeroMemory(&this->m_ddsd, sizeof(this->m_ddsd));
	this->m_ddsd.dwSize			= sizeof(this->m_ddsd);
	this->m_ddsd.dwFlags		= DDSD_CAPS;
	this->m_ddsd.ddsCaps.dwCaps	= DDSCAPS_PRIMARYSURFACE;

	if( FAILED(this->m_dd->CreateSurface(&this->m_ddsd, &this->m_primarysurface, NULL)) )
	{
		::strcpy((LPSTR)this->BX_ERROR_MSG, "Create PrimarySurface Error!");
		return ErrorMsg();
	}

	// ĸ 
    ::ZeroMemory(&this->m_ddsd, sizeof(this->m_ddsd));
	this->m_ddsd.dwSize			= sizeof( this->m_ddsd );
	this->m_ddsd.dwFlags		= DDSD_CAPS | DDSD_WIDTH | DDSD_HEIGHT;
	this->m_ddsd.ddsCaps.dwCaps	= DDSCAPS_OFFSCREENPLAIN;
	this->m_ddsd.dwWidth		= this->m_width;
	this->m_ddsd.dwHeight		= this->m_height;

	if( FAILED(this->m_dd->CreateSurface(&this->m_ddsd, &this->m_backsurface, NULL)) )
	{
		::strcpy((LPSTR)this->BX_ERROR_MSG, "Create BackSurface Error!");
		return ErrorMsg();
	}


	// Create the window clipper
	if( FAILED(this->m_dd->CreateClipper(0, &this->m_clipper, NULL)) )
	{
		::strcpy((LPSTR)this->BX_ERROR_MSG, "Clipper Create Error!");
		return ErrorMsg();
	}

	if( FAILED(this->m_clipper->SetHWnd(0, this->m_hwnd)) )
	{
		::strcpy((LPSTR)this->BX_ERROR_MSG, "Clipper Setting Error! - Window -");
		return ErrorMsg();
	}

	if( FAILED(this->m_primarysurface->SetClipper(this->m_clipper)) )
	{
		::strcpy((LPSTR)this->BX_ERROR_MSG, "Clipper Setting Error! - Primary Surface -");
		return ErrorMsg();
	}

	lpdd->Release();
	this->m_clipper->Release();
	this->m_clipper = NULL;



	return TRUE;
}





//////////////////////////////////////////
// Back Surface Memory Lock
HRESULT CBullXX::Lock()
{
	HRESULT hr;

	::ZeroMemory(&this->m_ddsd, sizeof(this->m_ddsd));
	this->m_ddsd.dwSize	= sizeof(this->m_ddsd);

	hr = this->m_backsurface->Lock(NULL, &this->m_ddsd, DDLOCK_WAIT, NULL);
	if( hr != DD_OK ) 
	{
		::strcpy((LPSTR)this->BX_ERROR_MSG, "Direct Draw Lock Error!");
		ErrorMsg();
		return hr;
	}

	this->m_back = (WORD*)this->m_ddsd.lpSurface;

	return hr;
}



//////////////////////////////////////////
// Back Surface Memory UnLock
HRESULT CBullXX::UnLock()
{
	return this->m_backsurface->Unlock(NULL);
}





//////////////////////////////////////////
// Surface Flip
BOOL CBullXX::Flip()
{
	switch(this->m_displaymode)
	{
	case BX_FULLSCREEN_MODE:
		if( FAILED(this->m_primarysurface->Flip(NULL, DDFLIP_WAIT)) )
		{
			if( FAILED(Restore()) )
			{
				::strcpy((LPSTR)this->BX_ERROR_MSG, "Direct Draw Flipping Error!");
				return ErrorMsg();
			}			
		}
		break;

	case BX_WINDOWSCREEN_MODE:
		RECT	srcrect;
		RECT	destrect;
		POINT	pt;
		pt.x	= 0;
		pt.y	= 0;

		::GetClientRect(this->m_hwnd, &srcrect);
		::GetClientRect(this->m_hwnd, &destrect);
		::ClientToScreen(this->m_hwnd, &pt);
		::OffsetRect(&destrect, pt.x, pt.y);

		if( FAILED(this->m_primarysurface->Blt(&destrect, this->m_backsurface, &srcrect, DDBLT_WAIT, NULL)) )
		{
			if( FAILED(Restore()) )
			{
				::strcpy((LPSTR)this->BX_ERROR_MSG, "Direct Draw Flipping Error!");
				return ErrorMsg();
			}			
		}
		break;
	}

	return TRUE;
}





//////////////////////////////////////////
// ̷Ʈ ο Ʈ  
LPDIRECTDRAW4 CBullXX::GetDirectDraw()
{
	return (LPDIRECTDRAW4)this->m_dd;
}


//////////////////////////////////////////
// ĸ   
LPDIRECTDRAWSURFACE4 CBullXX::GetBackSurface()
{
	return (LPDIRECTDRAWSURFACE4)this->m_backsurface;
}



////////////////////////////////////////////////
//  ȭ  
int	CBullXX::GetDisplayMode()
{
	return (int)this->m_displaymode;
}



////////////////////////////////////////////////
// ȭ    
int	CBullXX::GetWidth()
{
	return (int)this->m_width;
}



////////////////////////////////////////////////
// ȭ    
int	CBullXX::GetHeight()
{
	return (int)this->m_height;
}





//////////////////////////////////////////
// Surface Clear
BOOL CBullXX::ClearSurface(WORD rgb)
{
	DDBLTFX		ddbltfx;

	ddbltfx.dwSize = sizeof(DDBLTFX);
	ddbltfx.dwFillColor = rgb;

	if( FAILED(this->m_backsurface->Blt(NULL, NULL, NULL, DDBLT_COLORFILL | DDBLT_WAIT, &ddbltfx)) )
	{
		::strcpy((LPSTR)this->BX_ERROR_MSG, "Direct Draw ClearSurface Error!");
		return ErrorMsg();
	}

	return TRUE;
}




////////////////////////////////////////////////
// BackSurface ޸𸮿  (w:0 ~ 639, h:0 ~ 479)
// x : x ǥ 
// y : y ǥ 
WORD CBullXX::GetPixel(int x, int y)
{
	HRESULT hr;
	WORD	temp;
	int		pitch;

	if(x >= 0 && x < this->m_width && y >= 0 && y < this->m_height)
	{
		if( (hr = Lock()) != DD_OK) return 0;
		pitch = this->m_ddsd.lPitch/2;
		temp = (WORD)this->m_back[x + y * pitch];
		UnLock();

		return temp;
	}

	return 0;
}



////////////////////////////////////////////////
// ޸𸮿  (w:0 ~ 639, h:0 ~ 479) 
// x     : x ǥ 
// y     : y ǥ 
// color :  
void CBullXX::PutPixel(int x, int y, WORD color)
{
	HRESULT hr;
	int		pitch;

	if(x >= 0 && x < this->m_width && y >= 0 && y < this->m_height)
	{
		if( (hr = Lock()) != DD_OK ) return;
		pitch = this->m_ddsd.lPitch/2;
		this->m_back[x + y * pitch] = color;
		UnLock();
	}
}

////////////////////////////////////////////////
// ȭ鿡 ä ڽ ׸. 
void CBullXX::FillBox(int sx, int sy, int ex, int ey, WORD rgb)
{
	DDBLTFX ddbltfx;
	RECT	rect;

	if(sx <					0) sx = 0;
	if(sy <					0) sy = 0;
	if(ex >		this->m_width) ex = this->m_width;
	if(ey >	   this->m_height) ey = this->m_height;

	SetRect(&rect, sx, sy, ex, ey);
	ddbltfx.dwSize		= sizeof(DDBLTFX);
	ddbltfx.dwFillColor = rgb;

	this->m_backsurface->Blt(&rect, NULL, NULL, DDBLT_WAIT | DDBLT_COLORFILL, &ddbltfx);
}

////////////////////////////////////////////////
//  ׸ 
void CBullXX::Box(int sx, int sy, int ex, int ey, WORD rgb)
{
	WLine(sx, sy, ex-sx, rgb);
	WLine(sx, ey, ex-sx, rgb);

	HLine(ex, sy, ey-sy, rgb);
	HLine(sx, sy, ey-sy, rgb);
}

////////////////////////////////////////////////
//   ׸ 
void CBullXX::HLine(int sx, int sy, int depth, WORD rgb)
{
	FillBox(sx, sy, sx+1, sy+1+depth, rgb);
}


////////////////////////////////////////////////
// μ ׸ 
void CBullXX::WLine(int sx, int sy, int depth, WORD rgb)
{
	FillBox(sx, sy, sx+1+depth, sy+1, rgb);
}








////////////////////////////////////////////////
// BltFast Back Surface ׸ .
// pt      : ̹  ǥ 
// surface : ̹  surface
// srcrect : ̹ 簢  
// mode    : ̹  
BOOL CBullXX::BltFast(POINT pt, LPDIRECTDRAWSURFACE4 surface, RECT srcrect, DWORD mode)
{
	// ȭ Ŭ ˻ 
	if(pt.x < 0) 
	{
		srcrect.left	-= pt.x;
		pt.x			= 0;
	}
	if(pt.y < 0) 
	{
		srcrect.top		-= pt.y;
		pt.y			= 0;
	}
	if(pt.x+srcrect.right > this->m_width-1)
	{
		srcrect.right	-= (pt.x+srcrect.right)-this->m_width;
	}
	if(pt.y+srcrect.bottom > this->m_height-1)
	{
		srcrect.bottom	-= (pt.y+srcrect.bottom)-this->m_height;
	}

	if( FAILED(this->m_backsurface->BltFast(pt.x, pt.y, surface, &srcrect, DDBLTFAST_WAIT | mode)) )
	{
		if( FAILED(Restore()) )
		{
			::strcpy((LPSTR)this->BX_ERROR_MSG, "Direct Draw BltFast Error!");
			return ErrorMsg();
		}
	}

	return TRUE;
}



////////////////////////////////////////////////
// Blt Back Surface ׸ .
// pt       : ̹  ǥ 
// surface  : ̹  surface
// destrect :  ̹ 簢  
// srcrect  :  ̹ 簢  
// mode     : ̹  
BOOL CBullXX::Blt(POINT pt, LPDIRECTDRAWSURFACE4 surface, RECT srcrect, DWORD mode)
{
	RECT		destrect;

	destrect.top		= pt.y;
	destrect.left		= pt.x;
	destrect.bottom		= pt.y + srcrect.bottom;
	destrect.right		= pt.x + srcrect.right;

	// ȭ Ŭ ˻ 
	if(pt.x < 0) 
	{
		srcrect.left	-= pt.x;
		destrect.left	-= pt.x;
	}
	if(pt.y < 0) 
	{
		srcrect.top		-= pt.y;
		destrect.top	-= pt.y;
	}
	if(pt.x+srcrect.right > this->m_width-1)
	{
		srcrect.right	-= (pt.x+srcrect.right)-this->m_width;
		destrect.right	= pt.x + srcrect.right;
	}
	if(pt.y+srcrect.bottom > this->m_height-1)
	{
 		srcrect.bottom	-= (pt.y+srcrect.bottom)-this->m_height;
		destrect.bottom	= pt.y + srcrect.bottom;
	}

	if( FAILED(this->m_backsurface->Blt(&destrect, surface, &srcrect, DDBLT_WAIT | mode , NULL)) )
	{
		if( FAILED(Restore()) )
		{
			::strcpy((LPSTR)this->BX_ERROR_MSG, "Direct Draw Blt Error!");
			return ErrorMsg();
		}
	}

	return TRUE;
}


















