///////////////////////////////////////////////////////////////
//
// Direct Draw 16bit Color Control (CBullXX.h)
//
// 1998.12.18                                        Bull
//
//  : 1999.4.20
//
///////////////////////////////////////////////////////////////

#ifndef _CBULLXX_HEADER
#define _CBULLXX_HEADER

#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <stdlib.h>
#include <mmsystem.h>

#include <ddraw.h>


#define BX_FULLSCREEN_MODE		0x0F								// ü ȭ  
#define BX_WINDOWSCREEN_MODE	0xFF								// â ȭ  
	
#define BX_PRIMARY_SURFACE		0x00								//   
#define BX_BACK_SURFACE			0x02								// ĸ  


#define BX_RGB_BITCOUNT			16									// RGB Bit Count




// Ŭ
class CBullXX
{	
protected:	//  
    LPDIRECTDRAW4 			m_dd;									// DX Object
    LPDIRECTDRAWSURFACE4	m_primarysurface;						// Primary Surface
    LPDIRECTDRAWSURFACE4 	m_backsurface;							// Back Surface
	DDSURFACEDESC2			m_ddsd;
	LPDIRECTDRAWCLIPPER		m_clipper;

	HWND					m_hwnd;

	int						m_displaymode;							// ȭ  

	int						m_width;								//  
	int						m_height;								//   
	
	WORD*					m_primary;								//  ޸ ( ޸ ÿ Lock() ϰ, 
	WORD*					m_back;									// ĸ ޸    ÿ UnLock() ش. )


	int						m_rgb_bitcount;							// RGB Bit Count


	LPSTR					BX_ERROR_MSG[80];						//  ޼  


public:		//  



protected:	// Լ
	BOOL	ErrorMsg();												// ޼  

	BOOL	CreateFullScreenMode();									// ü ȭ  
	BOOL	CreateWindowMode();										// â ȭ  

	HRESULT Lock();													// Memory Lock...
	HRESULT UnLock();												// Memory UnLock...



public:		// Լ 
	CBullXX();														//  
	~CBullXX();														// Ҹ 

	BOOL	Init(HWND, int w, int h, int displaymode);				// ʱȭ 
	void 	UnInit();												//  

	BOOL	Restore();												// Surface   
	BOOL	Flip();													// ȭ ȯ(BackSurface <--> PrimarySurface) 

	BOOL	ClearSurface(WORD rgb = 0);								// Surface Clear...

	LPDIRECTDRAW4 GetDirectDraw();									// ٷƮ ο Ʈ  
	LPDIRECTDRAWSURFACE4 GetBackSurface();							// ĸ  
	int		GetDisplayMode();										//  ȭ  (ü Ǵ â )
	int		GetWidth();												// ȭ    
	int		GetHeight();											// ȭ    

	BOOL	BltFast(POINT, LPDIRECTDRAWSURFACE4, RECT, DWORD);		// BltFast Back Surface ׸ .
	BOOL	Blt(POINT, LPDIRECTDRAWSURFACE4, RECT, DWORD);			// Blt Back Surface ׸ .

	void	PutPixel(int x, int y, WORD color);						//   
	WORD	GetPixel(int x, int y);									//   

	void	FillBox(int sx, int sy, int ex, int ey, WORD rgb);		// ĥ  ׸ 
	void	Box(int sx, int sy, int ex, int ey, WORD rgb);			//  ׸
	void	HLine(int sx, int sy, int depth, WORD rgb);				//   ׸
	void	WLine(int sx, int sy, int depth, WORD rgb);				//   ׸ 

};










#endif






