///////////////////////////////////////////////////////////////
//
// Direct Input Class (CInput.cpp)
//
// 1999.4.15                                        
//
///////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "CInput.h"

static LPDIRECTINPUT			g_directinput;
static LPDIRECTINPUTDEVICE2		g_joystickdevice;	

BOOL CALLBACK			DIEnumDevicesProc(LPCDIDEVICEINSTANCE, LPVOID);	




///////////////////////////////////////////////////////////////
//  ޼  
BOOL CInput::ErrorMsg()
{
	if (this->INPUT_ERROR_MSG[0] == NULL) ::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Error!");

    ::MessageBox( NULL, (LPSTR)this->INPUT_ERROR_MSG, "Class Input Message", MB_ICONINFORMATION|MB_OK );

	return FALSE;
}




///////////////////////////////////////////////////////////////
// 
CInput::CInput()
{
	this->m_di					= NULL;

	// 콺
	this->m_did2mouse			= NULL;
	this->m_doubleclicktime		= 0;
	this->m_lastclicktime		= 0;
    this->m_itemnum				= 0;	 
	this->m_lbutton_down		= FALSE;
	this->m_lbutton_up			= FALSE;
	this->m_rbutton_down		= FALSE;
	this->m_rbutton_up			= FALSE;
	this->m_button_doubleclick	= FALSE;
	this->m_mouse_x				= FALSE;
	this->m_mouse_y				= FALSE;
	this->m_mouse_z				= FALSE;
	this->m_mouse_xdata			= 0;
	this->m_mouse_ydata			= 0;
	this->m_mouse_zdata			= 0;

	// Ű
	this->m_did2key				= NULL;

	// ̽ƽ
	this->m_did2joy				= NULL;

	g_directinput				= NULL;
	g_joystickdevice			= NULL;

	for(int i=0; i<32; i++)
	{
		this->m_joybutton[i]	= FALSE;
	}	
	this->m_joy_rx				= FALSE;
	this->m_joy_ry				= FALSE;
	this->m_joy_rz				= FALSE;
	this->m_joy_lx				= FALSE;
	this->m_joy_ly				= FALSE;
	this->m_joy_lz				= FALSE;
}




///////////////////////////////////////////////////////////////
// Ҹ
CInput::~CInput()
{
}




///////////////////////////////////////////////////////////////
// ʱȭ 
BOOL CInput::Init(HINSTANCE hinstance)
{
	// Direct Input Create
    if ( FAILED(DirectInputCreate( hinstance, DIRECTINPUT_VERSION, &this->m_di, NULL )) )
    {
		::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Create Error!");
		return ErrorMsg();
    }


    return TRUE;    
}




///////////////////////////////////////////////////////////////
// 
void CInput::UnInit()
{
    if(this->m_di != NULL)
    { 
        this->m_di->Release();
        this->m_di	= NULL;
    }
}



///////////////////////////////////////////////////////////////
// Direct Input Create Device2
LPDIRECTINPUTDEVICE2 CInput::CreateDevice2( LPDIRECTINPUT lpdi, GUID* pguid )
{
    HRESULT hr, hr2;
  
    LPDIRECTINPUTDEVICE  lpdid1;  // Temporary.
    LPDIRECTINPUTDEVICE2 lpdid2;  // The keeper.

    hr = lpdi->CreateDevice( *pguid, &lpdid1, NULL );
 
    if ( SUCCEEDED( hr ) )
    { 
        hr2 = lpdid1->QueryInterface( IID_IDirectInputDevice2, ( void ** )&lpdid2 ); 
        lpdid1->Release();
    } 
    else
    {
        OutputDebugString("Could not create IDirectInputDevice device" );
        return NULL;
    } 
    if ( FAILED( hr2 ) )
    {
        OutputDebugString("Could not create IDirectInputDevice2 device" );
        return NULL;
    }

    return lpdid2;
}  // CreateDevice2













///////////////////////////////////////////////////////////////
// Direct Input Mouse Device Init
///////////////////////////////////////////////////////////////
BOOL CInput::InitMouseDevice(HWND hwnd)
{
    DIDEVICEINSTANCE    diDeviceInstance;

    // ġ (Ŭ)
	UnInitMouseDevice();

    // Device2 Interface
    this->m_did2mouse = CreateDevice2( this->m_di, (GUID*)&GUID_SysMouse );
    if ( !this->m_did2mouse ) 
	{
		::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Mouse Device Error! 2001" );
		return ErrorMsg();
	}

    // Find out what type it is and set data format accordingly.
    diDeviceInstance.dwSize	= sizeof(DIDEVICEINSTANCE);
    this->m_did2mouse->GetDeviceInfo(&diDeviceInstance);

    switch ( GET_DIDEVICE_TYPE(diDeviceInstance.dwDevType) )
    {
        case DIDEVTYPE_MOUSE:
            if( FAILED(this->m_did2mouse->SetDataFormat(&c_dfDIMouse)) )
			{
				::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Mouse Device Error! 2002" );
				return ErrorMsg();
			}
            break;
        case DIDEVTYPE_KEYBOARD:
        case DIDEVTYPE_JOYSTICK:
        default: 
			::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Mouse Device Error! 2003" );
			return ErrorMsg();
    }


	//  
    if ( FAILED(this->m_did2mouse->SetCooperativeLevel(hwnd, DISCL_EXCLUSIVE | DISCL_FOREGROUND)) )
    {
		UnInitMouseDevice();

		::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Mouse Device Error! 2004" );
		ErrorMsg();
        return DIENUM_STOP;
    }

    // Set up the data buffer.
    DIPROPDWORD dipdw =
    {
        // The header.
        {
            sizeof( DIPROPDWORD ),      // diph.dwSize
            sizeof( DIPROPHEADER ),     // diph.dwHeaderSize
            0,                          // diph.dwObj
            DIPH_DEVICE,                // diph.dwHow
        },
        // Number of elements in data buffer.
        BUFFERSIZE,              // dwData
    };

    if( FAILED(this->m_did2mouse->SetProperty( DIPROP_BUFFERSIZE, &dipdw.diph )) )
	{
		UnInitMouseDevice();

		::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Mouse Device Error! 2005" );
		return ErrorMsg();
	}

    return TRUE;
}




///////////////////////////////////////////////////////////////
// Direct Input Mouse Device UnInit
void CInput::UnInitMouseDevice()
{
    if (this->m_did2mouse) 
    {
		SetMouseAcquire(FALSE);
        this->m_did2mouse->Release();
		this->m_did2mouse	= NULL;
    }
}





//////////////////////////////////////////////////////////////
// Acquire Setting
BOOL CInput::SetMouseAcquire(BOOL acq)
{
	if( this->m_did2mouse == NULL) return FALSE;

    if(acq)  
    {
		if( FAILED(this->m_did2mouse->Acquire()) )
		{
			::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Mouse SetMouseAcquire Error! 2001" );
			return ErrorMsg();
		}
    }
    else
    {
		if( FAILED(this->m_did2mouse->Unacquire()) )
		{
			::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Mouse SetMouseAcquire Error! 2002" );
			return ErrorMsg();
		}
    }

    this->m_doubleclicktime = GetDoubleClickTime();


    return TRUE;
} 






///////////////////////////////////////////////////////////////
// Mouse Event
BOOL CInput::PollMouse()
{
	HRESULT		hr;

    if(!this->m_did2mouse)
	{
//		::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Mouse Poll Error! 2001" );
//		return ErrorMsg();
		return FALSE;
	}

loop:
    this->m_did2mouse->Poll();		

    this->m_itemnum = BUFFERSIZE;

    hr = this->m_did2mouse->GetDeviceData( sizeof( DIDEVICEOBJECTDATA ), 
											this->m_mouse,			// Where to put data?
											&this->m_itemnum,		// How many items?
											0 );					// Flags.

    // If data stream was interrupted, reacquire the device and try again.
    if ( hr == DIERR_INPUTLOST )
    {
        if ( SetMouseAcquire(TRUE) )
            goto loop;
    }
                                                                                                                                                                                                                                                       
    // We can't get the device. Quit.
    if ( hr == DIERR_NOTACQUIRED )
    {
        if ( SetMouseAcquire(TRUE) )
            goto loop;
    }


	// ʱȭ
	this->m_lbutton_down		= FALSE;
	this->m_lbutton_up			= FALSE;
	this->m_rbutton_down		= FALSE;
	this->m_rbutton_up			= FALSE;
	this->m_button_doubleclick	= FALSE;
	this->m_mouse_x				= FALSE;
	this->m_mouse_y				= FALSE;
	this->m_mouse_z				= FALSE;
	this->m_mouse_xdata			= 0;
	this->m_mouse_ydata			= 0;
	this->m_mouse_zdata			= 0;


    // We got buffered input; act on it.
    if( SUCCEEDED(hr) )
    {
        for ( DWORD d=0; d<this->m_itemnum; d++ )
        {
			switch(this->m_mouse[d].dwOfs)
			{
			case DIMOFS_BUTTON0:
				if ( this->m_mouse[d].dwData & 0x80 )		// If button down.
	            {
/*
	                if ( ( this->m_mouse[d].dwTimeStamp - this->m_lastclicktime ) <= this->m_doubleclicktime )
	                {
						this->m_button_doubleclick = TRUE;
	                }
	                else
	                {
*/						this->m_lbutton_down = TRUE;
//	                }
//	                this->m_lastclicktime = this->m_mouse[d].dwTimeStamp;
	            }             
	            else										// Button up.
	            {
					this->m_lbutton_up = TRUE;
	            } 
				break;
			case DIMOFS_BUTTON1:
				if ( this->m_mouse[d].dwData & 0x80 )		// If button down.
	            {
					this->m_rbutton_down = TRUE;
	            }             
	            else										// Button up.
	            {
					this->m_rbutton_up = TRUE;
	            } 
				break;
			case DIMOFS_BUTTON2:
				break;
			case DIMOFS_BUTTON3:
				break;

			case DIMOFS_X:
				this->m_mouse_x		= TRUE;
				this->m_mouse_xdata	= this->m_mouse[d].dwData;
				break;
			case DIMOFS_Y:
				this->m_mouse_y		= TRUE;
				this->m_mouse_ydata	= this->m_mouse[d].dwData;
				break;
			case DIMOFS_Z:
				this->m_mouse_z		= TRUE;
				this->m_mouse_zdata	= this->m_mouse[d].dwData;
				break;
			}

        }  // Done looping through events.
	}


	return TRUE;
}














///////////////////////////////////////////////////////////////
// Direct Input Key Device Init
///////////////////////////////////////////////////////////////
BOOL CInput::InitKeyDevice(HWND hwnd)
{
    DIDEVICEINSTANCE    diDeviceInstance;

    // ġ (Ŭ)
	UnInitKeyDevice();

    // Device2 Interface
    this->m_did2key = CreateDevice2( this->m_di, (GUID*)&GUID_SysKeyboard );
    if ( !this->m_did2key ) 
	{
		::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Key Device Error! 2001" );
		return ErrorMsg();
	}

    // Find out what type it is and set data format accordingly.
    diDeviceInstance.dwSize	= sizeof(DIDEVICEINSTANCE);
    this->m_did2key->GetDeviceInfo(&diDeviceInstance);

    switch ( GET_DIDEVICE_TYPE(diDeviceInstance.dwDevType) )
    {
        case DIDEVTYPE_KEYBOARD:
            if( FAILED(this->m_did2key->SetDataFormat(&c_dfDIKeyboard)) )
			{
				::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Key Device Error! 2002" );
				return ErrorMsg();
			}
            break;
        case DIDEVTYPE_MOUSE:
        case DIDEVTYPE_JOYSTICK:
        default: 
			::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Key Device Error! 2003" );
			return ErrorMsg();
    }


	//  
    if ( FAILED(this->m_did2key->SetCooperativeLevel(hwnd, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND)) )
    {
		UnInitKeyDevice();
		::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Key Device Error! 2004" );
		ErrorMsg();
        return DIENUM_STOP;
    }


    // Set up the data buffer.
    DIPROPDWORD dipdw =
    {
        // The header.
        {
            sizeof( DIPROPDWORD ),      // diph.dwSize
            sizeof( DIPROPHEADER ),     // diph.dwHeaderSize
            0,                          // diph.dwObj
            DIPH_DEVICE,                // diph.dwHow
        },
        // Number of elements in data buffer.
        BUFFERSIZE,              // dwData
    };


    if( FAILED(this->m_did2key->SetProperty( DIPROP_BUFFERSIZE, &dipdw.diph )) )
	{
		UnInitKeyDevice();
		::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Key Device Error! 2005" );
		return ErrorMsg();
	}

    return TRUE;
}





///////////////////////////////////////////////////////////////
// Direct Input Key Device UnInit
void CInput::UnInitKeyDevice()
{
    if (this->m_did2key) 
    {
		SetKeyAcquire(FALSE);
        this->m_did2key->Release();
		this->m_did2key	= NULL;
    }
}





///////////////////////////////////////////////////////////////
// Acquire Setting
BOOL CInput::SetKeyAcquire(BOOL acq)
{
	if( this->m_did2key == NULL) return FALSE;

    if(acq)  
    {
        if( FAILED(this->m_did2key->Acquire()) )
		{
			::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Key SetKeyAcquire Error! 2001" );
			return ErrorMsg();
		}
    }
    else
    {
       	if( FAILED(this->m_did2key->Unacquire()) )
		{
			::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Key SetKeyAcquire Error! 2002" );
			return ErrorMsg();
		}
    }


    return TRUE;
} 







///////////////////////////////////////////////////////////////
// Key Event
BOOL CInput::PollKey()
{
	HRESULT		hr;

    if(!this->m_did2key)
	{
//		::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Key Poll Error! 2001" );
//		return ErrorMsg();
		return FALSE;
	}

loop:
    this->m_did2key->Poll();		

    hr = this->m_did2key->GetDeviceState( sizeof( this->m_key ), this->m_key );  

    // If data stream was interrupted, reacquire the device and try again.
    if ( hr == DIERR_INPUTLOST )
    {
        if ( SetKeyAcquire(TRUE) )
            goto loop;
    }
                                                                                                                                                                                                                                                       
    // We can't get the device. Quit.
    if ( hr == DIERR_NOTACQUIRED )
    {
        if ( SetKeyAcquire(TRUE) )
            goto loop;
    }



	return TRUE;
}



///////////////////////////////////////////////////////////////
// Key Down
BOOL CInput::KeyDown(DWORD key)
{
	if( this->m_key[key] & 0x80 )
	{
		return TRUE;
	}

	return FALSE;
}














///////////////////////////////////////////////////////////////
// Direct Input Joystick Device Init
///////////////////////////////////////////////////////////////
BOOL CInput::InitJoyDevice(HWND hwnd)
{
    DIDEVICEINSTANCE    diDeviceInstance;

    // ġ (Ŭ)
	UnInitJoyDevice();

	// ̷Ʈ ǲ Ʈ  Ѱش.()
	g_directinput = this->m_di;

    if( FAILED(this->m_di->EnumDevices(DIDEVTYPE_JOYSTICK, DIEnumDevicesProc, NULL, DIEDFL_ATTACHEDONLY)) )
	{
		UnInitJoyDevice();
		::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Joystick Device Error! 2001" );
		return ErrorMsg();
	}

	if(!g_joystickdevice)
	{
		UnInitJoyDevice();
		::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Joystick Device Error! 2002" );
		return ErrorMsg();
	}

	//  ̽ƽ ġ Ŭ ġ Ѱش.()
	this->m_did2joy = g_joystickdevice;

    // Find out what type it is and set data format accordingly.
    diDeviceInstance.dwSize	= sizeof(DIDEVICEINSTANCE);
    this->m_did2joy->GetDeviceInfo(&diDeviceInstance);

    switch ( GET_DIDEVICE_TYPE(diDeviceInstance.dwDevType) )
    {
        case DIDEVTYPE_JOYSTICK:
            if( FAILED(this->m_did2joy->SetDataFormat(&c_dfDIJoystick)) )
			{
				UnInitJoyDevice();
				::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Joystick Device Error! 2003" );
				return ErrorMsg();
			}
            break;
        case DIDEVTYPE_MOUSE:
        case DIDEVTYPE_KEYBOARD:
        default: 
			::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Joystick Device Error! 2004" );
			return ErrorMsg();
    }


	//  
    if ( FAILED(this->m_did2joy->SetCooperativeLevel(hwnd, DISCL_EXCLUSIVE | DISCL_FOREGROUND)) )
    {
		UnInitJoyDevice();
		::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Joystick Device Error! 2005" );
		ErrorMsg();
        return DIENUM_STOP;
    }

    // Set up the data buffer.
    DIPROPDWORD dipdw =
    {
        // The header.
        {
            sizeof( DIPROPDWORD ),      // diph.dwSize
            sizeof( DIPROPHEADER ),     // diph.dwHeaderSize
            0,                          // diph.dwObj
            DIPH_DEVICE,                // diph.dwHow
        },
        // Number of elements in data buffer.
        BUFFERSIZE,              // dwData
    };

    if( FAILED(this->m_did2joy->SetProperty( DIPROP_BUFFERSIZE, &dipdw.diph )) )
	{
		UnInitJoyDevice();
		::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Joystick Device Error! 2006" );
		return ErrorMsg();
	}



    DIPROPRANGE diprg; 
    diprg.diph.dwSize       = sizeof( diprg ); 
    diprg.diph.dwHeaderSize = sizeof( diprg.diph ); 
    diprg.diph.dwObj        = 0; 
    diprg.diph.dwHow        = DIPH_DEVICE; 
    diprg.lMin              = -1000; 
    diprg.lMax              = 1000; 
 
    if ( FAILED( this->m_did2joy->SetProperty( DIPROP_RANGE, &diprg.diph ) ) )
	{
		UnInitJoyDevice();
		::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Joystick Device Error! 2007" );
		return ErrorMsg();
	}

    // Set deadzone.
    DIPROPDWORD dipdz;
    dipdz.diph.dwSize       = sizeof( dipdz ); 
    dipdz.diph.dwHeaderSize = sizeof( dipdz.diph ); 
    dipdz.diph.dwObj        = 0;
    dipdz.diph.dwHow        = DIPH_DEVICE;
    dipdz.dwData            = 3000;

    if ( FAILED( this->m_did2joy->SetProperty( DIPROP_DEADZONE, &dipdz.diph ) ) )
	{
		UnInitJoyDevice();
		::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Joystick Device Error! 2008" );
		return ErrorMsg();
	}

    // Set saturation.
    dipdz.dwData            = 2000;
    if ( FAILED( this->m_did2joy->SetProperty( DIPROP_SATURATION, &dipdz.diph ) ) )
	{
		UnInitJoyDevice();
		::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Joystick Device Error! 2009" );
		return ErrorMsg();
	}


    return TRUE;
}




///////////////////////////////////////////////////////////////
// Direct Input Joystick Device UnInit
void CInput::UnInitJoyDevice()
{
    if(this->m_did2joy) 
    {
		SetJoyAcquire(FALSE);
        this->m_did2joy->Release();
		this->m_did2joy	= NULL;
    }
}





//////////////////////////////////////////////////////////////
// Acquire Setting
BOOL CInput::SetJoyAcquire(BOOL acq)
{
	if( this->m_did2joy == NULL) return FALSE;

    if(acq)  
    {
		if( FAILED(this->m_did2joy->Acquire()) )
		{
			::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Joystick SetJoyAcquire Error! 2001" );
			return ErrorMsg();
		}
    }
    else
    {
		if( FAILED(this->m_did2joy->Unacquire()) )
		{
			::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Joystick SetJoyAcquire Error! 2002" );
			return ErrorMsg();
		}
    }


    return TRUE;
} 





///////////////////////////////////////////////////////////////
// Key Event
BOOL CInput::PollJoy()
{
	HRESULT		hr;

    if(!this->m_did2joy)
	{
//		::strcpy((LPSTR)this->INPUT_ERROR_MSG, "Direct Input Joystick Poll Error! 2001" );
//		return ErrorMsg();
		return FALSE;
	}

loop:
    this->m_did2joy->Poll();		

    hr = this->m_did2joy->GetDeviceState( sizeof(DIJOYSTATE), &this->m_joy ); 

    // If data stream was interrupted, reacquire the device and try again.
    if ( hr == DIERR_INPUTLOST )
    {
        if ( SetJoyAcquire(TRUE) )
            goto loop;
    }
                                                                                                                                                                                                                                                       
    // We can't get the device. Quit.
    if ( hr == DIERR_NOTACQUIRED )
    {
        if ( SetJoyAcquire(TRUE) )
            goto loop;
    }

	//  ʱȭ 
	this->m_joy_rx				= FALSE;
	this->m_joy_ry				= FALSE;
	this->m_joy_rz				= FALSE;
	this->m_joy_lx				= FALSE;
	this->m_joy_ly				= FALSE;
	this->m_joy_lz				= FALSE;

	// ̽ƽ ġ 
	if(this->m_joy.lX > 0) this->m_joy_rx = TRUE;
	if(this->m_joy.lY > 0) this->m_joy_ry = TRUE;
	if(this->m_joy.lZ > 0) this->m_joy_rz = TRUE;
	if(this->m_joy.lX < 0) this->m_joy_lx = TRUE;
	if(this->m_joy.lY < 0) this->m_joy_ly = TRUE;
	if(this->m_joy.lZ < 0) this->m_joy_lz = TRUE;

	// ̽ƽ ư 
    for (int i = 0; i < 32; i++)
    {
		this->m_joybutton[i] = FALSE;

        if ( this->m_joy.rgbButtons[i] & 0x80 )
        {
            this->m_joybutton[i] = TRUE;
        }
    }


	return TRUE;
}






///////////////////////////////////////////////////////////////
// ̽ƽ ġ 
BOOL CALLBACK DIEnumDevicesProc( LPCDIDEVICEINSTANCE lpddi, LPVOID pvRef )
{
    HRESULT hr, hr2;
  
    LPDIRECTINPUTDEVICE  lpdid1;  // Temporary.

    hr = g_directinput->CreateDevice( lpddi->guidInstance, &lpdid1, NULL );

    if ( SUCCEEDED( hr ) )
    { 
        hr2 = lpdid1->QueryInterface( IID_IDirectInputDevice2, ( void ** )&g_joystickdevice ); 
        lpdid1->Release();
    } 
    else
    {
        OutputDebugString("Could not create IDirectInputDevice device" );
        return NULL;
    } 
    if ( FAILED( hr2 ) )
    {
        OutputDebugString("Could not create IDirectInputDevice2 device" );
        return NULL;
    }


    return DIENUM_STOP;   
}








