///////////////////////////////////////////////////////////////
//
// Midi Class (CMidi.cpp)
//
// 1999.5.2                                        
//
///////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "CMidi.h"


/////////////////////////////////////////////////////////////////////////////
//  ߻ߴٸ MCI  ϴ ڿ ޽ ڿѴ.
DWORD CMidi::ErrorMsg()
{
	if(this->MIDI_ERROR_MSG[0] == NULL) ::strcpy((LPSTR)this->MIDI_ERROR_MSG, "Midi Error!");

    ::MessageBox( NULL, (LPSTR)this->MIDI_ERROR_MSG, "Class Midi Message", MB_ICONINFORMATION|MB_OK );

	return FALSE;
}



CMidi::CMidi()
{
	this->m_hwnd	= NULL;

	this->m_isload	= FALSE;
	this->m_isplay	= FALSE;
}


CMidi::~CMidi()
{
}



/////////////////////////////////////////////////////////
// ʱȭ 
BOOL CMidi::Init(HWND hwnd)
{
	this->m_hwnd	= hwnd;

	if(!this->m_hwnd)
	{
		return FALSE;
	}

	return TRUE;
}



/////////////////////////////////////////////////////////
// 
void CMidi::UnInit()
{
	if(this->m_isload)
	{
		Stop();
	}
}


//////////////////////////////////////////////////////////
// Play
BOOL CMidi::Play(LPCSTR	filename)
{
	char buffer[256];

	//  εǾ ִٸ Ų.
	if(this->m_isload)
	{
		Stop();
	}

	if(filename == NULL)
	{
		::strcpy((LPSTR)this->MIDI_ERROR_MSG, "Midi Play Error! 2001");
		return ErrorMsg();
	}

	sprintf(buffer, "open %s type sequencer alias Midi", filename);

	if(::mciSendString("close all", NULL, 0, NULL) != 0)
	{
		::strcpy((LPSTR)this->MIDI_ERROR_MSG, "Midi Play Error! 2002");
		return ErrorMsg();
	}

	if(::mciSendString(buffer, NULL, 0, NULL) != 0)
	{	
		::strcpy((LPSTR)this->MIDI_ERROR_MSG, "Midi Play Error! 2003");
		return ErrorMsg();
	}

	if(::mciSendString("play Midi from 0 notify", NULL, 0, this->m_hwnd) != 0)
	{
		::strcpy((LPSTR)this->MIDI_ERROR_MSG, "Midi Play Error! 2004");
		return ErrorMsg();
	}	

	this->m_isload	= TRUE;
	this->m_isplay	= TRUE;

	return TRUE;
}


//////////////////////////////////////////////////////////
// Stop
CMidi::Stop()
{
	if(!this->m_isplay) return TRUE;

	if(::mciSendString("close all", NULL, 0, NULL) != 0)
	{
		::strcpy((LPSTR)this->MIDI_ERROR_MSG, "Midi Stop Error!");
		return ErrorMsg();
	}   

	this->m_isload	= FALSE;
	this->m_isplay	= FALSE;

	return TRUE;
}

//////////////////////////////////////////////////////////
// Pause
BOOL CMidi::Pause()
{
	if(!this->m_isload || !this->m_isplay) return TRUE;

	// Pause if we're not already paused
	if(::mciSendString("stop Midi", NULL, 0, NULL) != 0)
	{
		::strcpy((LPSTR)this->MIDI_ERROR_MSG, "Midi Pause Error!");
		return ErrorMsg();
	}

	this->m_isplay	= FALSE;

	return TRUE;
}

//////////////////////////////////////////////////////////
// Resume
BOOL CMidi::Resume()
{	
	if(!this->m_isload || this->m_isplay) return FALSE;

	// Resume midi
	if(::mciSendString("play Midi notify", NULL, 0, this->m_hwnd) != 0)
	{
		::strcpy((LPSTR)this->MIDI_ERROR_MSG, "Midi Resume Error!");
		return ErrorMsg();
	}

	this->m_isplay	= TRUE;

	return TRUE;
}


//////////////////////////////////////////////////////////
// RePlay
BOOL CMidi::RePlay()
{
	if(!this->m_isload) return FALSE;

	// Replay midi
	if(::mciSendString("play Midi from 0 notify", NULL, 0, this->m_hwnd) != 0)
	{
		::strcpy((LPSTR)this->MIDI_ERROR_MSG, "Midi RePlay Error!");
		return ErrorMsg();
	}

	this->m_isplay	= TRUE;

	return TRUE;
}

