///////////////////////////////////////////////////////////////
//
// Direct Sound Class (CSound.cpp)
//
// 1999.4.9                                        
//
///////////////////////////////////////////////////////////////


#include "stdafx.h"
#include "CSound.h"



/////////////////////////////////////////
// ޼  
BOOL CSound::ErrorMsg()
{
	if (this->SOUND_ERROR_MSG[0] == NULL) ::strcpy((LPSTR)this->SOUND_ERROR_MSG, "Direct Sound Error!");

    ::MessageBox( NULL, (LPSTR)this->SOUND_ERROR_MSG, "Class Sound Message", MB_ICONINFORMATION|MB_OK );

	return FALSE;
}




/////////////////////////////////////////
// 
CSound::CSound()
{
	this->m_ds = NULL;
}



/////////////////////////////////////////
// Ҹ
CSound::~CSound()
{
}






/////////////////////////////////////////
// ʱȭ
BOOL CSound::Init(HWND hwnd)
{
	// Direct Sound Create
	if( FAILED(DirectSoundCreate(NULL, &this->m_ds, NULL)) )
	{
		UnInit();
		::strcpy((LPSTR)this->SOUND_ERROR_MSG, "Direct Sound Create Error!");
		return ErrorMsg();
	}

	// Interface Cooperativelevel
	if( FAILED(this->m_ds->SetCooperativeLevel(hwnd, DSSCL_NORMAL)) )
	{
		UnInit();
		::strcpy((LPSTR)this->SOUND_ERROR_MSG, "Direct Sound CooperativeLevel Error!");
		return ErrorMsg();
	}
	
	// Speaker Setting
	if( FAILED(this->m_ds->SetSpeakerConfig(DSSPEAKER_COMBINED(DSSPEAKER_STEREO, DSSPEAKER_GEOMETRY_WIDE))) )
	{
		UnInit();
		::strcpy((LPSTR)this->SOUND_ERROR_MSG, "Direct Sound Speaker Setting Error!");
		return ErrorMsg();
	}


	return TRUE;
}







/////////////////////////////////////////
// ʱȭ
void CSound::UnInit()
{
	if(this->m_ds)
	{
		this->m_ds->Release(); 
		this->m_ds	= NULL;
	}
}





/////////////////////////////////////////
// ȭ ε(*.wav)
LPDIRECTSOUNDBUFFER CSound::LoadWav(LPSTR filename)
{
	LPDIRECTSOUNDBUFFER buffer;

	// open a wav file
	HMMIO wavefile;
	wavefile = mmioOpen(filename, 0, MMIO_READ|MMIO_ALLOCBUF);
	if(wavefile == NULL)
	{
		::strcpy((LPSTR)this->SOUND_ERROR_MSG, "Direct Sound mmioOpen Error!");
		ErrorMsg();
		return NULL;
	}
	
	// find wave data
	MMCKINFO parent;
	memset(&parent, 0, sizeof(MMCKINFO));
	parent.fccType = mmioFOURCC('W','A','V','E');
	mmioDescend(wavefile, &parent, 0, MMIO_FINDRIFF);

	// find fmt data
	MMCKINFO child;
	memset(&child, 0, sizeof(MMCKINFO));
	child.fccType = mmioFOURCC('f','m','t',' ');
	mmioDescend(wavefile, &child, &parent,0);

	// read the format
	WAVEFORMATEX wavefmt;
	mmioRead(wavefile, (char*)&wavefmt, sizeof(wavefmt));
	if(wavefmt.wFormatTag != WAVE_FORMAT_PCM)
	{
		::strcpy((LPSTR)this->SOUND_ERROR_MSG, "Direct Sound mmioRead Error!");
		ErrorMsg();
		return NULL;
	}

	// find the wave data chunk
	mmioAscend(wavefile, &child, 0);
	child.ckid = mmioFOURCC('d','a','t','a');
	mmioDescend(wavefile, &child, &parent, MMIO_FINDCHUNK);

	// create a directsound buffer to hold wave data
	DSBUFFERDESC bufdesc;
	memset(&bufdesc, 0, sizeof(DSBUFFERDESC));
	bufdesc.dwSize			= sizeof(DSBUFFERDESC);
	bufdesc.dwFlags			= DSBCAPS_CTRLDEFAULT;
	bufdesc.dwBufferBytes	= child.cksize;
	bufdesc.lpwfxFormat		= &wavefmt;
	if( FAILED(this->m_ds->CreateSoundBuffer(&bufdesc, &buffer, NULL)) )
	{
		::strcpy((LPSTR)this->SOUND_ERROR_MSG, "Direct Sound CreateBuffer Error!");
		ErrorMsg();
		return NULL;
	}
	
	// write wave data to directsound buffer you just created
	void *write1 = 0; 
	void *write2 = 0;
	unsigned long length1;
	unsigned long length2;

	buffer->Lock(0, child.cksize, &write1, &length1, &write2, &length2, 0);
	if(write1 > 0)
	{
		mmioRead(wavefile, (char*)write1, length1);
	}
	if(write2 > 0)
	{
		mmioRead(wavefile, (char*)write2, length2);
	}
	buffer->Unlock(write1, length1, write2, length2);

	//close the wavefile, don't need it anymore, it's in the directsound buffer now
	mmioClose(wavefile, 0);

	return buffer;
}





/////////////////////////////////////////
//   
void CSound::Release(LPDIRECTSOUNDBUFFER buffer)
{
	if( buffer )
	{
		buffer->Release();
		buffer	= NULL;
	}
}





/////////////////////////////////////////
//   
LPDIRECTSOUNDBUFFER	CSound::DuplicateSoundBuffer(LPDIRECTSOUNDBUFFER srcbuffer)
{
	LPDIRECTSOUNDBUFFER buffer;

	if( srcbuffer )
	{
		if( FAILED(this->m_ds->DuplicateSoundBuffer(srcbuffer, &buffer)) )
		{
			::strcpy((LPSTR)this->SOUND_ERROR_MSG, "Direct Sound DuplicateBuffer Error! 2001");
			ErrorMsg();
			return NULL;
		}
	}
	else
	{
		::strcpy((LPSTR)this->SOUND_ERROR_MSG, "Direct Sound DuplicateBuffer Error! 2002");
		ErrorMsg();
		return NULL;
	}

	return buffer;
}



/////////////////////////////////////////
//  ÷(ó ׻ ٽ ÷)
BOOL CSound::NewPlay(LPDIRECTSOUNDBUFFER buffer, BOOL loop)
{
	DWORD	dwFlag;

	if( buffer )
	{
		switch(loop)
		{
		case TRUE:
			dwFlag = DSBPLAY_LOOPING;
			break;
		case FALSE:
			dwFlag = 0;
			break;
		}
	
		buffer->SetCurrentPosition(0);
		buffer->Play(0, 0, dwFlag);
	}
	else
	{
		::strcpy((LPSTR)this->SOUND_ERROR_MSG, "Direct Sound NewPlay Error!");
		return ErrorMsg();
	}

	return TRUE;
}




/////////////////////////////////////////
//  ÷(  ÷̵ɶ ٸ)
BOOL CSound::Play(LPDIRECTSOUNDBUFFER buffer, BOOL loop)
{
	DWORD	status;
	DWORD	dwFlag;

	if( buffer )
	{
		switch(loop)
		{
		case TRUE:
			dwFlag = DSBPLAY_LOOPING;
			break;
		case FALSE:
			dwFlag = 0;
			break;
		}

		buffer->GetStatus(&status);

		if( status != DSBSTATUS_PLAYING)
		{
			buffer->SetCurrentPosition(0);
			buffer->Play(0, 0, dwFlag);
		}
	}
	else
	{
		::strcpy((LPSTR)this->SOUND_ERROR_MSG, "Direct Sound Play Error!");
		return ErrorMsg();
	}

	return TRUE;
}




/////////////////////////////////////////
//  
BOOL CSound::Stop(LPDIRECTSOUNDBUFFER buffer)
{
	if( buffer )
	{
		buffer->Stop();
	}
	else
	{
		::strcpy((LPSTR)this->SOUND_ERROR_MSG, "Direct Sound Stop Error!");
		return ErrorMsg();
	}

	return TRUE;
}




/////////////////////////////////////////
// ļ ø
BOOL CSound::AddFrequency(LPDIRECTSOUNDBUFFER buffer, int step)
{
	DWORD	freq;

	if( buffer )
	{
		buffer->GetFrequency(&freq);
		freq = freq + step;	
		if( freq > DSBFREQUENCY_MAX ) freq = DSBFREQUENCY_MAX;
		buffer->SetFrequency(freq);
	}
	else
	{
		::strcpy((LPSTR)this->SOUND_ERROR_MSG, "Direct Sound AddFrequency Error!");
		return ErrorMsg();
	}

	return TRUE;
}




/////////////////////////////////////////
// ļ 
BOOL CSound::SubFrequency(LPDIRECTSOUNDBUFFER buffer, int step)
{
	DWORD	freq;

	if( buffer )
	{
		buffer->GetFrequency(&freq);
		freq = freq - step;
		if( freq < DSBFREQUENCY_MIN ) freq = DSBFREQUENCY_MAX;
		buffer->SetFrequency(freq);
	}
	else
	{
		::strcpy((LPSTR)this->SOUND_ERROR_MSG, "Direct Sound SubFrequency Error!");
		return ErrorMsg();
	}

	return TRUE;
}





/////////////////////////////////////////
//  
BOOL CSound::AddVolume(LPDIRECTSOUNDBUFFER buffer, int step)
{
	LONG	volume;

	if( buffer )
	{
		buffer->GetVolume(&volume);
		volume = volume + step;
		if( volume > DSBVOLUME_MAX ) volume = DSBVOLUME_MAX;
		buffer->SetVolume(volume);	
	}
	else
	{
		::strcpy((LPSTR)this->SOUND_ERROR_MSG, "Direct Sound AddVolume Error!");
		return ErrorMsg();
	}

	return TRUE;
}




/////////////////////////////////////////
//  				
BOOL CSound::SubVolume(LPDIRECTSOUNDBUFFER buffer, int step)
{
	LONG	volume;

	if( buffer )
	{
		buffer->GetVolume(&volume);
		volume = volume - step;
		if( volume < DSBVOLUME_MIN ) volume = DSBVOLUME_MIN;
		buffer->SetVolume(volume);	
	}
	else
	{
		::strcpy((LPSTR)this->SOUND_ERROR_MSG, "Direct Sound SubVolume Error!");
		return ErrorMsg();
	}

	return TRUE;
}




/////////////////////////////////////////
//  
BOOL CSound::RightPan(LPDIRECTSOUNDBUFFER buffer, int step)
{
	LONG	pan;

	if( buffer )
	{
		buffer->GetPan(&pan);
		pan = pan + step;
		if( pan > DSBPAN_RIGHT ) pan = DSBPAN_RIGHT;
		buffer->SetPan(pan);	
	}
	else
	{
		::strcpy((LPSTR)this->SOUND_ERROR_MSG, "Direct Sound RightPan error!");
		return ErrorMsg();
	}

	return TRUE;
}



/////////////////////////////////////////
//  
BOOL CSound::LeftPan(LPDIRECTSOUNDBUFFER buffer, int step)
{
	LONG	pan;

	if( buffer )
	{
		buffer->GetPan(&pan);
		pan = pan - step;
		if( pan < DSBPAN_LEFT ) pan = DSBPAN_LEFT;
		buffer->SetPan(pan);	
	}
	else
	{
		::strcpy((LPSTR)this->SOUND_ERROR_MSG, "Direct Sound LeftPan error!");
		return ErrorMsg();
	}

	return TRUE;
}			


/////////////////////////////////////////
//  
BOOL CSound::CenterPan(LPDIRECTSOUNDBUFFER buffer)
{
	if( buffer )
	{
		buffer->SetPan(DSBPAN_CENTER);	
	}
	else
	{
		::strcpy((LPSTR)this->SOUND_ERROR_MSG, "Direct Sound CenterPan error!");
		return ErrorMsg();
	}

	return TRUE;
}			












