// alphaView.cpp : implementation of the CAlphaView class
//

#include "stdafx.h"
#include "alpha.h"

#include "alphaDoc.h"
#include "alphaView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAlphaView

IMPLEMENT_DYNCREATE(CAlphaView, CView)

BEGIN_MESSAGE_MAP(CAlphaView, CView)
	//{{AFX_MSG_MAP(CAlphaView)
	ON_COMMAND(ID_EXIT, OnExit)
	ON_WM_DESTROY()
	ON_WM_KEYDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAlphaView construction/destruction

CAlphaView::CAlphaView()
{
	// TODO: add construction code here
}

CAlphaView::~CAlphaView()
{
}

BOOL CAlphaView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CAlphaView drawing

void CAlphaView::OnDraw(CDC* pDC)
{
	CAlphaDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CAlphaView diagnostics

#ifdef _DEBUG
void CAlphaView::AssertValid() const
{
	CView::AssertValid();
}

void CAlphaView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CAlphaDoc* CAlphaView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CAlphaDoc)));
	return (CAlphaDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAlphaView message handlers






BOOL CAlphaView::UpDateFrame()
{
	if( !((CMainFrame*)AfxGetMainWnd())->m_active )
	{
		return FALSE;
	}


	// input event
//	this->m_di.PollJoy();
	this->m_di.PollKey();
	this->m_di.PollMouse();


	((CMainFrame*)AfxGetMainWnd())->m_dd.ClearSurface(this->m_util.GetRGB(0, 0, 0));


	POINT	pt		= this->m_util.GetPoint(200, 0);
	RECT	rect	= this->m_util.GetRect( 0, 0, this->m_util.GetWidth(this->m_surface), this->m_util.GetHeight(this->m_surface) );

	((CMainFrame*)AfxGetMainWnd())->m_dd.Blt(pt, this->m_surface, rect, NULL);




	// Joystick
	if(this->m_di.m_joybutton[0]) this->m_mx = 100;
	if(this->m_di.m_joybutton[1]) this->m_my = 100;

	if(this->m_di.m_joy_rx)	this->m_mx+=10;
	if(this->m_di.m_joy_lx)	this->m_mx-=10;
	if(this->m_di.m_joy_ry)	this->m_my+=10;
	if(this->m_di.m_joy_ly)	this->m_my-=10;

	// mouse
	if(this->m_di.m_lbutton_down) 
	{
		// ߾
		this->m_mx = 220;
		this->m_my = 190;
	}
	if(this->m_di.m_mouse_x) this->m_mx += this->m_di.m_mouse_xdata;
	if(this->m_di.m_mouse_y) this->m_my += this->m_di.m_mouse_ydata;

	// keyboard
	if(this->m_di.KeyDown(DIK_RETURN) | this->m_di.KeyDown(DIK_NUMPADENTER))
	{
		// ߾
		this->m_mx = 220;
		this->m_my = 190;
	}
	if(this->m_di.KeyDown(DIK_LEFT))	this->m_mx -= 5;
	if(this->m_di.KeyDown(DIK_RIGHT))	this->m_mx += 5;
	if(this->m_di.KeyDown(DIK_UP))		this->m_my -= 5;
	if(this->m_di.KeyDown(DIK_DOWN))	this->m_my += 5;

	// output
	switch(this->m_outsw)
	{
	case 0:
		{
		// normal
		pt		= this->m_util.GetPoint(this->m_mx, this->m_my);
		rect	= this->m_util.GetRect( 0, 0, this->m_util.GetWidth(this->m_spr), this->m_util.GetHeight(this->m_spr) );

		((CMainFrame*)AfxGetMainWnd())->m_dd.Blt(pt, this->m_spr, rect, DDBLT_KEYSRC);
		}

		this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), 0,   20, "Effect          Normal");
		break;

	case 1:
		{
		// bright effect
		static BOOL sw=FALSE;
		static int	count=100;
		switch(sw)
		{
		case TRUE:
			this->m_util.BrightEffect(this->m_surface, 0, 0, 200, 100, this->m_spr, count);
			count+=10;
			if(count > 100) 
			{
				sw = FALSE;
				count = 100;
			}
			break;

		case FALSE:
			this->m_util.BrightEffect(this->m_surface, 0, 0, 200, 100, this->m_spr, count);
			count-=10;
			if(count < 0) 
			{
				sw = TRUE;
				count = 0;
			}
			break;
		}

		pt		= this->m_util.GetPoint(this->m_mx, this->m_my);
		rect	= this->m_util.GetRect( 0, 0, this->m_util.GetWidth(this->m_spr), this->m_util.GetHeight(this->m_spr) );
	
		((CMainFrame*)AfxGetMainWnd())->m_dd.Blt(pt, this->m_spr, rect, NULL);
		}

		this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), 0,   20, "Effect          Birght (Fade)");
		break;

	case 2:
		{
		// trans effect
		static int r = 31;
		static int g = 0;
		static int b = 0;

		if(this->m_di.KeyDown(DIK_ADD) | this->m_di.KeyDown(DIK_EQUALS))	
		{
			r++;
			if(r > 31)
			{
				r = 31;
				g++;
				if(g > 63)
				{
					g = 63;
					b++;
					if(b > 31) b = 31;
				}
			}
		}
		if(this->m_di.KeyDown(DIK_SUBTRACT) | this->m_di.KeyDown(DIK_MINUS))	
		{
			b--;
			if(b < 0)
			{
				b = 0;
				g--;
				if(g < 0)
				{
					g = 0;
					r--;
					if(r < 0) r = 0;
				}
			}
		}

		this->m_util.TransEffect(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), this->m_mx, this->m_my, 200, 100, this->m_effect, this->m_util.GetRGB(r, g, b));

		pt		= this->m_util.GetPoint(this->m_mx, this->m_my);
		rect	= this->m_util.GetRect( 0, 0, this->m_util.GetWidth(this->m_effect), this->m_util.GetHeight(this->m_effect) );

		((CMainFrame*)AfxGetMainWnd())->m_dd.Blt(pt, this->m_effect, rect, NULL);
		}

		this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(),  0,  20, "Effect          Trans Color");
		this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), 20,  60, "Use to ' + ' & ' - ' Key");
		break;

	case 3:
		{
		// overlap effect
		static BOOL sw=FALSE;
		static int	count=100;
		switch(sw)
		{
		case TRUE:
			this->m_util.OverlapEffect(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), this->m_mx, this->m_my, 200, 100, this->m_spr, this->m_effect, count);
			count+=10;
			if(count > 100) 
			{
				sw = FALSE;
				count = 100;
			}
			break;

		case FALSE:
			this->m_util.OverlapEffect(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), this->m_mx, this->m_my, 200, 100, this->m_spr, this->m_effect, count);
			count-=10;
			if(count < 0) 
			{
				sw = TRUE;
				count = 0;
			}
			break;
		}

		pt		= this->m_util.GetPoint(this->m_mx, this->m_my);
		rect	= this->m_util.GetRect( 0, 0, this->m_util.GetWidth(this->m_effect), this->m_util.GetHeight(this->m_effect) );

		((CMainFrame*)AfxGetMainWnd())->m_dd.Blt(pt, this->m_effect, rect, NULL);
		}

		this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), 0,   20, "Effect          Overlap");
		break;
	}



	static	FLOAT	frame;

	if( this->m_timer.FrameSkip(0, 1.0f) )
	{
		frame = this->m_timer.m_fps[0];
	}

	// ʴ Ӽ  
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(),  0,   0, "FPS");
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), 75,   0, frame);

	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), 0,  200, "ENTER Key & Left Button");
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), 0,  220, " : Sprite Center");

	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), 0,  300, "F1 : Midi Play (test.mid)");
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), 0,  320, "F2 : Midi Stop");
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), 0,  340, "F3 : Wav Play & Stop (test0.wav) - Loop");
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), 0,  360, "F4 : Wav Play (test1.wav) - No Loop");

	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), 0,  460, "'SPACE' Key - Effect Switch");

	((CMainFrame*)AfxGetMainWnd())->m_dd.Flip();

	return TRUE;
}

void CAlphaView::OnExit() 
{
	// TODO: Add your command handler code here
	UnInit();
	((CMainFrame*)AfxGetMainWnd())->UnInit();

	::PostQuitMessage(0);
}

void CAlphaView::OnDestroy() 
{
	CView::OnDestroy();
	
	// TODO: Add your message handler code here
	UnInit();
	((CMainFrame*)AfxGetMainWnd())->UnInit();
}




void CAlphaView::Init()
{
	this->m_util.SearchMaskBit(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface());		// ȼ  ´.(ũ Ʈ)

	this->m_surface = NULL;

	this->m_spr		= NULL;
	this->m_spr		= this->m_util.CreateMemory(((CMainFrame*)AfxGetMainWnd())->m_dd.GetDirectDraw(), 200, 100);

	this->m_effect	= NULL;
	this->m_effect	= this->m_util.CreateMemory(((CMainFrame*)AfxGetMainWnd())->m_dd.GetDirectDraw(), 200, 100);

	this->m_surface = this->m_util.LoadBmp(((CMainFrame*)AfxGetMainWnd())->m_dd.GetDirectDraw(), "test1.bmp");

	this->m_util.GetImage(this->m_surface, 0, 0, 200, 100, this->m_spr);


	this->m_mx = 100;
	this->m_my = 100;

	this->m_outsw = 0;

//	this->m_cd.Play();

	this->m_ds.Init(::AfxGetMainWnd()->m_hWnd);
	this->m_sb1 = this->m_ds.LoadWav("test0.wav");
	this->m_sb2 = this->m_ds.LoadWav("test1.wav");

	this->m_di.Init(::AfxGetInstanceHandle());
	this->m_di.InitKeyDevice(::AfxGetMainWnd()->m_hWnd);
//	this->m_di.InitJoyDevice(::AfxGetMainWnd()->m_hWnd);
	this->m_di.InitMouseDevice(::AfxGetMainWnd()->m_hWnd);



	this->m_midi.Init(::AfxGetMainWnd()->m_hWnd);

}


void CAlphaView::UnInit()
{

	this->m_midi.Stop();

//	this->m_di.UnInitJoyDevice();
	this->m_di.UnInitMouseDevice();
	this->m_di.UnInitKeyDevice();
	this->m_di.UnInit();

	this->m_util.Release(this->m_surface);
	this->m_util.Release(this->m_spr);
	this->m_util.Release(this->m_effect);

	this->m_ds.Release(this->m_sb1);
	this->m_ds.Release(this->m_sb2);
	this->m_ds.UnInit();
 
}



void CAlphaView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();
	
	// TODO: Add your specialized code here and/or call the base class

	Init();
}








void CAlphaView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default

	switch(nChar)
	{
	case VK_SPACE:
		this->m_outsw++;
		if(this->m_outsw > 3) this->m_outsw = 0;
		break;
	case VK_ESCAPE:
		UnInit();
		((CMainFrame*)AfxGetMainWnd())->UnInit();
		::PostQuitMessage(0);
		break;

	// midi
	case VK_F1:
		this->m_midi.Play("test.mid");
		break;
	case VK_F2:
		this->m_midi.Stop();
		break;

	// wave
	case VK_F3:
		{
		static int sw = 0;
		sw = !sw;
		if(sw == 1) this->m_ds.Play(this->m_sb1, TRUE);
		if(sw == 0) this->m_ds.Stop(this->m_sb1);
		}
		break;

	case VK_F4:
		this->m_ds.Play(this->m_sb2);
		break;
	}

	
	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}




