// alphaView.h : interface of the CAlphaView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_ALPHAVIEW_H__89B3AF2F_D639_11D2_A7B0_0080ADB04D11__INCLUDED_)
#define AFX_ALPHAVIEW_H__89B3AF2F_D639_11D2_A7B0_0080ADB04D11__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000



#include "CTimer\\CTimer.h"
#include "CUtil\\CUtil.h"
#include "CWinFont\\CWinFont.h"
#include "CAudio\\CAudio.h"
#include "CSound\\CSound.h"
#include "CInput\\CInput.h"
#include "CMidi\\CMidi.h"


#include "MainFrm.h"



class CAlphaView : public CView
{
protected: // create from serialization only
	CAlphaView();
	DECLARE_DYNCREATE(CAlphaView)

// Attributes
public:
	CAlphaDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAlphaView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CAlphaView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CAlphaView)
	afx_msg void OnExit();
	afx_msg void OnDestroy();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()


protected:
	CUtil					m_util;
	CWinFont				m_font;
	CTimer					m_timer;

	CAudio					m_cd;
	CSound					m_ds;
	CInput					m_di;

	CMidi					m_midi;


	LPDIRECTDRAWSURFACE4	m_surface;
	LPDIRECTDRAWSURFACE4	m_spr;
	LPDIRECTDRAWSURFACE4	m_effect;


	LPDIRECTSOUNDBUFFER		m_sb1;
	LPDIRECTSOUNDBUFFER		m_sb2;
	LPDIRECTSOUNDBUFFER		m_sb3;
	LPDIRECTSOUNDBUFFER		m_sb4;
	LPDIRECTSOUNDBUFFER		m_sb5;
	

	int						m_mx;
	int						m_my;


	int						m_outsw;	//   (0 ~ ?)
	
protected:
	void		Init();
	void		UnInit();


public:
	BOOL		UpDateFrame();



};

#ifndef _DEBUG  // debug version in alphaView.cpp
inline CAlphaDoc* CAlphaView::GetDocument()
   { return (CAlphaDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_ALPHAVIEW_H__89B3AF2F_D639_11D2_A7B0_0080ADB04D11__INCLUDED_)
