///////////////////////////////////////////////////////////////
//
// Direct Draw 16bit Color Control Utility(CUtil.h)
//
// 1999.3.5                                        Bull
//
///////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "CUtil.h"



/////////////////////////////////////////
// ޼  
BOOL CUtil::ErrorMsg()
{
	if (this->UTIL_ERROR_MSG[0] == NULL) ::strcpy((LPSTR)this->UTIL_ERROR_MSG, "Direct Draw Utility Error!");

    ::MessageBox( NULL, (LPSTR)this->UTIL_ERROR_MSG, "Class Util Message", MB_ICONINFORMATION|MB_OK );

	return FALSE;
}



///////////////////////////////
//  
CUtil::CUtil()
{
	this->m_transcolor		= BX_DEFAULT_COLORKEY;				// ⺻  
}

///////////////////////////////////
// Ҹ 
CUtil::~CUtil()
{
}



////////////////////////////////////////////////
// Surface Memory 
void CUtil::Release(LPDIRECTDRAWSURFACE4 surface)
{
	if( surface )
	{
		surface->Release();
		surface = NULL;
	}
}



//////////////////////////////////////////////////
// ޸ Ȯ
// : LoadBmp   surface ޸𸮸 
//   Ȯʰ surface Ҽ .
LPDIRECTDRAWSURFACE4 CUtil::CreateMemory(LPDIRECTDRAW4 lpDD, int w, int h)
{
	DDSURFACEDESC2			ddsd;
	LPDIRECTDRAWSURFACE4	surface;

    // create a DirectDrawSurface for this bitmap
    ::ZeroMemory(&ddsd, sizeof(ddsd));
    ddsd.dwSize			= sizeof(ddsd);
    ddsd.dwFlags		= DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_SYSTEMMEMORY;
    ddsd.dwWidth		= w;
    ddsd.dwHeight		= h;

    if( FAILED(lpDD->CreateSurface(&ddsd, &surface, NULL)) )
    {
        ::OutputDebugString("CreateSurface failed");
        return NULL;
    }

	//  ó (÷ Ű )
	if( surface ) SetColorKey(surface, this->m_transcolor);

	// ޸ Ŭ
	ClearSurface(surface);

	return surface;
}





//////////////////////////////////////////
// Surface Clear
BOOL CUtil::ClearSurface(LPDIRECTDRAWSURFACE4 surface, WORD rgb)
{
	DDBLTFX		ddbltfx;

	ddbltfx.dwSize = sizeof(DDBLTFX);
	ddbltfx.dwFillColor = rgb;

	// surface  ä
	if( FAILED(surface->Blt(NULL, NULL, NULL, DDBLT_COLORFILL | DDBLT_WAIT, &ddbltfx)) )
	{
		::strcpy((LPSTR)this->UTIL_ERROR_MSG, "Direct Draw Utility ClearSurface Error!");
		return ErrorMsg();
	}


	return TRUE;
}






////////////////////////////////////////////////
// Ʈ ȭ ε
// szBitmap : ȭ ̸ 
LPDIRECTDRAWSURFACE4 CUtil::LoadBmp(LPDIRECTDRAW4 lpDD, LPCSTR szBitmap)
{
	LPDIRECTDRAWSURFACE4		surface;

	// 鿡 ̹ ε
	if( (surface = LoadBitMap(lpDD, szBitmap, 0, 0)) == NULL )
	{
		::strcpy((LPSTR)this->UTIL_ERROR_MSG, "Direct Draw Utility LoadBmp Error!");
		ErrorMsg();
		return NULL;
	}

	//  ó (÷ Ű )
	if( surface ) SetColorKey(surface, this->m_transcolor);

	return (LPDIRECTDRAWSURFACE4)surface;
}



////////////////////////////////////////////////
// BMPȭ Surface ε.
// pdd      : Direct Draw Structure
// szBitmap : filename
// dx       : ̹  ũ 
// dy       : ̹  ũ 
LPDIRECTDRAWSURFACE4 CUtil::LoadBitMap(LPDIRECTDRAW4 pdd, LPCSTR szBitmap, int dx, int dy)
{
	HBITMAP					hbm;
	BITMAP					bm;
	DDSURFACEDESC2			ddsd;
	LPDIRECTDRAWSURFACE4	pdds;

    //  try to load the bitmap as a resource, if that fails, try it as a file
    hbm = (HBITMAP)::LoadImage(GetModuleHandle(NULL), szBitmap, IMAGE_BITMAP, dx, dy, LR_CREATEDIBSECTION);
    if (hbm == NULL)
	{
		hbm = (HBITMAP)::LoadImage(NULL, szBitmap, IMAGE_BITMAP, dx, dy, LR_LOADFROMFILE|LR_CREATEDIBSECTION);
	}
    if (hbm == NULL)
	{
		return NULL;
	}

    // get size of the bitmap
    ::GetObject(hbm, sizeof(bm), &bm);

    // create a DirectDrawSurface for this bitmap
    ::ZeroMemory(&ddsd, sizeof(ddsd));
    ddsd.dwSize			= sizeof(ddsd);
    ddsd.dwFlags		= DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
    ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_SYSTEMMEMORY;
    ddsd.dwWidth		= bm.bmWidth;
    ddsd.dwHeight		= bm.bmHeight;

	//  ޸  
    if( FAILED(pdd->CreateSurface(&ddsd, &pdds, NULL)) )
    {
        ::OutputDebugString("CreateSurface failed");
        return NULL;
    }

    CopyBitMap(pdds, hbm, 0, 0, 0, 0);
    ::DeleteObject(hbm);

    return pdds;
}


////////////////////////////////////////////////
// Surface BitMap Copy
HRESULT CUtil::CopyBitMap(LPDIRECTDRAWSURFACE4 pdds, HBITMAP hbm, int x, int y, int dx, int dy)
{
	HDC                 hdcImage;
	HDC                 hdc;
	BITMAP              bm;
	DDSURFACEDESC2      ddsd;
	HRESULT             hr;

    if (hbm == NULL || pdds == NULL)
	{
		return E_FAIL;
	}

    // make sure this surface is restored.
    pdds->Restore();

    //  select bitmap into a memoryDC so we can use it.
    hdcImage = ::CreateCompatibleDC(NULL);
    if(!hdcImage)
	{
		::OutputDebugString("CreateCompatible DC Failed\n");
	}
    ::SelectObject(hdcImage, hbm);

    // get size of the bitmap
    ::GetObject(hbm, sizeof(bm), &bm);	// get size of bitmap
    dx = dx == 0 ? bm.bmWidth  : dx;	// use the passed size, unless zero
    dy = dy == 0 ? bm.bmHeight : dy;

    // get size of surface.
    ::ZeroMemory(&ddsd, sizeof(ddsd));
    ddsd.dwSize  = sizeof(ddsd);
    ddsd.dwFlags = DDSD_HEIGHT | DDSD_WIDTH;
    pdds->GetSurfaceDesc(&ddsd);

	if ( (hr = pdds->GetDC(&hdc)) == DD_OK )
    {
        ::StretchBlt(hdc, 0, 0, ddsd.dwWidth, ddsd.dwHeight, hdcImage, x, y, dx, dy, SRCCOPY);
        pdds->ReleaseDC(hdc);
    }

    ::DeleteDC(hdcImage);

    return hr;
}



///////////////////////////////////////////////////////////////////
// ColorKey Match 
DWORD CUtil::ColorMatch(LPDIRECTDRAWSURFACE4 pdds, COLORREF rgb)
{
    COLORREF rgbT;
    HDC hdc;
    DWORD dw = CLR_INVALID;
    DDSURFACEDESC2 ddsd;
    HRESULT hres;

    //  use GDI SetPixel to color match for us
    if (rgb != CLR_INVALID && pdds->GetDC(&hdc) == DD_OK)
    {
		rgbT = ::GetPixel(hdc, 0, 0);								// save current pixel value
		::SetPixel(hdc, 0, 0, rgb);									// set our value
		pdds->ReleaseDC(hdc);
    }

    // now lock the surface so we can read back the converted color
    ddsd.dwSize = sizeof(ddsd);
    while ((hres = pdds->Lock(NULL, &ddsd, 0, NULL)) == DDERR_WASSTILLDRAWING);

    if (hres == DD_OK)
    {
		dw  = *(DWORD *)ddsd.lpSurface;								// get DWORD
	     if(ddsd.ddpfPixelFormat.dwRGBBitCount < 32)
	         dw &= (1 << ddsd.ddpfPixelFormat.dwRGBBitCount)-1;		// mask it to bpp
		pdds->Unlock(NULL);
    }

    //  now put the color that was there back.
    if (rgb != CLR_INVALID && pdds->GetDC(&hdc) == DD_OK)
    {
		::SetPixel(hdc, 0, 0, rgbT);
		pdds->ReleaseDC(hdc);
    }

    return dw;
}


///////////////////////////////////////////////////////////////////
// ColorKey  
HRESULT CUtil::SetColorKey(LPDIRECTDRAWSURFACE4 pdds, COLORREF rgb)
{
    DDCOLORKEY          ddck;

    ddck.dwColorSpaceLowValue  = ColorMatch(pdds, rgb);
    ddck.dwColorSpaceHighValue = ddck.dwColorSpaceLowValue;

    return pdds->SetColorKey(DDCKEY_SRCBLT, &ddck);
}

///////////////////////////////////////////////////////////////////
// ColorKey  
void CUtil::SetTransColor(COLORREF rgb)
{
	this->m_transcolor	= rgb;
}


///////////////////////////////////////////////////////////////////
// ColorKey  
void CUtil::SetTransColor(LPDIRECTDRAWSURFACE4 surface, COLORREF rgb)
{
	this->m_transcolor	= rgb;

	//  ó (÷ Ű )
	if( surface ) SetColorKey(surface, this->m_transcolor);
}





//////////////////////////////////////////
// Surface 
BOOL CUtil::Restore(LPDIRECTDRAWSURFACE4 surface)
{
	if( surface && surface->IsLost() != DD_OK )
	{
		if( FAILED(surface->Restore()) )
		{
			::strcpy((LPSTR)this->UTIL_ERROR_MSG, "Direct Draw Utility Restore Error!");
			return ErrorMsg();
		}
	}

	return TRUE;
}


//////////////////////////////////////////
//  Surface Memory Lock
// surface : Direct Draw Surface Structure
// buffer  : Ÿ   
WORD* CUtil::Lock(LPDIRECTDRAWSURFACE4 surface)
{
	::ZeroMemory(&this->m_ddsd, sizeof(this->m_ddsd));
	this->m_ddsd.dwSize	= sizeof(this->m_ddsd);

	if( FAILED(surface->Lock(NULL, &this->m_ddsd, DDLOCK_WAIT, NULL)) )
	{
		::strcpy((LPSTR)this->UTIL_ERROR_MSG, "Direct Draw Utility Lock Error!");
		ErrorMsg();
		return NULL;
	}

	return (WORD*)this->m_ddsd.lpSurface;
}

//////////////////////////////////////////
//  Surface Memory UnLock
// surface : Direct Draw Surface Structure
HRESULT	CUtil::UnLock(LPDIRECTDRAWSURFACE4 surface)
{
	return surface->Unlock(NULL);
}




//////////////////////////////////////////
// ȼ  ˾Ƴ.
void CUtil::SearchMaskBit(LPDIRECTDRAWSURFACE4 surface)
{
	HRESULT		hr;

	::ZeroMemory(&this->m_ddsd, sizeof(this->m_ddsd));
	this->m_ddsd.dwSize		= sizeof( this->m_ddsd );
    this->m_ddsd.dwFlags	= DDSD_PIXELFORMAT;

    hr = surface->GetSurfaceDesc(&this->m_ddsd);

    if(hr == DD_OK)
	{
		this->m_redmaskbit		=	0xf800;
		this->m_greenmaskbit	=	0x07e0;
		this->m_bluemaskbit		=	0x001f;

		this->m_redshiftbit		=	11;
		this->m_greenshiftbit	=	5;
		this->m_blueshiftbit	=	0;

		if (this->m_ddsd.ddpfPixelFormat.dwRBitMask == 0xF800) 
		{
			this->m_pixelformat		=	BX_RGB565;
		}
		if (this->m_ddsd.ddpfPixelFormat.dwRBitMask == 0x7C00) 
		{
			this->m_pixelformat		=	BX_RGB555;

			this->m_redmaskbit		=	0x7c00;
			this->m_greenmaskbit	=	0x03e0;

			this->m_redshiftbit		=	10;
			this->m_greenshiftbit	=	5;
			this->m_blueshiftbit	=	0;
		}
		if (this->m_ddsd.ddpfPixelFormat.dwRBitMask == 0x001F) 
		{
			this->m_pixelformat		=	BX_BGR565;

			this->m_blueshiftbit	=	11;
			this->m_greenshiftbit	=	5;
			this->m_redshiftbit		=	0;
		}
	}
}




/////////////////////////////////////////////////////////
// ũ Ʈ  Ʈ ؼ ȼ ´.(WORD)
// r :  
// g :    
// b : Ķ 
WORD CUtil::GetMixRGB(WORD r, WORD g, WORD b)
{
	return ( (WORD)r<<this->m_redshiftbit | (WORD)g<<this->m_greenshiftbit | (WORD)b<<this->m_blueshiftbit );
}




/////////////////////////////////////////////////////////
// RGB Ʈ  ´.
// r :  
// g :    
// b : Ķ 
WORD CUtil::GetRGB(WORD r, WORD g, WORD b)
{
	switch(this->m_pixelformat)
	{
	case BX_RGB565:
		return (WORD)GetMixRGB(r, g, b);

	case BX_RGB555:
		return (WORD)GetMixRGB(r, g/2, b);

	case BX_BGR565:
		return (WORD)GetMixRGB(b, g, r);
	}

	::strcpy((LPSTR)this->UTIL_ERROR_MSG, "Direct Draw Utility GetRGB Error!");
	return ErrorMsg();
}



/////////////////////////////////////////////////////////
// R, G, B  .
// color : 
RGB	CUtil::GetRGB(WORD color)
{
	RGB		rgb;

	// red 
	rgb.r = color & this->m_redmaskbit;
	rgb.r = rgb.r>>this->m_redshiftbit;
	// green 
	rgb.g = color & this->m_greenmaskbit;
	rgb.g = rgb.g>>this->m_greenshiftbit;
	// blue 
	rgb.b = color & this->m_bluemaskbit;
	rgb.b = rgb.b>>this->m_blueshiftbit;


	return rgb;
}





////////////////////////////////////////////////
// Surface    
int	CUtil::GetWidth(LPDIRECTDRAWSURFACE4 surface)
{
	int width = 0;

	if( Lock(surface) )
	{
		width = this->m_ddsd.dwWidth;
	}
	else
	{
		::strcpy((LPSTR)this->UTIL_ERROR_MSG, "Direct Draw GetWidth Error!");
		ErrorMsg();
	}

	UnLock(surface);

	return (int)width;
}



////////////////////////////////////////////////
// Surface    
int	CUtil::GetHeight(LPDIRECTDRAWSURFACE4 surface)
{
	int height = 0;

	if( Lock(surface) )
	{
		height = this->m_ddsd.dwHeight;
	}
	else
	{
		::strcpy((LPSTR)this->UTIL_ERROR_MSG, "Direct Draw GetWidth Error!");
		ErrorMsg();
	}

	UnLock(surface);

	return (int)height;
}




////////////////////////////////////////////////
// Surface ũ⸦ ´.
RECT CUtil::GetRect(long sx, long sy, long ex, long ey)
{
	RECT	rect;

    rect.left   =  sx;
    rect.top    =  sy;
    rect.right  =  ex;
    rect.bottom =  ey;

	return rect;
}


////////////////////////////////////////////////
// ǥ ´.
POINT CUtil::GetPoint(long sx, long sy)
{
	POINT pt;

	pt.x = sx;
	pt.y = sy;

	return pt;
}




////////////////////////////////////////////////
// surface ä ڽ ׸. 
void CUtil::FillBox(LPDIRECTDRAWSURFACE4 surface, int sx, int sy, int ex, int ey, WORD rgb)
{
	DDBLTFX ddbltfx;
	RECT	rect;
	int		w, h;

	w = GetWidth(surface);
	h = GetHeight(surface);

	if(sx <	0) sx = 0;
	if(sy <	0) sy = 0;
	if(ex >	w) ex = w;
	if(ey >	h) ey = h;

	SetRect(&rect, sx, sy, ex, ey);
	ddbltfx.dwSize		= sizeof(DDBLTFX);
	ddbltfx.dwFillColor = rgb;

	surface->Blt(&rect, NULL, NULL, DDBLT_WAIT | DDBLT_COLORFILL, &ddbltfx);
}



////////////////////////////////////////////////
// surface  ׸ 
void CUtil::Box(LPDIRECTDRAWSURFACE4 surface, int sx, int sy, int ex, int ey, WORD rgb)
{
	WLine(surface, sx, sy, ex-sx, rgb);
	WLine(surface, sx, ey, ex-sx, rgb);

	HLine(surface, ex, sy, ey-sy, rgb);
	HLine(surface, sx, sy, ey-sy, rgb);
}

////////////////////////////////////////////////
// surface   ׸ 
void CUtil::HLine(LPDIRECTDRAWSURFACE4 surface, int sx, int sy, int depth, WORD rgb)
{
	FillBox(surface, sx, sy, sx+1, sy+1+depth, rgb);
}


////////////////////////////////////////////////
// surface μ ׸ 
void CUtil::WLine(LPDIRECTDRAWSURFACE4 surface, int sx, int sy, int depth, WORD rgb)
{
	FillBox(surface, sx, sy, sx+1+depth, sy+1, rgb);
}





///////////////////////////////////////////////////////////
// surface ޸𸮿  (w:0 ~ 639, h:0 ~ 479)
// x : x ǥ 
// y : y ǥ 
WORD CUtil::GetPixel(LPDIRECTDRAWSURFACE4 surface, int x, int y)
{
	WORD*	lptemp;
	WORD	temp;
	int		pitch;

	// ȭ Ŭ  ˻
	if(x >= 0 && x < GetWidth(surface) && y >= 0 && y < GetHeight(surface))
	{
		if( (lptemp = Lock(surface)) == NULL)
		{
			::strcpy((LPSTR)this->UTIL_ERROR_MSG, "Direct Draw GetPixel Error! 2001");
			ErrorMsg();
			return NULL;
		}
		pitch	= this->m_ddsd.lPitch/2;
		temp	= (WORD)lptemp[x + y * pitch];
		UnLock(surface);

		return temp;
	}

	::strcpy((LPSTR)this->UTIL_ERROR_MSG, "Direct Draw GetPixel Error! 2002");
	ErrorMsg();
	return NULL;
}



///////////////////////////////////////////////////////////
// surface   
// x : x ǥ 
// y : y ǥ 
// color : 
BOOL CUtil::PutPixel(LPDIRECTDRAWSURFACE4 surface, int x, int y, WORD color)
{
	WORD*	lptemp;
	int		pitch;

	// ȭ Ŭ  ˻
	if(x >= 0 && x < GetWidth(surface) && y >= 0 && y < GetHeight(surface))
	{
		if( (lptemp = Lock(surface)) == NULL) 
		{
			::strcpy((LPSTR)this->UTIL_ERROR_MSG, "Direct Draw Utility PutPixel Error!");
			return ErrorMsg();
		}
		pitch	= this->m_ddsd.lPitch/2;
		lptemp[x + y * pitch] = color;
		UnLock(surface);
	}

	return TRUE;
}




////////////////////////////////////////////////////////////
// surface ޸𸮿 ̹ ´.
// x : x  ǥ 
// y : y  ǥ 
// w :  ũ
// h :  ũ
BOOL CUtil::GetImage(LPDIRECTDRAWSURFACE4 srcsurface, int x, int y, int w, int h, LPDIRECTDRAWSURFACE4 destsurface)
{
	WORD*					dest;
	WORD*					src;
	int						destpitch;
	int						srcpitch;

	// Surface Loack ɰ Pitch ´.
	if( (dest = Lock(destsurface)) == NULL) 
	{
		::strcpy((LPSTR)this->UTIL_ERROR_MSG, "Direct Draw Utility GetImage Error! 2001");
		return ErrorMsg();
	}
	destpitch	= this->m_ddsd.lPitch/2;
	if( (src = Lock(srcsurface)) == NULL) 
	{
		::strcpy((LPSTR)this->UTIL_ERROR_MSG, "Direct Draw Utility GetImage Error! 2002");
		return ErrorMsg();
	}
	srcpitch	= this->m_ddsd.lPitch/2;

	for(int i=0; i<h; i++)
	{
		for(int j=0; j<w; j++)
		{
			dest[j + i * destpitch] = src[(j+x) + (i+y) * srcpitch];
		}
	}

	UnLock(srcsurface);
	UnLock(destsurface);

	//  ó (÷ Ű )
	if( destsurface ) SetColorKey(destsurface, this->m_transcolor);

	return TRUE;

}











//**************************************************************************//
// ȭ ȿ 
//**************************************************************************//

////////////////////////////////////////////////////////////
// ȭ  (κ  )
// x   : x  ǥ 
// y   : y  ǥ 
// w   :  ũ
// h   :  ũ
// per :  (100%)
BOOL CUtil::BrightEffect(LPDIRECTDRAWSURFACE4 srcsurface, int x, int y, int w, int h, LPDIRECTDRAWSURFACE4 destsurface, int per)
{
	WORD*	dest;
	WORD*	src;
	int		destpitch;
	int		srcpitch;
	RGB		rgb;

	if(per > 100) per = 100;
	if(per <   0) per = 0;

	// Surface Loack ɰ Pitch ´.
	if( (dest = Lock(destsurface)) == NULL) 
	{
		::strcpy((LPSTR)this->UTIL_ERROR_MSG, "Direct Draw Utility BirghtEffect Error! 2001");
		return ErrorMsg();
	}
	destpitch	= this->m_ddsd.lPitch/2;
	if( (src = Lock(srcsurface)) == NULL) 
	{
		::strcpy((LPSTR)this->UTIL_ERROR_MSG, "Direct Draw Utility BirghtEffect Error! 2002");
		return ErrorMsg();
	}
	srcpitch	= this->m_ddsd.lPitch/2;

	for(int i=y; i<h; i++)
	{
		for(int j=x; j<w; j++)
		{
			// ȭ Ŭ ˻ 
			if(j < 0 || i < 0 || j > 639 || i > 479) continue;

			// R, G, B   ´
			rgb = GetRGB(src[j + i * srcpitch]);

			// Ѵ
			rgb.r = (rgb.r*per)/100;
			rgb.g = (rgb.g*per)/100;
			rgb.b = (rgb.b*per)/100;

			// R, G, B  Ѵ()
			dest[j + i * destpitch] = GetMixRGB(rgb.r, rgb.g, rgb.b);
		}
	}

	UnLock(srcsurface);
	UnLock(destsurface);

	return TRUE;
}




////////////////////////////////////////////////////////////
//  ȿ(   óѴ.)
// backsurface :  ̹
// x           : x  ǥ 
// y           : y  ǥ 
// w           :  ũ
// h           :  ũ
// destsurface :  ̹
// rgb		   :  ó  
BOOL CUtil::TransEffect(LPDIRECTDRAWSURFACE4 backsurface, int x, int y, int w, int h, LPDIRECTDRAWSURFACE4 destsurface, WORD rgb)
{
	WORD*	back;
	WORD*	dest;
	int		backpitch;
	int		destpitch;
	RGB		backrgb;
	RGB		destrgb;
	RGB		trans;

	trans	= GetRGB(rgb);

	// Surface Loack ɰ Pitch ´.
	if( (back = Lock(backsurface)) == NULL) 
	{
		::strcpy((LPSTR)this->UTIL_ERROR_MSG, "Direct Draw Utility TransEffect Error! 2001");
		return ErrorMsg();
	}
	backpitch	= this->m_ddsd.lPitch/2;
	if( (dest = Lock(destsurface)) == NULL)
	{
		::strcpy((LPSTR)this->UTIL_ERROR_MSG, "Direct Draw Utility TransEffect Error! 2002");
		return ErrorMsg();
	}
	destpitch	= this->m_ddsd.lPitch/2;


	for(int i=0; i<h; i++)
	{
		for(int j=0; j<w; j++)
		{
			// ȭ Ŭ ˻
			if(j+x < 0 || i+y < 0 || j+x > 639 || i+y > 479) continue;

			backrgb = GetRGB(back[(j+x) + (i+y) * backpitch]);

			destrgb.r = (backrgb.r>>1) + (trans.r>>1);
			destrgb.g = (backrgb.g>>1) + (trans.g>>1);
			destrgb.b = (backrgb.b>>1) + (trans.b>>1);

			dest[j + i * destpitch] = GetMixRGB(destrgb.r, destrgb.g, destrgb.b);
		}
	}

	UnLock(backsurface);
	UnLock(destsurface);


	return TRUE;
}






////////////////////////////////////////////////////////////
// ġ ȿ(Overlap Effect : ̹ ڿ ģ.)
// backsurface :  ̹
// x           : x  ǥ 
// y           : y  ǥ 
// w           :  ũ
// h           :  ũ
// srcsurface  :  ̹
// destsurface :  ̹
BOOL CUtil::OverlapEffect(LPDIRECTDRAWSURFACE4 backsurface, int x, int y, int w, int h, LPDIRECTDRAWSURFACE4 srcsurface, LPDIRECTDRAWSURFACE4 destsurface, int per)
{
	WORD*	back;
	WORD*	src;
	WORD*	dest;
	int		backpitch;
	int		srcpitch;
	int		destpitch;
	RGB		backrgb;
	RGB		srcrgb;
	RGB		destrgb;

	WORD	srcper;
	WORD	backper;

	if(per > 100) per = 100;
	if(per <   1) per = 0;

	srcper	= per;
	backper = 100-per;

	// Surface Loack ɰ Pitch ´.
	if( (back = Lock(backsurface)) == NULL) 
	{
		::strcpy((LPSTR)this->UTIL_ERROR_MSG, "Direct Draw Utility LightenEffect Error! 2001");
		return ErrorMsg();
	}
	backpitch	= this->m_ddsd.lPitch/2;
	if( (src = Lock(srcsurface)) == NULL)
	{
		::strcpy((LPSTR)this->UTIL_ERROR_MSG, "Direct Draw Utility LightenEffect Error! 2002");
		return ErrorMsg();
	}
	srcpitch	= this->m_ddsd.lPitch/2;
	if( (dest = Lock(destsurface)) == NULL)
	{
		::strcpy((LPSTR)this->UTIL_ERROR_MSG, "Direct Draw Utility LightenEffect Error! 2003");
		return ErrorMsg();
	}
	destpitch	= this->m_ddsd.lPitch/2;


	for(int i=0; i<h; i++)
	{
		for(int j=0; j<w; j++)
		{
			// ȭ Ŭ ˻
			if(j+x < 0 || i+y < 0 || j+x > 639 || i+y > 479) continue;
			//  ˻
			if( src[j + i * srcpitch] == this->m_transcolor ) continue;

			backrgb = GetRGB(back[(j+x) + (i+y) * backpitch]);
			srcrgb  = GetRGB(src[j + i * srcpitch]);

			destrgb.r = (srcrgb.r*per)/100 + (backrgb.r*(100-per))/100;
			destrgb.g = (srcrgb.g*per)/100 + (backrgb.g*(100-per))/100;
			destrgb.b = (srcrgb.b*per)/100 + (backrgb.b*(100-per))/100;

			dest[j + i * destpitch] = GetMixRGB(destrgb.r, destrgb.g, destrgb.b);
		}
	}

	UnLock(backsurface);
	UnLock(srcsurface);
	UnLock(destsurface);

	return TRUE;
}





