///////////////////////////////////////////////////////////////
//
// Direct Draw 16bit Color Control Utility(CUtil.h)
//
// 1999.3.5                                        Bull
//
//  : 1999.4.20
//
///////////////////////////////////////////////////////////////
#ifndef _CUTIL_HEADER
#define _CUTIL_HEADER


#include <ddraw.h>


#define BX_RGB565				0x00								// ȼ  RGB 5:6:5
#define BX_RGB555				0x02								// ȼ  RGB 5:5:5
#define BX_BGR565				0x04								// ȼ  BGR 5:6:5
	
#define BX_DEFAULT_COLORKEY		RGB(0, 255, 0)						// ⺻ ÷Ű(32bit RGB)



// RGBü(16bit RGB)
typedef struct tagRGB
{
	WORD	r;			// 565 : ִ 0 ~ 31, 555 : ִ 0 ~ 31
	WORD	g;			// 565 : ִ 0 ~ 63, 555 :  0 ~ 31
	WORD	b;			// 565 : ִ 0 ~ 31, 555 : ִ 0 ~ 31
}	RGB, *LPRGB;



// Ŭ
class CUtil
{	
protected:	//  
	DDSURFACEDESC2			m_ddsd;

	COLORREF				m_transcolor;							//   - RGB(r, g, b);

	WORD					m_pixelformat;							//  ȼ  

	WORD					m_redmaskbit;							//  ũ Ʈ 
	WORD					m_greenmaskbit;							//    ũ Ʈ 
	WORD					m_bluemaskbit;							// Ķ ũ Ʈ 

	int						m_redshiftbit;							//  Ʈ Ʈ 
	int						m_greenshiftbit;						//    Ʈ Ʈ 
	int						m_blueshiftbit;							// Ķ Ʈ Ʈ 


	LPSTR					UTIL_ERROR_MSG[80];						//  ޼  


public:		//  






protected:	// Լ
	BOOL	ErrorMsg();												// ޼  

	LPDIRECTDRAWSURFACE4 LoadBitMap(LPDIRECTDRAW4 pdd, 
								LPCSTR szBitmap, int dx, int dy);	// Ʈ ȭ ε
	HRESULT CopyBitMap(LPDIRECTDRAWSURFACE4 pdds, HBITMAP hbm, 
									int x, int y, int dx, int dy);	// Surface Ʈ ȭ 
	HRESULT SetColorKey(LPDIRECTDRAWSURFACE4 pdds, COLORREF rgb);	// Color Key  
	DWORD	ColorMatch(LPDIRECTDRAWSURFACE4 pdds, COLORREF rgb);	// Color Key Match

	WORD*	Lock(LPDIRECTDRAWSURFACE4 surface);						//  Surface Memory Lock
	HRESULT	UnLock(LPDIRECTDRAWSURFACE4 surface);					//  Surface Memory UnLock


	WORD	GetMixRGB(WORD r, WORD g, WORD b);						// ũ Ʈ  Ʈ ؼ ȼ ´.					




public:		// Լ 
	CUtil();														//  
	~CUtil();														// Ҹ 

	BOOL	ClearSurface(LPDIRECTDRAWSURFACE4, WORD rgb = 0);		// surface clear

	void	SearchMaskBit(LPDIRECTDRAWSURFACE4);					// ȼ  ´.(*ݵ ش.)

	LPDIRECTDRAWSURFACE4 CreateMemory(LPDIRECTDRAW4, int x, int y);	// Surface Memory Ȯ
	LPDIRECTDRAWSURFACE4 LoadBmp(LPDIRECTDRAW4, LPCSTR);			// Ʈ ȭ ε
	void	Release(LPDIRECTDRAWSURFACE4);							// Surface Memory  

	void	SetTransColor(COLORREF rgb);							//   
	void	SetTransColor(LPDIRECTDRAWSURFACE4, COLORREF rgb);		//   ʱȭ  

	BOOL	Restore(LPDIRECTDRAWSURFACE4);							// Surface   

	RGB		GetRGB(WORD color);										// WORD --> RGB
	WORD	GetRGB(WORD r, WORD g, WORD b);							// RGB  --> WORD

	WORD	GetPixel(LPDIRECTDRAWSURFACE4, int x, int y);			// surface   
	BOOL	PutPixel(LPDIRECTDRAWSURFACE4, int x, int y, WORD);		// surface   

	BOOL	GetImage(LPDIRECTDRAWSURFACE4 src, int x, int y, 
							int w, int h, LPDIRECTDRAWSURFACE4 dest);// surface ̹ 	

	int		GetWidth(LPDIRECTDRAWSURFACE4);							// Surface    
	int		GetHeight(LPDIRECTDRAWSURFACE4);						// Surface    
	POINT	GetPoint(long sx, long sy);								// ǥ ´.
	RECT	GetRect(long sx, long sy, long ex, long ey);			// 簢  ´.

	void	FillBox(LPDIRECTDRAWSURFACE4, int sx, int sy, int ex, int ey, WORD rgb);	// ĥ  ׸ 
	void	Box(LPDIRECTDRAWSURFACE4, int sx, int sy, int ex, int ey, WORD rgb);		//  ׸
	void	HLine(LPDIRECTDRAWSURFACE4, int sx, int sy, int depth, WORD rgb);			//   ׸
	void	WLine(LPDIRECTDRAWSURFACE4, int sx, int sy, int depth, WORD rgb);			//   ׸ 



	BOOL	BrightEffect(LPDIRECTDRAWSURFACE4 src, int x, int y, int w, int h, 
													LPDIRECTDRAWSURFACE4 dest, int per);// ȭ  ȿ(Ϻκ  )

	BOOL	TransEffect(LPDIRECTDRAWSURFACE4 backsurface, int x, int y, int w, int h, 
											LPDIRECTDRAWSURFACE4 destsurface, WORD rgb);//  ȿ

	BOOL	OverlapEffect(LPDIRECTDRAWSURFACE4 backsurface, int x, int y, int w, int h, 
			LPDIRECTDRAWSURFACE4 srcsurafce, LPDIRECTDRAWSURFACE4 destsurface, int per);// ġ ȿ



};










#endif



