// FRTView.cpp : implementation of the CFRTView class
//

#include "stdafx.h"
#include "FRT.h"

#include "FRTDoc.h"
#include "FRTView.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFRTView

IMPLEMENT_DYNCREATE(CFRTView, CView)

BEGIN_MESSAGE_MAP(CFRTView, CView)
	//{{AFX_MSG_MAP(CFRTView)
	ON_COMMAND(ID_EXIT, OnExit)
	ON_COMMAND(ID_FILEOPEN, OnFileopen)
	ON_COMMAND(ID_DELAY, OnDelay)
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_SCREENINIT, OnScreeninit)
	ON_COMMAND(ID_FRAMEEDIT, OnFrameedit)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFRTView construction/destruction

CFRTView::CFRTView()
{
	// TODO: add construction code here
}


CFRTView::~CFRTView()
{
}

BOOL CFRTView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CFRTView drawing

void CFRTView::OnDraw(CDC* pDC)
{
//	CFRTDoc* pDoc = GetDocument();
//	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CFRTView diagnostics

#ifdef _DEBUG
void CFRTView::AssertValid() const
{
	CView::AssertValid();
}

void CFRTView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CFRTDoc* CFRTView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CFRTDoc)));
	return (CFRTDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CFRTView message handlers


// ʱȭ 
void CFRTView::Init()
{
	this->m_framedelay		= 1;
	this->m_filecount		= 0;

	this->m_bmploading		= FALSE;
	this->m_autoanimation	= FALSE;

	for(int i=0; i<ID_MAX_FILECOUNT; i++)
	{
		this->m_sprite[i].num		= 0;
		this->m_sprite[i].w			= 0;
		this->m_sprite[i].h			= 0;
		this->m_sprite[i].filename	= (LPCSTR)NULL;
		this->m_sprite[i].surface	= NULL;

		this->m_spritearray[i]		= 0;
	}

	this->m_spritecount		= 0;	
	this->m_countnumber		= 0;

	this->m_util.SearchMaskBit(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface());
}

// 
void CFRTView::UnInit()
{
	SpriteInit();
}



void CFRTView::SpriteInit()
{
	this->m_framedelay		= 1;
	this->m_filecount		= 0;

	this->m_bmploading		= FALSE;
	this->m_autoanimation	= FALSE;

	for(int i=0; i<ID_MAX_FILECOUNT; i++)
	{
		this->m_sprite[i].num		= 0;
		this->m_sprite[i].w			= 0;
		this->m_sprite[i].h			= 0;
		this->m_sprite[i].filename	= (LPCSTR)NULL;
		if(this->m_sprite[i].surface != NULL)
		{
			this->m_sprite[i].surface->Release();
			this->m_sprite[i].surface	= NULL;
		}

		this->m_spritearray[i]		= 0;
	}

	this->m_spritecount		= 0;	
	this->m_countnumber		= 0;
}


// ȭ 
BOOL CFRTView::UpDateFrame()
{
	if( !((CMainFrame*)AfxGetMainWnd())->m_active )
	{
		return FALSE;
	}

	((CMainFrame*)AfxGetMainWnd())->m_dd.ClearSurface(this->m_util.GetRGB(0, 0, 0));

	// ̹ ε϶ .
	if( this->m_bmploading == TRUE)
	{
		if(this->m_autoanimation == TRUE)
		{
			if( this->m_timer.FrameSkip(ID_TIME_FRAMEDELAY, ((FLOAT)this->m_framedelay/1000.0f)) )
			{
				this->m_countnumber++;
				if(this->m_countnumber >= this->m_spritecount) this->m_countnumber = 0;
			}
		}

		POINT	pt		= this->m_util.GetPoint(
							320-this->m_util.GetWidth(this->m_sprite[this->m_spritearray[this->m_countnumber]].surface)/2, 
							240-this->m_util.GetHeight(this->m_sprite[this->m_spritearray[this->m_countnumber]].surface)/2 );
		RECT	rect	= this->m_util.GetRect( 0, 0, 
							this->m_util.GetWidth(this->m_sprite[this->m_spritearray[this->m_countnumber]].surface), 	
							this->m_util.GetHeight(this->m_sprite[this->m_spritearray[this->m_countnumber]].surface) );

		((CMainFrame*)AfxGetMainWnd())->m_dd.Blt(pt, this->m_sprite[this->m_spritearray[this->m_countnumber]].surface, rect, NULL);
	}



	// ؽƮ 
	TextDraw();


	((CMainFrame*)AfxGetMainWnd())->m_dd.Flip();
	
	return TRUE;
}



void CFRTView::TextDraw()
{
	static	FLOAT	frame;

	if( this->m_timer.FrameSkip(ID_TIME_FRAME, 1.0f) )
	{
		frame = this->m_timer.m_fps[ID_TIME_FRAME];
	}

	// ȭ ̸ 
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(),   0,   0, "File Name");
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), 110,   0, this->m_sprite[this->m_spritearray[this->m_countnumber]].filename);

	// ׸ ũ
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(),   0,   20, "Sprite Size                 x");
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), 110,   20, this->m_sprite[this->m_spritearray[this->m_countnumber]].w );
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), 160,   20, this->m_sprite[this->m_spritearray[this->m_countnumber]].h );

	// ü ȭ 
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(),   0,   40, "File Count");
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), 110,   40, this->m_filecount);

	//  ȣ
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(),   0,   60, "Frame Number");
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), 110,   60, this->m_spritearray[this->m_countnumber]);

	// õ Ʈ 
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(),   0,   80, "Sprite Count");
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), 110,   80, this->m_spritecount);

	// Ʈ ȣ
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(),   0,   100, "Sprite Number");
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), 110,   100, this->m_countnumber);

	// Ӱ ð 
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(),   0,   120, "Frame Delay");
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), 110,   120, this->m_framedelay);

	// ʴ Ӽ  
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(),   0,   140, "FPS");
	this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(), 110,   140, frame);

	// ̽Ű ޼
	switch(this->m_autoanimation)
	{
	case TRUE:
		this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(),   0,   460, "'Space' Key : Animation On");
		break;
	case FALSE:
		this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(),   0,   460, "'Space' Key : Animation Off - Use to 'Left' or 'Right' Key");
		break;
	}

	// ̹ ε ƴҶ .
	if( this->m_bmploading == FALSE)
	{
		this->m_font.DrawText(((CMainFrame*)AfxGetMainWnd())->m_dd.GetBackSurface(),   260,   220, "No Sprite Load...");
	}
}




void CFRTView::OnExit() 
{
	// TODO: Add your command handler code here

	CExitDlg	dlg;
	
	switch(dlg.DoModal())
	{
	case IDOK:

		UnInit();
		((CMainFrame*)AfxGetMainWnd())->UnInit();

		::PostQuitMessage(0);
		break;
	}
}







BOOL CFRTView::EncodeFileName()
{
	POSITION		position;

	char			lpstr[40*100];
	::ZeroMemory(lpstr, 40*100);

	CFileDialog		
		FileDlg(TRUE, NULL, NULL, OFN_FILEMUSTEXIST|OFN_HIDEREADONLY|OFN_ALLOWMULTISELECT, NULL, this);

//	CFileDialog		FileDlg(NULL);
//	FileDlg.m_ofn.Flags				= OFN_FILEMUSTEXIST|OFN_HIDEREADONLY|OFN_ALLOWMULTISELECT;

    FileDlg.m_ofn.hwndOwner			= NULL;
    FileDlg.m_ofn.lStructSize		= sizeof(OPENFILENAME);
    FileDlg.m_ofn.lpstrFilter		= "BMP File(*.bmp)\0*.bmp\0All File(*.*)\0*.*\0";

    FileDlg.m_ofn.lpstrInitialDir	= ".\\";
	FileDlg.m_ofn.lpstrTitle		= "File Open";
    FileDlg.m_ofn.lpstrDefExt		= "*.bmp";

    FileDlg.m_ofn.nMaxFile			= sizeof(lpstr);


	switch(FileDlg.DoModal())
	{
	case IDCANCEL:
		return FALSE;
		break;
	case IDOK:
		this->m_filecount	= 0;
		position = FileDlg.GetStartPosition();

		for(int i=0; i<ID_MAX_FILECOUNT; i++)
		{
			this->m_sprite[i].filename	= (LPCSTR)NULL;
		}

		if( position != NULL )
		{
			while(TRUE)
			{
				this->m_sprite[this->m_filecount].filename = FileDlg.GetNextPathName(position);
				this->m_filecount++;
				if( position == NULL || this->m_filecount == 32768 )
				{
					break;
				}
			}
		}
		break;
	}

	return TRUE;
}





void CFRTView::OnFileopen() 
{
	// TODO: Add your command handler code here
	
	// ȭ ̸  
	if( EncodeFileName() == TRUE)
	{
		// ׸  
		LoadBmpFile();
	}
}


void CFRTView::OnDelay() 
{
	// TODO: Add your command handler code here
	CDelayDlg	dlg;

	//   
	dlg.m_framedelay = this->m_framedelay;

	switch(dlg.DoModal())
	{
		case IDOK:
//			if(dlg.m_framedelay > 1.0f) dlg.m_framedelay = 1.0f;
			this->m_framedelay	= dlg.m_framedelay;
			break;
	}
	
}









////////////////////////////////////////
// * ȭ ̸ Ǿִ  *
// ȭ  , óȭ ̸ ȭ ̸ ٲ
// Ǿ ִ. ׷Ƿ  2 ȭ ġ ٲپ ̹ εؾ Ѵ.
BOOL CFRTView::LoadBmpFile()
{
	int i;

	this->m_autoanimation	= FALSE;
	this->m_countnumber		= 0;

	this->m_spritecount		= this->m_filecount;

	// ȭ ̸ ȭ(Sort)
	CString		swap = (LPSTR)NULL;
	for(i=0; i<this->m_filecount-1; i++)
	{
		for(int j=i+1; j<this->m_filecount; j++)
		{
			if( this->m_sprite[i].filename > this->m_sprite[j].filename)
			{
				swap = this->m_sprite[i].filename;
				this->m_sprite[i].filename = this->m_sprite[j].filename;
				this->m_sprite[j].filename = swap;
			}
		}
	}

	// о ȭ ŭ ̹ оδ.
	for(i=0; i<this->m_filecount; i++)
	{
		// ٽ 
		this->m_sprite[i].num		= i;
		this->m_sprite[i].filename	= this->m_sprite[i].filename;
		this->m_sprite[i].surface	= this->m_util.LoadBmp(((CMainFrame*)AfxGetMainWnd())->m_dd.GetDirectDraw(), this->m_sprite[i].filename );
		this->m_sprite[i].w			= this->m_util.GetWidth(this->m_sprite[i].surface);
		this->m_sprite[i].h			= this->m_util.GetHeight(this->m_sprite[i].surface);

		this->m_spritearray[i]		= this->m_sprite[i].num;
	}

	// ׸ ε
	this->m_bmploading	= TRUE;


	return TRUE;
}





void CFRTView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	// TODO: Add your message handler code here and/or call default

	switch(nChar)
	{
	case VK_SPACE:
		this->m_autoanimation = !this->m_autoanimation;
		break;

	case VK_RIGHT:
		//    
		if(this->m_autoanimation == FALSE)
		{
			this->m_countnumber++;
			if(this->m_countnumber == this->m_spritecount) this->m_countnumber = 0;
		}
		break;

	case VK_LEFT:
		if(this->m_autoanimation == FALSE)
		{
			this->m_countnumber--;
			if(this->m_countnumber == -1) this->m_countnumber = this->m_spritecount-1;
		}
		break;
	}
	
	CView::OnKeyDown(nChar, nRepCnt, nFlags);
}


void CFRTView::OnScreeninit() 
{
	// TODO: Add your command handler code here

	SpriteInit();
}



void CFRTView::OnFrameedit() 
{
	// TODO: Add your command handler code here
	// ̹ ε϶ .
	if( this->m_bmploading == FALSE)
	{
		MessageBox("ε ȭ ϴ.", " ", MB_OK);
		return;
	}


	this->m_autoanimation	= FALSE;
	this->m_countnumber		= 0;

	CEditDlg	dlg;

	// ü ε ȭ 
	dlg.m_filecount = this->m_filecount;
	//  ε ȭ ̸ ʱȭ 
	for(int i=0; i<this->m_filecount; i++)
	{
		dlg.m_string[i] = this->m_sprite[i].filename;
	}

	//   Ʈ  
	dlg.m_spritecount = this->m_spritecount;
	//   Ʈ ʱȭ 
	for(int j=0; j<this->m_spritecount; j++)
	{
		dlg.m_sprite[j] = this->m_spritearray[j];
	}


	switch(dlg.DoModal())
	{
	case IDOK:
		{
			this->m_spritecount = dlg.m_spritecount;
			for(int i=0; i<m_spritecount; i++)
			{
				this->m_spritearray[i] = dlg.m_sprite[i];
			}
		}
		break;

	case IDCANCEL:
		break;
	}
}


void CFRTView::OnDestroy() 
{
	CView::OnDestroy();
	
	// TODO: Add your message handler code here

	UnInit();
	((CMainFrame*)AfxGetMainWnd())->UnInit();
}

void CFRTView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();
	
	// TODO: Add your specialized code here and/or call the base class

	Init();
}
