// FRTView.h : interface of the CFRTView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_FRTVIEW_H__B37DC358_CBD2_11D2_A7B0_0080ADB04D11__INCLUDED_)
#define AFX_FRTVIEW_H__B37DC358_CBD2_11D2_A7B0_0080ADB04D11__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000


#include "CTimer\CTimer.h"
#include "CWinFont\CWinFont.h"
#include "CUtil\CUtil.h"


#include <ddraw.h>
#include "MainFrm.h"
#include "ExitDlg.h"
#include "DelayDlg.h"
#include "EditDlg.h"




#define	ID_TIME_FRAME				99
#define	ID_TIME_FRAMEDELAY			98




typedef struct tagSPRITE
{
	int						num;
	int						w, h;
	CString					filename;
	LPDIRECTDRAWSURFACE4	surface;
}	SPRITE;





class CFRTView : public CView
{
protected: // create from serialization only
	CFRTView();
	DECLARE_DYNCREATE(CFRTView)

// Attributes
public:
	CFRTDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFRTView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CFRTView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CFRTView)
	afx_msg void OnExit();
	afx_msg void OnFileopen();
	afx_msg void OnDelay();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnScreeninit();
	afx_msg void OnFrameedit();
	afx_msg void OnDestroy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()




protected:
	CTimer		m_timer;										// Ÿ̸ Ŭ
	CWinFont	m_font;											// Ʈ Ŭ
	CUtil		m_util;											// ⺻ ƿƼ

	int			m_framedelay;									//  ð 
	int			m_filecount;									// ü ȭ 

	BOOL		m_bmploading;									// ׸ ε
	BOOL		m_autoanimation;								// ڵ ϸ̼ 

	SPRITE		m_sprite[ID_MAX_FILECOUNT];						// Ʈ  

	int			m_spritecount;									//   Ʈ  
	int			m_countnumber;									//  Ʈ īƮ ȣ
	int			m_spritearray[ID_MAX_FILECOUNT];				//   Ʈ ȣ 	

protected:
	void		Init();											// ʱȭ 
	void		UnInit();										// 

	void		SpriteInit();									/// Ʈ Ÿ ʱȭ 

	void		TextDraw();										// ȭ鿡 ؽƮ  
	BOOL		EncodeFileName();								// ȭ ̸  
	BOOL		LoadBmpFile();									// ׸  

public:
	BOOL		UpDateFrame();									// ȭ  



};


#ifndef _DEBUG  // debug version in FRTView.cpp
inline CFRTDoc* CFRTView::GetDocument()
   { return (CFRTDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_FRTVIEW_H__B37DC358_CBD2_11D2_A7B0_0080ADB04D11__INCLUDED_)
