/*===============================================================
 *
 *
 *
 *===============================================================*/

#define INITGUID

#include <windows.h>
#include <malloc.h>
#include <string.h>
#include <mmsystem.h>
#include <d3drmwin.h>
#include <stdio.h>
#include "vcmain.h"
#include "vcerror.h"

#define SETBACK			5000.0				// Back clipping 

static FILE			*fp;

// staticԼ vcmainο Ǹ, ܺο  Ұϴ.
static	BOOL	CreateSimpleScene( LPVEGCLI3DINFO lpInfo );
static	BOOL	createD3DRMWindowed( LPVEGCLI3DINFO lpInfo, int cx, int cy, int bpp );
static	BOOL	createD3DRMExclusive( LPVEGCLI3DINFO lpInfo, int cx, int cy, int bpp );
static	DWORD	bppToddbd( int bpp );
static	char*	LSTRRCHR( const char* lpString, int bChar );
static HRESULT LoadTextures(char *sName, void *pArg, LPVEGTEXTURE *hTexture);

static  LPVEGCLI3DINFO	glpInfo;			// LoadTextures()Լ   ִ.

//////////////////////////////////////////////////////////////////////////////////////////////
//
// VEG Client 3Dƾ ʱȭ
//
//////////////////////////////////////////////////////////////////////////////////////////////

// [Լ  ]
// Direct 3DRM ʱȭϰ VEGCLI3DINFOü ޸ ڵ Ѵ.
//
// [      ȯ]
// vegcli3Dü ޸ ڵ
//
// [      ]
// nDispMode : VEGCLI_DISPMODE_WINDOWED / VEGCLI_DISPMODE_EXCLUSIVE
//			   VEGCLI_DISPMODE_WINDOWED ũ  · α׷
//			   ȴ.
//			   VEGCLI_DISPMODE_EXCLUSIVE ȭ(Full screen)   ȴ.
// cx, cy    :  ũ. PIXEL ̴.
// bpp       : bit per plane  8, 16, 24   ִ.
//
// [      ]
// ʿ  ѹ ҷ Ѵ.
//   vegcli3Dü    ִ.
//  ⼭ ϴ ڵ鰪  ؾ Ѵ.
//
// [  Լ]
// vegcli3DDestroy()
//
// [    ]
// vegcli3DCreate( hwnd, VEGCLI_DISPMODE_WINDOWED, 320, 200, 16 );
//
LPVEGCLI3DINFO
vegcli3DCreate( HWND hwnd, int nDispMode, int cx, int cy, int bpp )
{
	LPVEGCLI3DINFO	lpInfo;

#ifdef VEGDEBUG
	fp = fopen( VEGCLI3DLOGFILE, "a+" );
	fprintf( fp, "\nVEG CLIENT 3D SYSTEM STARTING...\n" );
	fprintf( fp, "Initialization started...\n" );
	fprintf( fp, "vegcli3DCreate(%d, %d, %d, %d) started\n", nDispMode, cx, cy, bpp );
	fclose( fp );
#endif // VEGDEBUG

	lpInfo = (LPVEGCLI3DINFO) malloc( sizeof( VEGCLI3DINFO ) );
	if( !lpInfo ) 
	{
		vegMsg( "Insufficient memory[ vegcli3DCreate() ]\n" );
		return NULL;
	}
	lpInfo->hwnd        = hwnd;
	lpInfo->vegDispMode = nDispMode;
	lpInfo->bDispFPS	= FALSE;
	lpInfo->ptFPS.x		= 0;
	lpInfo->ptFPS.y		= 0;
	lpInfo->dwLastTime  = 0;
	lpInfo->dwCurTime   = 0;
	lpInfo->dwFpsTime   = 0;
	lpInfo->dwDeltaTime = 0;
	lpInfo->dwFramesRendered = 0;
	lpInfo->dwFps = 0;
	lstrcpy( lpInfo->lpszTexturePath, "\\" );
	GetCurrentDirectory( 128, lpInfo->lpszAppPath );
	
	glpInfo = lpInfo;

    if( VEGCLI_DISPMODE_WINDOWED  == nDispMode )
	{
		if( !createD3DRMWindowed( lpInfo, cx, cy, bpp ) )
		{
			free( lpInfo );
			return NULL;
		}
	}
	else
	if( VEGCLI_DISPMODE_EXCLUSIVE == nDispMode )
	{
		if( !createD3DRMExclusive( lpInfo, cx, cy, bpp ) )
		{
			free( lpInfo );
			return NULL;
		}
	}

	// ̷ ϸ default   丮  ȴ.
	// ̴ ؽĸ о϶ ȴ.

#ifdef VEGDEBUG
	fp = fopen( VEGCLI3DLOGFILE, "a+" );
	fprintf( fp, "vegcli3DCreate(%d, %d, %d, %d) ended\n", nDispMode, cx, cy, bpp );
	fclose( fp );
#endif // VEGDEBUG
	return lpInfo;
}

// [Լ  ]
// VEGCLI3DINFOü κ ü鿡 Ҵ ޸𸮸 ϰ,
// VEGCLI3DINFOü ü ޸𸮿 Ѵ.
// vegcli3D̺귯  ݵ ҷ Ѵ.
//
// [      ȯ]
// 
//
// [      ]
// h - vegcli3DCreate() Ͽ Ҵ VEGCLI3DINFOü ޸ ڵ
//
// [      ]
//  ݵ ҷ Ѵ.
//
// [  Լ]
// vegcli3DCreate()
//
// [    ]
// vegcli3DDestroy( h );
//
void
vegcli3DDestroy( LPVEGCLI3DINFO lpInfo )
{
#ifdef VEGDEBUG
	fp = fopen( VEGCLI3DLOGFILE, "a+" );
	fprintf( fp, "vegcli3DDestroy() started\n" );
	fclose( fp );
#endif // VEGDEBUG

	RELEASE( lpInfo->view );
	RELEASE( lpInfo->camera );
	RELEASE( lpInfo->device );
	RELEASE( lpInfo->scene );
	RELEASE( lpInfo->animation );
	RELEASE( lpInfo->animationSet );
	RELEASE( lpInfo->lpDDClipper );
	RELEASE( lpInfo->lpD3DRM );

	if( lpInfo->vegDispMode == VEGCLI_DISPMODE_EXCLUSIVE )
	{
		RELEASE( lpInfo->lpDDPal );
		RELEASE( lpInfo->lpDDSPrimary );
		RELEASE( lpInfo->lpDD );
	}

	free( lpInfo );

#ifdef VEGDEBUG
	fp = fopen( VEGCLI3DLOGFILE, "a+" );
	fprintf( fp, "vegcli3DDestroy() ended\n" );
	fclose( fp );
#endif // VEGDEBUG
}

void vegcli3DFPSDisplay( LPVEGCLI3DINFO lpInfo, BOOL b )
{
	lpInfo->bDispFPS	= b;
	lpInfo->ptFPS.x		= 0;
	lpInfo->ptFPS.y		= 0;
}

void vegcli3DFPSSetPos( LPVEGCLI3DINFO lpInfo, LPPOINT pt )
{
	lpInfo->ptFPS.x		= pt->x;
	lpInfo->ptFPS.y		= pt->y;
}

void vegcli3DFPSOut( LPVEGCLI3DINFO lpInfo )
{
	HDC		hDC;
	char	lpsz[128];

	if( lpInfo->dwFpsTime < DWORD( 1000 ) )
		return;

	if( !lpInfo->dwFpsTime )
		return;

	lpInfo->dwFps = lpInfo->dwFramesRendered / ( lpInfo->dwFpsTime / 1000 );

//	wsprintf( lpsz, "  FPS : %lu, %lu, %lu  ", lpInfo->dwFps, lpInfo->dwFramesRendered, lpInfo->dwFpsTime );
	wsprintf( lpsz, "  FPS : %lu  ", lpInfo->dwFps );
	if( lpInfo->vegDispMode == VEGCLI_DISPMODE_WINDOWED )
	{
		hDC = GetDC( lpInfo->hwnd );
		TextOut( hDC, lpInfo->ptFPS.x, lpInfo->ptFPS.y, lpsz, strlen( lpsz ) );
		ReleaseDC( lpInfo->hwnd, hDC );
	}
	else
	{
		if( lpInfo->lpDDSBack->GetDC(&hDC) == DD_OK )
		{
			SetBkColor(hDC, RGB(0, 0, 255));
			SetTextColor(hDC, RGB(255, 255, 0));
			TextOut( hDC, lpInfo->ptFPS.x, lpInfo->ptFPS.y, lpsz, strlen( lpsz ) );
			lpInfo->lpDDSBack->ReleaseDC(hDC);
		}
	}

	lpInfo->dwFramesRendered = 0;
	lpInfo->dwFpsTime = 0;
}

//////////////////////////////////////////////////////////////////////////////////////////////
//
// Frame Create
//     Լ 
//
//////////////////////////////////////////////////////////////////////////////////////////////

//
// 
// [Լ  ]
//   Ͽ  ӿ ߰Ѵ.
//
// [      ȯ]
//  ü  ִ  ü 
//
// [      ]
// lpParentFrame : scene ̴ scene  ̾߸ Ѵ.
// lpRef         : SetPosition SetOrientation Ҷ  Ǵ ̴.
//                 Ϲ scene ´.
// lt            :  
// rgb           :  . rgb->x,y,z 0 ~ 1.0  ´.
// pos           :  ġ
// d             :  ġ ( direction vector ) 
// u             :   ( up vector )
// pos null, (d,u) ÿ Ͽ null
//
// [      ]
//    · ϵȴ.    ִ.
// ϱ ,  ü ü Ҽ .
//
// [  Լ]
//
// [    ]
//
LPVEGFRAME
vegcli3DLightCreate( LPVEGCLI3DINFO lpInfo,
		 		     LPVEGFRAME lpParent,
				     LPVEGFRAME lpRef,
				     D3DRMLIGHTTYPE lt, 
				     D3DVECTOR* rgb, 
				     D3DVECTOR* pos, 
				     D3DVECTOR* d, 
				     D3DVECTOR* u )
{
	HRESULT					rval;
	LPVEG					lpD3DRM = lpInfo->lpD3DRM;
    LPVEGFRAME		light = NULL;
    LPDIRECT3DRMLIGHT		light1 = NULL;

    ATTEMPT( rval = lpD3DRM->CreateFrame( lpParent, &light ) );
    ATTEMPT( rval = lpD3DRM->CreateLightRGB( lt, rgb->x, rgb->y, rgb->z, &light1 ) );
	if( pos )
		ATTEMPT( rval = light->SetPosition( lpRef, pos->x, pos->y, pos->z ) );
	if( d && u )
		ATTEMPT( rval = light->SetOrientation( lpRef, d->x, d->y, d->y, u->x, u->y, u->z ) );
    ATTEMPT( rval = light->AddLight( light1 ) );
	RELEASE( light1 );

	return light;

generic_error:
    vegMsg( "Error in vegcli3DLightCreate() - %s", DXErrorToString( rval ) );

	return NULL;
}

// [Լ  ]
// X о DIRECT3DRMMESHBUILDERü .
// X DirectX  ƿƼ CONV3DS.EXE Ͽ ȴ.
//
// [      ȯ]
//  DIRECT3DRMMESHBUILDERü 
//
// [      ]
// lpInfo   : LPVEGCLI3DINFO 
// filename : conv3ds -m ɼǿ Ͽ  ޽ 
//            ex) conv3ds -m bird.3ds
//
// [      ]
// ޽θ   ƴ hierarchy  ִ ̶,
//  -mɼǿ Ͽ  X ƴѰ, ε Ͱ  о.
// (Ȯ hierarchy   ޽ о.)
//
// [  Լ]
// vegcli3DMeshCreateFromRes()
//
// [    ]
// vegcli3DMeshCreateFromFile( lpInfo, "bird.x" );
//
LPVEGMESHBUILDER
vegcli3DMeshCreateFromFile( LPVEGCLI3DINFO lpInfo, LPCTSTR filename )
{
	HRESULT					rval;
	LPVEG					lpD3DRM = lpInfo->lpD3DRM;
	LPVEGMESHBUILDER		builder = NULL;

	glpInfo = lpInfo;
	ATTEMPT( rval = lpD3DRM->CreateMeshBuilder( &builder ) );
	ATTEMPT( rval = builder->Load( (LPVOID)filename, NULL, D3DRMLOAD_FROMFILE , LoadTextures, NULL ) );

	return builder;

generic_error:
	vegMsg( "Error in vegCliMeshCreateFromFile() - %s", DXErrorToString( rval ) );
	return NULL;
}

// [Լ  ]
// vegcli3DMeshCreateFromFile()   Ѵ.
// ٸ ҽ ͸ д´.
//
// [      ȯ]
//  DIRECT3DRMMESHBUILDERü 
//
// [      ]
// lpInfo   : LPVEGCLI3DINFO 
// res      : ҽ ID
//            ex) conv3ds -m bird.3ds
//
// [      ]
// ޽θ   ƴ hierarchy  ִ ̶,
//  -mɼǿ Ͽ  X ƴѰ, ε Ͱ  о.
// (Ȯ hierarchy   ޽ о.)
//
// [  Լ]
// vegcli3DMeshCreateFromFile()
//
// [    ]
// vegcli3DMeshCreateFromRes( lpInfo, IDR_XFILE_BIRD );
//
LPVEGMESHBUILDER
vegcli3DMeshCreateFromRes( LPVEGCLI3DINFO lpInfo, LPD3DRMLOADRESOURCE res )
{
	HRESULT					rval;
	LPVEG					lpD3DRM = lpInfo->lpD3DRM;
	LPVEGMESHBUILDER builder = NULL;

	glpInfo = lpInfo;
	ATTEMPT( rval = lpD3DRM->CreateMeshBuilder( &builder ) );
	ATTEMPT( rval = builder->Load( (LPVOID)res, NULL, D3DRMLOAD_FROMRESOURCE, LoadTextures, NULL ) );

	return builder;

generic_error:
	vegMsg( "Error in vegCliMeshCreateFromRes() - %s", DXErrorToString( rval ) );
	return NULL;
}

// [Լ  ]
// ܼ ޽ ȭ о  .
// ܼ ޽ Hierarchy animationŸ   ʴ
// ׾߸ ޽ Ÿ  ִ ȭ Ѵ.
//  conv3ds.exe   -m ɼǿ ؼ Ǵ ȭ ĪѴ.
// 1. X  о ޽ .
// 2.   .
// 3.  ϵ ޽ ӿ ΰ(AddVisual)Ѵ.
// 4.  ġ, Direction , Up ͸ Ѵ.
//
// [      ȯ]
//   ü 
//
// [      ]
// lpInfo   : LPVEGCLI3DINFO 
// lpParent : ڽ    θ  
// lpRef    : 3 󿡼  ǥ ϱ  δ.
//            Ϲ scene ´.
// pos      : 3  ǥ(null)
// d        :    
// u        :    
// filename : ޽Ͱ  ִ X
// pos null, (d,u) ÿ Ͽ null
//
// [      ]
// ޽θ   ƴ hierarchy  ִ ̶,
//  -mɼǿ Ͽ  X ƴѰ, ε Ͱ  о.
// (Ȯ hierarchy   ޽ о.)
//
// [  Լ]
// vegcli3DFrameCreateFromMeshRes()
//
// [    ]
// vegcli3DFrameCreateFromMeshFile( lpInfo, 
//									lpInfo->scene,
//									lpInfo->scene,
//									&pos, &d, &u, 
//									"bird.x" );
//
LPVEGFRAME
vegcli3DFrameCreateFromMeshFile( LPVEGCLI3DINFO lpInfo,
								 LPVEGFRAME lpParent,
								 LPVEGFRAME lpRef,
								 D3DVECTOR* pos, 
								 D3DVECTOR* d, 
								 D3DVECTOR* u,
								 LPCTSTR filename )
{
	HRESULT					rval;
	LPVEG					lpD3DRM = lpInfo->lpD3DRM;
	LPVEGFRAME				frame   = NULL;
	LPVEGMESHBUILDER		builder = NULL;

	builder = vegcli3DMeshCreateFromFile( lpInfo, filename );
	ATTEMPT( rval = lpD3DRM->CreateFrame( lpParent, &frame ) );
	ATTEMPT( rval = frame->AddVisual( builder ) );
	if( pos )
		ATTEMPT( rval = frame->SetPosition( lpRef, pos->x, pos->y, pos->z ) );
	if( d && u )
		ATTEMPT( rval = frame->SetOrientation( lpRef, d->x, d->y, d->y, u->x, u->y, u->z ) );
	RELEASE( builder );
	ATTEMPT( frame->Release() );		// AddVisual() COM ref count Ų.
										//  frame release() ѹ ȣ ʿ䰡 ִ.

	return frame;

generic_error:
	vegMsg( "Error in vegcli3DFrameCreateFromFile() - %s", DXErrorToString( rval ) );

	RELEASE( builder );
	RELEASE( frame );
	return NULL;
}

// [Լ  ]
// ܼ ޽͸ ҽ о  .
// ܼ ޽ Hierarchy animationŸ   ʴ
// ׾߸ ޽ Ÿ  ִ ȭ Ѵ.
//  conv3ds.exe   -m ɼǿ ؼ Ǵ ȭ ĪѴ.
// 1. X  о ޽ .
// 2.   .
// 3.  ϵ ޽ ӿ ΰ(AddVisual)Ѵ.
// 4.  ġ, Direction , Up ͸ Ѵ.
//
// [      ȯ]
//   ü 
//
// [      ]
// lpInfo   : LPVEGCLI3DINFO 
// lpParent : ڽ    θ  
// lpRef    : 3 󿡼  ǥ ϱ  δ.
//            Ϲ scene ´.
// pos      : 3  ǥ(null)
// d        :    
// u        :    
// lpRes	: ޽Ͱ  ִ  ҽ(Xĸ )
// pos null, (d,u) ÿ Ͽ null
//
// [      ]
// ޽θ   ƴ hierarchy  ִ ҽ,
//  -mɼǿ Ͽ  X ƴѰ, ε Ͱ  о.
// (Ȯ hierarchy   ޽ о.)
//
// [  Լ]
// vegcli3DFrameCreateFromMeshFile()
//
// [    ]
// vegcli3DFrameCreateFromMeshRes( lpInfo, 
//								   lpInfo->scene,
//								   lpInfo->scene,
//								   &pos, &d, &u, 
//								   IDR_XFILE_BIRD );
//
LPVEGFRAME
vegcli3DFrameCreateFromMeshRes( LPVEGCLI3DINFO lpInfo,
						     LPVEGFRAME lpParent,
						     LPVEGFRAME lpRef,
						     D3DVECTOR* pos, 
						     D3DVECTOR* d, 
						     D3DVECTOR* u,
						     LPD3DRMLOADRESOURCE lpRes )
{
	HRESULT					rval;
	LPVEG					lpD3DRM = lpInfo->lpD3DRM;
	LPVEGFRAME				frame   = NULL;
	LPVEGMESHBUILDER		builder = NULL;

	builder = vegcli3DMeshCreateFromRes( lpInfo, lpRes );
	ATTEMPT( rval = lpD3DRM->CreateFrame( lpParent, &frame ) );
	ATTEMPT( rval = frame->AddVisual( builder ) );
	if( pos )
		ATTEMPT( rval = frame->SetPosition( lpRef, pos->x, pos->y, pos->z ) );
	if( d && u )
		ATTEMPT( rval = frame->SetOrientation( lpRef, d->x, d->y, d->y, u->x, u->y, u->z ) );
	RELEASE( builder );
	ATTEMPT( frame->Release() );		// AddVisual() COM ref count Ų.
										//  frame release() ѹ ȣ ʿ䰡 ִ.
	return frame;

generic_error:
	vegMsg( "Error in vegcli3DFrameCreateFromRes() - %s", DXErrorToString( rval ) );

	RELEASE( builder );
	RELEASE( frame );
	return NULL;
}

// [Լ  ]
// ȭϿ д  ƴ  ޽ Ÿ   Ѵ.
//  DIRECT3DRMMESHBUILDERü Ͽ  Ѵ.
// 1.   .
// 2.  ϵ ־ ޽ ӿ ΰ(AddVisual)Ѵ.
// 3.  ġ, Direction , Up ͸ Ѵ.
//
// [      ȯ]
//   ü 
//
// [      ]
// lpInfo   : LPVEGCLI3DINFO 
// lpParent : ڽ    θ  
// lpRef    : 3 󿡼  ǥ ϱ  δ.
//            Ϲ scene ´.
// pos      : 3  ǥ(null)
// d        :    
// u        :    
// lpBuilder: DIRECT3DRMMESHBUILDERü 
// pos null, (d,u) ÿ Ͽ null
//
// [      ]
//
// [  Լ]
// vegcli3DMeshCreateFromFile()
//
// [    ]
// vegcli3DFrameCreateFromMesh( lpInfo,
//								lpInfo->scene,
//								lpInfo->scene,
//								&pos, &d, &u,
//								lpMesh );
//
LPVEGFRAME
vegcli3DFrameCreateFromMesh( LPVEGCLI3DINFO lpInfo,
						     LPVEGFRAME lpParent,
						     LPVEGFRAME lpRef,
						     D3DVECTOR* pos, 
						     D3DVECTOR* d, 
						     D3DVECTOR* u,
						     LPVEGMESHBUILDER lpBuilder )
{
	HRESULT			rval;
	LPVEG			lpD3DRM = lpInfo->lpD3DRM;
	LPVEGFRAME		frame   = NULL;

	ATTEMPT( rval = lpD3DRM->CreateFrame( lpParent, &frame ) );
	ATTEMPT( rval = frame->AddVisual( lpBuilder ) );
	if( pos )
		ATTEMPT( rval = frame->SetPosition( lpRef, pos->x, pos->y, pos->z ) );
	if( d && u )
		ATTEMPT( rval = frame->SetOrientation( lpRef, d->x, d->y, d->y, u->x, u->y, u->z ) );

	ATTEMPT( frame->Release() );		// AddVisual() COM ref count Ų.
										//  frame release() ѹ ȣ ʿ䰡 ִ.
	return frame;

generic_error:
	vegMsg( "Error in vegcli3DFrameCreateFromMesh() - %s", DXErrorToString( rval ) );

	RELEASE( frame );
	return NULL;
}

// [Լ  ]
// ִϸ̼ Ÿ ִ ޽ ȭ оδ.
//  conv3ds.exe   -A ɼǿ ؼ Ǵ ȭ ĪѴ.
// 1.   .
// 2. DIRECT3DRMANIMATIONSETü Ѵ.
// 3.  DIRECT3DRMANIMATIONSETü Ͽ ִϸ̼   Ѵ.
//
// [      ȯ]
//   ü 
//
// [      ]
// lpInfo   : LPVEGCLI3DINFO 
// lpParent : ڽ    θ  
// filename : о X 
//
// [      ]
// ݵ conv3ds -Aɼǿ Ͽ  ̾ Ѵ.
//
// [  Լ]
// vegcli3DFrameHierCreateFromAnimeFile()
//
// [    ]
// vegcli3DFrameHierCreateFromAnimeFile( lpInfo,
//										 lpInfo->scene,
//										 "bird_fly.x" );
//
LPVEGFRAME
vegcli3DFrameHierCreateFromAnimeFile( LPVEGCLI3DINFO lpInfo, LPVEGFRAME lpParent, LPCTSTR filename )
{
	HRESULT						rval;
	LPVEGANIMATIONSET	lpAnimSet;
	LPVEGFRAME			lpFrame;

	glpInfo = lpInfo;
	ATTEMPT( rval = lpInfo->lpD3DRM->CreateFrame( lpParent, &lpFrame ) );
	ATTEMPT( rval = lpInfo->lpD3DRM->CreateAnimationSet( &lpAnimSet ) );
	lpInfo->animationSet = lpAnimSet;

	ATTEMPT( rval = lpAnimSet->Load( (LPVOID)filename, NULL, 
									 D3DRMLOAD_FROMFILE, LoadTextures,
									 NULL, lpFrame ) );

	return lpFrame;

generic_error:
	vegMsg( "Error in vegcli3DFrameHierCreateFromAnimeFile() - %s", DXErrorToString( rval ) );
	return NULL;
}

// [Լ  ]
// ִϸ̼ Ÿ ִ ޽ ȭ оδ.
//  conv3ds.exe   -A ɼǿ ؼ Ǵ ȭ ĪѴ.
//  ҽ оδٴ 븸 ٸ.
// 1.   .
// 2. DIRECT3DRMANIMATIONSETü Ѵ.
// 3.  DIRECT3DRMANIMATIONSETü Ͽ ִϸ̼   Ѵ.
//
// [      ȯ]
//   ü 
//
// [      ]
// lpInfo   : LPVEGCLI3DINFO 
// lpParent : ڽ    θ  
// lpRes	: ޽ ִϸ̼ Ͱ  ִ  ҽ(Xĸ )
//
// [      ]
// ݵ conv3ds -Aɼǿ Ͽ  ̾ Ѵ.
//
// [  Լ]
// vegcli3DFrameHierCreateFromAnimeRes()
//
// [    ]
// vegcli3DFrameHierCreateFromAnimeRes( lpInfo,
//										lpInfo->scene,
//										IDR_XFILE_BIRDFLY );
//
LPVEGFRAME
vegcli3DFrameHierCreateFromAnimeRes( LPVEGCLI3DINFO lpInfo, LPVEGFRAME lpParent, LPD3DRMLOADRESOURCE lpRes )
{
	HRESULT						rval;
	LPVEGANIMATIONSET	lpAnimSet;
	LPVEGFRAME			lpFrame;

	glpInfo = lpInfo;
	ATTEMPT( rval = lpInfo->lpD3DRM->CreateFrame( lpParent, &lpFrame ) );
	ATTEMPT( rval = lpInfo->lpD3DRM->CreateAnimationSet( &lpAnimSet ) );
	lpInfo->animationSet = lpAnimSet;

	ATTEMPT( rval = lpAnimSet->Load( (LPVOID)lpRes, NULL, 
									 D3DRMLOAD_FROMRESOURCE, LoadTextures,
									 NULL, lpFrame ) );

	return lpFrame;

generic_error:
	vegMsg( "Error in vegcli3DFrameHierCreateFromAnimeRes() - %s", DXErrorToString( rval ) );
	return NULL;
}

// [Լ  ]
// ִϸ̼ Ÿ  ʰ, Ӱ  θ ڽ 
// hierarchy()    Լ о Ѵ.
//  conv3ds.exe ϵ, -m̳ -Aɼ  ¿ ؾ Ѵ.
//
// [      ȯ]
//   ü 
//
// [      ]
// lpInfo   : LPVEGCLI3DINFO 
// lpParent : ڽ    θ  
// lpRes	: ޽ ִϸ̼ Ͱ  ִ  ҽ(Xĸ )
//
// [      ]
// ݵ conv3ds -A -mɼ   ̾ Ѵ.
//
// [  Լ]
// vegcli3DFrameHierCreateFromFrameRes()
//
// [    ]
// vegcli3DFrameHierCreateFromFrameFile( lpInfo,
//										 lpInfo->scene,
//										 "bird_hierarchy.x");
//
LPVEGFRAME
vegcli3DFrameHierCreateFromFrameFile( LPVEGCLI3DINFO lpInfo, LPVEGFRAME lpParent, LPCTSTR filename )
{
	HRESULT						rval;
	LPVEGFRAME			lpFrame;
  
	glpInfo = lpInfo;
	ATTEMPT( rval = lpInfo->lpD3DRM->CreateFrame( lpParent, &lpFrame ) );
	ATTEMPT( rval = lpFrame->Load( (LPVOID)filename, NULL, D3DRMLOAD_FROMFILE, LoadTextures, NULL ) );
	
  	return lpFrame;

generic_error:
	vegMsg( "Error in vegcli3DFrameHierCreateFromFrameFile() - %s", DXErrorToString( rval ) );
	return NULL;
}

// [Լ  ]
// ִϸ̼ Ÿ  ʰ, Ӱ  θ ڽ 
// hierarchy()    Լ о Ѵ.
//  conv3ds.exe ϵ, -m̳ -Aɼ  ¿ ؾ Ѵ.
//  ҽ оδٴ 븸 ٸ.
//
// [      ȯ]
//   ü 
//
// [      ]
// lpInfo   : LPVEGCLI3DINFO 
// lpParent : ڽ    θ  
// lpRes	: ޽ ִϸ̼ Ͱ  ִ  ҽ(Xĸ )
//
// [      ]
// ޽θ   ƴ hierarchy  ִ ҽ,
//  -mɼǿ Ͽ  X ƴѰ, ε Ͱ  о.
// (Ȯ hierarchy   ޽ о.)
//
// [  Լ]
// vegcli3DFrameHierCreateFromFrameFile()
//
// [    ]
// vegcli3DFrameHierCreateFromFrameRes( lpInfo,
//										lpInfo->scene,
//										IDR_XFILE_BIRD_HIERARCHY );
//
LPVEGFRAME
vegcli3DFrameHierCreateFromFrameRes( LPVEGCLI3DINFO lpInfo, LPVEGFRAME lpParent, LPD3DRMLOADRESOURCE lpRes )
{
	HRESULT						rval;
	LPVEGFRAME			lpFrame;
  
	glpInfo = lpInfo;
	ATTEMPT( rval = lpInfo->lpD3DRM->CreateFrame( lpParent, &lpFrame ) );
	ATTEMPT( rval = lpFrame->Load( (LPVOID)lpRes, NULL, D3DRMLOAD_FROMRESOURCE, LoadTextures, NULL ) );
	
  	return lpFrame;

generic_error:
	vegMsg( "Error in vegcli3DFrameHierCreateFromFrameRes() - %s", DXErrorToString( rval ) );
	return NULL;
}

// [Լ  ]
// ƹ͵ .   ü .
//  ӿ , ޽, ƹ͵ . ġ  ʾҴ.
//
// [      ȯ]
//   ü 
//
// [      ]
// lpInfo   : LPVEGCLI3DINFO 
// lpParent : ڽ    θ  
//
// [      ]
//
// [  Լ]
// vegcli3DFrameDestroy()
//
// [    ]
// vegcli3DFrameCreate( lpInfo, lpInfo->scene );
//
LPVEGFRAME
vegcli3DFrameCreate( LPVEGCLI3DINFO lpInfo, LPVEGFRAME lpParent )
{
	HRESULT			rval;
	LPVEG			lpD3DRM = lpInfo->lpD3DRM;
	LPVEGFRAME		frame   = NULL;

	ATTEMPT( rval = lpD3DRM->CreateFrame( lpParent, &frame ) );

	return frame;

generic_error:
	vegMsg( "Error in vegcli3DFrameCreate() - %s", DXErrorToString( rval ) );

	RELEASE( frame );
	return NULL;
}

// [Լ  ]
// Ǿ ִ  ü Ѵ.
//
// [      ȯ]
//    TRUE
//    FALSE ȯѴ.
//
// [      ]
// lpFrame :  
//
// [      ]
// 翬 ̰, ش  Ǹ, ׿  ڽ 
// (child frame)鵵 Բ ȴ.
//
// [  Լ]
//
// [    ]
// vegcli3DFrameCreate( lpInfo, lpInfo->scene );
//
BOOL
vegcli3DFrameDestroy( LPVEGFRAME lpFrame )
{
	HRESULT			rval;
    LPVEGFRAME		lpParent;

    ATTEMPT( rval = lpFrame->GetParent( &lpParent ) );
    ATTEMPT( rval = lpParent->DeleteChild( lpFrame ) );
	ATTEMPT( rval = lpParent->Release() );
	return TRUE;

generic_error:
	vegMsg( "Error in vegcli3DFrameDestroy() - %s", DXErrorToString( rval ) );
	return FALSE;
}

//////////////////////////////////////////////////////////////////////////////////////////////
//
// Frame Set
// Position, Orientation, Rotation, Velocity 
//
//////////////////////////////////////////////////////////////////////////////////////////////

// [Լ  ]
// ־  ־ ġ ̵Ѵ.
//  ǥ 3 ǥ̴.
//
// [      ȯ]
//    TRUE
// ̵   FALSE ȯѴ. (κ lpFrame null 찡 .)
//
// [      ]
// lpFrame	: ̵ 
// lpRef    : 3 󿡼  ǥ ϱ  δ.
//            Ϲ scene ´.
// pos		: D3DVECTOR 
//
// [      ]
// lpFrame null  ʵ Ѵ.
// pos ̹Ƿ μ ѱ涧 ͷ Ѱܾ Ѵ.
//
// [  Լ]
// vegcli3DFrameGetPos()
//
// [    ]
// pos.x = D3DVAL( 0.0 );
// pos.y = D3DVAL( 0.0 );
// pos.z = D3DVAL( 0.0 );
// vegcli3DFrameSetPos( lpFrame, lpInfo->scene, &pos ); ->  ǥ (0,0,0) ̵
//
BOOL
vegcli3DFrameSetPos( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVECTOR *lpPos )
{
	HRESULT	rval;

	ATTEMPT( rval = lpFrame->SetPosition( lpRef, lpPos->x, lpPos->y, lpPos->z ) );
	return TRUE;

generic_error:
	vegMsg( "Error in vegcli3DFrameSetPos() - %s", DXErrorToString( rval ) );
	return FALSE;
}

// [Լ  ]
// ־   ǥ ´.
//  ǥ 3 ǥ̴.
//
// [      ȯ]
//  ǥ   TRUE
//   FALSE ȯѴ.(κ lpFrame null 찡 .)
//
// [      ]
// lpFrame	: ̵ 
// lpRef    : 3 󿡼  ǥ ϱ  δ.
//            Ϲ scene ´.
// pos		: D3DVECTOR 
//
// [      ]
// lpFrame null  ʵ Ѵ.
// pos ̹Ƿ μ ѱ涧 ͷ Ѱܾ Ѵ.
//
// [  Լ]
// vegcli3DFrameSetPos()
//
// [    ]
// D3DVECTOR	pos;
//
// vegcli3DFrameGetPos( lpFrame, lpInfo->scene, &pos ); ->   ǥ pos ´.
//
BOOL
vegcli3DFrameGetPos( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVECTOR *lpPos )
{
	HRESULT	rval;

	ATTEMPT( rval = lpFrame->GetPosition( lpRef, lpPos ) );
	return TRUE;

generic_error:
	vegMsg( "Error in vegcli3DFrameGetPos() - %s", DXErrorToString( rval ) );
	return FALSE;
}

// [Լ  ]
//  ӿ ⺤(direction vector) 溤(up vector) Ѵ.
// ⺻ ⺤ʹ [0,0,1] 溤ʹ[0,1,0]  ´.
// ̷ , 溤͸ ־  ִ   Լ̴.
//
// [      ȯ]
//  ǥ   TRUE
//   FALSE ȯѴ.(κ lpFrame null 찡 .)
//
// [      ]
// lpFrame	:   
// lpRef    : 3 󿡼  ǥ ϱ  δ.
//            Ϲ scene ´.
// d		:  , D3DVECTOR 
// u		:  , D3DVECTOR 
//
// [      ]
// lpFrame null  ʵ Ѵ.
// d, u ̹Ƿ μ ѱ涧 ͷ Ѱܾ Ѵ.
//
// [  Լ]
// vegcli3DFrameGetOrg()
//
// [    ]
// vegcli3DFrameSetOrg( lpFrame, lpInfo->scene, &dir, &up );
//
BOOL
vegcli3DFrameSetOrg( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVECTOR *d, D3DVECTOR *u )
{
	HRESULT	rval;

	ATTEMPT( rval = lpFrame->SetOrientation( lpRef, d->x, d->y, d->z, u->x, u->y, u->z ) );
	return TRUE;

generic_error:
	vegMsg( "Error in vegcli3DFrameSetOrg() - %s", DXErrorToString( rval ) );
	return FALSE;
}

// [Լ  ]
//   ⺤Ϳ 溤  ´.
//
// [      ȯ]
//  ǥ   TRUE
//   FALSE ȯѴ.(κ lpFrame null 찡 .)
//
// [      ]
// lpFrame	:   
// lpRef    : 3 󿡼  ǥ ϱ  δ.
//            Ϲ scene ´.
// d		:  , D3DVECTOR 
// u		:  , D3DVECTOR 
//
// [      ]
// lpFrame null  ʵ Ѵ.
// d, u ̹Ƿ μ ѱ涧 ͷ Ѱܾ Ѵ.
//
// [  Լ]
// vegcli3DFrameSetPos()
//
// [    ]
// D3DVECTOR	dir, up;
//
// vegcli3DFrameGetOrg( lpFrame, lpInfo->scene, &dir, &up ); ->   ǥ pos ´.
//
BOOL
vegcli3DFrameGetOrg( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVECTOR *d, D3DVECTOR *u )
{
	HRESULT	rval;

	ATTEMPT( rval = lpFrame->GetOrientation( lpRef, d, u ) );
	return TRUE;

generic_error:
	vegMsg( "Error in vegcli3DFrameGetOrg() - %s", DXErrorToString( rval ) );
	return FALSE;
}

// [Լ  ]
// rot ͸ ȸ Ͽ  theta  ŭ ȸѴ.
// Լ  vegcli3DRender() ȣ  thetaŭ ȸ ϾǷ
//  ȸ ִϸ̼   ִ.
//
// [      ȯ]
//    TRUE
//   FALSE ȯѴ.(κ lpFrame null 찡 .)
//
// [      ]
// lpFrame	:   
// lpRef    : 3 󿡼  ǥ ϱ  δ.
//            Ϲ scene ´.
// rot		: ȸ  
// theta	: ȸ  ,  ̴.
//
// [      ]
// lpFrame null  ʵ Ѵ.
// theta D3DVAL( 0.0 ) ָ ȸ   ִ.
//
// [  Լ]
// vegcli3DFrameGetRotation(), vegcli3DFrameAddRotation()
//
// [    ]
// D3DVECTOR	axis;
//
// axis.x = D3DVAL( 0 );
// axis.y = D3DVAL( 1 );
// axis.z = D3DVAL( 0 );
// vegcli3DFrameSetRotation( lpFrame, lpInfo->scene, &axis, D3DVAL( 0.1 ) ); -> y ߽ ȸ
//
BOOL
vegcli3DFrameSetRotation( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVECTOR *rot, D3DVALUE theta )
{
	HRESULT	rval;

	ATTEMPT( rval = lpFrame->SetRotation(lpRef, rot->x, rot->y, rot->z, theta ) );
	return TRUE;

generic_error:
	vegMsg( "Error in vegcli3DFrameSetRotation() - %s", DXErrorToString( rval ) );
	return FALSE;
}

// [Լ  ]
// rot ͸ ȸ Ͽ  theta  ŭ ȸѴ.
//  Լ ٸ,  ѹ ȸŲٴ ̴.
//
// [      ȯ]
//    TRUE
//   FALSE ȯѴ.(κ lpFrame null 찡 .)
//
// [      ]
// lpFrame	  :   
// rctCombine : D3DRMCOMBINE_REPLACE, D3DRMCOMBINE_BEFORE, D3DRMCOMBINE_AFTER 3 
// rot		  : ȸ  
// theta	  : ȸ  ,  ̴.
//
// [      ]
// lpFrame null  ʵ Ѵ.
// theta D3DVAL( 0.0 ) ָ ȸ   ִ.
//
// [  Լ]
// vegcli3DFrameSetRotation(), vegcli3DFrameGetRotation()
//
// [    ]
// D3DVECTOR	axis;
//
// axis.x = D3DVAL( 0 );
// axis.y = D3DVAL( 1 );
// axis.z = D3DVAL( 0 );
// vegcli3DFrameAddRotation( lpFrame, lpInfo->scene, &axis, D3DVAL( 0.1 ) ); -> y ߽ ȸ
//
BOOL
vegcli3DFrameAddRotation( LPVEGFRAME lpFrame, D3DRMCOMBINETYPE rctCombine, D3DVECTOR *rot, D3DVALUE theta )
{
	HRESULT	rval;

	ATTEMPT( rval = lpFrame->AddRotation( rctCombine, rot->x, rot->y, rot->z, theta ) );
	return TRUE;

generic_error:
	vegMsg( "Error in vegcli3DFrameAddRotation() - %s", DXErrorToString( rval ) );
	return FALSE;
}

// [Լ  ]
// SetRotation() Ǿ ִ ȸ  ´.
//
// [      ȯ]
//    TRUE
//   FALSE ȯѴ.(κ lpFrame null 찡 .)
//
// [      ]
// lpFrame	:   
// lpRef    : 3 󿡼  ǥ ϱ  δ.
//            Ϲ scene ´.
// rot		: ȸ  
// theta	: ȸ  ,  ̴.
//
// [      ]
// lpFrame null  ʵ Ѵ.
// theta D3DVAL( 0.0 ) ָ ȸ   ִ.
//
// [  Լ]
// vegcli3DFrameSetRotation(), vegcli3DFrameAddRotation()
//
// [    ]
// D3DVECTOR	axis;
//
// axis.x = D3DVAL( 0 );
// axis.y = D3DVAL( 1 );
// axis.z = D3DVAL( 0 );
// vegcli3DFrameGetRotation( lpFrame, lpInfo->scene, &axis, D3DVAL( 0.1 ) ); -> y ߽ ȸ
//
BOOL
vegcli3DFrameGetRotation( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVECTOR *rot, D3DVALUE *theta )
{
	HRESULT	rval;

	ATTEMPT( rval = lpFrame->GetRotation( lpRef, rot, theta ) );
	return TRUE;

generic_error:
	vegMsg( "Error in vegcli3DFrameGetRotation() - %s", DXErrorToString( rval ) );
	return FALSE;
}

BOOL
vegcli3DFrameSetVelocity( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVECTOR *vel, BOOL fRotVel )
{
	HRESULT	rval;

	ATTEMPT( rval = lpFrame->SetVelocity( lpRef, vel->x, vel->y, vel->z, fRotVel ) );
	return TRUE;
	
generic_error:
	vegMsg( "Error in vegcli3DFrameSetVelocity() - %s", DXErrorToString( rval ) );
	return FALSE;
}

BOOL
vegcli3DFrameGetVelocity( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVECTOR *vel, BOOL fRotVel )
{
	HRESULT	rval;

	ATTEMPT( rval = lpFrame->GetVelocity( lpRef, vel, fRotVel ) );
	return TRUE;

generic_error:
	vegMsg( "Error in vegcli3DFrameGetVelocity() - %s", DXErrorToString( rval ) );
	return FALSE;
}

//  Լ  D3DRMCOMBINE_REPLACE µ,
//  D3DRMCOMBINE_REPLACE, D3DRMCOMBINE_BEFORE, D3DRMCOMBINE_AFTER 3 ִ.
// غ 迡 ϸ BEFORE    ü matrix ȭŰ,
// AFTER   ڽ ȭŲ. REPLACE ߸𸣰ڰ... ư, 3 ڲ
//  ڽ ϴ  ãƾ Ѵ.
// vegcli3DFrameGetScaleԼ .
BOOL
vegcli3DFrameSetScale( LPVEGFRAME lpFrame, D3DVALUE x, D3DVALUE y, D3DVALUE z )
{
	HRESULT	rval;

	ATTEMPT( rval = lpFrame->AddScale(D3DRMCOMBINE_REPLACE, x, y, z ) );
	return TRUE;

generic_error:
	vegMsg( "Error in vegcli3DFrameSetScale() - %s", DXErrorToString( rval ) );
	return FALSE;
}

//////////////////////////////////////////////////////////////////////////////////////////////
//
// Frame
//  ̵
//   Լ  Navi迭 Լ  ̿ϸ
// 3D Walkthru  ս ȴ.
//
//////////////////////////////////////////////////////////////////////////////////////////////

//lpFrame thetaŭ front ̵
BOOL
vegcli3DFrameMoveFront( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta )
{
	D3DVECTOR	pos, d, u, t1, t2;

	vegcli3DFrameGetOrg( lpFrame, lpRef, &d, &u );
	D3DRMVectorNormalize( &d );
	D3DRMVectorScale( &t1, &d, theta );
	vegcli3DFrameGetPos( lpFrame, lpRef, &t2  );
	D3DRMVectorAdd( &pos, &t2, &t1 );
	vegcli3DFrameSetPos( lpFrame, lpRef, &pos  );

	return TRUE;
}

//lpFrame thetaŭ back ̵
BOOL
vegcli3DFrameMoveBack( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta )
{
	D3DVECTOR	pos, d, u, t1, t2;

	vegcli3DFrameGetOrg( lpFrame, lpRef, &d, &u );
	D3DRMVectorNormalize( &d );
	D3DRMVectorScale( &t1, &d, theta );
	vegcli3DFrameGetPos( lpFrame, lpRef, &t2  );
	D3DRMVectorSubtract( &pos, &t2, &t1 );
	vegcli3DFrameSetPos( lpFrame, lpRef, &pos  );

	return TRUE;
}

//lpFrame thetaŭ up ̵
BOOL
vegcli3DFrameMoveUp( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta )
{
	D3DVECTOR	pos, d, u, t1, t2;

	vegcli3DFrameGetOrg( lpFrame, lpRef, &d, &u );
	D3DRMVectorNormalize( &u );
	D3DRMVectorScale( &t1, &u, theta );
	vegcli3DFrameGetPos( lpFrame, lpRef, &t2  );
	D3DRMVectorAdd( &pos, &t2, &t1 );
	vegcli3DFrameSetPos( lpFrame, lpRef, &pos  );

	return TRUE;
}

//lpFrame thetaŭ down ̵
BOOL
vegcli3DFrameMoveDown( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta )
{
	D3DVECTOR	pos, d, u, t1, t2;

	vegcli3DFrameGetOrg( lpFrame, lpRef, &d, &u );
	D3DRMVectorNormalize( &u );
	D3DRMVectorScale( &t1, &u, theta );
	vegcli3DFrameGetPos( lpFrame, lpRef, &t2  );
	D3DRMVectorSubtract( &pos, &t2, &t1 );
	vegcli3DFrameSetPos( lpFrame, lpRef, &pos  );

	return TRUE;
}

//lpFrame thetaŭ left ̵
BOOL
vegcli3DFrameMoveLeft( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta )
{
	D3DVECTOR	pos, d, u, t1, t2, t3;

	vegcli3DFrameGetOrg( lpFrame, lpRef, &d, &u );
	D3DRMVectorCrossProduct( &t1, &d, &u );
	D3DRMVectorNormalize( &t1 );
	D3DRMVectorScale( &t2, &t1, theta );
	lpFrame->GetPosition( lpRef, &t3 );
	D3DRMVectorAdd( &pos, &t3, &t2 );
	vegcli3DFrameSetPos( lpFrame, lpRef, &pos  );

	return TRUE;
}

//lpFrame thetaŭ right ̵
BOOL
vegcli3DFrameMoveRight( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta )
{
	D3DVECTOR	pos, d, u, t1, t2, t3;

	vegcli3DFrameGetOrg( lpFrame, lpRef, &d, &u );
	D3DRMVectorCrossProduct( &t1, &d, &u );
	D3DRMVectorNormalize( &t1 );
	D3DRMVectorScale( &t2, &t1, theta );
	lpFrame->GetPosition( lpRef, &t3 );
	D3DRMVectorSubtract( &pos, &t3, &t2 );
	vegcli3DFrameSetPos( lpFrame, lpRef, &pos  );

	return TRUE;
}

//lpFrame thetaŭ left ȸ
BOOL
vegcli3DFrameTurnLeft( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta )
{
	HRESULT		rval;
	D3DVECTOR	d, u;

	vegcli3DFrameGetOrg( lpFrame, lpRef, &d, &u );

	rval = 
	lpFrame->AddRotation( D3DRMCOMBINE_BEFORE,
						  u.x,
						  u.y,
						  u.z,
						  -theta );
	if( D3DRM_OK != rval )
	{
		vegMsg( "Error in vegcli3DFrameTurnLeft() - %s", DXErrorToString( rval ) );
		return FALSE;
	}

	return TRUE;
}

//lpFrame thetaŭ right ȸ
BOOL
vegcli3DFrameTurnRight( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta )
{
	HRESULT		rval;
	D3DVECTOR	d, u;

	vegcli3DFrameGetOrg( lpFrame, lpRef, &d, &u );

	rval = 
	lpFrame->AddRotation( D3DRMCOMBINE_BEFORE,
						  u.x,
						  u.y,
						  u.z,
						  theta );
	if( D3DRM_OK != rval )
	{
		vegMsg( "Error in vegcli3DFrameTurnRight() - %s", DXErrorToString( rval ) );
		return FALSE;
	}

	return TRUE;
}

//lpFrame thetaŭ up ȸ
BOOL
vegcli3DFrameTurnUp( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta )
{
	HRESULT		rval;
	D3DVECTOR	d, u, t;

	vegcli3DFrameGetOrg( lpFrame, lpRef, &d, &u );
	D3DRMVectorCrossProduct( &t, &d, &u );
	
	rval = 
	lpFrame->AddRotation( D3DRMCOMBINE_BEFORE,
						  t.x,
						  t.y,
						  t.z,
						  theta );
	if( D3DRM_OK != rval )
	{
		vegMsg( "Error in vegcli3DFrameTurnUp() - %s", DXErrorToString( rval ) );
		return FALSE;
	}

	return TRUE;
}

//lpFrame thetaŭ down ȸ
BOOL
vegcli3DFrameTurnDown( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta )
{
	HRESULT		rval;
	D3DVECTOR	d, u, t;

	vegcli3DFrameGetOrg( lpFrame, lpRef, &d, &u );
	D3DRMVectorCrossProduct( &t, &d, &u );

	rval = 
	lpFrame->AddRotation( D3DRMCOMBINE_BEFORE,
						  t.x,
						  t.y,
						  t.z,
						  -theta );
	if( D3DRM_OK != rval )
	{
		vegMsg( "Error in vegcli3DFrameTurnDown() - %s", DXErrorToString( rval ) );
		return FALSE;
	}

	return TRUE;
}

//lpFrame thetaŭ left (å   ѱٰ ϸ ȴ.)
BOOL
vegcli3DFrameRollLeft( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta )
{
	HRESULT		rval;
	D3DVECTOR	d, u;

	vegcli3DFrameGetOrg( lpFrame, lpRef, &d, &u );

	rval = 
	lpFrame->AddRotation( D3DRMCOMBINE_BEFORE,
						  d.x,
						  d.y,
						  d.z,
						  theta );
	if( D3DRM_OK != rval )
	{
		vegMsg( "Error in vegcli3DFrameRollLeft() - %s", DXErrorToString( rval ) );
		return FALSE;
	}

	return TRUE;
}

//lpFrame thetaŭ right (å   ѱٰ ϸ ȴ.)
BOOL
vegcli3DFrameRollRight( LPVEGFRAME lpFrame, LPVEGFRAME lpRef, D3DVALUE theta )
{
	HRESULT		rval;
	D3DVECTOR	d, u;

	vegcli3DFrameGetOrg( lpFrame, lpRef, &d, &u );

	rval = 
	lpFrame->AddRotation( D3DRMCOMBINE_BEFORE,
						  d.x,
						  d.y,
						  d.z,
						  -theta );

	if( D3DRM_OK != rval )
	{
		vegMsg( "Error in vegcli3DFrameRollRight() - %s", DXErrorToString( rval ) );
		return FALSE;
	}

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////////////////
//
// Walk thru == Navigate
//
//////////////////////////////////////////////////////////////////////////////////////////////

// ī޶ thetaŭ front ̵
BOOL
vegcli3DNaviMoveFront( LPVEGCLI3DINFO lpInfo, D3DVALUE theta )
{
	return vegcli3DFrameMoveFront( lpInfo->camera, lpInfo->scene, theta );
}

// ī޶ thetaŭ back ̵
BOOL
vegcli3DNaviMoveBack( LPVEGCLI3DINFO lpInfo, D3DVALUE theta )
{
	return vegcli3DFrameMoveBack( lpInfo->camera, lpInfo->scene, theta );
}

// ī޶ thetaŭ up ̵
BOOL
vegcli3DNaviMoveUp( LPVEGCLI3DINFO lpInfo, D3DVALUE theta )
{
	return vegcli3DFrameMoveUp( lpInfo->camera, lpInfo->scene, theta );
}

// ī޶ thetaŭ down ̵
BOOL
vegcli3DNaviMoveDown( LPVEGCLI3DINFO lpInfo, D3DVALUE theta )
{
	return vegcli3DFrameMoveDown( lpInfo->camera, lpInfo->scene, theta );
}

// ī޶ thetaŭ left ̵
BOOL
vegcli3DNaviMoveLeft( LPVEGCLI3DINFO lpInfo, D3DVALUE theta )
{
	return vegcli3DFrameMoveLeft( lpInfo->camera, lpInfo->scene, theta );
}

// ī޶ thetaŭ right ̵
BOOL
vegcli3DNaviMoveRight( LPVEGCLI3DINFO lpInfo, D3DVALUE theta )
{
	return vegcli3DFrameMoveRight( lpInfo->camera, lpInfo->scene, theta );
}

// ī޶ thetaŭ left ȸ
BOOL
vegcli3DNaviTurnLeft( LPVEGCLI3DINFO lpInfo, D3DVALUE theta )
{
	return vegcli3DFrameTurnLeft( lpInfo->camera, lpInfo->scene, theta );
}

// ī޶ thetaŭ right ȸ
BOOL
vegcli3DNaviTurnRight( LPVEGCLI3DINFO lpInfo, D3DVALUE theta )
{
	return vegcli3DFrameTurnRight( lpInfo->camera, lpInfo->scene, theta );
}

// ī޶ thetaŭ up ȸ
BOOL
vegcli3DNaviTurnUp( LPVEGCLI3DINFO lpInfo, D3DVALUE theta )
{
	return vegcli3DFrameTurnUp( lpInfo->camera, lpInfo->scene, theta );
}

// ī޶ thetaŭ down ȸ
BOOL
vegcli3DNaviTurnDown( LPVEGCLI3DINFO lpInfo, D3DVALUE theta )
{
	return vegcli3DFrameTurnDown( lpInfo->camera, lpInfo->scene, theta );
}

// ī޶ thetaŭ left (å   ѱٰ ϸ ȴ.)
BOOL
vegcli3DNaviRollLeft( LPVEGCLI3DINFO lpInfo, D3DVALUE theta )
{
	return vegcli3DFrameRollLeft( lpInfo->camera, lpInfo->scene, theta );
}

// ī޶ thetaŭ right (å   ѱٰ ϸ ȴ.)
BOOL
vegcli3DNaviRollRight( LPVEGCLI3DINFO lpInfo, D3DVALUE theta )
{
	return vegcli3DFrameRollRight( lpInfo->camera, lpInfo->scene, theta );
}

//////////////////////////////////////////////////////////////////////////////////////////////
//
// Render
//
//////////////////////////////////////////////////////////////////////////////////////////////
//
// ȭ ͸Ͽ viewport Ѵ.
// ̶ frame rate Ͽ  ýۿ ° frame skip Ѵ.
//
BOOL 
vegcli3DRender( LPVEGCLI3DINFO lpInfo ) 
{
	HRESULT				rval;

	if( !lpInfo )
		return FALSE;

    // frame rate Ͽ frame skip ϱ  ƾ̴.
	if( !lpInfo->dwLastTime )
		lpInfo->dwLastTime = timeGetTime();

    lpInfo->dwCurTime	  = timeGetTime();
    lpInfo->dwDeltaTime = lpInfo->dwCurTime - lpInfo->dwLastTime;
    lpInfo->dwLastTime  = lpInfo->dwCurTime;
    lpInfo->dwFpsTime  += lpInfo->dwDeltaTime;

	lpInfo->dwFramesRendered++;

	if( lpInfo->vegDispMode == VEGCLI_DISPMODE_EXCLUSIVE )
	{
		DDBLTFX bltFx;
		ZeroMemory( &bltFx, sizeof(DDBLTFX) );

		bltFx.dwSize        = sizeof(DDBLTFX);
		bltFx.dwFillColor   = 0;

		lpInfo->lpDDSBack->Blt( NULL, NULL, NULL, DDBLT_WAIT | DDBLT_COLORFILL, &bltFx );
	}

    ATTEMPT( rval = lpInfo->scene->Move( D3DVAL(lpInfo->dwDeltaTime) ) );
    ATTEMPT( rval = lpInfo->view->Clear( D3DRMCLEAR_ALL ) );
    ATTEMPT( rval = lpInfo->view->Render( lpInfo->scene ) );
    ATTEMPT( rval = lpInfo->device->Update() );

	if( lpInfo->bDispFPS )
		vegcli3DFPSOut( lpInfo );

	if( lpInfo->vegDispMode == VEGCLI_DISPMODE_EXCLUSIVE )
	{
//		lpInfo->lpDDSBack->Unlock( NULL );
		ATTEMPT( rval = lpInfo->lpDDSPrimary->Flip( NULL,DDFLIP_WAIT ) );
	}
	
    return TRUE;

generic_error:
	vegMsg( "Error in vegcli3DRender() - %s", DXErrorToString( rval ) );

//	if( lpInfo->vegDispMode == VEGCLI_DISPMODE_EXCLUSIVE )
//		lpInfo->lpDDSBack->Unlock( NULL );

	return FALSE;
}

//////////////////////////////////////////////////////////////////////////////////////////////
//
// texture functions
//
//////////////////////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////////////////////
//
// Rendering quality
//
//////////////////////////////////////////////////////////////////////////////////////////////

// quality =
// D3DRMRENDER_WIREFRAME   (D3DRMSHADE_FLAT+D3DRMLIGHT_OFF+D3DRMFILL_WIREFRAME)
// D3DRMRENDER_UNLITFLAT   (D3DRMSHADE_FLAT+D3DRMLIGHT_OFF+D3DRMFILL_SOLID)
// D3DRMRENDER_FLAT        (D3DRMSHADE_FLAT+D3DRMLIGHT_ON+D3DRMFILL_SOLID)
// D3DRMRENDER_GOURAUD     (D3DRMSHADE_GOURAUD+D3DRMLIGHT_ON+D3DRMFILL_SOLID)
// D3DRMRENDER_PHONG       (D3DRMSHADE_PHONG+D3DRMLIGHT_ON+D3DRMFILL_SOLID)
// 
BOOL
vegcli3DQualitySet( LPVEGCLI3DINFO lpInfo, D3DRMRENDERQUALITY quality )
{
	HRESULT	rval;

    rval = lpInfo->device->SetQuality( quality );
    if (rval != D3DRM_OK) 
	{
        vegMsg( "Error in vegcli3DQualitySet() - %s", DXErrorToString(rval));
        return FALSE;
    }
    return TRUE;
}

D3DRMRENDERQUALITY
vegcli3DQualityGet( LPVEGCLI3DINFO lpInfo )
{
    return lpInfo->device->GetQuality();
}

/* lm =
 * D3DRMLIGHT_OFF	Lighting is off. 
 * D3DRMLIGHT_ON	Lighting is on. 
 * D3DRMLIGHT_MASK	Lighting uses a mask. 
 * D3DRMLIGHT_MAX	Maximum lighting mode. 
 */
BOOL
vegcli3DQualitySetLight( LPVEGCLI3DINFO lpInfo, D3DRMLIGHTMODE lm )
{
	HRESULT				rval;
    D3DRMRENDERQUALITY	quality = vegcli3DQualityGet( lpInfo );
 
	quality = (quality & ~D3DRMLIGHT_MASK) | lm;
    rval = vegcli3DQualitySet( lpInfo, quality );
    if (rval != TRUE) 
	{
        vegMsg( "Error in vegcli3DQualitySetLight() - %s", DXErrorToString(rval));
        return FALSE;
    }
    return TRUE;
}

// fm = 
// D3DRMFILL_POINTS		Fills points only; minimum fill mode. 
// D3DRMFILL_WIREFRAME	Fill wireframes. 
// D3DRMFILL_SOLID		Fill solid objects. 
// D3DRMFILL_MASK		Fill using a mask. 
// D3DRMFILL_MAX		Maximum value for fill mode. 
// 
BOOL
vegcli3DQualitySetFill( LPVEGCLI3DINFO lpInfo, D3DRMFILLMODE fm )
{
	HRESULT				rval;
    D3DRMRENDERQUALITY	quality = vegcli3DQualityGet( lpInfo );
 
	quality = (quality & ~D3DRMLIGHT_MASK) | fm;
    rval = vegcli3DQualitySet( lpInfo, quality );
    if (rval != TRUE) 
	{
        vegMsg( "Error in vegcli3DQualitySetFill() - %s", DXErrorToString(rval));
        return FALSE;
    }
    return TRUE;
}

// sm = 
// D3DRMSHADE_FLAT
// D3DRMSHADE_GOURAUD
// D3DRMSHADE_PHONG
// D3DRMSHADE_MASK
// D3DRMSHADE_MAX
// 
BOOL
vegcli3DQualitySetShade( LPVEGCLI3DINFO lpInfo, D3DRMSHADEMODE sm )
{
	HRESULT				rval;
    D3DRMRENDERQUALITY	quality = vegcli3DQualityGet( lpInfo );
 
	quality = (quality & ~D3DRMLIGHT_MASK) | sm;
    rval = vegcli3DQualitySet( lpInfo, quality );
    if (rval != TRUE) 
	{
        vegMsg( "Error in vegcli3DQualitySetShade() - %s", DXErrorToString(rval));
        return FALSE;
    }
    return TRUE;
}

/* tq = 
 * D3DRMTEXTURE_NEAREST				Choose the nearest pixel in the texture. 
 * D3DRMTEXTURE_LINEAR				Linearly interpolate the four nearest pixels. 
 * D3DRMTEXTURE_MIPNEAREST			Similar to D3DRMTEXTURE_NEAREST, but uses the appropriate mipmap instead of the texture. 
 * D3DRMTEXTURE_MIPLINEAR			Similar to D3DRMTEXTURE_LINEAR, but uses the appropriate mipmap instead of the texture. 
 * D3DRMTEXTURE_LINEARMIPNEAREST	Similar to D3DRMTEXTURE_MIPNEAREST, but interpolates between the two nearest mipmaps. 
 * D3DRMTEXTURE_LINEARMIPLINEAR		Similar to D3DRMTEXTURE_MIPLINEAR, but interpolates between the two nearest mipmaps. 
 */
BOOL
vegcli3DQualitySetTexture( LPVEGCLI3DINFO lpInfo, D3DRMTEXTUREQUALITY tq )
{
	HRESULT		rval;

	rval = lpInfo->device->SetTextureQuality( tq );
	if( rval != D3DRM_OK )
	{
        vegMsg( "Error in vegcli3DQualitySetTexture() - %s", DXErrorToString(rval));
		return FALSE;
	}

	return TRUE;
}

// flag = TRUE or FALSE
//
// 
BOOL
vegcli3DQualitySetDither( LPVEGCLI3DINFO lpInfo, BOOL flag )
{
	HRESULT		rval;

	rval = lpInfo->device->SetDither( flag );
	if( rval != D3DRM_OK )
	{
        vegMsg( "Error in vegcli3DQualitySetDither() - %s", DXErrorToString(rval));
		return FALSE;
	}

	return TRUE;
}

/* cm = 
 * D3DCOLOR_MONO	Use a monochromatic model (or ramp model). In this model, 
 *                  the blue component of a vertex color is used to define the 
 *					brightness of a lit vertex.
 * D3DCOLOR_RGB		Use a full RGB model. 
 * ϰ ϸ MONO 8bit÷ ̰,
 * RGB 24bit÷ ̴. ƴ, 32bit?
 * 򸮳...?!
 */
BOOL
vegcli3DQualitySetColormodel( LPVEGCLI3DINFO lpInfo, D3DRMCOLORMODEL cm )
{
    if ( lpInfo->colormodel == cm ) return TRUE;
	
	lpInfo->colormodel = cm;
    if (!vegcli3DRebuildDevice( lpInfo, lpInfo->device->GetWidth(), lpInfo->device->GetHeight()))
	{
        vegMsg( "Error in vegcli3DQualitySetColormodel()\n" );
        return FALSE;
	}

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////////////////
//
//  ̽ ̳, Ʈ  low level API
//
//////////////////////////////////////////////////////////////////////////////////////////////
LPGUID
vegcli3DFindDevice( LPVEGCLI3DINFO lpInfo, D3DCOLORMODEL cm, BOOL bSoftwareOnly )
{
    static
	D3DFINDDEVICERESULT		result;
    LPDIRECTDRAW			lpDD;
    LPDIRECT3D				lpD3D;
    D3DFINDDEVICESEARCH		search;
    HRESULT					error;
    HDC						hdc;
    int						bpp;

    hdc = GetDC(NULL);
    bpp = GetDeviceCaps(hdc, BITSPIXEL);
    ReleaseDC(NULL, hdc);

	if( lpInfo->vegDispMode == VEGCLI_DISPMODE_WINDOWED )
	{
		if (DirectDrawCreate(NULL, &lpDD, NULL))
			return NULL;
	}
	else
		lpDD = lpInfo->lpDD;


    if (lpDD->QueryInterface(IID_IDirect3D, (LPVOID *)&lpD3D)) 
	{
		if( lpInfo->vegDispMode == VEGCLI_DISPMODE_WINDOWED )
			lpDD->Release();

        return NULL;
    }
    
    memset(&search, 0, sizeof search);
    search.dwSize = sizeof search;
    search.dwFlags = D3DFDS_COLORMODEL;
    search.dcmColorModel = (cm == D3DCOLOR_MONO) ? D3DCOLOR_MONO : D3DCOLOR_RGB;
    if (bSoftwareOnly)
    {
		search.dwFlags |= D3DFDS_HARDWARE;
		search.bHardware = FALSE;
    }

    memset(&result, 0, sizeof result);
    result.dwSize = sizeof result;

    error = lpD3D->FindDevice(&search, &result);

    if (error == DD_OK)
	{
		/*
		 * If the device found is hardware but cannot support the current
		 * bit depth, then fall back to software rendering.
		 */
		if (result.ddHwDesc.dwFlags && !(result.ddHwDesc.dwDeviceRenderBitDepth & bppToddbd(bpp))) 
		{
			
			search.dwFlags |= D3DFDS_HARDWARE;
			search.bHardware = FALSE;
			memset(&result, 0, sizeof result);
			result.dwSize = sizeof result;
			error = lpD3D->FindDevice(&search, &result);
		}
    }

    lpD3D->Release();
	if( lpInfo->vegDispMode == VEGCLI_DISPMODE_WINDOWED )
		lpDD->Release();

    if (error)
	return NULL;
    else
	return &result.guid;
}

// MS ҽ ణ Ͽ ״  ִ.
// 
BOOL 
vegcli3DCreateDevice( LPVEGCLI3DINFO lpInfo, int cx, int cy, int bpp )
{
	HRESULT	rval;
   	HWND	hwnd = lpInfo->hwnd;
    HDC		hdc;
	
	LPVEG	lpD3DRM = lpInfo->lpD3DRM;

#ifdef VEGDEBUG
	fp = fopen( VEGCLI3DLOGFILE, "a+" );
	fprintf( fp, "vegcli3DCreateDevice() started\n" );
	fclose( fp );
#endif // VEGDEBUG

	if( lpInfo->vegDispMode == VEGCLI_DISPMODE_WINDOWED )
	{
		if( FAILED( lpD3DRM->CreateDeviceFromClipper( lpInfo->lpDDClipper, 
													  vegcli3DFindDevice( lpInfo, lpInfo->colormodel, FALSE ),
													  cx, cy, 
													  &lpInfo->device ) ) )
			if( FAILED( lpD3DRM->CreateDeviceFromClipper( lpInfo->lpDDClipper, 
														  vegcli3DFindDevice( lpInfo, lpInfo->colormodel, TRUE ),
														  cx, cy, 
														  &lpInfo->device ) ) )
				goto generic_error;
	}

	if( lpInfo->vegDispMode == VEGCLI_DISPMODE_EXCLUSIVE )
	{

		if( FAILED( lpD3DRM->CreateDeviceFromSurface( vegcli3DFindDevice( lpInfo, lpInfo->colormodel, FALSE ),
													  lpInfo->lpDD,
													  lpInfo->lpDDSBack,
													  0,
													  &lpInfo->device ) ) )
			if( FAILED( lpD3DRM->CreateDeviceFromSurface( vegcli3DFindDevice( lpInfo, lpInfo->colormodel, TRUE ),
														  lpInfo->lpDD,
														  lpInfo->lpDDSBack,
														  0,
														  &lpInfo->device ) ) )
				goto generic_error;
	}

    lpInfo->device->SetRenderMode(D3DRMRENDERMODE_BLENDEDTRANSPARENCY|D3DRMRENDERMODE_SORTEDTRANSPARENCY);

    hdc = GetDC( hwnd );
    bpp = GetDeviceCaps( hdc, BITSPIXEL );
    ReleaseDC( hwnd, hdc );
    switch ( bpp )
    {
		case 8:
			ATTEMPT( rval = lpInfo->device->SetShades(4) );
			ATTEMPT( rval = lpD3DRM->SetDefaultTextureShades(4) );
			break;

		case 16:
			ATTEMPT( rval = lpInfo->device->SetShades(32) );
			ATTEMPT( rval = lpD3DRM->SetDefaultTextureColors(64) );
			ATTEMPT( rval = lpD3DRM->SetDefaultTextureShades(16) );
			ATTEMPT( rval = lpInfo->device->SetDither(FALSE) );
			break;

		case 24:
		case 32:
			ATTEMPT( rval = lpInfo->device->SetShades(256) );
			ATTEMPT( rval = lpD3DRM->SetDefaultTextureColors(64) );
			ATTEMPT( rval = lpD3DRM->SetDefaultTextureShades(256) );
			ATTEMPT( rval = lpInfo->device->SetDither(FALSE) );
			break;

		default:
			ATTEMPT( rval = lpInfo->device->SetDither(FALSE) );
    }

    if ( !CreateSimpleScene( lpInfo ) )
        goto generic_error;

#ifdef VEGDEBUG
	fp = fopen( VEGCLI3DLOGFILE, "a+" );
	fprintf( fp, "vegcli3DCreateDevice() ended\n" );
	fclose( fp );
#endif // VEGDEBUG

    return TRUE;

generic_error:
    vegMsg( "Error in vegcli3DCreateDevice() - %s", DXErrorToString( rval ) );

#ifdef VEGDEBUG
	fp = fopen( VEGCLI3DLOGFILE, "a+" );
	fprintf( fp, "vegcli3DCreateDevice() failed\n" );
	fclose( fp );
#endif // VEGDEBUG

    return FALSE;
}

// MS ҽ ణ Ͽ ״  ִ.
//
// Regenerate the device if the color model changes or the window size
// changes.
// 
BOOL 
vegcli3DRebuildDevice( LPVEGCLI3DINFO lpInfo, int cx, int cy )
{
	HWND				hwnd = lpInfo->hwnd;
    HRESULT				rval;
    int					old_dither  = lpInfo->device->GetDither();
    D3DRMRENDERQUALITY	old_quality = lpInfo->device->GetQuality();
    int					old_shades  = lpInfo->device->GetShades();
	LPVEG				lpD3DRM = lpInfo->lpD3DRM;

    RELEASE(lpInfo->view);
    RELEASE(lpInfo->device);
	
	if( lpInfo->vegDispMode == VEGCLI_DISPMODE_WINDOWED )
	{
		if( FAILED( lpD3DRM->CreateDeviceFromClipper( lpInfo->lpDDClipper, 
													  vegcli3DFindDevice( lpInfo, lpInfo->colormodel, FALSE ),
													  cx, cy, 
													  &lpInfo->device ) ) )
			if( FAILED( lpD3DRM->CreateDeviceFromClipper( lpInfo->lpDDClipper, 
														  vegcli3DFindDevice( lpInfo, lpInfo->colormodel, TRUE ),
														  cx, cy, 
														  &lpInfo->device ) ) )
				goto generic_error;
	}

	if( lpInfo->vegDispMode == VEGCLI_DISPMODE_EXCLUSIVE )
	{

		if( FAILED( lpD3DRM->CreateDeviceFromSurface( vegcli3DFindDevice( lpInfo, lpInfo->colormodel, FALSE ),
													  lpInfo->lpDD,
													  lpInfo->lpDDSBack,
													  0,
													  &lpInfo->device ) ) )
			if( FAILED( lpD3DRM->CreateDeviceFromSurface( vegcli3DFindDevice( lpInfo, lpInfo->colormodel, TRUE ),
														  lpInfo->lpDD,
														  lpInfo->lpDDSBack,
														  0,
														  &lpInfo->device ) ) )
				goto generic_error;
	}

    lpInfo->device->SetRenderMode(D3DRMRENDERMODE_BLENDEDTRANSPARENCY|D3DRMRENDERMODE_SORTEDTRANSPARENCY);

    ATTEMPT( rval = lpInfo->device->SetDither( old_dither ) );
    ATTEMPT( rval = lpInfo->device->SetQuality( old_quality ) );
    ATTEMPT( rval = lpInfo->device->SetShades( old_shades ) );
    cx = lpInfo->device->GetWidth();
    cy = lpInfo->device->GetHeight();
    ATTEMPT( rval = lpInfo->lpD3DRM->CreateViewport( lpInfo->device, lpInfo->camera, 0, 0, cx, cy, &lpInfo->view));
    ATTEMPT( rval = lpInfo->view->SetBack( D3DVAL(SETBACK) ) );
    return TRUE;

generic_error:
    vegMsg( "Error in vegcli3DRebuildDevice() - %s", DXErrorToString( rval ));
    return FALSE;
}

// MS ҽ ణ Ͽ ״  ִ.
//
// Resize the viewport and device when the window size changes.
// 
BOOL 
vegcli3DResizeViewport( LPVEGCLI3DINFO lpInfo, int cx, int cy)
{
	HRESULT		rval;
	HWND		hwnd;
    int			view_width;
    int			view_height;
    int			dev_width;
    int			dev_height;

	if( !lpInfo )
		return TRUE;

	if( lpInfo->vegDispMode == VEGCLI_DISPMODE_EXCLUSIVE )
		return TRUE;

	hwnd		= lpInfo->hwnd;
    view_width  = lpInfo->view->GetWidth();
    view_height = lpInfo->view->GetHeight();
    dev_width   = lpInfo->device->GetWidth();
    dev_height  = lpInfo->device->GetHeight();

    if (view_width == cx && view_height == cy )
        return TRUE;
    
    if ( cx <= dev_width && cy<= dev_height ) 
	{
        RELEASE( lpInfo->view );
        ATTEMPT( rval = lpInfo->lpD3DRM->CreateViewport(lpInfo->device, lpInfo->camera, 0, 0, cx, cy, &lpInfo->view));
        ATTEMPT( rval = lpInfo->view->SetBack(D3DVAL(SETBACK)));
    }

    if (!vegcli3DRebuildDevice( lpInfo, cx, cy))
        return FALSE;

    return TRUE;
generic_error:
    vegMsg( "Error in vegcli3DResizeViewport() - %s", DXErrorToString( rval ));
    return FALSE;
}

//////////////////////////////////////////////////////////////////////////////////////////////
//
// Static Functions
//
//////////////////////////////////////////////////////////////////////////////////////////////

static
BOOL
createD3DRMWindowed( LPVEGCLI3DINFO lpInfo, int cx, int cy, int bpp )
{
	HWND					hwnd = lpInfo->hwnd;
    HRESULT					rval;
	LPDIRECT3DRM			lpD3DRM1;
	LPVEG					lpD3DRM;
	LPVEGDDRAWCLIPPER		lpDDClipper;

#ifdef VEGDEBUG
	FILE	*fp;
	fp = fopen( VEGCLI3DLOGFILE, "a+" );
	fprintf( fp, "createD3DRMWindowed(%d, %d, %d) started\n", cx, cy, bpp );
	fclose( fp );
#endif // VEGDEBUG


	rval = Direct3DRMCreate( &lpD3DRM1 );
    if( rval != D3DRM_OK ) 
	{
        vegMsg( "Failed to create Direct3DRM[ createD3DRMWindowed() ] - %s", DXErrorToString( rval ) );
        return FALSE;
    }
	rval = lpD3DRM1->QueryInterface( IID_VEG, (LPVOID *) &lpD3DRM );
    if( rval != D3DRM_OK ) 
	{
        vegMsg( "Failed to Query Direct3DRM3[ createD3DRMWindowed() ] - %s", DXErrorToString( rval ) );
        return FALSE;
    }
	RELEASE( lpD3DRM1 );

    //
	// Direct3DRM  ̽   Ѵ.
	//      (window based mode) DirectDraw
	// clipperü  ־ ̽ ϰ, 
	// ü ȭ (exclusive mode) DirectDraw ĸ۸ 
	// Ͽ Ѵ.
	//
    if( FAILED( DirectDrawCreateClipper( 0, &lpDDClipper, NULL ) ) ) 
	{
        return FALSE;
    }

    if( FAILED ( lpDDClipper->SetHWnd( 0, hwnd ) ) ) 
	{
        RELEASE( lpDDClipper );
        return FALSE;
    }

	lpInfo->lpDD            = NULL;
	lpInfo->lpDDSPrimary    = NULL;
	lpInfo->lpDDSBack       = NULL;
	lpInfo->lpDDPal         = NULL;
	lpInfo->lpDDClipper     = lpDDClipper;
    lpInfo->lpD3DRM         = lpD3DRM;
	lpInfo->animation		= NULL;
	lpInfo->animationSet	= NULL;
	if( bpp == 8 )
		lpInfo->colormodel = D3DCOLOR_MONO;
	else
		lpInfo->colormodel = D3DCOLOR_RGB;

	if( !vegcli3DCreateDevice( lpInfo, cx, cy, bpp ) ) 
	{
        return FALSE;
    }

#ifdef VEGDEBUG
	fp = fopen( VEGCLI3DLOGFILE, "a+" );
	fprintf( fp, "createD3DRMWindowed(%d, %d, %d) ended\n", cx, cy, bpp );
	fclose( fp );
#endif // VEGDEBUG

	return TRUE;
}

static
BOOL
createD3DRMExclusive( LPVEGCLI3DINFO lpInfo, int cx, int cy, int bpp )
{
	HWND					hwnd = lpInfo->hwnd;
	HRESULT					rval;
	DDSURFACEDESC			ddsd;
	DDSCAPS					ddscaps;
	DDCOLORKEY				ddck;
	LPDIRECTDRAW			lpDD1;
	LPVEGDDRAW				lpDD;
	LPVEGDDRAWSURFACE		lpDDSP;
	LPVEGDDRAWSURFACE		lpDDSB;
	LPVEGDDRAWPALETTE		lpDDPal;
	LPDIRECT3DRM			lpD3DRM1;
	LPVEG					lpD3DRM;

//	LPDIRECTDRAWCLIPPER		lpDDClipper;

#ifdef VEGDEBUG
	FILE	*fp;
	fp = fopen( VEGCLI3DLOGFILE, "a+" );
	fprintf( fp, "createD3DRMExclusive(%d, %d, %d) started\n", cx, cy, bpp );
	fclose( fp );
#endif // VEGDEBUG

	rval = DirectDrawCreate( NULL, &lpDD1, NULL );
	if ( DD_OK != rval ) 
	{
	    vegMsg( "Failed to create DirectDraw[ createD3DRMExclusive() ] - %s", DDErrorToString( rval ) );
		return FALSE;
	}

	lpDD = lpDD1;
/*
	rval = lpDD1->QueryInterface( IID_VEGDDRAW, (LPVOID *)&lpDD );
	if ( DD_OK != rval ) 
	{
	    vegMsg( "Failed to Query DirectDraw4[ createD3DRMExclusive() ] - %s", DDErrorToString( rval ) );
		return FALSE;
	}
*/
	//	Ÿ Ǯũ  Ѵ. (EXCLUSIVE, FULLSCREEN)
	//	 ctrl+alt+del Ű   ֵ Ѵ. (ALLOWREBOOT)
	ATTEMPT( rval = lpDD->SetCooperativeLevel ( hwnd, DDSCL_ALLOWREBOOT | DDSCL_EXCLUSIVE | DDSCL_FULLSCREEN ) );

	ATTEMPT( rval = lpDD->SetDisplayMode( cx, cy, bpp ) );

	//	 ø ִϸ̼  DDSURFACEDESC ü Ѵ.
	ddsd.dwSize = sizeof ddsd;
	ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
	ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP | DDSCAPS_COMPLEX | DDSCAPS_3DDEVICE;
	ddsd.dwBackBufferCount = 1;

	//	 ۸ Ѵ.
	ATTEMPT( rval = lpDD->CreateSurface ( &ddsd, &lpDDSP, NULL ) );

	//	  ۿ ٴ ĸ ۸ Ѵ.
	ddscaps.dwCaps = DDSCAPS_BACKBUFFER | DDSCAPS_3DDEVICE;
	ATTEMPT( rval = lpDDSP->GetAttachedSurface ( &ddscaps, &lpDDSB ) );

	// ķƮ Ѵ.
	if( bpp == 8 )
	{
	    LPPALETTEENTRY	pPe;
		int				i;

		pPe = (LPPALETTEENTRY) malloc ( ( sizeof PALETTEENTRY ) * 256 );
		if( !pPe ) return FALSE;

		for( i = 10 ; i < 245 ; i++ )
		{
			pPe[i].peRed = i;
			pPe[i].peGreen = i;
			pPe[i].peBlue = i;
		}
		ATTEMPT( rval = lpDD->CreatePalette( DDPCAPS_8BIT, pPe, &lpDDPal, NULL ) );
	    if( lpDDPal )
		{
			ATTEMPT( rval = lpDDSP->SetPalette( lpDDPal ) );
		}
		free( pPe );
	}
	else
		lpDDPal = NULL;

// ҽ ÷Ű Ѵ.
	ddck.dwColorSpaceLowValue = 255;
	ddck.dwColorSpaceHighValue = 255;
	lpDDSB->SetColorKey( DDCKEY_SRCBLT, &ddck );
	
	rval = Direct3DRMCreate( &lpD3DRM1 );
    if( rval != D3DRM_OK ) 
	{
        vegMsg( "Failed to create Direct3DRM[ createD3DRMExclusive() ] - %s", DXErrorToString( rval ) );
        return FALSE;
    }
	rval = lpD3DRM1->QueryInterface( IID_VEG, (LPVOID *) &lpD3DRM );
    if( rval != D3DRM_OK ) 
	{
        vegMsg( "Failed to Query Direct3DRM3[ createD3DRMExclusive() ] - %s", DXErrorToString( rval ) );
        return FALSE;
    }
	RELEASE( lpD3DRM1 );

	lpInfo->lpDD            = lpDD;
	lpInfo->lpDDSPrimary    = lpDDSP;
	lpInfo->lpDDSBack       = lpDDSB;
	lpInfo->lpDDPal         = lpDDPal;
	lpInfo->lpDDClipper		= NULL;
	lpInfo->lpD3DRM         = lpD3DRM;
	lpInfo->animation		= NULL;
	lpInfo->animationSet	= NULL;
	if( bpp == 8 )
		lpInfo->colormodel = D3DCOLOR_MONO;
	else
		lpInfo->colormodel = D3DCOLOR_RGB;

    if( !vegcli3DCreateDevice( lpInfo, cx, cy, bpp ) ) 
	{
        return FALSE;
    }

#ifdef VEGDEBUG
	fp = fopen( VEGCLI3DLOGFILE, "a+" );
	fprintf( fp, "createD3DRMExclusive(%d, %d, %d) ended\n", cx, cy, bpp );
	fclose( fp );
#endif // VEGDEBUG

	return TRUE;
generic_error:
	vegMsg( "Error in createD3DRMExclusive() - %s", DXErrorToString( rval ) );

#ifdef VEGDEBUG
	fp = fopen( VEGCLI3DLOGFILE, "a+" );
	fprintf( fp, "createD3DRMExclusive(%d, %d, %d) failed\n", cx, cy, bpp );
	fclose( fp );
#endif // VEGDEBUG

	return FALSE;
}
	
//
// (⺻ Ǵ, ּ ʿ) scene .
//  scene̶  ϰ camera Ѵ.
//   Լ caller vegcli3DCreateDevice() viewport Ѵ.
//  :  light .
//        ׷, ̰͸   غ ¯ ̴.
//
static 
BOOL 
CreateSimpleScene( LPVEGCLI3DINFO lpInfo )
{
	LPVEG					lpD3DRM = lpInfo->lpD3DRM;
    LPVEGFRAME				frame   = NULL;
    LPVEGFRAME				light   = NULL;
    LPVEGMESHBUILDER		builder = NULL;
    LPDIRECT3DRMLIGHT		light1  = NULL;
    LPDIRECT3DRMLIGHT		light2  = NULL;

#ifdef VEGDEBUG
	fp = fopen( VEGCLI3DLOGFILE, "a+" );
	fprintf( fp, "CreateSimpleScene() started\n" );
	fclose( fp );
#endif // VEGDEBUG

    ATTEMPT( lpD3DRM->CreateFrame( NULL, &lpInfo->scene ) );
    ATTEMPT( lpD3DRM->CreateFrame( lpInfo->scene, &lpInfo->camera ) );
    ATTEMPT( lpInfo->camera->SetPosition( lpInfo->scene, D3DVAL(0.0), D3DVAL(0.0), D3DVAL(0.0) ) );
    ATTEMPT( lpD3DRM->CreateViewport( lpInfo->device, lpInfo->camera, 0, 0,
									  lpInfo->device->GetWidth(),
									  lpInfo->device->GetHeight(), 
									  &lpInfo->view) );
    ATTEMPT( lpInfo->view->SetBack( D3DVAL(SETBACK) ) );

#ifdef VEGDEBUG
	fp = fopen( VEGCLI3DLOGFILE, "a+" );
	fprintf( fp, "CreateSimpleScene() ended\n" );
	fclose( fp );
#endif // VEGDEBUG

	return TRUE;

generic_error:
    vegMsg( "Error in CreateSimpleScene()[ vegcli3D ]\n");

#ifdef VEGDEBUG
	fp = fopen( VEGCLI3DLOGFILE, "a+" );
	fprintf( fp, "CreateSimpleScene() failed\n" );
	fclose( fp );
#endif // VEGDEBUG

	return FALSE;
}

static 
DWORD 
bppToddbd( int bpp )
{
    switch( bpp ) 
	{
    case 1:
        return DDBD_1;
    case 2:
        return DDBD_2;
    case 4:
        return DDBD_4;
    case 8:
        return DDBD_8;
    case 16:
        return DDBD_16;
    case 24:
        return DDBD_24;
    case 32:
        return DDBD_32;
    }
    return 0;
}

static
char* 
LSTRRCHR( const char* lpString, int bChar )
{
    if( lpString != NULL )
    {
        const char*     lpBegin;

        lpBegin = lpString;

        while( *lpString != 0 )
            lpString++;

        while( 1 )
        {
            if( *lpString == bChar )
                return (char*)lpString;
            
            if( lpString == lpBegin )
                break;

            lpString--;
        }
    }

    return NULL;
} // LSTRRCHR //

//------------------------------------------------------------------
// 
// Function     : LoadTextures
//
// Purpose      : Loads an individual texture
//
// NOTE         : Textures must have a size divisible by 2 (e.g. 128x64, 256x256)
//
//------------------------------------------------------------------
// ؽ ũ μ  2 ߸ Ѵ.
//

HRESULT
LoadTextures(char *sName, void *pArg, LPVEGTEXTURE *hTexture)
{
	char path[128];
            
	lstrcpy( path, glpInfo->lpszAppPath );
	lstrcat( path, glpInfo->lpszTexturePath );
	lstrcat( path, sName );
    // Load the texture
    if (FAILED(glpInfo->lpD3DRM->LoadTexture(path, hTexture))) return -1;

    return 0;
}

